/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.resolver;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class TestBSN_001
extends AbstractStateTest {
    BundleDescription bundle_1 = null;
    BundleDescription bundle_2 = null;
    BundleDescription bundle_3 = null;

    @Test
    public void testTest_001() {
        State state = this.buildEmptyState();
        StateObjectFactory sof = StateObjectFactory.defaultFactory;
        this.bundle_1 = this.create_bundle_1(sof);
        this.bundle_2 = this.create_bundle_2(sof);
        this.bundle_3 = this.create_bundle_3(sof);
        this.addBundlesToState_a(state);
        try {
            state.resolve();
        }
        catch (Throwable t) {
            Assert.fail((String)("unexpected exception class=" + t.getClass().getName() + " message=" + t.getMessage()));
            return;
        }
        this.checkBundlesResolved_a();
        this.checkWiring_a();
    }

    public void checkWiringState_1() {
        ExportPackageDescription[] exports = this.bundle_1.getResolvedImports();
        Assert.assertNotNull((String)"export array is unexpectedly null", (Object)exports);
        Assert.assertTrue((String)"export array is unexpectedly empty", (exports.length > 0 ? 1 : 0) != 0);
        ExportPackageDescription[] exportPackageDescriptionArray = exports;
        int n = exports.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription exp = exportPackageDescriptionArray[n2];
            String exportPackageName = exp.getName();
            Assert.assertNotNull((String)"package name is null", (Object)exportPackageName);
            if (exportPackageName.equals("foo")) {
                Assert.assertNotNull((String)"Package [foo] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [foo] is wired incorrectly ", exp.getExporter(), this.bundle_3);
            }
            ++n2;
        }
    }

    public void checkWiringState_2() {
    }

    public void checkWiringState_3() {
    }

    public void checkWiring_a() {
        this.checkWiringState_1();
        this.checkWiringState_2();
        this.checkWiringState_3();
    }

    public void addBundlesToState_a(State state) {
        boolean added = false;
        added = state.addBundle(this.bundle_1);
        Assert.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_2);
        Assert.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_3);
        Assert.assertTrue((String)"failed to add bundle ", (boolean)added);
    }

    public void checkBundlesResolved_a() {
        Assert.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_1.isResolved());
        Assert.assertTrue((String)"unexpected bundle resolution state", (!this.bundle_2.isResolved() ? 1 : 0) != 0);
        Assert.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_3.isResolved());
    }

    public BundleDescription create_bundle_1(StateObjectFactory sof) {
        Properties dictionary_1 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_1).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_1).put("Bundle-SymbolicName", "A");
        ((Dictionary)dictionary_1).put("Import-Package", "foo; version=\"1.0\"; bundle-symbolic-name=\"C\"");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_1, "bundle_1", 1L);
        }
        catch (BundleException be) {
            Assert.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_2(StateObjectFactory sof) {
        Properties dictionary_2 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_2).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_2).put("Bundle-SymbolicName", "B");
        ((Dictionary)dictionary_2).put("Import-Package", "foo; version=\"1.0\"; bundle-symbolic-name=\"A\"");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_2, "bundle_2", 2L);
        }
        catch (BundleException be) {
            Assert.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_3(StateObjectFactory sof) {
        Properties dictionary_3 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_3).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_3).put("Bundle-SymbolicName", "C");
        ((Dictionary)dictionary_3).put("Export-Package", "foo; version=\"1.0\"");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_3, "bundle_3", 3L);
        }
        catch (BundleException be) {
            Assert.fail((String)be.getMessage());
        }
        return bundle;
    }
}

