/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.resource;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.resource.AbstractResourceTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.FrameworkWiring;

public class ResolverHookTests
extends AbstractResourceTest {
    @Test
    public void testSingletonIdentity() throws Exception {
        final RuntimeException[] error = new RuntimeException[1];
        final boolean[] called = new boolean[1];
        ResolverHookFactory resolverHookFactory = triggers -> new ResolverHook(){

            public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
                if (error[0] != null) {
                    return;
                }
                called[0] = true;
                try {
                    Assert.assertEquals((String)"Wrong namespace", (Object)"osgi.identity", (Object)singleton.getNamespace());
                    Assert.assertEquals((String)"Wrong singleton directive", (Object)"true", singleton.getDirectives().get("singleton"));
                    String symbolicName = (String)singleton.getAttributes().get("osgi.identity");
                    for (Object collisionCandidate : collisionCandidates) {
                        BundleCapability candidate = (BundleCapability)collisionCandidate;
                        Assert.assertEquals((String)"Wrong namespace", (Object)"osgi.identity", (Object)candidate.getNamespace());
                        Assert.assertEquals((String)"Wrong singleton directive", (Object)"true", candidate.getDirectives().get("singleton"));
                        Assert.assertEquals((String)"Wrong symbolic name", (Object)symbolicName, candidate.getAttributes().get("osgi.identity"));
                    }
                }
                catch (RuntimeException e) {
                    error[0] = e;
                }
            }

            public void filterResolvable(Collection candidates) {
            }

            public void filterMatches(BundleRequirement requirement, Collection candidates) {
            }

            public void end() {
            }
        };
        ServiceRegistration hookReg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)resolverHookFactory, null);
        try {
            Bundle tb1v1 = this.installer.installBundle("singleton.tb1v1");
            Bundle tb1v2 = this.installer.installBundle("singleton.tb1v2");
            Assert.assertFalse((boolean)((FrameworkWiring)OSGiTestsActivator.getContext().getBundle(0L).adapt(FrameworkWiring.class)).resolveBundles(Arrays.asList(tb1v1, tb1v2)));
            Assert.assertTrue((String)"ResolverHook was not called", (boolean)called[0]);
            if (error[0] != null) {
                throw error[0];
            }
        }
        finally {
            hookReg.unregister();
        }
    }
}

