/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.security;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.osgi.internal.signedcontent.BundleToJarInputStream;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.DirBundleFile;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.security.BaseSecurityTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public class BundleToJarInputStreamTest {
    private static final List<String> testJarNames = Arrays.asList("multiply_signed", "SHA256withRSA", "SHA384withRSA", "SHA512withRSA", "signed_tsa", "signed_with_corrupt", "signed_with_metadata_added", "signed_with_metadata_corrupt", "signed_with_metadata_removed", "signed_with_metadata", "signed_with_missing_digest", "signed_with_sf_corrupted", "signed", "signedJava16", "test.bug252098", "unsigned");
    private static final List<String> corruptedJarNames = Arrays.asList("signed_with_corrupt", "signed_with_metadata_corrupt", "signed_with_sf_corrupted");

    @Test
    public void testInputStreamEquality() throws IOException {
        for (String testJarName : testJarNames) {
            this.compareContent(testJarName);
        }
    }

    @Test
    public void testSignedContentCorruption() throws Exception {
        for (String testJarName : testJarNames) {
            this.readJarContent(testJarName);
        }
    }

    private void readJarContent(String testJarName) throws Exception {
        block2: {
            File jar = BaseSecurityTest.getEntryFile(BaseSecurityTest.getTestJarPath(testJarName));
            File extracted = this.extract(jar);
            try {
                this.verify(extracted);
            }
            catch (Exception e) {
                if (corruptedJarNames.contains(testJarName)) break block2;
                throw e;
            }
        }
    }

    private void verify(File extracted) throws IOException {
        BundleToJarInputStream inputToJar = new BundleToJarInputStream((BundleFile)new DirBundleFile(extracted, false));
        Throwable throwable = null;
        Object var4_5 = null;
        try (JarInputStream jarInput = new JarInputStream((InputStream)inputToJar);){
            ZipEntry extractedEntry = jarInput.getNextEntry();
            while (extractedEntry != null) {
                this.getBytes(jarInput);
                extractedEntry = jarInput.getNextEntry();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void compareContent(String testJarName) throws IOException {
        File jar = BaseSecurityTest.getEntryFile(BaseSecurityTest.getTestJarPath(testJarName));
        File extracted = this.extract(jar);
        this.compare(jar, extracted);
    }

    private void compare(File jar, File extracted) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile jarFile = new ZipFile(jar);){
            LinkedHashSet<String> validated = new LinkedHashSet<String>();
            BundleToJarInputStream inputToJar = new BundleToJarInputStream((BundleFile)new DirBundleFile(extracted, false));
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (ZipInputStream jarInput = new ZipInputStream((InputStream)inputToJar);){
                ZipEntry extractedEntry = jarInput.getNextEntry();
                while (extractedEntry != null) {
                    if (!extractedEntry.isDirectory()) {
                        byte[] extractedBytes = this.getBytes(jarInput);
                        byte[] originalBytes = this.getBytes(jarFile.getInputStream(jarFile.getEntry(extractedEntry.getName())));
                        Assert.assertArrayEquals((String)("Wrong entry content: " + extractedEntry.getName()), (byte[])originalBytes, (byte[])extractedBytes);
                        validated.add(extractedEntry.getName());
                    }
                    extractedEntry = jarInput.getNextEntry();
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            Iterator<String> validpaths = validated.iterator();
            String first = (String)validpaths.next();
            if (first.toUpperCase().endsWith("META-INF/")) {
                first = (String)validpaths.next();
            }
            Assert.assertEquals((String)"Expected manifest.", (Object)"META-INF/MANIFEST.MF", (Object)first.toUpperCase());
            AtomicReference foundNonSignatureFile = new AtomicReference();
            validpaths.forEachRemaining(s -> {
                if (this.isSignatureFile((String)s)) {
                    Assert.assertNull((String)"Found non signature file before.", foundNonSignatureFile.get());
                } else {
                    foundNonSignatureFile.compareAndSet(null, s);
                }
            });
            Enumeration<? extends ZipEntry> originalEntries = jarFile.entries();
            while (originalEntries.hasMoreElements()) {
                ZipEntry originalEntry = originalEntries.nextElement();
                validated.remove(originalEntry.getName());
            }
            Assert.assertTrue((String)("More paths extracted content: " + String.valueOf(validated)), (boolean)validated.isEmpty());
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private boolean isSignatureFile(String s) {
        if ((s = s.toUpperCase()).startsWith("META-INF/") && s.indexOf(47, "META-INF/".length()) == -1) {
            return s.endsWith(".SF") || s.endsWith(".DSA") || s.endsWith(".RSA") || s.endsWith(".EC");
        }
        return false;
    }

    byte[] getBytes(InputStream in) throws IOException {
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        byte[] drain = new byte[4096];
        int read = in.read(drain, 0, drain.length);
        while (read != -1) {
            content.write(drain, 0, read);
            read = in.read(drain, 0, drain.length);
        }
        return content.toByteArray();
    }

    private File extract(File jar) throws IOException {
        BundleContext bc = OSGiTestsActivator.getContext();
        File dir = bc.getDataFile("extracted/" + jar.getName());
        if (dir.isDirectory()) {
            return dir;
        }
        dir.mkdirs();
        Throwable throwable = null;
        Object var5_6 = null;
        try (ZipFile jarFile = new ZipFile(jar);){
            Enumeration<? extends ZipEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                Throwable throwable2 = null;
                Object var10_13 = null;
                try (InputStream in = jarFile.getInputStream(entry);){
                    File destination = new File(dir, entry.getName());
                    destination.getParentFile().mkdirs();
                    BaseSecurityTest.copy(in, destination);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return dir;
    }
}

