/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.osgi.internal.service.security.KeyStoreTrustEngine;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.tests.OSGiTestsActivator;

public class KeyStoreTrustEngineTest
extends TestCase {
    private static char[] PASSWORD_DEFAULT = new char[]{'c', 'h', 'a', 'n', 'g', 'e', 'i', 't'};
    private static String TYPE_DEFAULT = "JKS";
    private static TestCase[] s_tests = new TestCase[]{new KeyStoreTrustEngineTest("findTrustAnchor positive test: self signed trusted", new String[]{"ca1_root"}){

        public void runTest() {
            this.testFindTrustAnchor0();
        }
    }, new KeyStoreTrustEngineTest("findTrustAnchor positive test: chain with root trusted", new String[]{"ca1_root"}){

        public void runTest() {
            this.testFindTrustAnchor1();
        }
    }, new KeyStoreTrustEngineTest("findTrustAnchor positive test: chain with intermediate trusted", new String[]{"ca1_ou"}){

        public void runTest() {
            this.testFindTrustAnchor2();
        }
    }, new KeyStoreTrustEngineTest("findTrustAnchor positive test: chain with leaf trusted", new String[]{"ca1_leafb"}){

        public void runTest() {
            this.testFindTrustAnchor3();
        }
    }, new KeyStoreTrustEngineTest("findTrustAnchor negative test: untrusted self signed", new String[0]){

        public void runTest() {
            this.testFindTrustAnchor4();
        }
    }, new KeyStoreTrustEngineTest("findTrustAnchor negative test: untrusted chain", new String[0]){

        public void runTest() {
            this.testFindTrustAnchor5();
        }
    }, new KeyStoreTrustEngineTest("findTrustAnchor negative test: invalid chain", new String[0]){

        public void runTest() {
            this.testFindTrustAnchor6();
        }
    }, new KeyStoreTrustEngineTest("findTrustAnchor negative test: incomplete-able chain", new String[0]){

        public void runTest() {
            this.testFindTrustAnchor7();
        }
    }, new KeyStoreTrustEngineTest("findTrustAnchor negative test: null chain", new String[0]){

        public void runTest() {
            this.testFindTrustAnchor8();
        }
    }, new KeyStoreTrustEngineTest("addTrustAnchor positive test: add with alias", new String[0]){

        public void runTest() {
            this.testAddTrustAnchor0();
        }
    }, new KeyStoreTrustEngineTest("addTrustAnchor negative test: null cert specified", new String[0]){

        public void runTest() {
            this.testAddTrustAnchor2();
        }
    }, new KeyStoreTrustEngineTest("addTrustAnchor negative test: existing cert specified", new String[]{"ca1_root"}){

        public void runTest() {
            this.testAddTrustAnchor3();
        }
    }, new KeyStoreTrustEngineTest("addTrustAnchor negative test: existing alias specified", new String[]{"ca1_root"}){

        public void runTest() {
            this.testAddTrustAnchor4();
        }
    }, new KeyStoreTrustEngineTest("removeTrustAnchor positive test: remove by alias", new String[]{"ca1_root"}){

        public void runTest() {
            this.testRemoveTrustAnchor0();
        }
    }, new KeyStoreTrustEngineTest("removeTrustAnchor positive test: remove by cert", new String[]{"ca1_root"}){

        public void runTest() {
            this.testRemoveTrustAnchor1();
        }
    }, new KeyStoreTrustEngineTest("removeTrustAnchor negative test: cert not found", new String[0]){

        public void runTest() {
            this.testRemoveTrustAnchor2();
        }
    }, new KeyStoreTrustEngineTest("removeTrustAnchor negative test: by alias not found", new String[0]){

        public void runTest() {
            this.testRemoveTrustAnchor3();
        }
    }, new KeyStoreTrustEngineTest("removeTrustAnchor negative test: remove by null alias", new String[0]){

        public void runTest() {
            this.testRemoveTrustAnchor4();
        }
    }, new KeyStoreTrustEngineTest("removeTrustAnchor negative test: remove by null certificate", new String[0]){

        public void runTest() {
            this.testRemoveTrustAnchor5();
        }
    }, new KeyStoreTrustEngineTest("getTrustAnchor positive test: get by alias", new String[]{"ca1_root"}){

        public void runTest() {
            this.testGetTrustAnchor0();
        }
    }, new KeyStoreTrustEngineTest("getTrustAnchor negative test: get by null alias", new String[0]){

        public void runTest() {
            this.testGetTrustAnchor1();
        }
    }, new KeyStoreTrustEngineTest("getTrustAnchor negative test: does not exist", new String[0]){

        public void runTest() {
            this.testGetTrustAnchor2();
        }
    }, new KeyStoreTrustEngineTest("getAliases positive test: get the alias list", new String[]{"ca1_root", "ca2_root"}){

        public void runTest() {
            this.testGetAliases0();
        }
    }};
    private static KeyStore supportStore;
    private String[] aliases;
    private KeyStore testStore;
    private File testStoreFile;
    TrustEngine engine;

    static {
        try {
            URL supportUrl = OSGiTestsActivator.getBundle().getEntry("test_files/security/keystore.jks");
            supportStore = KeyStore.getInstance(TYPE_DEFAULT);
            supportStore.load(supportUrl.openStream(), PASSWORD_DEFAULT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Unit tests for TrustEngine");
        TestCase[] testCaseArray = s_tests;
        int n = s_tests.length;
        int n2 = 0;
        while (n2 < n) {
            TestCase s_test = testCaseArray[n2];
            suite.addTest((Test)s_test);
            ++n2;
        }
        return suite;
    }

    public KeyStoreTrustEngineTest() {
    }

    public KeyStoreTrustEngineTest(String name, String ... aliases) {
        super(name);
        this.aliases = aliases;
    }

    protected void setUp() throws Exception {
        if (supportStore == null) {
            KeyStoreTrustEngineTest.fail((String)"Could not open keystore with test certificates!");
        }
        this.testStore = KeyStore.getInstance(TYPE_DEFAULT);
        this.testStore.load(null, PASSWORD_DEFAULT);
        if (this.aliases != null) {
            String[] stringArray = this.aliases;
            int n = this.aliases.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                this.testStore.setCertificateEntry(alias, KeyStoreTrustEngineTest.getTestCertificate(alias));
                ++n2;
            }
        }
        this.testStoreFile = File.createTempFile("teststore", "jks");
        FileOutputStream out = new FileOutputStream(this.testStoreFile);
        try {
            this.testStore.store(out, PASSWORD_DEFAULT);
        }
        finally {
            KeyStoreTrustEngineTest.safeClose(out);
        }
        this.engine = new KeyStoreTrustEngine(this.testStoreFile.getPath(), TYPE_DEFAULT, PASSWORD_DEFAULT, "teststore", null);
    }

    protected static void safeClose(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void tearDown() {
        this.engine = null;
        this.testStore = null;
        this.testStoreFile.delete();
    }

    private static Certificate getTestCertificate(String alias) throws KeyStoreException {
        return supportStore.getCertificate(alias);
    }

    private static Certificate[] getTestCertificateChain(String ... aliases) throws KeyStoreException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>(aliases.length);
        String[] stringArray = aliases;
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            certs.add(KeyStoreTrustEngineTest.getTestCertificate(alias));
            ++n2;
        }
        return certs.toArray(new Certificate[0]);
    }

    public void testFindTrustAnchor0() {
        try {
            Certificate cert = this.engine.findTrustAnchor(new Certificate[]{KeyStoreTrustEngineTest.getTestCertificate("ca1_root")});
            KeyStoreTrustEngineTest.assertNotNull((String)"Did not return a cert for self-signed case", (Object)cert);
            KeyStoreTrustEngineTest.assertEquals((String)"Input and output certs not equal for self-signed case", (Object)cert, (Object)KeyStoreTrustEngineTest.getTestCertificate("ca1_root"));
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.fail((String)("Unexpected exception testing trusted self-signed cert: " + t.getMessage()));
        }
    }

    public void testFindTrustAnchor1() {
        try {
            Certificate cert = this.engine.findTrustAnchor(KeyStoreTrustEngineTest.getTestCertificateChain("ca1_leafb", "ca1_ou", "ca1_root"));
            KeyStoreTrustEngineTest.assertNotNull((String)"Certificate did not come back in trusted root case", (Object)cert);
            KeyStoreTrustEngineTest.assertEquals((String)"Output cert is not root trusted cert", (Object)cert, (Object)KeyStoreTrustEngineTest.getTestCertificate("ca1_root"));
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.fail((String)("Unexpected exception testing trusted root from complete chain: " + t.getMessage()));
        }
    }

    public void testFindTrustAnchor2() {
        try {
            Certificate cert = this.engine.findTrustAnchor(KeyStoreTrustEngineTest.getTestCertificateChain("ca1_leafb", "ca1_ou", "ca1_root"));
            KeyStoreTrustEngineTest.assertNotNull((String)"Certificate did not come back in trusted intermediate case", (Object)cert);
            KeyStoreTrustEngineTest.assertEquals((String)"Output cert is not intermediate trusted cert", (Object)cert, (Object)KeyStoreTrustEngineTest.getTestCertificate("ca1_ou"));
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.fail((String)("Unexpected exception testing trusted root from complete chain: " + t.getMessage()));
        }
    }

    public void testFindTrustAnchor3() {
        try {
            Certificate cert = this.engine.findTrustAnchor(KeyStoreTrustEngineTest.getTestCertificateChain("ca1_leafb", "ca1_ou", "ca1_root"));
            KeyStoreTrustEngineTest.assertNotNull((String)"Certificate did not come back in trusted leaf case", (Object)cert);
            KeyStoreTrustEngineTest.assertEquals((String)"Output cert is not leaf trusted cert", (Object)cert, (Object)KeyStoreTrustEngineTest.getTestCertificate("ca1_leafb"));
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.fail((String)("Unexpected exception testing trusted root from complete chain: " + t.getMessage()));
        }
    }

    public void testFindTrustAnchor4() {
        try {
            Certificate cert = this.engine.findTrustAnchor(new Certificate[]{KeyStoreTrustEngineTest.getTestCertificate("ca2_root")});
            KeyStoreTrustEngineTest.assertNull((String)"Incorrectly returned a certificate for untrusted self-signed case", (Object)cert);
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.fail((String)("Unexpected exception testing untrusted self-signed cert: " + t.getMessage()));
        }
    }

    public void testFindTrustAnchor5() {
        try {
            Certificate cert = this.engine.findTrustAnchor(KeyStoreTrustEngineTest.getTestCertificateChain("ca2_leafb", "ca2_ou", "ca2_root"));
            KeyStoreTrustEngineTest.assertNull((String)"Incorrectly returned a certificate for untrusted chain case", (Object)cert);
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.fail((String)("Unexpected exception testing untrusted chain: " + t.getMessage()));
        }
    }

    public void testFindTrustAnchor6() {
        try {
            Certificate cert = this.engine.findTrustAnchor(KeyStoreTrustEngineTest.getTestCertificateChain("ca2_leafa", "ca1_root"));
            KeyStoreTrustEngineTest.assertNull((String)"Incorrectly returned a certificate on invalid certificate chain", (Object)cert);
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.assertNull((String)"Incorrectly thrown exception thrown on invalid certificate chain", (Object)t);
        }
    }

    public void testFindTrustAnchor7() {
        try {
            Certificate cert = this.engine.findTrustAnchor(KeyStoreTrustEngineTest.getTestCertificateChain("ca1_leafb", "ca1_root"));
            KeyStoreTrustEngineTest.assertNull((String)"Incorrectly returned a certificate on incomplete-able certificate chain", (Object)cert);
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.assertNull((String)"Incorrectly thrown exception thrown on incomplete-able certificate chain", (Object)t);
        }
    }

    public void testFindTrustAnchor8() {
        try {
            this.engine.findTrustAnchor(null);
            KeyStoreTrustEngineTest.fail((String)"Did not throw IllegalArgumentException on NULL certificate");
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.assertTrue((String)"Incorrect exception thrown on NULL certificate", (boolean)(t instanceof IllegalArgumentException));
        }
    }

    public void testAddTrustAnchor0() {
        try {
            String alias = this.engine.addTrustAnchor(KeyStoreTrustEngineTest.getTestCertificate("ca1_root"), "ca1_root");
            KeyStoreTrustEngineTest.assertEquals((String)"Alias returned does not equal alias input", (String)alias, (String)"ca1_root");
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.fail((String)("Unexpected exception adding trusted root: " + t.getMessage()));
        }
    }

    public void testAddTrustAnchor1() {
        try {
            String alias = this.engine.addTrustAnchor(KeyStoreTrustEngineTest.getTestCertificate("ca1_root"), null);
            KeyStoreTrustEngineTest.assertNotNull((String)"Generated alias was not correctly returned", (Object)alias);
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.fail((String)("Unexpected exception adding trusted root (autogen alias): " + t.getMessage()));
        }
    }

    public void testAddTrustAnchor2() {
        try {
            this.engine.addTrustAnchor(null, "ca1_root");
            KeyStoreTrustEngineTest.fail((String)"Did not throw IllegalArgumentException on NULL certificate");
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.assertTrue((String)"Incorrect exception thrown on NULL certificate", (boolean)(t instanceof IllegalArgumentException));
        }
    }

    public void testAddTrustAnchor3() {
        try {
            this.engine.addTrustAnchor(KeyStoreTrustEngineTest.getTestCertificate("ca1_root"), "new_root");
            KeyStoreTrustEngineTest.assertTrue((String)"Did not throw CertificateException on duplicate cert", (boolean)false);
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.assertTrue((String)"Incorrect exception thrown on duplicate cert", (boolean)(t instanceof CertificateException));
            return;
        }
        KeyStoreTrustEngineTest.fail((String)"Expected exception when adding trust anchor");
    }

    public void testAddTrustAnchor4() {
        try {
            this.engine.addTrustAnchor(KeyStoreTrustEngineTest.getTestCertificate("ca2_root"), "ca1_root");
            KeyStoreTrustEngineTest.assertTrue((String)"Did not throw CertificateException on duplicate alias", (boolean)false);
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.assertTrue((String)"Incorrect exception thrown on duplicate alias", (boolean)(t instanceof CertificateException));
            return;
        }
        KeyStoreTrustEngineTest.fail((String)"Expected exception when adding trust anchor");
    }

    public void testRemoveTrustAnchor0() {
        try {
            this.engine.removeTrustAnchor("ca1_root");
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.fail((String)("Unexpected exception thrown when removing by alias: " + t.getMessage()));
        }
    }

    public void testRemoveTrustAnchor1() {
        try {
            this.engine.removeTrustAnchor(KeyStoreTrustEngineTest.getTestCertificate("ca1_root"));
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.fail((String)("Unexpected exception thrown when removing by cert: " + t.getMessage()));
        }
    }

    public void testRemoveTrustAnchor2() {
        try {
            this.engine.removeTrustAnchor(KeyStoreTrustEngineTest.getTestCertificate("ca1_root"));
            KeyStoreTrustEngineTest.fail((String)"Did not throw CertificateException on cert not found");
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.assertTrue((String)"Incorrect exception thrown on remove by cert", (boolean)(t instanceof CertificateException));
        }
    }

    public void testRemoveTrustAnchor3() {
        try {
            this.engine.removeTrustAnchor("ca2_root");
            KeyStoreTrustEngineTest.assertTrue((String)"Did not throw CertificateException on alias not found", (boolean)false);
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.assertTrue((String)"Incorrect exception thrown on remove by alias", (boolean)(t instanceof CertificateException));
            return;
        }
        KeyStoreTrustEngineTest.fail((String)"Expected exception when removing trust anchor");
    }

    public void testRemoveTrustAnchor4() {
        try {
            this.engine.removeTrustAnchor(null);
            KeyStoreTrustEngineTest.fail((String)"Did not throw CertificateException on alias null");
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.assertTrue((String)"Incorrect exception thrown on remove by null alias", (boolean)(t instanceof IllegalArgumentException));
        }
    }

    public void testRemoveTrustAnchor5() {
        try {
            this.engine.removeTrustAnchor(null);
            KeyStoreTrustEngineTest.fail((String)"Did not throw IllegalArgumentException on remove by cert null");
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.assertTrue((String)"Incorrect exception thrown on remove by null cert", (boolean)(t instanceof IllegalArgumentException));
        }
    }

    public void testGetTrustAnchor0() {
        try {
            Certificate cert = this.engine.getTrustAnchor("ca1_root");
            KeyStoreTrustEngineTest.assertEquals((String)"Did not get expected certificate", (Object)KeyStoreTrustEngineTest.getTestCertificate("ca1_root"), (Object)cert);
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.fail((String)("Unexpected exception when retrieving trust anchor: " + t.getMessage()));
        }
    }

    public void testGetTrustAnchor1() {
        try {
            this.engine.getTrustAnchor(null);
            KeyStoreTrustEngineTest.fail((String)"Did not throw IllegalArgumentException on get by alias null");
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.assertTrue((String)"Incorrect exception thrown on remove by null alias", (boolean)(t instanceof IllegalArgumentException));
        }
    }

    public void testGetTrustAnchor2() {
        try {
            Certificate cert = this.engine.getTrustAnchor("ca2_root");
            KeyStoreTrustEngineTest.assertNull((String)"Incorrectly returned a certificate on certificate does not exist", (Object)cert);
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.assertNull((String)"Incorrectly thrown exception on alias does not exist", (Object)t);
            return;
        }
    }

    public void testGetAliases0() {
        try {
            this.engine.getAliases();
        }
        catch (Throwable t) {
            KeyStoreTrustEngineTest.fail((String)("Unexpected exception when retrieving alias list: " + t.getMessage()));
        }
    }
}

