/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.security;

import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osgi.tests.security.BaseSecurityTest;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.condpermadmin.BundleSignerCondition;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class OSGiAPICertificateTest
extends BaseSecurityTest {
    private static String dn1 = "CN=CA1 LeafA, O=CA1, L=Boston, ST=Massachusetts, C=US";
    private static String dn2 = "CN=CA1 Root, O=CA1, L=Boston, ST=Massachusetts, C=US";
    private static String dn3 = "CN=CA1 LeafA, O=CA1, L=Austin, ST=Texas, C=US";
    private static String dn4 = "CN=CA1 Root, O=CA1, L=Austin, ST=Texas, C=US";
    private static String dn5 = "CN=CA1 LeafA, O=CA1, L=*, ST=*, C=US";
    private static String dn6 = "CN=CA1 Root, O=CA1, L=*, ST=*, C=US";
    private static String dn7 = "*, L=*, ST=*, C=US";
    private static String dnChain01True = dn1 + ";" + dn2;
    private static String dnChain02True = "*;" + dn2;
    private static String dnChain03True = dn1 + ";*";
    private static String dnChain04False = dn1 + ";" + dn4;
    private static String dnChain05False = dn3 + ";" + dn2;
    private static String dnChain06True = dn5 + ";" + dn6;
    private static String dnChain07True = dn7 + ";" + dn6;
    private static String dnChain08True = dn5 + ";" + dn7;
    private static String dnChain01TrueEscaped = OSGiAPICertificateTest.escapeStar(dnChain01True);
    private static String dnChain02TrueEscaped = OSGiAPICertificateTest.escapeStar(dnChain02True);
    private static String dnChain03TrueEscaped = OSGiAPICertificateTest.escapeStar(dnChain03True);
    private static String dnChain04FalseEscaped = OSGiAPICertificateTest.escapeStar(dnChain04False);
    private static String dnChain05FalseEscaped = OSGiAPICertificateTest.escapeStar(dnChain05False);
    private static String dnChain06TrueEscaped = OSGiAPICertificateTest.escapeStar(dnChain06True);
    private static String dnChain07TrueEscaped = OSGiAPICertificateTest.escapeStar(dnChain07True);
    private static String dnChain08TrueEscaped = OSGiAPICertificateTest.escapeStar(dnChain08True);
    private static ConditionInfo info01True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{"-"});
    private static ConditionInfo info02False = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{"-", "!"});
    private static ConditionInfo info03True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain01True});
    private static ConditionInfo info04True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain02True});
    private static ConditionInfo info05True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain03True});
    private static ConditionInfo info06False = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain04False});
    private static ConditionInfo info07False = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain05False});
    private static ConditionInfo info08True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain06True});
    private static ConditionInfo info09True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain07True});
    private static ConditionInfo info10True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain08True});
    private final Collection<Bundle> installedBundles = new ArrayList<Bundle>();

    private static String escapeStar(String dnChain) {
        if (dnChain == null || ((String)dnChain).length() == 0) {
            return dnChain;
        }
        int star = ((String)dnChain).indexOf(42);
        while (star >= 0) {
            dnChain = ((String)dnChain).substring(0, star) + "\\" + ((String)dnChain).substring(star);
            star = ((String)dnChain).indexOf(42, star + 2);
        }
        return dnChain;
    }

    public OSGiAPICertificateTest() {
    }

    public OSGiAPICertificateTest(String name, String jarname, String[] aliases) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.registerEclipseTrustEngine();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        for (Bundle b : this.installedBundles) {
            try {
                b.uninstall();
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
    }

    @Override
    protected Bundle installBundle(String bundlePath) throws BundleException, IOException {
        Bundle b = super.installBundle(bundlePath);
        this.installedBundles.add(b);
        return b;
    }

    public void testBundleSignerCondition01() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info01True);
        OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
    }

    public void testBundleSignerCondition02() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info02False);
        OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.FALSE, (Object)condition);
    }

    public void testBundleSignerCondition03() throws Exception {
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info01True);
        OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.FALSE, (Object)condition);
    }

    public void testBundleSignerCondition04() throws Exception {
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info02False);
        OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
    }

    public void testBundleSignerCondition05() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info03True);
        OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
    }

    public void testBundleSignerCondition06() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info04True);
        OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
    }

    public void testBundleSignerCondition07() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info05True);
        OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
    }

    public void testBundleSignerCondition08() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info06False);
        OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.FALSE, (Object)condition);
    }

    public void testBundleSignerCondition09() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info07False);
        OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.FALSE, (Object)condition);
    }

    public void testBundleSignerCondition10() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info08True);
        OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
    }

    public void testBundleSignerCondition11() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info09True);
        OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
    }

    public void testBundleSignerCondition12() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info10True);
        OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
    }

    public void testAdminPermission01() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        AdminPermission declaredPerm = new AdminPermission("(signer=-)", "context");
        AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
        OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
    }

    public void testAdminPermission02() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain01TrueEscaped + ")", "context");
        AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
        OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
    }

    public void testAdminPermission03() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        AdminPermission declaredPerm = new AdminPermission("(!(signer=-))", "context");
        AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
        OSGiAPICertificateTest.assertFalse((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
    }

    public void testAdminPermission04() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        AdminPermission declaredPerm = new AdminPermission("(!(signer=" + dnChain01TrueEscaped + "))", "context");
        AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
        OSGiAPICertificateTest.assertFalse((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
    }

    public void testAdminPermission05() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain02TrueEscaped + ")", "context");
        AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
        OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
    }

    public void testAdminPermission06() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain03TrueEscaped + ")", "context");
        AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
        OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
    }

    public void testAdminPermission07() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain04FalseEscaped + ")", "context");
        AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
        OSGiAPICertificateTest.assertFalse((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
    }

    public void testAdminPermission08() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain05FalseEscaped + ")", "context");
        AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
        OSGiAPICertificateTest.assertFalse((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
    }

    public void testAdminPermission09() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain06TrueEscaped + ")", "context");
        AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
        OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
    }

    public void testAdminPermission10() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain07TrueEscaped + ")", "context");
        AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
        OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
    }

    public void testAdminPermission11() throws Exception {
        this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
        AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain08TrueEscaped + ")", "context");
        AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
        OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
    }
}

