/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.security;

import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import junit.framework.Test;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.osgi.signedcontent.InvalidContentException;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.security.BaseSecurityTest;
import org.osgi.framework.Bundle;

public class SignedBundleTest
extends BaseSecurityTest {
    public static Test suite() {
        ConfigurationSessionTestSuite suite = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", "Unit session tests for SignedContent");
        OSGiTestsActivator.addRequiredOSGiTestsBundles(suite);
        suite.addTestSuite(SignedBundleTest.class);
        return suite;
    }

    protected void setUp() throws Exception {
        this.registerEclipseTrustEngine();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSignedContent01() throws Exception {
        Bundle testBundle = null;
        try {
            testBundle = this.installBundle(SignedBundleTest.getTestJarPath("unsigned"));
            SignedBundleTest.assertNotNull((String)"Test bundle not installed!", (Object)testBundle);
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertFalse((String)"Content is signed!!", (boolean)signedContent.isSigned());
        }
        finally {
            testBundle.uninstall();
        }
    }

    public void testSignedContent02() throws Exception {
        Bundle testBundle = null;
        try {
            testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signed"));
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
            signedContent.checkValidity(infos[0]);
            SignedBundleTest.assertTrue((String)"Signer is not trusted", (boolean)infos[0].isTrusted());
            SignedBundleTest.assertNotNull((String)"Trust anchor is null", (Object)infos[0].getTrustAnchor());
            SignedContentEntry[] entries = signedContent.getSignedEntries();
            SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
            SignedContentEntry[] signedContentEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                SignedContentEntry entry = signedContentEntryArray[n2];
                entry.verify();
                SignerInfo[] entryInfos = entry.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
                SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                ++n2;
            }
        }
        finally {
            testBundle.uninstall();
            this.getTrustEngine().removeTrustAnchor("ca1_leafa");
        }
    }

    public void testSignedContent03() throws Exception {
        Bundle testBundle = null;
        try {
            testBundle = this.installBundle(SignedBundleTest.getTestJarPath("multiply_signed"));
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca2_leafa"), "ca2_leafa");
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)2, (int)infos.length);
            SignerInfo[] signerInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                SignerInfo info = signerInfoArray[n2];
                signedContent.checkValidity(info);
                signedContent.checkValidity(info);
                SignedBundleTest.assertTrue((String)("Signer is not trusted: " + String.valueOf(info.getCertificateChain()[0])), (boolean)info.isTrusted());
                SignedBundleTest.assertNotNull((String)"Trust anchor is null", (Object)info.getTrustAnchor());
                ++n2;
            }
            SignedContentEntry[] entries = signedContent.getSignedEntries();
            SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
            SignedContentEntry[] signedContentEntryArray = entries;
            int n3 = entries.length;
            n = 0;
            while (n < n3) {
                SignedContentEntry entry = signedContentEntryArray[n];
                entry.verify();
                SignerInfo[] entryInfos = entry.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)2, (int)entryInfos.length);
                SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                ++n;
            }
        }
        finally {
            testBundle.uninstall();
            this.getTrustEngine().removeTrustAnchor("ca1_leafa");
            this.getTrustEngine().removeTrustAnchor("ca2_leafa");
        }
    }

    public void testSignedContent04() throws Exception {
        Bundle testBundle = null;
        try {
            testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signed"));
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
            SignerInfo[] signerInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                SignerInfo info = signerInfoArray[n2];
                SignedBundleTest.assertTrue((String)("Signer is trusted: " + String.valueOf(info.getCertificateChain()[0])), (!info.isTrusted() ? 1 : 0) != 0);
                ++n2;
            }
        }
        finally {
            testBundle.uninstall();
        }
    }

    public void testSignedContent05() throws Exception {
        Bundle testBundle = null;
        try {
            testBundle = this.installBundle(SignedBundleTest.getTestJarPath("multiply_signed"));
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)2, (int)infos.length);
            SignerInfo[] signerInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                SignerInfo info = signerInfoArray[n2];
                SignedBundleTest.assertTrue((String)("Signer is trusted: " + String.valueOf(info.getCertificateChain()[0])), (!info.isTrusted() ? 1 : 0) != 0);
                ++n2;
            }
        }
        finally {
            testBundle.uninstall();
        }
    }

    public void testSignedContent06() throws Exception {
        Bundle testBundle = null;
        try {
            testBundle = this.installBundle(SignedBundleTest.getTestJarPath("multiply_signed"));
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)2, (int)infos.length);
            SignerInfo[] signerInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                SignerInfo info = signerInfoArray[n2];
                Certificate[] certs = info.getCertificateChain();
                if (info.isTrusted()) {
                    X509Certificate x509Cert = (X509Certificate)certs[0];
                    SignedBundleTest.assertTrue((String)"CA1 LeafA signer is not trusted", (x509Cert.getSubjectX500Principal().getName().indexOf("CA1 LeafA") >= 0 ? 1 : 0) != 0);
                }
                ++n2;
            }
        }
        finally {
            testBundle.uninstall();
            this.getTrustEngine().removeTrustAnchor("ca1_leafa");
        }
    }

    public void testSignedContent07() throws Exception {
        Bundle testBundle = null;
        try {
            testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signed_with_corrupt"));
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
            SignedContentEntry[] entries = signedContent.getSignedEntries();
            SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
            SignedContentEntry[] signedContentEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                SignedContentEntry entry = signedContentEntryArray[n2];
                SignerInfo[] entryInfos = entry.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                try {
                    entry.verify();
                    if ("org/eclipse/equinox/security/junit/CorruptClass.class".equals(entry.getName())) {
                        SignedBundleTest.fail((String)("Expected a corruption for: " + entry.getName()));
                    }
                    SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
                    SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                }
                catch (InvalidContentException e) {
                    SignedBundleTest.assertEquals((String)("Unexpected corruption in '" + entry.getName() + "': " + String.valueOf((Object)e)), (String)"org/eclipse/equinox/security/junit/CorruptClass.class", (String)entry.getName());
                    SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)0, (int)entryInfos.length);
                }
                ++n2;
            }
        }
        finally {
            testBundle.uninstall();
            this.getTrustEngine().removeTrustAnchor("ca1_leafa");
        }
    }

    public void testSignedContent07a() throws Exception {
        Bundle testBundle = null;
        try {
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signed_with_corrupt"));
                testBundle.loadClass("org.eclipse.equinox.security.junit.CorruptClass");
            }
            catch (LinkageError error) {
                if ("all".equals(System.getProperty("osgi.signedcontent.support"))) {
                    Throwable t = error.getCause();
                    SignedBundleTest.assertTrue((String)("Cause is the wrong type: " + String.valueOf(t)), (boolean)(t instanceof InvalidContentException));
                }
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.uninstall();
        }
    }

    public void testSignedContent08() throws Exception {
        Bundle testBundle = null;
        try {
            testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signed_tsa"));
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
            SignedBundleTest.assertNotNull((String)"Signing time is null!", (Object)signedContent.getSigningTime(infos[0]));
        }
        finally {
            testBundle.uninstall();
            this.getTrustEngine().removeTrustAnchor("ca1_leafa");
        }
    }

    public void testSignedContent09() throws Exception {
        File unsignedFile = SignedBundleTest.getEntryFile(SignedBundleTest.getTestJarPath("unsigned"));
        SignedBundleTest.assertNotNull((String)"Could not find unsigned file!", (Object)unsignedFile);
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(unsignedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertFalse((String)"Content is signed!!", (boolean)signedContent.isSigned());
    }

    public void testSignedContent10() throws Exception {
        File signedFile = SignedBundleTest.getEntryFile(SignedBundleTest.getTestJarPath("signed"));
        this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
        SignerInfo[] infos = signedContent.getSignerInfos();
        SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
        SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
        signedContent.checkValidity(infos[0]);
        SignedBundleTest.assertTrue((String)"Signer is not trusted", (boolean)infos[0].isTrusted());
        SignedBundleTest.assertNotNull((String)"Trust anchor is null", (Object)infos[0].getTrustAnchor());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedContentEntry[] signedContentEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SignedContentEntry entry = signedContentEntryArray[n2];
            entry.verify();
            SignerInfo[] entryInfos = entry.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
            SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
            ++n2;
        }
    }

    public void testSignedContent11() throws Exception {
        File multipleSigned = SignedBundleTest.getEntryFile(SignedBundleTest.getTestJarPath("multiply_signed"));
        this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca2_leafa"), "ca2_leafa");
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(multipleSigned);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
        SignerInfo[] infos = signedContent.getSignerInfos();
        SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
        SignedBundleTest.assertEquals((String)"wrong number of signers", (int)2, (int)infos.length);
        SignerInfo[] signerInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            SignerInfo info = signerInfoArray[n2];
            signedContent.checkValidity(info);
            signedContent.checkValidity(info);
            SignedBundleTest.assertTrue((String)("Signer is not trusted: " + String.valueOf(info.getCertificateChain()[0])), (boolean)info.isTrusted());
            SignedBundleTest.assertNotNull((String)"Trust anchor is null", (Object)info.getTrustAnchor());
            ++n2;
        }
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedContentEntry[] signedContentEntryArray = entries;
        int n3 = entries.length;
        n = 0;
        while (n < n3) {
            SignedContentEntry entry = signedContentEntryArray[n];
            entry.verify();
            SignerInfo[] entryInfos = entry.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)2, (int)entryInfos.length);
            SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
            ++n;
        }
    }

    public void testSignedContent12() throws Exception {
        File signedFile = SignedBundleTest.getEntryFile(SignedBundleTest.getTestJarPath("signed"));
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
        SignerInfo[] infos = signedContent.getSignerInfos();
        SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
        SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
        SignerInfo[] signerInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            SignerInfo info = signerInfoArray[n2];
            SignedBundleTest.assertTrue((String)("Signer is trusted: " + String.valueOf(info.getCertificateChain()[0])), (!info.isTrusted() ? 1 : 0) != 0);
            ++n2;
        }
    }

    public void testSignedContent13() throws Exception {
        File multipleSigned = SignedBundleTest.getEntryFile(SignedBundleTest.getTestJarPath("multiply_signed"));
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(multipleSigned);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
        SignerInfo[] infos = signedContent.getSignerInfos();
        SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
        SignedBundleTest.assertEquals((String)"wrong number of signers", (int)2, (int)infos.length);
        SignerInfo[] signerInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            SignerInfo info = signerInfoArray[n2];
            SignedBundleTest.assertTrue((String)("Signer is trusted: " + String.valueOf(info.getCertificateChain()[0])), (!info.isTrusted() ? 1 : 0) != 0);
            ++n2;
        }
    }

    public void testSignedContent14() throws Exception {
        File multipleSigned = SignedBundleTest.getEntryFile(SignedBundleTest.getTestJarPath("multiply_signed"));
        this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(multipleSigned);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
        SignerInfo[] infos = signedContent.getSignerInfos();
        SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
        SignedBundleTest.assertEquals((String)"wrong number of signers", (int)2, (int)infos.length);
        SignerInfo[] signerInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            SignerInfo info = signerInfoArray[n2];
            Certificate[] certs = info.getCertificateChain();
            if (info.isTrusted()) {
                X509Certificate x509Cert = (X509Certificate)certs[0];
                SignedBundleTest.assertTrue((String)"CA1 LeafA signer is not trusted", (x509Cert.getSubjectX500Principal().getName().indexOf("CA1 LeafA") >= 0 ? 1 : 0) != 0);
            }
            ++n2;
        }
    }

    public void testSignedContent15() throws Exception {
        File corruptedFile = SignedBundleTest.getEntryFile(SignedBundleTest.getTestJarPath("signed_with_corrupt"));
        this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(corruptedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
        SignerInfo[] infos = signedContent.getSignerInfos();
        SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
        SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedContentEntry[] signedContentEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SignedContentEntry entry = signedContentEntryArray[n2];
            SignerInfo[] entryInfos = entry.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            try {
                entry.verify();
                if ("org/eclipse/equinox/security/junit/CorruptClass.class".equals(entry.getName())) {
                    SignedBundleTest.fail((String)("Expected a corruption for: " + entry.getName()));
                }
                SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
                SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
            }
            catch (InvalidContentException e) {
                SignedBundleTest.assertEquals((String)("Unexpected corruption in '" + entry.getName() + "': " + String.valueOf((Object)e)), (String)"org/eclipse/equinox/security/junit/CorruptClass.class", (String)entry.getName());
                SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)0, (int)entryInfos.length);
            }
            ++n2;
        }
    }

    public void testSignedContent16() throws Exception {
        File signedTsaFile = SignedBundleTest.getEntryFile(SignedBundleTest.getTestJarPath("signed_tsa"));
        this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedTsaFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
        SignerInfo[] infos = signedContent.getSignerInfos();
        SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
        SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
        SignedBundleTest.assertNotNull((String)"Signing time is null!", (Object)signedContent.getSigningTime(infos[0]));
    }

    public void testBug225090_01() throws Exception {
        File signedFile = SignedBundleTest.copyEntryFile(SignedBundleTest.getTestJarPath("signed"));
        this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
        SignerInfo[] infos = signedContent.getSignerInfos();
        SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
        SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
        signedContent.checkValidity(infos[0]);
        SignedBundleTest.assertTrue((String)"Signer is not trusted", (boolean)infos[0].isTrusted());
        SignedBundleTest.assertNotNull((String)"Trust anchor is null", (Object)infos[0].getTrustAnchor());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedContentEntry[] signedContentEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SignedContentEntry entry = signedContentEntryArray[n2];
            entry.verify();
            SignerInfo[] entryInfos = entry.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
            SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
            ++n2;
        }
        signedFile.delete();
        SignedBundleTest.assertFalse((String)"File should not exist", (boolean)signedFile.exists());
    }

    public void testBug225090_02() throws Exception {
        File unsignedFile = SignedBundleTest.copyEntryFile(SignedBundleTest.getTestJarPath("unsigned"));
        SignedBundleTest.assertNotNull((String)"Could not find unsigned file!", (Object)unsignedFile);
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(unsignedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertFalse((String)"Content is signed!!", (boolean)signedContent.isSigned());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedContentEntry[] signedContentEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SignedContentEntry entry = signedContentEntryArray[n2];
            entry.verify();
            SignerInfo[] entryInfos = entry.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)0, (int)entryInfos.length);
            ++n2;
        }
        unsignedFile.delete();
        SignedBundleTest.assertFalse((String)"File should not exist", (boolean)unsignedFile.exists());
    }

    public void testBug228427_01() throws Exception {
        File signedFile = SignedBundleTest.copyEntryFile(SignedBundleTest.getTestJarPath("signed_with_metadata"));
        SignedBundleTest.assertNotNull((String)"Could not find signed file!", (Object)signedFile);
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Content is not signed!!", (boolean)signedContent.isSigned());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedBundleTest.assertEquals((String)"Incorrect number of signed entries", (int)5, (int)entries.length);
        SignedContentEntry[] signedContentEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SignedContentEntry entry = signedContentEntryArray[n2];
            entry.verify();
            SignerInfo[] entryInfos = entry.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
            ++n2;
        }
        signedFile.delete();
        SignedBundleTest.assertFalse((String)"File should not exist", (boolean)signedFile.exists());
    }

    public void testBug228427_02() throws Exception {
        File signedFile = SignedBundleTest.copyEntryFile(SignedBundleTest.getTestJarPath("signed_with_metadata_added"));
        SignedBundleTest.assertNotNull((String)"Could not find signed file!", (Object)signedFile);
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Content is not signed!!", (boolean)signedContent.isSigned());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedBundleTest.assertEquals((String)"Incorrect number of signed entries", (int)4, (int)entries.length);
        SignedContentEntry[] signedContentEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SignedContentEntry entry = signedContentEntryArray[n2];
            entry.verify();
            SignerInfo[] entryInfos = entry.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
            ++n2;
        }
        signedFile.delete();
        SignedBundleTest.assertFalse((String)"File should not exist", (boolean)signedFile.exists());
    }

    public void testBug228427_03() throws Exception {
        File signedFile = SignedBundleTest.copyEntryFile(SignedBundleTest.getTestJarPath("signed_with_metadata_corrupt"));
        SignedBundleTest.assertNotNull((String)"Could not find signed file!", (Object)signedFile);
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Content is not signed!!", (boolean)signedContent.isSigned());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedBundleTest.assertEquals((String)"Incorrect number of signed entries", (int)5, (int)entries.length);
        SignedContentEntry[] signedContentEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SignedContentEntry entry = signedContentEntryArray[n2];
            try {
                entry.verify();
                SignedBundleTest.assertFalse((String)("Wrong entry is validated: " + entry.getName()), (boolean)"META-INF/test/test1.file".equals(entry.getName()));
                SignerInfo[] entryInfos = entry.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
            }
            catch (InvalidContentException e) {
                SignedBundleTest.assertEquals((String)"Wrong entry is corrupted", (String)"META-INF/test/test1.file", (String)entry.getName());
                SignerInfo[] entryInfos = entry.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)0, (int)entryInfos.length);
            }
            ++n2;
        }
        signedFile.delete();
        SignedBundleTest.assertFalse((String)"File should not exist", (boolean)signedFile.exists());
    }

    public void testBug228427_04() throws Exception {
        File signedFile = SignedBundleTest.copyEntryFile(SignedBundleTest.getTestJarPath("signed_with_metadata_removed"));
        SignedBundleTest.assertNotNull((String)"Could not find signed file!", (Object)signedFile);
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Content is not signed!!", (boolean)signedContent.isSigned());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedBundleTest.assertEquals((String)"Incorrect number of signed entries", (int)4, (int)entries.length);
        SignedContentEntry[] signedContentEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SignedContentEntry entry = signedContentEntryArray[n2];
            entry.verify();
            SignerInfo[] entryInfos = entry.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
            ++n2;
        }
        signedFile.delete();
        SignedBundleTest.assertFalse((String)"File should not exist", (boolean)signedFile.exists());
    }

    public void testBug236329_01() throws Exception {
        File signedFile = SignedBundleTest.copyEntryFile(SignedBundleTest.getTestJarPath("signed_with_sf_corrupted"));
        SignedBundleTest.assertNotNull((String)"Could not find signed file!", (Object)signedFile);
        try {
            this.getSignedContentFactory().getSignedContent(signedFile);
            SignedBundleTest.fail((String)("Should have gotten a SignatureException for file: " + String.valueOf(signedFile)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testBug252098() throws Exception {
        Bundle testBundle = null;
        try {
            testBundle = this.installBundle(SignedBundleTest.getTestJarPath("test.bug252098"));
            SignedBundleTest.assertNotNull((String)"Test bundle not installed!", (Object)testBundle);
            testBundle.start();
        }
        finally {
            if (testBundle != null) {
                testBundle.uninstall();
            }
        }
    }

    public void testBug378155() throws Exception {
        this.doTestBug378155("SHA256withRSA");
        this.doTestBug378155("SHA384withRSA");
        this.doTestBug378155("SHA512withRSA");
    }

    private void doTestBug378155(String bundleName) throws Exception {
        Bundle testBundle = null;
        try {
            testBundle = this.installBundle(SignedBundleTest.getTestJarPath(bundleName));
            SignedBundleTest.assertNotNull((String)"Test bundle not installed!", (Object)testBundle);
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
            signedContent.checkValidity(infos[0]);
            SignedBundleTest.assertFalse((String)"Signer is trusted", (boolean)infos[0].isTrusted());
            SignedBundleTest.assertNull((String)"Trust anchor is not null", (Object)infos[0].getTrustAnchor());
            SignedContentEntry[] entries = signedContent.getSignedEntries();
            SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
            SignedContentEntry[] signedContentEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                SignedContentEntry entry = signedContentEntryArray[n2];
                entry.verify();
                SignerInfo[] entryInfos = entry.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
                SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                ++n2;
            }
        }
        finally {
            if (testBundle != null) {
                testBundle.uninstall();
            }
        }
    }

    public void testBug434711() throws Exception {
        File nonAsciiFile = SignedBundleTest.getEntryFile(SignedBundleTest.getTestJarPath("bundleWithNonAsciiCharsFilename"));
        SignedBundleTest.assertNotNull((String)"Could not find Non Ascii Chars file!", (Object)nonAsciiFile);
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(nonAsciiFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Content is not signed!!", (boolean)signedContent.isSigned());
        SignedContentEntry[] signedContentEntryArray = signedContent.getSignedEntries();
        int n = signedContentEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            SignedContentEntry entry = signedContentEntryArray[n2];
            entry.verify();
            ++n2;
        }
    }

    public void test489686() throws Exception {
        Bundle testBundle = null;
        try {
            testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signed_with_missing_digest"));
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertFalse((String)"Should not be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)0, (int)infos.length);
            SignedContentEntry[] entries = signedContent.getSignedEntries();
            SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
            SignedBundleTest.assertEquals((String)"Expected no signed entries.", (int)0, (int)entries.length);
        }
        finally {
            testBundle.uninstall();
        }
    }

    public void testSignedContentJava16() throws Exception {
        Bundle testBundle = null;
        try {
            testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signedJava16"));
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca2_leafa"), "ca2_leafa");
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
            signedContent.checkValidity(infos[0]);
            SignedBundleTest.assertTrue((String)"Signer is not trusted", (boolean)infos[0].isTrusted());
            SignedBundleTest.assertNotNull((String)"Trust anchor is null", (Object)infos[0].getTrustAnchor());
            SignedContentEntry[] entries = signedContent.getSignedEntries();
            SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
            SignedContentEntry[] signedContentEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                SignedContentEntry entry = signedContentEntryArray[n2];
                entry.verify();
                SignerInfo[] entryInfos = entry.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
                SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                ++n2;
            }
        }
        finally {
            testBundle.uninstall();
            this.getTrustEngine().removeTrustAnchor("ca2_leafa");
        }
    }
}

