/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.securityadmin;

import ext.framework.b.TestCondition;
import java.io.File;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.securityadmin.SecurityManagerTests;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public class SecurityAdminUnitTests
extends AbstractBundleTests {
    private static final PermissionInfo[] SOCKET_INFOS = new PermissionInfo[]{new PermissionInfo("java.net.SocketPermission", "localhost", "accept")};
    private static final PermissionInfo[] READONLY_INFOS = new PermissionInfo[]{new PermissionInfo("java.io.FilePermission", "<<ALL FILES>>", "read")};
    private static final PermissionInfo[] READWRITE_INFOS = new PermissionInfo[]{new PermissionInfo("java.io.FilePermission", "<<ALL FILES>>", "read"), new PermissionInfo("java.io.FilePermission", "<<ALL FILES>>", "write")};
    private static final PermissionInfo[] RELATIVE_EXEC_FILE_INFOS = new PermissionInfo[]{new PermissionInfo("java.io.FilePermission", "bin/*", "execute")};
    private static final PermissionInfo[] RUNTIME_INFOS = new PermissionInfo[]{new PermissionInfo("java.lang.RuntimePermission", "exitVM", null)};
    private static final ConditionInfo[] ALLLOCATION_CONDS = new ConditionInfo[]{new ConditionInfo("org.osgi.service.condpermadmin.BundleLocationCondition", new String[]{"*"})};
    private static final ConditionInfo MUT_SAT = new ConditionInfo("ext.framework.b.TestCondition", new String[]{"MUT_SAT", "true", "false", "true"});
    private static final ConditionInfo NOT_MUT_SAT = new ConditionInfo("ext.framework.b.TestCondition", new String[]{"NOT_MUT_SAT", "false", "false", "true"});
    private static final ConditionInfo POST_MUT_SAT = new ConditionInfo("ext.framework.b.TestCondition", new String[]{"POST_MUT_SAT", "true", "true", "true"});
    private static final ConditionInfo POST_MUT_UNSAT = new ConditionInfo("ext.framework.b.TestCondition", new String[]{"POST_MUT_UNSAT", "true", "true", "false"});
    private static final ConditionInfo SIGNER_CONDITION1 = new ConditionInfo("org.osgi.service.condpermadmin.BundleSignerCondition", new String[]{"*;cn=test1,c=US"});
    private static final ConditionInfo SIGNER_CONDITION2 = new ConditionInfo("org.osgi.service.condpermadmin.BundleSignerCondition", new String[]{"*;cn=test2,c=US"});
    private static final ConditionInfo NOT_SIGNER_CONDITION1 = new ConditionInfo("org.osgi.service.condpermadmin.BundleSignerCondition", new String[]{"*;cn=test1,c=US", "!"});
    private static final String TEST_BUNDLE = "test";
    private static final String TEST2_BUNDLE = "test2";
    private Policy previousPolicy;
    private Equinox equinox;
    private ConditionalPermissionAdmin cpa;
    private PermissionAdmin pa;

    @BeforeClass
    public static void setupClass() {
        Assume.assumeTrue((String)"Security-Manager is disallowed", (boolean)SecurityManagerTests.isSecurityManagerAllowed());
    }

    @Override
    public void setUp() throws Exception {
        this.previousPolicy = Policy.getPolicy();
        final AllPermission allPermission = new AllPermission();
        final PermissionCollection allPermissions = new PermissionCollection(){
            private static final long serialVersionUID = 3258131349494708277L;

            @Override
            public void add(Permission permission) {
            }

            @Override
            public boolean implies(Permission permission) {
                return true;
            }

            public Enumeration elements() {
                return new Enumeration(){
                    int cur = 0;

                    @Override
                    public boolean hasMoreElements() {
                        return this.cur < 1;
                    }

                    public Object nextElement() {
                        if (this.cur == 0) {
                            this.cur = 1;
                            return allPermission;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }
        };
        Policy.setPolicy(new Policy(){

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                return allPermissions;
            }

            @Override
            public void refresh() {
            }
        });
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        this.equinox = new Equinox(configuration);
        this.equinox.init();
        this.cpa = (ConditionalPermissionAdmin)this.equinox.getBundleContext().getService(this.equinox.getBundleContext().getServiceReference(ConditionalPermissionAdmin.class));
        this.pa = (PermissionAdmin)this.equinox.getBundleContext().getService(this.equinox.getBundleContext().getServiceReference(PermissionAdmin.class));
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        this.equinox.stop();
        if (System.getSecurityManager() != null) {
            System.setSecurityManager(null);
        }
        Policy.setPolicy(this.previousPolicy);
        super.tearDown();
    }

    @Test
    public void testCreateDomain() throws BundleException {
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        this.testPermission(acc, new AllPermission(), true);
    }

    @Test
    public void testLocationPermission01() throws BundleException {
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        this.pa.setPermissions(test.getLocation(), READONLY_INFOS);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), false);
        this.pa.setPermissions(test.getLocation(), null);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), true);
    }

    @Test
    public void testLocationPermission02() throws BundleException {
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        this.pa.setPermissions(test.getLocation(), READWRITE_INFOS);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), false);
        this.pa.setPermissions(test.getLocation(), null);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), true);
    }

    @Test
    public void testLocationPermission03() throws BundleException {
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        this.pa.setDefaultPermissions(READONLY_INFOS);
        this.pa.setPermissions(test.getLocation(), READWRITE_INFOS);
        ConditionalPermissionInfo condPermInfo = this.cpa.addConditionalPermissionInfo(ALLLOCATION_CONDS, SOCKET_INFOS);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), false);
        this.testPermission(acc, new SocketPermission("localhost", "accept"), false);
        this.pa.setPermissions(test.getLocation(), null);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), false);
        this.testPermission(acc, new AllPermission(), false);
        this.testPermission(acc, new SocketPermission("localhost", "accept"), true);
        condPermInfo.delete();
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), false);
        this.testPermission(acc, new SocketPermission("localhost", "accept"), false);
        this.pa.setDefaultPermissions(null);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), true);
        this.testPermission(acc, new SocketPermission("localhost", "accept"), true);
    }

    @Test
    public void testDefaultPermissions01() throws BundleException {
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        this.pa.setDefaultPermissions(READONLY_INFOS);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), false);
        this.pa.setDefaultPermissions(null);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), true);
    }

    @Test
    public void testDefaultPermissions02() throws BundleException {
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        this.pa.setDefaultPermissions(READONLY_INFOS);
        this.pa.setPermissions(test.getLocation(), SOCKET_INFOS);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), false);
        this.testPermission(acc, new AllPermission(), false);
        this.testPermission(acc, new SocketPermission("localhost", "accept"), true);
        this.pa.setPermissions(test.getLocation(), null);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), false);
        this.testPermission(acc, new SocketPermission("localhost", "accept"), false);
        this.pa.setDefaultPermissions(null);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), true);
    }

    @Test
    public void testNotLocationCondition01() throws BundleException {
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        ConditionalPermissionInfo condPermInfo = this.cpa.addConditionalPermissionInfo(this.getLocationConditions("xxx", true), SOCKET_INFOS);
        this.testPermission(acc, new AllPermission(), false);
        this.testPermission(acc, new SocketPermission("localhost", "accept"), true);
        condPermInfo.delete();
        this.testPermission(acc, new AllPermission(), true);
        this.testPermission(acc, new SocketPermission("localhost", "accept"), true);
    }

    @Test
    public void testNotLocationCondition02() throws BundleException {
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        ConditionalPermissionInfo condPermInfo = this.cpa.addConditionalPermissionInfo(this.getLocationConditions(test.getLocation(), true), SOCKET_INFOS);
        this.testPermission(acc, new AllPermission(), false);
        this.testPermission(acc, new SocketPermission("localhost", "accept"), false);
        condPermInfo.delete();
        this.testPermission(acc, new AllPermission(), true);
        this.testPermission(acc, new SocketPermission("localhost", "accept"), true);
    }

    @Test
    public void testMultipleLocationConditions01() throws BundleException {
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        ConditionalPermissionInfo condPermInfo1 = this.cpa.addConditionalPermissionInfo(this.getLocationConditions("xxx", false), SOCKET_INFOS);
        ConditionalPermissionInfo condPermInfo2 = this.cpa.addConditionalPermissionInfo(ALLLOCATION_CONDS, READONLY_INFOS);
        this.testPermission(acc, new SocketPermission("localhost", "accept"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        condPermInfo1.delete();
        this.testPermission(acc, new SocketPermission("localhost", "accept"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        condPermInfo2.delete();
        this.testPermission(acc, new SocketPermission("localhost", "accept"), true);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
    }

    @Test
    public void testMultipleLocationConditions02() throws BundleException {
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext pd = (AccessControlContext)test.adapt(AccessControlContext.class);
        ConditionalPermissionInfo condPermInfo1 = this.cpa.addConditionalPermissionInfo(this.getLocationConditions("xxx", false), SOCKET_INFOS);
        ConditionalPermissionInfo condPermInfo2 = this.cpa.addConditionalPermissionInfo(ALLLOCATION_CONDS, READONLY_INFOS);
        ConditionalPermissionInfo condPermInfo3 = this.cpa.addConditionalPermissionInfo(this.getLocationConditions(test.getLocation(), false), RUNTIME_INFOS);
        this.testPermission(pd, new SocketPermission("localhost", "accept"), false);
        this.testPermission(pd, new RuntimePermission("exitVM", null), true);
        this.testPermission(pd, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(pd, new FilePermission(TEST_BUNDLE, "read"), true);
        condPermInfo1.delete();
        this.testPermission(pd, new SocketPermission("localhost", "accept"), false);
        this.testPermission(pd, new RuntimePermission("exitVM", null), true);
        this.testPermission(pd, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(pd, new FilePermission(TEST_BUNDLE, "read"), true);
        condPermInfo2.delete();
        this.testPermission(pd, new SocketPermission("localhost", "accept"), false);
        this.testPermission(pd, new RuntimePermission("exitVM", null), true);
        this.testPermission(pd, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(pd, new FilePermission(TEST_BUNDLE, "read"), false);
        condPermInfo3.delete();
        this.testPermission(pd, new SocketPermission("localhost", "accept"), true);
        this.testPermission(pd, new RuntimePermission("exitVM", null), true);
        this.testPermission(pd, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testPermission(pd, new FilePermission(TEST_BUNDLE, "read"), true);
    }

    @Test
    public void testUpdate01() {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        Assert.assertTrue((String)"table is not empty", (boolean)rows.isEmpty());
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
    }

    @Test
    public void testUpdate02() throws BundleException {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        ConditionalPermissionInfo info = this.cpa.newConditionalPermissionInfo(null, ALLLOCATION_CONDS, READONLY_INFOS, "allow");
        rows.add(info);
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), false);
        update = this.cpa.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.clear();
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), true);
    }

    @Test
    public void testUpdate03() throws BundleException {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        ConditionalPermissionInfo info1 = this.cpa.newConditionalPermissionInfo(null, ALLLOCATION_CONDS, READWRITE_INFOS, "deny");
        ConditionalPermissionInfo info2 = this.cpa.newConditionalPermissionInfo(null, ALLLOCATION_CONDS, READONLY_INFOS, "allow");
        rows.add(info1);
        rows.add(info2);
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), false);
        this.testPermission(acc, new AllPermission(), false);
        update = this.cpa.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.remove(0);
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), false);
        update = this.cpa.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.remove(0);
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), true);
    }

    @Test
    public void testUpdate04() throws BundleException {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        ConditionalPermissionInfo info1 = this.cpa.newConditionalPermissionInfo(null, ALLLOCATION_CONDS, READWRITE_INFOS, "deny");
        ConditionalPermissionInfo info2 = this.cpa.newConditionalPermissionInfo(null, ALLLOCATION_CONDS, READONLY_INFOS, "allow");
        rows.add(info1);
        rows.add(info2);
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        ConditionalPermissionUpdate update1 = this.cpa.newConditionalPermissionUpdate();
        List rows1 = update1.getConditionalPermissionInfos();
        rows1.remove(0);
        ConditionalPermissionUpdate update2 = this.cpa.newConditionalPermissionUpdate();
        List rows2 = update2.getConditionalPermissionInfos();
        rows2.remove(0);
        Assert.assertTrue((String)"failed to commit", (boolean)update2.commit());
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), false);
        Assert.assertFalse((String)"succeeded commit", (boolean)update1.commit());
        update = this.cpa.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.remove(0);
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), true);
    }

    @Test
    public void testSecurityManager01() throws BundleException {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        ConditionalPermissionInfo info = this.cpa.newConditionalPermissionInfo(null, ALLLOCATION_CONDS, READONLY_INFOS, "allow");
        rows.add(info);
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        ProtectionDomain pd = (ProtectionDomain)test.adapt(ProtectionDomain.class);
        ProtectionDomain[] pds = new ProtectionDomain[]{pd};
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "write"), false);
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testSMPermission(pds, new AllPermission(), false);
        update = this.cpa.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.clear();
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "write"), true);
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testSMPermission(pds, new AllPermission(), true);
    }

    @Test
    public void testPostponedConditions01() throws BundleException {
        this.installConditionBundle();
        TestCondition.clearConditions();
        Bundle test1 = this.installTestBundle(TEST_BUNDLE);
        Bundle test2 = this.installTestBundle(TEST2_BUNDLE);
        ProtectionDomain pd1 = (ProtectionDomain)test1.adapt(ProtectionDomain.class);
        ProtectionDomain pd2 = (ProtectionDomain)test2.adapt(ProtectionDomain.class);
        ProtectionDomain[] pds = new ProtectionDomain[]{pd1, pd2};
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_SAT}, READONLY_INFOS, "deny"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_UNSAT}, READONLY_INFOS, "allow"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, ALLLOCATION_CONDS, READONLY_INFOS, "deny"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), false);
        TestCondition tc1sat = TestCondition.getTestCondition((String)("POST_MUT_SAT_" + test1.getBundleId()));
        TestCondition tc2sat = TestCondition.getTestCondition((String)("POST_MUT_SAT_" + test2.getBundleId()));
        TestCondition tc1unsat = TestCondition.getTestCondition((String)("POST_MUT_UNSAT_" + test1.getBundleId()));
        TestCondition tc2unsat = TestCondition.getTestCondition((String)("POST_MUT_UNSAT_" + test2.getBundleId()));
        Assert.assertNotNull((String)"tc1sat", (Object)tc1sat);
        Assert.assertNotNull((String)"tc2sat", (Object)tc2sat);
        Assert.assertNotNull((String)"tc1unsat", (Object)tc1unsat);
        Assert.assertNotNull((String)"tc2unsat", (Object)tc2unsat);
        tc1sat.setSatisfied(false);
        tc2sat.setSatisfied(false);
        tc1unsat.setSatisfied(true);
        tc2unsat.setSatisfied(true);
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), true);
        tc1sat.setSatisfied(true);
        tc2sat.setSatisfied(true);
        update = this.cpa.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.remove(0);
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), true);
        tc1unsat.setSatisfied(false);
        tc2unsat.setSatisfied(false);
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), false);
        update = this.cpa.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.remove(0);
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), false);
    }

    @Test
    public void testPostponedConditions02() throws BundleException {
        this.installConditionBundle();
        TestCondition.clearConditions();
        Bundle test1 = this.installTestBundle(TEST_BUNDLE);
        Bundle test2 = this.installTestBundle(TEST2_BUNDLE);
        ProtectionDomain pd1 = (ProtectionDomain)test1.adapt(ProtectionDomain.class);
        ProtectionDomain pd2 = (ProtectionDomain)test2.adapt(ProtectionDomain.class);
        ProtectionDomain[] pds = new ProtectionDomain[]{pd1, pd2};
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_SAT}, READONLY_INFOS, "deny"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_SAT}, READONLY_INFOS, "deny"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_UNSAT}, READONLY_INFOS, "deny"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, ALLLOCATION_CONDS, READONLY_INFOS, "deny"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), false);
        TestCondition tc1sat = TestCondition.getTestCondition((String)("POST_MUT_SAT_" + test1.getBundleId()));
        TestCondition tc2sat = TestCondition.getTestCondition((String)("POST_MUT_SAT_" + test2.getBundleId()));
        TestCondition tc1unsat = TestCondition.getTestCondition((String)("POST_MUT_UNSAT_" + test1.getBundleId()));
        TestCondition tc2unsat = TestCondition.getTestCondition((String)("POST_MUT_UNSAT_" + test2.getBundleId()));
        Assert.assertTrue((String)"tc1sat and tc2sat are either both null or both non-null", (boolean)(tc1sat == null ^ tc2sat == null));
        Assert.assertTrue((String)"tc1unsat and tc2unsat are either both null or both non-null", (boolean)(tc1unsat == null ^ tc2unsat == null));
        TestCondition modifySat = tc1sat != null ? tc1sat : tc2sat;
        TestCondition modifyUnsat = tc1unsat != null ? tc1unsat : tc2unsat;
        modifySat.setSatisfied(false);
        modifyUnsat.setSatisfied(true);
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), false);
    }

    @Test
    public void testPostponedConditions03() throws BundleException {
        this.installConditionBundle();
        TestCondition.clearConditions();
        Bundle test1 = this.installTestBundle(TEST_BUNDLE);
        Bundle test2 = this.installTestBundle(TEST2_BUNDLE);
        ProtectionDomain pd1 = (ProtectionDomain)test1.adapt(ProtectionDomain.class);
        ProtectionDomain pd2 = (ProtectionDomain)test2.adapt(ProtectionDomain.class);
        ProtectionDomain[] pds = new ProtectionDomain[]{pd1, pd2};
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_SAT}, READONLY_INFOS, "allow"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_SAT}, READONLY_INFOS, "allow"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_UNSAT}, READONLY_INFOS, "allow"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, ALLLOCATION_CONDS, READONLY_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), true);
        TestCondition tc1sat = TestCondition.getTestCondition((String)("POST_MUT_SAT_" + test1.getBundleId()));
        TestCondition tc2sat = TestCondition.getTestCondition((String)("POST_MUT_SAT_" + test2.getBundleId()));
        TestCondition tc1unsat = TestCondition.getTestCondition((String)("POST_MUT_UNSAT_" + test1.getBundleId()));
        TestCondition tc2unsat = TestCondition.getTestCondition((String)("POST_MUT_UNSAT_" + test2.getBundleId()));
        Assert.assertNotNull((String)"tc1sat", (Object)tc1sat);
        Assert.assertNotNull((String)"tc2sat", (Object)tc2sat);
        Assert.assertNotNull((String)"tc1unsat", (Object)tc1unsat);
        Assert.assertNotNull((String)"tc2unsat", (Object)tc2unsat);
        tc1sat.setSatisfied(false);
        tc2sat.setSatisfied(false);
        tc1unsat.setSatisfied(true);
        tc2unsat.setSatisfied(true);
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), true);
    }

    @Test
    public void testPostponedConditions04() throws BundleException {
        this.installConditionBundle();
        TestCondition.clearConditions();
        Bundle test1 = this.installTestBundle(TEST_BUNDLE);
        Bundle test2 = this.installTestBundle(TEST2_BUNDLE);
        ProtectionDomain pd1 = (ProtectionDomain)test1.adapt(ProtectionDomain.class);
        ProtectionDomain pd2 = (ProtectionDomain)test2.adapt(ProtectionDomain.class);
        ProtectionDomain[] pds = new ProtectionDomain[]{pd1, pd2};
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_SAT}, READONLY_INFOS, "deny"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_SAT}, READONLY_INFOS, "deny"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_UNSAT}, READONLY_INFOS, "deny"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), false);
        TestCondition tc1sat = TestCondition.getTestCondition((String)("POST_MUT_SAT_" + test1.getBundleId()));
        TestCondition tc2sat = TestCondition.getTestCondition((String)("POST_MUT_SAT_" + test2.getBundleId()));
        TestCondition tc1unsat = TestCondition.getTestCondition((String)("POST_MUT_UNSAT_" + test1.getBundleId()));
        TestCondition tc2unsat = TestCondition.getTestCondition((String)("POST_MUT_UNSAT_" + test2.getBundleId()));
        Assert.assertTrue((String)"tc1sat and tc2sat are either both null or both non-null", (boolean)(tc1sat == null ^ tc2sat == null));
        Assert.assertTrue((String)"tc1unsat and tc2unsat are either both null or both non-null", (boolean)(tc1unsat == null ^ tc2unsat == null));
        TestCondition modifySat = tc1sat != null ? tc1sat : tc2sat;
        TestCondition modifyUnsat = tc1unsat != null ? tc1unsat : tc2unsat;
        modifySat.setSatisfied(false);
        modifyUnsat.setSatisfied(true);
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), false);
    }

    @Test
    public void testPostponedConditions05() throws BundleException {
        this.installConditionBundle();
        TestCondition.clearConditions();
        Bundle test1 = this.installTestBundle(TEST_BUNDLE);
        Bundle test2 = this.installTestBundle(TEST2_BUNDLE);
        ProtectionDomain pd1 = (ProtectionDomain)test1.adapt(ProtectionDomain.class);
        ProtectionDomain pd2 = (ProtectionDomain)test2.adapt(ProtectionDomain.class);
        ProtectionDomain[] pds = new ProtectionDomain[]{pd1, pd2};
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_SAT}, READONLY_INFOS, "deny"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_UNSAT}, READONLY_INFOS, "allow"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_SAT}, READONLY_INFOS, "allow"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{POST_MUT_UNSAT}, READONLY_INFOS, "allow"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, ALLLOCATION_CONDS, READONLY_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), false);
        TestCondition tc1sat = TestCondition.getTestCondition((String)("POST_MUT_SAT_" + test1.getBundleId()));
        TestCondition tc2sat = TestCondition.getTestCondition((String)("POST_MUT_SAT_" + test2.getBundleId()));
        TestCondition tc1unsat = TestCondition.getTestCondition((String)("POST_MUT_UNSAT_" + test1.getBundleId()));
        TestCondition tc2unsat = TestCondition.getTestCondition((String)("POST_MUT_UNSAT_" + test2.getBundleId()));
        Assert.assertNotNull((String)"tc1sat", (Object)tc1sat);
        Assert.assertNotNull((String)"tc2sat", (Object)tc2sat);
        Assert.assertNotNull((String)"tc1unsat", (Object)tc1unsat);
        Assert.assertNotNull((String)"tc2unsat", (Object)tc2unsat);
        tc1sat.setSatisfied(false);
        tc2sat.setSatisfied(false);
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), true);
    }

    @Test
    public void testMutableConditions() throws BundleException {
        this.installConditionBundle();
        TestCondition.clearConditions();
        Bundle test1 = this.installTestBundle(TEST_BUNDLE);
        ProtectionDomain pd1 = (ProtectionDomain)test1.adapt(ProtectionDomain.class);
        ProtectionDomain[] pds = new ProtectionDomain[]{pd1};
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{MUT_SAT}, READONLY_INFOS, "deny"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, ALLLOCATION_CONDS, READONLY_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), false);
        TestCondition tc1sat = TestCondition.getTestCondition((String)("MUT_SAT_" + test1.getBundleId()));
        Assert.assertNotNull((String)"tc1sat", (Object)tc1sat);
        tc1sat.setSatisfied(false);
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), true);
        tc1sat.setSatisfied(true);
        update = this.cpa.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.clear();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{NOT_MUT_SAT, MUT_SAT}, READONLY_INFOS, "deny"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, ALLLOCATION_CONDS, READONLY_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), false);
        this.testSMPermission(pds, new FilePermission(TEST_BUNDLE, "read"), false);
        this.testSMPermission(pds, new FilePermission(TEST2_BUNDLE, "read"), false);
        TestCondition tc2sat = TestCondition.getTestCondition((String)("NOT_MUT_SAT_" + test1.getBundleId()));
        Assert.assertNotNull((String)"tc2sat", (Object)tc2sat);
    }

    @Test
    public void testAccessControlContext01() {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION1}, READONLY_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        AccessControlContext acc = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test1,c=US"});
        Assert.assertThrows(AccessControlException.class, () -> acc.checkPermission(new FilePermission(TEST_BUNDLE, "write")));
        acc.checkPermission(new FilePermission(TEST_BUNDLE, "read"));
    }

    @Test
    public void testAccessControlContext01a() {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION1}, READONLY_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        AccessControlContext acc = this.cpa.getAccessControlContext(new String[]{"cn=test1,c=US"});
        Assert.assertThrows(AccessControlException.class, () -> acc.checkPermission(new FilePermission(TEST_BUNDLE, "write")));
        acc.checkPermission(new FilePermission(TEST_BUNDLE, "read"));
    }

    @Test
    public void testAccessControlContext02() {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION1}, READONLY_INFOS, "allow"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION1}, READWRITE_INFOS, "deny"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION1}, READWRITE_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        AccessControlContext acc = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test1,c=US"});
        Assert.assertThrows(AccessControlException.class, () -> acc.checkPermission(new FilePermission(TEST_BUNDLE, "write")));
        acc.checkPermission(new FilePermission(TEST_BUNDLE, "read"));
    }

    @Test
    public void testAccessControlContext03() {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION1}, READONLY_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        AccessControlContext acc = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test2,c=US"});
        Assert.assertThrows(AccessControlException.class, () -> acc.checkPermission(new FilePermission(TEST_BUNDLE, "write")));
        Assert.assertThrows(AccessControlException.class, () -> acc.checkPermission(new FilePermission(TEST_BUNDLE, "read")));
        update = this.cpa.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION2}, READONLY_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        AccessControlContext acc2 = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test2,c=US"});
        Assert.assertThrows(AccessControlException.class, () -> acc2.checkPermission(new FilePermission(TEST_BUNDLE, "write")));
        acc2.checkPermission(new FilePermission(TEST_BUNDLE, "read"));
    }

    @Test
    public void testAccessControlContext04() {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION1, SIGNER_CONDITION2}, READONLY_INFOS, "allow"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION1}, READWRITE_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        AccessControlContext acc = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test2,c=US"});
        Assert.assertThrows(AccessControlException.class, () -> acc.checkPermission(new FilePermission(TEST_BUNDLE, "write")));
        Assert.assertThrows(AccessControlException.class, () -> acc.checkPermission(new FilePermission(TEST_BUNDLE, "read")));
        AccessControlContext acc2 = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test1,c=US", "cn=t1,c=FR;cn=test2,c=US"});
        acc2.checkPermission(new FilePermission(TEST_BUNDLE, "write"));
        acc2.checkPermission(new FilePermission(TEST_BUNDLE, "read"));
    }

    @Test
    public void testAccessControlContext05() {
        AccessControlContext acc = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test2,c=US"});
        acc.checkPermission(new FilePermission(TEST_BUNDLE, "write"));
        acc.checkPermission(new FilePermission(TEST_BUNDLE, "read"));
        acc.checkPermission(new AllPermission());
        this.pa.setDefaultPermissions(READWRITE_INFOS);
        AccessControlContext acc2 = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test2,c=US"});
        acc2.checkPermission(new FilePermission(TEST_BUNDLE, "write"));
        acc2.checkPermission(new FilePermission(TEST_BUNDLE, "read"));
        Assert.assertThrows(AccessControlException.class, () -> acc2.checkPermission(new AllPermission()));
    }

    @Test
    public void testAccessControlContext06() {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[0], READONLY_INFOS, "allow"));
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION1}, READWRITE_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        AccessControlContext acc = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test2,c=US"});
        acc.checkPermission(new FilePermission(TEST_BUNDLE, "read"));
        Assert.assertThrows(AccessControlException.class, () -> acc.checkPermission(new FilePermission(TEST_BUNDLE, "write")));
    }

    @Test
    public void testAccessControlContext07() {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{NOT_SIGNER_CONDITION1}, READONLY_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        AccessControlContext acc = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test1,c=US"});
        Assert.assertThrows(AccessControlException.class, () -> acc.checkPermission(new FilePermission(TEST_BUNDLE, "write")));
        Assert.assertThrows(AccessControlException.class, () -> acc.checkPermission(new FilePermission(TEST_BUNDLE, "read")));
        AccessControlContext acc2 = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test2,c=US"});
        Assert.assertThrows(AccessControlException.class, () -> acc2.checkPermission(new FilePermission(TEST_BUNDLE, "write")));
        acc2.checkPermission(new FilePermission(TEST_BUNDLE, "read"));
    }

    @Test
    public void testEncodingInfos01() throws Exception {
        String info1 = "ALLOW { [Test1] (Type1 \"name1\" \"action1\") } \"name1\"";
        String info2 = "ALLOW { [Test2] (Type2 \"name2\" \"action2\") } \"name2\"";
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List updateInfos = update.getConditionalPermissionInfos();
        updateInfos.add(this.cpa.newConditionalPermissionInfo(info1));
        updateInfos.add(this.cpa.newConditionalPermissionInfo(info2));
        Assert.assertTrue((String)"Failed commit", (boolean)update.commit());
        SecurityAdminUnitTests.stop((Framework)this.equinox);
        this.equinox.init();
        this.cpa = (ConditionalPermissionAdmin)this.equinox.getBundleContext().getService(this.equinox.getBundleContext().getServiceReference(ConditionalPermissionAdmin.class));
        this.pa = (PermissionAdmin)this.equinox.getBundleContext().getService(this.equinox.getBundleContext().getServiceReference(PermissionAdmin.class));
        String info3 = "deny { [Test3] (Type3 \"name3\" \"action3\") } \"name3\"";
        ArrayList infos = new ArrayList();
        Enumeration eInfos = this.cpa.getConditionalPermissionInfos();
        while (eInfos.hasMoreElements()) {
            infos.add(eInfos.nextElement());
        }
        Assert.assertEquals((String)"Wrong number of infos", (long)2L, (long)infos.size());
        Assert.assertTrue((String)"Missing info1", (boolean)infos.contains(this.cpa.newConditionalPermissionInfo(info1)));
        Assert.assertTrue((String)"Missing info2", (boolean)infos.contains(this.cpa.newConditionalPermissionInfo(info2)));
        Assert.assertEquals((String)"Wrong index of info1", (long)0L, (long)infos.indexOf(this.cpa.newConditionalPermissionInfo(info1)));
        Assert.assertEquals((String)"Wrong index of info2", (long)1L, (long)infos.indexOf(this.cpa.newConditionalPermissionInfo(info2)));
        update = this.cpa.newConditionalPermissionUpdate();
        updateInfos = update.getConditionalPermissionInfos();
        Assert.assertTrue((String)"Info lists are not equal", (boolean)updateInfos.equals(infos));
        updateInfos.add(this.cpa.newConditionalPermissionInfo(info3));
        Assert.assertTrue((String)"Failed commit", (boolean)update.commit());
        infos = new ArrayList();
        eInfos = this.cpa.getConditionalPermissionInfos();
        while (eInfos.hasMoreElements()) {
            infos.add(eInfos.nextElement());
        }
        Assert.assertTrue((String)"Info lists are not equal", (boolean)updateInfos.equals(infos));
    }

    @Test
    public void testEncodingInfos02() {
        ConditionInfo cond1 = new ConditionInfo("Test1", new String[]{"arg1", "arg2"});
        ConditionInfo cond2 = new ConditionInfo("Test1", new String[]{"arg1", "arg2", "arg3"});
        ConditionInfo cond3 = new ConditionInfo("Test1", new String[]{"test } test", "} test"});
        PermissionInfo perm1 = new PermissionInfo("Type1", "name1", "action1");
        PermissionInfo perm2 = new PermissionInfo("Type1", "}", "test }");
        ConditionalPermissionInfo testInfo1 = this.cpa.newConditionalPermissionInfo("name1", new ConditionInfo[]{cond1}, new PermissionInfo[]{perm1}, "allow");
        ConditionalPermissionInfo testInfo2 = this.checkGoodInfo("AlLoW { [Test1 \"arg1\" \"arg2\"] (Type1 \"name1\" \"action1\") } \"name1\"");
        this.checkInfos(testInfo1, testInfo2);
        testInfo1 = this.cpa.newConditionalPermissionInfo("name1", new ConditionInfo[]{cond2}, new PermissionInfo[]{perm1}, "deny");
        testInfo2 = this.checkGoodInfo("dEnY { [Test1 \"arg1\" \"arg2\" \"arg3\"] (Type1 \"name1\" \"action1\") } \"name1\"");
        this.checkInfos(testInfo1, testInfo2);
        testInfo1 = this.cpa.newConditionalPermissionInfo("name1", null, new PermissionInfo[]{perm1}, "deny");
        testInfo2 = this.checkGoodInfo("dEnY { (Type1 \"name1\" \"action1\") } \"name1\"");
        this.checkInfos(testInfo1, testInfo2);
        testInfo1 = this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{cond1}, new PermissionInfo[]{perm1}, "allow");
        testInfo2 = this.checkGoodInfo("allow { [Test1 \"arg1\" \"arg2\"] (Type1 \"name1\" \"action1\") }");
        this.checkInfos(testInfo1, testInfo2);
        testInfo1 = this.cpa.newConditionalPermissionInfo("", new ConditionInfo[]{cond1}, new PermissionInfo[]{perm1}, "allow");
        testInfo2 = this.checkGoodInfo("allow { [Test1 \"arg1\" \"arg2\"] (Type1 \"name1\" \"action1\") } \"\"");
        this.checkInfos(testInfo1, testInfo2);
        testInfo1 = this.cpa.newConditionalPermissionInfo("name1", new ConditionInfo[]{cond1}, new PermissionInfo[]{perm1}, "allow");
        testInfo2 = this.checkGoodInfo("allow{[Test1 \"arg1\" \"arg2\"](Type1 \"name1\" \"action1\")}\"name1\"");
        this.checkInfos(testInfo1, testInfo2);
        testInfo1 = this.cpa.newConditionalPermissionInfo("name", new ConditionInfo[]{cond3}, new PermissionInfo[]{perm2}, "allow");
        testInfo2 = this.checkGoodInfo("allow { [Test1 \"test } test\" \"} test\"] (Type1 \"}\" \"test }\") } \"name\"");
        this.checkInfos(testInfo1, testInfo2);
        testInfo1 = this.cpa.newConditionalPermissionInfo("na } me", new ConditionInfo[]{cond3}, new PermissionInfo[]{perm2}, "allow");
        testInfo2 = this.checkGoodInfo("allow { [Test1 \"test } test\" \"} test\"] (Type1 \"}\" \"test }\") } \"na } me\"");
        this.checkInfos(testInfo1, testInfo2);
        this.checkBadInfo("invalid { [Test1] (Type1 \"name1\" \"action1\") } \"name1\"");
        this.checkBadInfo("allow { [] (Type1 \"name1\" \"action1\") } \"name1\"");
        this.checkBadInfo("deny { [\"arg1\"] (Type1 \"name1\" \"action1\") } \"name1\"");
        this.checkBadInfo("ALLOW { [Test1 \"arg1\" \"arg2\"] } \"name1\"");
        this.checkBadInfo("ALLOW { [Test1 \"arg1\" \"arg2\"] () } \"name1\"");
        this.checkBadInfo("ALLOW { [Test1 \"arg1\" \"arg2\"] (\"name1\" \"action1\") } \"name1\"");
        this.checkBadInfo("AlLoW { [Test1 \"arg1\" \"arg2\"] (Type1 \"name1\" \"action1\") } name1");
        this.checkBadInfo("AlLoW { [Test1 \"arg1\" \"arg2\"] (Type1 \"name1\" \"action1\") } \"name1");
        this.checkBadInfo("AlLoW { [Test1 \"arg1\" \"arg2\"] (Type1 \"name1\" \"action1\") } name1\"");
        this.checkBadInfo("AlLoW { [Test1 \"arg1\" \"arg2\"] (Type1 \"name1\" \"action1\") } \"");
        this.checkBadInfo("AlLoW { [Test1 \"arg1\" \"arg2\"] (Type1 \"name1\" \"action1\") } \"name1\" extrajunk");
    }

    @Test
    public void testBug286307() throws BundleException {
        Bundle test = this.installTestBundle("test.bug286307");
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        this.testPermission(acc, new FilePermission(TEST_BUNDLE, "read"), true);
        this.testPermission(acc, new AllPermission(), false);
    }

    @Test
    public void testRelativeFilePermission() throws BundleException {
        Bundle test = this.installTestBundle(TEST_BUNDLE);
        File dataArea = test.getDataFile("");
        File testFile = new File(dataArea, "testFile.txt");
        File testExecutable = new File(dataArea, "bin/execFile");
        AccessControlContext acc = (AccessControlContext)test.adapt(AccessControlContext.class);
        this.pa.setPermissions(test.getLocation(), RELATIVE_EXEC_FILE_INFOS);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "write"), true);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "read"), true);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "execute"), false);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "write"), true);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "read"), true);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "execute"), true);
        this.testPermission(acc, new AllPermission(), false);
        this.pa.setPermissions(test.getLocation(), null);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "write"), true);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "read"), true);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "execute"), true);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "write"), true);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "read"), true);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "execute"), true);
        this.testPermission(acc, new AllPermission(), true);
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, this.getLocationConditions(test.getLocation(), false), RELATIVE_EXEC_FILE_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testPermission(acc, new FilePermission(testFile.getPath(), "write"), true);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "read"), true);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "execute"), false);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "write"), true);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "read"), true);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "execute"), true);
        this.testPermission(acc, new AllPermission(), false);
        update = this.cpa.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.clear();
        rows.add(this.cpa.newConditionalPermissionInfo(null, this.getLocationConditions(test.getLocation(), false), READONLY_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testPermission(acc, new FilePermission(testFile.getPath(), "write"), true);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "read"), true);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "execute"), false);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "write"), true);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "read"), true);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "execute"), false);
        this.testPermission(acc, new AllPermission(), false);
        update = this.cpa.newConditionalPermissionUpdate();
        update.getConditionalPermissionInfos().clear();
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.pa.setDefaultPermissions(RELATIVE_EXEC_FILE_INFOS);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "write"), true);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "read"), true);
        this.testPermission(acc, new FilePermission(testFile.getPath(), "execute"), false);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "write"), true);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "read"), true);
        this.testPermission(acc, new FilePermission(testExecutable.getPath(), "execute"), false);
        this.testPermission(acc, new AllPermission(), false);
        this.pa.setDefaultPermissions(null);
        this.testPermission(acc, new AllPermission(), true);
        update = this.cpa.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION1}, RELATIVE_EXEC_FILE_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        File relativeExecutable = new File("bin/executableFile");
        acc = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test1,c=US"});
        this.testPermission(acc, new FilePermission(relativeExecutable.getAbsolutePath(), "execute"), false);
        update = this.cpa.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.clear();
        PermissionInfo[] absExectInfos = new PermissionInfo[]{new PermissionInfo("java.io.FilePermission", relativeExecutable.getAbsolutePath(), "execute")};
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION1}, absExectInfos, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        this.testPermission(acc, new FilePermission(relativeExecutable.getAbsolutePath(), "execute"), true);
    }

    @Test
    public void testPermissionCheckCache() {
        ConditionalPermissionUpdate update = this.cpa.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(this.cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{SIGNER_CONDITION1}, READONLY_INFOS, "allow"));
        Assert.assertTrue((String)"failed to commit", (boolean)update.commit());
        AccessControlContext acc = this.cpa.getAccessControlContext(new String[]{"cn=t1,c=FR;cn=test1,c=US"});
        int i = 0;
        while (i < 10000000) {
            acc.checkPermission(new FilePermission(TEST_BUNDLE + i, "read"));
            ++i;
        }
    }

    private void checkInfos(ConditionalPermissionInfo testInfo1, ConditionalPermissionInfo testInfo2) {
        Assert.assertTrue((String)("Infos are not equal: " + testInfo1.getEncoded() + " " + testInfo2.getEncoded()), (boolean)testInfo1.equals((Object)testInfo2));
        Assert.assertEquals((String)"Info hash code is not equal", (long)testInfo1.hashCode(), (long)testInfo2.hashCode());
    }

    private void checkBadInfo(String encoded) {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            ConditionalPermissionInfo conditionalPermissionInfo = this.cpa.newConditionalPermissionInfo(encoded);
        });
    }

    private ConditionalPermissionInfo checkGoodInfo(String encoded) {
        return this.cpa.newConditionalPermissionInfo(encoded);
    }

    private void testSMPermission(ProtectionDomain[] pds, Permission permission, boolean expectedToPass) {
        this.testPermission(new AccessControlContext(pds), permission, expectedToPass);
    }

    private void testPermission(AccessControlContext acc, Permission permission, boolean expectedToPass) {
        SecurityManager sm = System.getSecurityManager();
        if (expectedToPass) {
            sm.checkPermission(permission, acc);
        } else {
            Assert.assertThrows(SecurityException.class, () -> sm.checkPermission(permission, acc));
        }
    }

    private ConditionInfo[] getLocationConditions(String location, boolean not) {
        String[] stringArray;
        if (not) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = location;
            stringArray = stringArray2;
            stringArray2[1] = "!";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = location;
        }
        String[] args = stringArray;
        return new ConditionInfo[]{new ConditionInfo("org.osgi.service.condpermadmin.BundleLocationCondition", args)};
    }

    private Bundle installTestBundle(String name) throws BundleException {
        String location = installer.getBundleLocation(name);
        return this.equinox.getBundleContext().installBundle(location);
    }

    private void installConditionBundle() throws BundleException {
        Bundle bundle = installer.installBundle("ext.framework.b", false);
        installer.resolveBundles(new Bundle[]{bundle});
    }
}

