/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.securityadmin;

import java.io.File;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.condpermadmin.BundleLocationCondition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;
import org.osgi.service.permissionadmin.PermissionInfo;
import org.osgi.service.startlevel.StartLevel;

public class SecurityManagerTests
extends AbstractBundleTests {
    private static final PermissionInfo hostFragmentPermission = new PermissionInfo(BundlePermission.class.getName(), "*", "host,fragment");
    private static final PermissionInfo hostFragmentProvidePermission = new PermissionInfo(BundlePermission.class.getName(), "*", "host,fragment,provide");
    private static final PermissionInfo allPackagePermission = new PermissionInfo(PackagePermission.class.getName(), "*", "import,export");
    private static final PermissionInfo importPackagePermission = new PermissionInfo(PackagePermission.class.getName(), "*", "import");
    private static final PermissionInfo importFrameworkPackagePermission = new PermissionInfo(PackagePermission.class.getName(), "org.osgi.framework", "import");
    private Policy previousPolicy;

    @BeforeClass
    public static void setupClass() {
        Assume.assumeTrue((String)"Security-Manager is disallowed", (boolean)SecurityManagerTests.isSecurityManagerAllowed());
    }

    @Override
    public void setUp() throws Exception {
        this.previousPolicy = Policy.getPolicy();
        final AllPermission allPermission = new AllPermission();
        final PermissionCollection allPermissions = new PermissionCollection(){
            private static final long serialVersionUID = 3258131349494708277L;

            @Override
            public void add(Permission permission) {
            }

            @Override
            public boolean implies(Permission permission) {
                return true;
            }

            public Enumeration elements() {
                return new Enumeration(){
                    int cur = 0;

                    @Override
                    public boolean hasMoreElements() {
                        return this.cur < 1;
                    }

                    public Object nextElement() {
                        if (this.cur == 0) {
                            this.cur = 1;
                            return allPermission;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }
        };
        Policy.setPolicy(new Policy(){

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                return allPermissions;
            }

            @Override
            public void refresh() {
            }
        });
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.getSecurityManager() != null) {
            System.setSecurityManager(null);
        }
        Policy.setPolicy(this.previousPolicy);
    }

    @Test
    public void testEnableSecurityManager01() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testEnableSecurityManager01");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertNotNull((String)"SecurityManager is null", (Object)this.getSecurityManager());
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        SecurityManagerTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        Assert.assertNull((String)"SecurityManager is not null", (Object)this.getSecurityManager());
    }

    @Test
    public void testEnableSecurityManager02() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testEnableSecurityManager02");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertNotNull((String)"SecurityManager is null", (Object)this.getSecurityManager());
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        String locationSecurityA = installer.getBundleLocation("security.a");
        String locationSecurityAFragA = installer.getBundleLocation("security.a.frag.a");
        ConditionalPermissionAdmin ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
        ConditionalPermissionUpdate update = ca.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo(null, null, new PermissionInfo[]{hostFragmentPermission, allPackagePermission}, "allow"));
        Assert.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
        Bundle securityA = systemContext.installBundle(locationSecurityA);
        systemContext.installBundle(locationSecurityAFragA);
        equinox.start();
        try {
            securityA.start();
        }
        finally {
            SecurityManagerTests.stop((Framework)equinox);
        }
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        Assert.assertNull((String)"SecurityManager is not null", (Object)this.getSecurityManager());
    }

    @Test
    public void testEnableSecurityManager03() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testEnableSecurityManager03");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertNotNull((String)"SecurityManager is null", (Object)this.getSecurityManager());
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        String locationSecurityA = installer.getBundleLocation("security.a");
        ConditionalPermissionAdmin ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
        ConditionalPermissionUpdate update = ca.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo(null, null, new PermissionInfo[]{hostFragmentPermission, importPackagePermission}, "allow"));
        Assert.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
        Bundle securityA = systemContext.installBundle(locationSecurityA);
        equinox.start();
        PackageAdmin pa = (PackageAdmin)systemContext.getService(systemContext.getServiceReference(PackageAdmin.class.getName()));
        try {
            Assert.assertTrue((boolean)pa.resolveBundles(new Bundle[]{securityA}));
            ExportedPackage[] eps = pa.getExportedPackages(securityA);
            Assert.assertNull((String)"Found unexpected exports", (Object)eps);
            RequiredBundle[] rbs = pa.getRequiredBundles(securityA.getSymbolicName());
            Assert.assertNull((String)"Found unexpected required bundle", (Object)rbs);
            update = ca.newConditionalPermissionUpdate();
            rows = update.getConditionalPermissionInfos();
            rows.clear();
            rows.add(ca.newConditionalPermissionInfo(null, null, new PermissionInfo[]{hostFragmentProvidePermission, allPackagePermission}, "allow"));
            Assert.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
            securityA.uninstall();
            securityA = systemContext.installBundle(locationSecurityA);
            Assert.assertTrue((boolean)pa.resolveBundles(new Bundle[]{securityA}));
            eps = pa.getExportedPackages(securityA);
            Assert.assertNotNull((String)"Did not find expected exports", (Object)eps);
            Assert.assertEquals((String)"Wrong number of exports found", (long)1L, (long)eps.length);
            rbs = pa.getRequiredBundles(securityA.getSymbolicName());
            Assert.assertNotNull((String)"Did not find required bundle", (Object)eps);
            Assert.assertEquals((String)"Wrong number of required bundles found", (long)1L, (long)rbs.length);
        }
        finally {
            SecurityManagerTests.stop((Framework)equinox);
        }
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        Assert.assertNull((String)"SecurityManager is not null", (Object)this.getSecurityManager());
    }

    @Test
    public void testEnableSecurityManager04() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile("testEnableSecurityManager04");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertNotNull((String)"SecurityManager is null", (Object)this.getSecurityManager());
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        String locationLinkA = installer.getBundleLocation("test.link.a");
        String locationLinkAClient = installer.getBundleLocation("test.link.a.client");
        ConditionInfo linkACondition = new ConditionInfo(BundleLocationCondition.class.getName(), new String[]{locationLinkA});
        ConditionInfo linkAClientCondition = new ConditionInfo(BundleLocationCondition.class.getName(), new String[]{locationLinkAClient});
        PermissionInfo filterPermission = new PermissionInfo(PackagePermission.class.getName(), "(&(name=test.link.a)(package.name=test.link.*))", "import");
        ConditionalPermissionAdmin ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
        ConditionalPermissionUpdate update = ca.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo(null, new ConditionInfo[]{linkACondition}, new PermissionInfo[]{hostFragmentProvidePermission, allPackagePermission}, "allow"));
        rows.add(ca.newConditionalPermissionInfo(null, new ConditionInfo[]{linkAClientCondition}, new PermissionInfo[]{importFrameworkPackagePermission, filterPermission}, "allow"));
        Assert.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
        Bundle linkA = systemContext.installBundle(locationLinkA);
        Bundle linkAClient = systemContext.installBundle(locationLinkAClient);
        equinox.start();
        PackageAdmin pa = (PackageAdmin)systemContext.getService(systemContext.getServiceReference(PackageAdmin.class.getName()));
        try {
            Assert.assertTrue((boolean)pa.resolveBundles(new Bundle[]{linkA, linkAClient}));
            filterPermission = new PermissionInfo(PackagePermission.class.getName(), "(&(name=fail.match)(package.name=test.link.*))", "import");
            update = ca.newConditionalPermissionUpdate();
            rows = update.getConditionalPermissionInfos();
            rows.clear();
            rows.add(ca.newConditionalPermissionInfo(null, new ConditionInfo[]{linkACondition}, new PermissionInfo[]{hostFragmentProvidePermission, allPackagePermission}, "allow"));
            rows.add(ca.newConditionalPermissionInfo(null, new ConditionInfo[]{linkAClientCondition}, new PermissionInfo[]{importFrameworkPackagePermission, filterPermission}, "allow"));
            Assert.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
            pa.refreshPackages(new Bundle[]{linkA, linkAClient});
            Thread.sleep(2000L);
            Assert.assertEquals((String)"linkA has wrong state", (long)4L, (long)linkA.getState());
            Assert.assertEquals((String)"linkAClient has wrong state", (long)2L, (long)linkAClient.getState());
        }
        finally {
            SecurityManagerTests.stop((Framework)equinox);
        }
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        Assert.assertNull((String)"SecurityManager is not null", (Object)this.getSecurityManager());
    }

    @Test
    public void testEnableSecurityManager05() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertNotNull((String)"SecurityManager is null", (Object)this.getSecurityManager());
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        String locationLinkA = installer.getBundleLocation("test.link.a");
        String locationLinkAClient = installer.getBundleLocation("test.link.a.client");
        Bundle linkA = systemContext.installBundle(locationLinkA);
        Bundle linkAClient = systemContext.installBundle(locationLinkAClient);
        equinox.start();
        try {
            PackageAdmin pa = (PackageAdmin)systemContext.getService(systemContext.getServiceReference(PackageAdmin.class.getName()));
            Assert.assertTrue((boolean)pa.resolveBundles(new Bundle[]{linkA, linkAClient}));
            linkA.uninstall();
            linkAClient.uninstall();
            linkA = systemContext.installBundle(locationLinkA);
            linkAClient = systemContext.installBundle(locationLinkAClient);
            Assert.assertTrue((boolean)pa.resolveBundles(new Bundle[]{linkA, linkAClient}));
        }
        finally {
            SecurityManagerTests.stop((Framework)equinox);
        }
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        Assert.assertNull((String)"SecurityManager is not null", (Object)this.getSecurityManager());
    }

    private SecurityManager getSecurityManager() {
        return System.getSecurityManager();
    }

    @Test
    public void testLocalization01() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testLocalization01");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertNotNull((String)"SecurityManager is null", (Object)this.getSecurityManager());
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        String locationSecurityA = installer.getBundleLocation("security.a");
        String locationSecurityAFragA = installer.getBundleLocation("security.a.frag.a");
        ConditionalPermissionAdmin ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
        ConditionalPermissionUpdate update = ca.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo(null, null, new PermissionInfo[]{hostFragmentPermission, allPackagePermission}, "allow"));
        Assert.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
        Bundle securityA = systemContext.installBundle(locationSecurityA);
        systemContext.installBundle(locationSecurityAFragA);
        equinox.start();
        try {
            securityA.start();
            Dictionary headers = securityA.getHeaders("en_US");
            String name = (String)headers.get("Bundle-Name");
            Assert.assertEquals((String)"Wrong Bundle-Name", (Object)"en_US", (Object)name);
            headers = securityA.getHeaders("en");
            name = (String)headers.get("Bundle-Name");
            Assert.assertEquals((String)"Wrong Bundle-Name", (Object)"default", (Object)name);
        }
        finally {
            SecurityManagerTests.stop((Framework)equinox);
        }
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        Assert.assertNull((String)"SecurityManager is not null", (Object)this.getSecurityManager());
    }

    @Test
    public void testBug254600() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testBug254600");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertNotNull((String)"SecurityManager is null", (Object)this.getSecurityManager());
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle securityB = null;
        long idB = -1L;
        String locationSecurityA = installer.getBundleLocation("security.a");
        String locationSecurityB = installer.getBundleLocation("security.b");
        systemContext.installBundle(locationSecurityA);
        securityB = systemContext.installBundle(locationSecurityB);
        idB = securityB.getBundleId();
        securityB.start();
        securityB.stop();
        SecurityManagerTests.stop((Framework)equinox);
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        securityB = systemContext.getBundle(idB);
        securityB.start();
        securityB.stop();
        SecurityManagerTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        Assert.assertNull((String)"SecurityManager is not null", (Object)this.getSecurityManager());
    }

    @Test
    public void testBug287750() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertNotNull((String)"SecurityManager is null", (Object)this.getSecurityManager());
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle testBundle = null;
        String locationTestBundle = installer.getBundleLocation("test.bug287750");
        testBundle = systemContext.installBundle(locationTestBundle);
        testBundle.start();
        StartLevel sl = (StartLevel)systemContext.getService(systemContext.getServiceReference(StartLevel.class.getName()));
        if (sl.getStartLevel() != 10) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertEquals((String)"Wrong startlevel", (long)10L, (long)sl.getStartLevel());
        SecurityManagerTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        Assert.assertNull((String)"SecurityManager is not null", (Object)this.getSecurityManager());
    }

    @Test
    public void testBug367614() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        Assert.assertNotNull((String)"SecurityManager is null", (Object)this.getSecurityManager());
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)8L, (long)equinox.getState());
        equinox.start();
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)32L, (long)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        ConditionalPermissionAdmin ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
        ConditionalPermissionUpdate update = ca.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo("test", null, new PermissionInfo[]{allPackagePermission}, "allow"));
        Assert.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
        ConditionalPermissionUpdate update1 = ca.newConditionalPermissionUpdate();
        rows = update1.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo("test", null, new PermissionInfo[]{allPackagePermission}, "allow"));
        Throwable t1 = Assert.assertThrows(Throwable.class, () -> {
            boolean bl = update1.commit();
        });
        Assert.assertTrue((String)("Wrong exception: " + String.valueOf(t1)), (boolean)(t1 instanceof IllegalStateException));
        SecurityManagerTests.stop((Framework)equinox);
        equinox.start();
        systemContext = equinox.getBundleContext();
        ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
        ConditionalPermissionUpdate update2 = ca.newConditionalPermissionUpdate();
        rows = update2.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo("test", null, new PermissionInfo[]{allPackagePermission}, "allow"));
        Throwable t2 = Assert.assertThrows(Throwable.class, () -> {
            boolean bl = update2.commit();
        });
        Assert.assertTrue((String)("Wrong exception: " + String.valueOf(t2)), (boolean)(t2 instanceof IllegalStateException));
        SecurityManagerTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        Assert.assertNull((String)"SecurityManager is not null", (Object)this.getSecurityManager());
    }

    @Test
    public void testDynamicImportWithSecurity() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        ResolverHookFactory dummyHook = triggers -> new ResolverHook(){

            public void filterResolvable(Collection<BundleRevision> candidates) {
            }

            public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
            }

            public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                if ("dynamic".equals(requirement.getDirectives().get("resolution"))) {
                    candidates.clear();
                }
            }

            public void end() {
            }
        };
        systemContext.registerService(ResolverHookFactory.class, (Object)dummyHook, null);
        Assert.assertNotNull((String)"System context is null", (Object)systemContext);
        String testDynamicImportLocation = installer.getBundleLocation("test.dynamicimport");
        ConditionalPermissionAdmin ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
        ConditionalPermissionUpdate update = ca.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo(null, null, new PermissionInfo[]{allPackagePermission}, "allow"));
        Assert.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
        Bundle testDynamicImport = systemContext.installBundle(testDynamicImportLocation);
        testDynamicImport.start();
        SecurityManagerTests.stop((Framework)equinox);
        Assert.assertEquals((String)"Wrong state for SystemBundle", (long)4L, (long)equinox.getState());
        Assert.assertNull((String)"SecurityManager is not null", (Object)this.getSecurityManager());
    }

    @Test
    public void testJava12SecurityManagerAllow() {
        this.doJava12SecurityManagerSetting("allow", false);
    }

    @Test
    public void testJava12SecurityManagerDisallow() {
        this.doJava12SecurityManagerSetting("disallow", false);
    }

    @Test
    public void testJava12SecurityManagerDefault() {
        this.doJava12SecurityManagerSetting("default", true);
    }

    @Test
    public void testJava12SecurityManagerEmpty() {
        this.doJava12SecurityManagerSetting("", true);
    }

    public void doJava12SecurityManagerSetting(String managerValue, boolean isSecurityManager) {
        block13: {
            String MANAGER_PROP = "java.security.manager";
            String previous = System.getProperty("java.security.manager");
            try {
                File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
                HashMap<String, String> configuration = new HashMap<String, String>();
                configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
                configuration.put("java.security.manager", managerValue);
                Equinox equinox = new Equinox(configuration);
                try {
                    try {
                        equinox.init();
                        if (isSecurityManager) {
                            Assert.assertNotNull((String)"SecurityManager is null", (Object)this.getSecurityManager());
                            break block13;
                        }
                        Assert.assertNull((String)"SecurityManager is not null", (Object)this.getSecurityManager());
                    }
                    catch (BundleException e) {
                        if (isSecurityManager && e.getCause() instanceof UnsupportedOperationException) {
                            FrameworkWiring wiring = (FrameworkWiring)this.getContext().getBundle("System Bundle").adapt(FrameworkWiring.class);
                            Collection java12 = wiring.findProviders(new Requirement(){

                                public Resource getResource() {
                                    return null;
                                }

                                public String getNamespace() {
                                    return "osgi.ee";
                                }

                                public Map<String, String> getDirectives() {
                                    return Collections.singletonMap("filter", "(version=12)");
                                }

                                public Map<String, Object> getAttributes() {
                                    return Collections.emptyMap();
                                }
                            });
                            Assert.assertFalse((String)"Only allowed UnsupportedOperationException on Java 12.", (boolean)java12.isEmpty());
                        } else {
                            Assert.fail((String)("Unexpected exception on init(): " + e.getMessage()));
                        }
                        SecurityManagerTests.stopQuietly((Framework)equinox);
                    }
                }
                finally {
                    SecurityManagerTests.stopQuietly((Framework)equinox);
                }
            }
            finally {
                if (previous == null) {
                    System.getProperties().remove("java.security.manager");
                } else {
                    System.setProperty("java.security.manager", previous);
                }
            }
        }
    }

    public static boolean isSecurityManagerAllowed() {
        SecurityManager original = System.getSecurityManager();
        try {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                }
            });
            System.setSecurityManager(original);
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }
}

