/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.serviceregistry;

import java.util.Hashtable;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceExceptionTests
extends AbstractBundleTests {
    @Test
    public void testServiceException01() throws InterruptedException, InvalidSyntaxException {
        String testMethodName = "testServiceException01";
        ServiceExceptionServiceFactory wrongObjectFactory = new ServiceExceptionServiceFactory("A String");
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", "testServiceException01");
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)wrongObjectFactory, props);
        ServiceExceptionFrameworkListener listener = new ServiceExceptionFrameworkListener(OSGiTestsActivator.getBundle(), null, 2);
        OSGiTestsActivator.getContext().addFrameworkListener((FrameworkListener)listener);
        try {
            ServiceReference[] refs = OSGiTestsActivator.getContext().getServiceReferences(Runnable.class.getName(), "(name=testServiceException01)");
            Assert.assertNotNull((String)"service refs is null", (Object)refs);
            Assert.assertEquals((String)"Wrong number of references", (long)1L, (long)refs.length);
            Runnable service = (Runnable)OSGiTestsActivator.getContext().getService(refs[0]);
            Assert.assertNull((String)"service is not null", (Object)service);
            listener.waitForEvent("Failed to fire ServiceException");
            OSGiTestsActivator.getContext().ungetService(refs[0]);
            Error error = wrongObjectFactory.getUngetFailure();
            if (error != null) {
                throw error;
            }
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
            if (listener != null) {
                OSGiTestsActivator.getContext().removeFrameworkListener((FrameworkListener)listener);
            }
        }
    }

    @Test
    public void testServiceException02() throws InterruptedException, InvalidSyntaxException {
        String testMethodName = "testServiceException02";
        ServiceExceptionServiceFactory nullObjectFactory = new ServiceExceptionServiceFactory(null);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", "testServiceException02");
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)nullObjectFactory, props);
        ServiceExceptionFrameworkListener listener = new ServiceExceptionFrameworkListener(OSGiTestsActivator.getBundle(), null, 2);
        OSGiTestsActivator.getContext().addFrameworkListener((FrameworkListener)listener);
        try {
            ServiceReference[] refs = OSGiTestsActivator.getContext().getServiceReferences(Runnable.class.getName(), "(name=testServiceException02)");
            Assert.assertNotNull((String)"service refs is null", (Object)refs);
            Assert.assertEquals((String)"Wrong number of references", (long)1L, (long)refs.length);
            Runnable service = (Runnable)OSGiTestsActivator.getContext().getService(refs[0]);
            Assert.assertNull((String)"service is not null", (Object)service);
            listener.waitForEvent("Failed to fire ServiceException");
            OSGiTestsActivator.getContext().ungetService(refs[0]);
            Error error = nullObjectFactory.getUngetFailure();
            if (error != null) {
                throw error;
            }
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
            if (listener != null) {
                OSGiTestsActivator.getContext().removeFrameworkListener((FrameworkListener)listener);
            }
        }
    }

    @Test
    public void testServiceException03() throws InterruptedException, InvalidSyntaxException {
        String testMethodName = "testServiceException03";
        RuntimeException cause = new RuntimeException("testServiceException03");
        ServiceExceptionServiceFactory runtimeExceptionFactory = new ServiceExceptionServiceFactory(cause);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", "testServiceException03");
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runtimeExceptionFactory, props);
        ServiceExceptionFrameworkListener listener = new ServiceExceptionFrameworkListener(OSGiTestsActivator.getBundle(), cause, 3);
        OSGiTestsActivator.getContext().addFrameworkListener((FrameworkListener)listener);
        try {
            ServiceReference[] refs = OSGiTestsActivator.getContext().getServiceReferences(Runnable.class.getName(), "(name=testServiceException03)");
            Assert.assertNotNull((String)"service refs is null", (Object)refs);
            Assert.assertEquals((String)"Wrong number of references", (long)1L, (long)refs.length);
            Runnable service = (Runnable)OSGiTestsActivator.getContext().getService(refs[0]);
            Assert.assertNull((String)"service is not null", (Object)service);
            listener.waitForEvent("Failed to fire ServiceException");
            OSGiTestsActivator.getContext().ungetService(refs[0]);
            Error error = runtimeExceptionFactory.getUngetFailure();
            if (error != null) {
                throw error;
            }
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
            if (listener != null) {
                OSGiTestsActivator.getContext().removeFrameworkListener((FrameworkListener)listener);
            }
        }
    }

    @Test
    public void testServiceException04() throws InterruptedException, InvalidSyntaxException {
        String testMethodName = "testServiceException04";
        Error cause = new Error("testServiceException04");
        ServiceExceptionServiceFactory errorFactory = new ServiceExceptionServiceFactory(cause);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", "testServiceException04");
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)errorFactory, props);
        ServiceExceptionFrameworkListener listener = new ServiceExceptionFrameworkListener(OSGiTestsActivator.getBundle(), cause, 3);
        OSGiTestsActivator.getContext().addFrameworkListener((FrameworkListener)listener);
        try {
            ServiceReference[] refs = OSGiTestsActivator.getContext().getServiceReferences(Runnable.class.getName(), "(name=testServiceException04)");
            Assert.assertNotNull((String)"service refs is null", (Object)refs);
            Assert.assertEquals((String)"Wrong number of references", (long)1L, (long)refs.length);
            Runnable service = (Runnable)OSGiTestsActivator.getContext().getService(refs[0]);
            Assert.assertNull((String)"service is not null", (Object)service);
            listener.waitForEvent("Failed to fire ServiceException");
            OSGiTestsActivator.getContext().ungetService(refs[0]);
            Error error = errorFactory.getUngetFailure();
            if (error != null) {
                throw error;
            }
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
            if (listener != null) {
                OSGiTestsActivator.getContext().removeFrameworkListener((FrameworkListener)listener);
            }
        }
    }

    class ServiceExceptionFrameworkListener
    implements FrameworkListener {
        private final Bundle registrationBundle;
        private final Throwable exception;
        private final int exceptionType;
        private boolean waitForEvent = true;

        public ServiceExceptionFrameworkListener(Bundle registrationBundle, Throwable exception, int exceptionType) {
            this.registrationBundle = registrationBundle;
            this.exception = exception;
            this.exceptionType = exceptionType;
        }

        public void frameworkEvent(FrameworkEvent event) {
            if (event.getBundle() != this.registrationBundle) {
                return;
            }
            if (!(event.getThrowable() instanceof ServiceException)) {
                return;
            }
            if (event.getThrowable().getCause() != this.exception) {
                return;
            }
            if (((ServiceException)event.getThrowable()).getType() != this.exceptionType) {
                return;
            }
            this.notifyWaiter();
        }

        private synchronized void notifyWaiter() {
            this.waitForEvent = false;
            this.notifyAll();
        }

        public synchronized void waitForEvent(String failMessage) throws InterruptedException {
            if (this.waitForEvent) {
                this.wait(10000L);
                if (this.waitForEvent) {
                    Assert.fail((String)failMessage);
                }
            }
        }
    }

    class ServiceExceptionServiceFactory
    implements ServiceFactory {
        private final Object serviceOrThrowable;
        private Error ungetFailure;

        public ServiceExceptionServiceFactory(Object serviceOrThrowable) {
            this.serviceOrThrowable = serviceOrThrowable;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            if (this.serviceOrThrowable instanceof RuntimeException) {
                throw (RuntimeException)this.serviceOrThrowable;
            }
            if (this.serviceOrThrowable instanceof Error) {
                throw (Error)this.serviceOrThrowable;
            }
            return this.serviceOrThrowable;
        }

        public synchronized void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            try {
                if (this.serviceOrThrowable instanceof RuntimeException) {
                    Assert.fail((String)("Unexpected call to ungetService: " + String.valueOf(this.serviceOrThrowable)));
                }
                if (this.serviceOrThrowable instanceof Error) {
                    Assert.fail((String)("Unexpected call to ungetService: " + String.valueOf(this.serviceOrThrowable)));
                }
            }
            catch (Error error) {
                this.ungetFailure = error;
            }
        }

        public Error getUngetFailure() {
            return this.ungetFailure;
        }
    }
}

