/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.serviceregistry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

public class ServiceHookTests
extends AbstractBundleTests {
    @Test
    public void testFindHook01() throws InvalidSyntaxException {
        String testMethodName = "testFindHook01";
        Runnable runIt = () -> {};
        BundleContext testContext = OSGiTestsActivator.getContext();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("name", "testFindHook01");
        props.put("service.description", "service 1");
        ServiceRegistration reg1 = testContext.registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.description", "service 2");
        ServiceRegistration reg2 = testContext.registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.description", "service 3");
        ServiceRegistration reg3 = testContext.registerService(Runnable.class.getName(), (Object)runIt, props);
        int[] hookCalled = new int[5];
        boolean[] startTest = new boolean[1];
        AssertionFailedError[] hookErrors = new AssertionFailedError[4];
        props.put("service.description", "find hook 1");
        props.put("service.description", "min value");
        props.put("service.ranking", Integer.MIN_VALUE);
        ServiceRegistration regHook1 = testContext.registerService(FindHook.class.getName(), (context, name, filter, allServices, references) -> {
            try {
                int[] nArray2 = hookCalled;
                synchronized (hookCalled) {
                    if (!startTest[0]) {
                        // ** MonitorExit[var11_11] (shouldn't be in output)
                        return;
                    }
                    nArray[0] = hookCalled[0] + 1;
                    nArray[nArray[0]] = 1;
                    // ** MonitorExit[var11_11] (shouldn't be in output)
                    Assert.assertEquals((String)"wrong context in hook", (Object)testContext, (Object)context);
                    Assert.assertEquals((String)"wrong name in hook", (Object)Runnable.class.getName(), (Object)name);
                    Assert.assertEquals((String)"wrong filter in hook", (Object)"(name=testFindHook01)", (Object)filter);
                    Assert.assertEquals((String)"wrong allservices in hook", (Object)false, (Object)allServices);
                    Assert.assertEquals((String)"wrong number of services in hook", (long)1L, (long)references.size());
                    for (ServiceReference ref : references) {
                        Assert.assertNotEquals((String)"service 1 is present", (Object)reg1.getReference(), (Object)ref);
                        Assert.assertNotEquals((String)"service 2 is present", (Object)reg2.getReference(), (Object)ref);
                    }
                    ServiceReference reference1 = reg1.getReference();
                    Assert.assertThrows((String)"add to collection succeeded", UnsupportedOperationException.class, () -> {
                        boolean bl = references.add(reference1);
                    });
                    Assert.assertThrows((String)"addAll to collection succeeded", UnsupportedOperationException.class, () -> {
                        boolean bl = references.addAll(Arrays.asList(reference1));
                    });
                }
            }
            catch (AssertionFailedError a) {
                assertionFailedErrorArray[0] = a;
                return;
            }
        }, props);
        props.put("service.description", "find hook 2");
        props.put("service.description", "max value first");
        props.put("service.ranking", Integer.MAX_VALUE);
        ServiceRegistration regHook2 = testContext.registerService(FindHook.class.getName(), (context, name, filter, allServices, references) -> {
            try {
                int[] nArray2 = hookCalled;
                synchronized (hookCalled) {
                    if (!startTest[0]) {
                        // ** MonitorExit[var10_10] (shouldn't be in output)
                        return;
                    }
                    nArray[0] = hookCalled[0] + 1;
                    nArray[nArray[0]] = 2;
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    Assert.assertEquals((String)"wrong context in hook", (Object)testContext, (Object)context);
                    Assert.assertEquals((String)"wrong name in hook", (Object)Runnable.class.getName(), (Object)name);
                    Assert.assertEquals((String)"wrong filter in hook", (Object)"(name=testFindHook01)", (Object)filter);
                    Assert.assertEquals((String)"wrong allservices in hook", (Object)false, (Object)allServices);
                    Assert.assertEquals((String)"wrong number of services in hook", (long)3L, (long)references.size());
                    references.removeIf(ref -> ref.equals(reg2.getReference()));
                    ServiceReference reference2 = reg2.getReference();
                    Assert.assertThrows((String)"add to collection succeeded", UnsupportedOperationException.class, () -> {
                        boolean bl = references.add(reference2);
                    });
                    Assert.assertThrows((String)"addAll to collection succeeded", UnsupportedOperationException.class, () -> {
                        boolean bl = references.addAll(Arrays.asList(reference2));
                    });
                }
            }
            catch (AssertionFailedError a) {
                assertionFailedErrorArray[1] = a;
                return;
            }
        }, props);
        props.put("service.description", "find hook 3");
        props.put("service.description", "max value second");
        props.put("service.ranking", Integer.MAX_VALUE);
        ServiceRegistration regHook3 = testContext.registerService(FindHook.class.getName(), (context, name, filter, allServices, references) -> {
            try {
                int[] nArray2 = hookCalled;
                synchronized (hookCalled) {
                    if (!startTest[0]) {
                        // ** MonitorExit[var10_10] (shouldn't be in output)
                        return;
                    }
                    nArray[0] = hookCalled[0] + 1;
                    nArray[nArray[0]] = 3;
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    Assert.assertEquals((String)"wrong context in hook", (Object)testContext, (Object)context);
                    Assert.assertEquals((String)"wrong name in hook", (Object)Runnable.class.getName(), (Object)name);
                    Assert.assertEquals((String)"wrong filter in hook", (Object)"(name=testFindHook01)", (Object)filter);
                    Assert.assertEquals((String)"wrong allservices in hook", (Object)false, (Object)allServices);
                    Assert.assertEquals((String)"wrong number of services in hook", (long)2L, (long)references.size());
                    for (ServiceReference ref : references) {
                        Assert.assertNotEquals((String)"service 2 is present", (Object)ref, (Object)reg2.getReference());
                    }
                    ServiceReference ref2 = reg2.getReference();
                    Assert.assertThrows(UnsupportedOperationException.class, () -> {
                        boolean bl = references.add(ref2);
                    });
                    Assert.assertThrows(UnsupportedOperationException.class, () -> {
                        boolean bl = references.addAll(Arrays.asList(ref2));
                    });
                }
            }
            catch (AssertionFailedError a) {
                assertionFailedErrorArray[2] = a;
                return;
            }
            {
                throw new RuntimeException("testFindHook01");
            }
        }, props);
        props.put("service.description", "find hook 4");
        props.put("service.description", "max value third");
        props.put("service.ranking", Integer.MAX_VALUE);
        ServiceRegistration regHook4 = testContext.registerService(FindHook.class.getName(), (context, name, filter, allServices, references) -> {
            try {
                int[] nArray2 = hookCalled;
                synchronized (hookCalled) {
                    if (!startTest[0]) {
                        // ** MonitorExit[var11_11] (shouldn't be in output)
                        return;
                    }
                    nArray[0] = hookCalled[0] + 1;
                    nArray[nArray[0]] = 4;
                    // ** MonitorExit[var11_11] (shouldn't be in output)
                    Assert.assertEquals((String)"wrong context in hook", (Object)testContext, (Object)context);
                    Assert.assertEquals((String)"wrong name in hook", (Object)Runnable.class.getName(), (Object)name);
                    Assert.assertEquals((String)"wrong filter in hook", (Object)"(name=testFindHook01)", (Object)filter);
                    Assert.assertEquals((String)"wrong allservices in hook", (Object)false, (Object)allServices);
                    Assert.assertEquals((String)"wrong number of services in hook", (long)2L, (long)references.size());
                    references.removeIf(ref -> {
                        Assert.assertNotEquals((String)"service 2 is present", (Object)ref, (Object)reg2.getReference());
                        return ref.equals(reg1.getReference());
                    });
                    ServiceReference ref2 = reg2.getReference();
                    Assert.assertThrows(UnsupportedOperationException.class, () -> {
                        boolean bl = references.add(ref2);
                    });
                    Assert.assertThrows(UnsupportedOperationException.class, () -> {
                        boolean bl = references.addAll(Arrays.asList(ref2));
                    });
                }
            }
            catch (AssertionFailedError a) {
                assertionFailedErrorArray[3] = a;
                return;
            }
        }, props);
        startTest[0] = true;
        try {
            ServiceReference[] refs = testContext.getServiceReferences(Runnable.class.getName(), "(name=testFindHook01)");
            Assert.assertEquals((String)"all hooks not called", (long)4L, (long)hookCalled[0]);
            Assert.assertEquals((String)"hook 2 not called first", (long)2L, (long)hookCalled[1]);
            Assert.assertEquals((String)"hook 3 not called second", (long)3L, (long)hookCalled[2]);
            Assert.assertEquals((String)"hook 4 not called third", (long)4L, (long)hookCalled[3]);
            Assert.assertEquals((String)"hook 1 not called fourth ", (long)1L, (long)hookCalled[4]);
            AssertionFailedError[] assertionFailedErrorArray = hookErrors;
            int n = hookErrors.length;
            int n2 = 0;
            while (n2 < n) {
                AssertionFailedError hookError = assertionFailedErrorArray[n2];
                if (hookError != null) {
                    throw hookError;
                }
                ++n2;
            }
            Assert.assertNotNull((String)"service refs is null", (Object)refs);
            Assert.assertEquals((String)"Wrong number of references", (long)1L, (long)refs.length);
            List<ServiceReference> refList = Arrays.asList(refs);
            Assert.assertFalse((String)"contains service 1", (boolean)refList.contains(reg1.getReference()));
            Assert.assertFalse((String)"contains service 2", (boolean)refList.contains(reg2.getReference()));
            Assert.assertTrue((String)"missing service 3", (boolean)refList.contains(reg3.getReference()));
            startTest[0] = false;
            regHook1.unregister();
            regHook1 = null;
            regHook2.unregister();
            regHook2 = null;
            regHook3.unregister();
            regHook3 = null;
            regHook4.unregister();
            regHook4 = null;
            refs = null;
            hookCalled[0] = 0;
            startTest[0] = true;
            refs = testContext.getServiceReferences(Runnable.class.getName(), "(name=testFindHook01)");
            Assert.assertEquals((String)"hooks called", (long)0L, (long)hookCalled[0]);
            Assert.assertNotNull((String)"service refs is null", (Object)refs);
            Assert.assertEquals((String)"Wrong number of references", (long)3L, (long)refs.length);
            refList = Arrays.asList(refs);
            Assert.assertTrue((String)"missing service 1", (boolean)refList.contains(reg1.getReference()));
            Assert.assertTrue((String)"missing service 2", (boolean)refList.contains(reg2.getReference()));
            Assert.assertTrue((String)"missing service 3", (boolean)refList.contains(reg3.getReference()));
        }
        finally {
            if (regHook1 != null) {
                regHook1.unregister();
            }
            if (regHook2 != null) {
                regHook2.unregister();
            }
            if (regHook3 != null) {
                regHook3.unregister();
            }
            if (regHook4 != null) {
                regHook4.unregister();
            }
            if (reg1 != null) {
                reg1.unregister();
            }
            if (reg2 != null) {
                reg2.unregister();
            }
            if (reg3 != null) {
                reg3.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventHook01() throws InvalidSyntaxException {
        String testMethodName = "testEventHook01";
        Runnable runIt = () -> {};
        BundleContext testContext = OSGiTestsActivator.getContext();
        int[] hookCalled = new int[2];
        AssertionFailedError[] hookErrors = new AssertionFailedError[1];
        ArrayList events = new ArrayList();
        ServiceListener sl = event -> {
            List list2 = events;
            synchronized (list2) {
                events.add(event);
            }
        };
        String filterString = "(&(name=testEventHook01)(objectClass=java.lang.Runnable))";
        Filter tmpFilter = testContext.createFilter("(&(name=testEventHook01)(objectClass=java.lang.Runnable))");
        testContext.addServiceListener(sl, "(&(name=testEventHook01)(objectClass=java.lang.Runnable))");
        Filter filter = tmpFilter;
        EventHook hook1 = (event, contexts) -> {
            try {
                if (!filter.match(event.getServiceReference())) {
                    return;
                }
                int[] nArray2 = hookCalled;
                synchronized (hookCalled) {
                    nArray[0] = hookCalled[0] + 1;
                    nArray[nArray[0]] = 1;
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    Assert.assertTrue((String)"does not contain test context", (boolean)contexts.contains(testContext));
                    Assert.assertThrows(UnsupportedOperationException.class, () -> {
                        boolean bl = contexts.add(testContext.getBundle(0L).getBundleContext());
                    });
                    Assert.assertThrows(UnsupportedOperationException.class, () -> {
                        boolean bl = contexts.addAll(Arrays.asList(testContext.getBundle(0L).getBundleContext()));
                    });
                }
            }
            catch (AssertionFailedError a) {
                assertionFailedErrorArray[0] = a;
                return;
            }
        };
        EventHook hook2 = (event, contexts) -> {
            try {
                if (!filter.match(event.getServiceReference())) {
                    return;
                }
                int[] nArray2 = hookCalled;
                synchronized (hookCalled) {
                    nArray[0] = hookCalled[0] + 1;
                    nArray[nArray[0]] = 1;
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    Assert.assertTrue((String)"does not contain test context", (boolean)contexts.contains(testContext));
                    contexts.remove(testContext);
                    Assert.assertThrows(UnsupportedOperationException.class, () -> {
                        boolean bl = contexts.add(testContext.getBundle(0L).getBundleContext());
                    });
                    Assert.assertThrows(UnsupportedOperationException.class, () -> {
                        boolean bl = contexts.addAll(Arrays.asList(testContext.getBundle(0L).getBundleContext()));
                    });
                }
            }
            catch (AssertionFailedError a) {
                assertionFailedErrorArray[0] = a;
                return;
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", "testEventHook01");
        props.put("service.description", "event hook 1");
        ServiceRegistration regHook = testContext.registerService(EventHook.class.getName(), (Object)hook1, props);
        ServiceRegistration reg1 = null;
        try {
            Object hookError;
            props.put("service.description", "service 1");
            ArrayList arrayList = events;
            synchronized (arrayList) {
                events.clear();
            }
            reg1 = testContext.registerService(Runnable.class.getName(), (Object)runIt, props);
            Assert.assertEquals((String)"all hooks not called", (long)1L, (long)hookCalled[0]);
            Assert.assertEquals((String)"hook 1 not called first", (long)1L, (long)hookCalled[1]);
            AssertionFailedError[] assertionFailedErrorArray = hookErrors;
            int n = hookErrors.length;
            int n2 = 0;
            while (n2 < n) {
                hookError = assertionFailedErrorArray[n2];
                if (hookError != null) {
                    throw hookError;
                }
                ++n2;
            }
            hookError = events;
            synchronized (hookError) {
                Assert.assertEquals((String)"listener not called once", (long)1L, (long)events.size());
                for (ServiceEvent event2 : events) {
                    Assert.assertEquals((String)"type not registered", (long)1L, (long)event2.getType());
                    Assert.assertEquals((String)"wrong service", (Object)reg1.getReference(), (Object)event2.getServiceReference());
                }
            }
            regHook.unregister();
            regHook = null;
            hookError = events;
            synchronized (hookError) {
                events.clear();
            }
            hookCalled[0] = 0;
            props.put("service.description", "service 2");
            reg1.setProperties(props);
            hookError = events;
            synchronized (hookError) {
                Assert.assertEquals((String)"listener not called once", (long)1L, (long)events.size());
                for (ServiceEvent event3 : events) {
                    Assert.assertEquals((String)"type not registered", (long)2L, (long)event3.getType());
                    Assert.assertEquals((String)"wrong service", (Object)reg1.getReference(), (Object)event3.getServiceReference());
                }
            }
            Assert.assertEquals((String)"hooks called", (long)0L, (long)hookCalled[0]);
            props.put("service.description", "event hook 2");
            regHook = testContext.registerService(EventHook.class.getName(), (Object)hook2, props);
            hookError = events;
            synchronized (hookError) {
                events.clear();
            }
            hookCalled[0] = 0;
            reg1.unregister();
            reg1 = null;
            hookError = events;
            synchronized (hookError) {
                Assert.assertEquals((String)"listener called", (long)0L, (long)events.size());
            }
            Assert.assertEquals((String)"all hooks not called", (long)1L, (long)hookCalled[0]);
            Assert.assertEquals((String)"hook 1 not called first", (long)1L, (long)hookCalled[1]);
            assertionFailedErrorArray = hookErrors;
            int n3 = hookErrors.length;
            int n4 = 0;
            while (n4 < n3) {
                hookError = assertionFailedErrorArray[n4];
                if (hookError != null) {
                    throw hookError;
                }
                ++n4;
            }
        }
        finally {
            if (regHook != null) {
                regHook.unregister();
            }
            if (reg1 != null) {
                reg1.unregister();
            }
            if (sl != null) {
                testContext.removeServiceListener(sl);
            }
        }
    }

    @Test
    public void testListenerHook01() throws InvalidSyntaxException {
        String testMethodName = "testListenerHook01";
        BundleContext testContext = OSGiTestsActivator.getContext();
        final ArrayList result = new ArrayList();
        final int[] hookCalled = new int[2];
        ListenerHook hook1 = new ListenerHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void added(Collection<ListenerHook.ListenerInfo> listeners) {
                int[] nArray = hookCalled;
                synchronized (hookCalled) {
                    hookCalled[0] = hookCalled[0] + 1;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    result.addAll(listeners);
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removed(Collection<ListenerHook.ListenerInfo> listeners) {
                int[] nArray = hookCalled;
                synchronized (hookCalled) {
                    hookCalled[1] = hookCalled[1] + 1;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    result.removeAll(listeners);
                    return;
                }
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", "testListenerHook01");
        props.put("service.description", "listener hook 1");
        ServiceRegistration regHook = testContext.registerService(ListenerHook.class.getName(), (Object)hook1, props);
        try {
            String f;
            BundleContext c;
            Assert.assertFalse((String)"no service listeners found", (boolean)result.isEmpty());
            Assert.assertEquals((String)"added not called", (long)1L, (long)hookCalled[0]);
            Assert.assertEquals((String)"removed called", (long)0L, (long)hookCalled[1]);
            int size = result.size();
            ServiceListener testSL = event -> {};
            String filterString1 = "(foo=bar)";
            testContext.addServiceListener(testSL, filterString1);
            Assert.assertEquals((String)"added not called", (long)2L, (long)hookCalled[0]);
            Assert.assertEquals((String)"removed called", (long)0L, (long)hookCalled[1]);
            Assert.assertEquals((String)"listener not added", (long)(size + 1), (long)result.size());
            boolean found = false;
            for (ListenerHook.ListenerInfo info : result) {
                BundleContext c2 = info.getBundleContext();
                String f2 = info.getFilter();
                if (c2 != testContext || !filterString1.equals(f2)) continue;
                Assert.assertFalse((String)"found more than once", (boolean)found);
                found = true;
            }
            Assert.assertTrue((String)"listener not found", (boolean)found);
            String filterString2 = "(bar=foo)";
            testContext.addServiceListener(testSL, filterString2);
            Assert.assertEquals((String)"added not called", (long)3L, (long)hookCalled[0]);
            Assert.assertEquals((String)"removed not called", (long)1L, (long)hookCalled[1]);
            Assert.assertEquals((String)"listener not removed and added", (long)(size + 1), (long)result.size());
            found = false;
            for (ListenerHook.ListenerInfo info : result) {
                c = info.getBundleContext();
                f = info.getFilter();
                if (c == testContext && filterString2.equals(f)) {
                    Assert.assertFalse((String)"found more than once", (boolean)found);
                    found = true;
                }
                Assert.assertFalse((String)"first listener not removed", (c == testContext && filterString1.equals(f) ? 1 : 0) != 0);
            }
            Assert.assertTrue((String)"listener not found", (boolean)found);
            testContext.removeServiceListener(testSL);
            Assert.assertEquals((String)"added called", (long)3L, (long)hookCalled[0]);
            Assert.assertEquals((String)"removed not called", (long)2L, (long)hookCalled[1]);
            Assert.assertEquals((String)"listener not removed", (long)size, (long)result.size());
            for (ListenerHook.ListenerInfo info : result) {
                c = info.getBundleContext();
                f = info.getFilter();
                Assert.assertFalse((String)"second listener not removed", (c == testContext && filterString2.equals(f) ? 1 : 0) != 0);
            }
            testContext.removeServiceListener(testSL);
            Assert.assertEquals((String)"added called", (long)3L, (long)hookCalled[0]);
            Assert.assertEquals((String)"removed called", (long)2L, (long)hookCalled[1]);
            Assert.assertEquals((String)"listener removed", (long)size, (long)result.size());
        }
        finally {
            if (regHook != null) {
                regHook.unregister();
            }
        }
    }

    @Test
    public void testListenerHook02() throws InvalidSyntaxException {
        String testMethodName = "testListenerHook02";
        BundleContext testContext = OSGiTestsActivator.getContext();
        final ArrayList result = new ArrayList();
        final int[] hookCalled = new int[2];
        ListenerHook hook1 = new ListenerHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void added(Collection<ListenerHook.ListenerInfo> listeners) {
                int[] nArray = hookCalled;
                synchronized (hookCalled) {
                    hookCalled[0] = hookCalled[0] + 1;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    result.addAll(listeners);
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removed(Collection<ListenerHook.ListenerInfo> listeners) {
                int[] nArray = hookCalled;
                synchronized (hookCalled) {
                    hookCalled[1] = hookCalled[1] + 1;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    result.removeAll(listeners);
                    return;
                }
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", "testListenerHook02");
        props.put("service.description", "listener hook 1");
        ServiceRegistration regHook = testContext.registerService(ListenerHook.class.getName(), (Object)hook1, props);
        try {
            String f;
            BundleContext c;
            Assert.assertFalse((String)"no service listeners found", (boolean)result.isEmpty());
            Assert.assertEquals((String)"added not called", (long)1L, (long)hookCalled[0]);
            Assert.assertEquals((String)"removed called", (long)0L, (long)hookCalled[1]);
            int size = result.size();
            ServiceListener testSL = event -> {};
            String filterString1 = "(objectClass=bar)";
            testContext.addServiceListener(testSL, filterString1);
            Assert.assertEquals((String)"added not called", (long)2L, (long)hookCalled[0]);
            Assert.assertEquals((String)"removed called", (long)0L, (long)hookCalled[1]);
            Assert.assertEquals((String)"listener not added", (long)(size + 1), (long)result.size());
            boolean found = false;
            for (ListenerHook.ListenerInfo info : result) {
                BundleContext c2 = info.getBundleContext();
                String f2 = info.getFilter();
                if (c2 != testContext || !filterString1.equals(f2)) continue;
                Assert.assertFalse((String)"found more than once", (boolean)found);
                found = true;
            }
            Assert.assertTrue((String)"listener not found", (boolean)found);
            Object filterString2 = null;
            testContext.addServiceListener(testSL);
            Assert.assertEquals((String)"added not called", (long)3L, (long)hookCalled[0]);
            Assert.assertEquals((String)"removed not called", (long)1L, (long)hookCalled[1]);
            Assert.assertEquals((String)"listener not removed and added", (long)(size + 1), (long)result.size());
            found = false;
            for (ListenerHook.ListenerInfo info : result) {
                c = info.getBundleContext();
                f = info.getFilter();
                if (c == testContext && f == filterString2) {
                    Assert.assertFalse((String)"found more than once", (boolean)found);
                    found = true;
                }
                Assert.assertFalse((String)"first listener not removed", (c == testContext && filterString1.equals(f) ? 1 : 0) != 0);
            }
            Assert.assertTrue((String)"listener not found", (boolean)found);
            testContext.removeServiceListener(testSL);
            Assert.assertEquals((String)"added called", (long)3L, (long)hookCalled[0]);
            Assert.assertEquals((String)"removed not called", (long)2L, (long)hookCalled[1]);
            Assert.assertEquals((String)"listener not removed", (long)size, (long)result.size());
            for (ListenerHook.ListenerInfo info : result) {
                c = info.getBundleContext();
                f = info.getFilter();
                Assert.assertFalse((String)"second listener not removed", (c == testContext && f == filterString2 ? 1 : 0) != 0);
            }
            testContext.removeServiceListener(testSL);
            Assert.assertEquals((String)"added called", (long)3L, (long)hookCalled[0]);
            Assert.assertEquals((String)"removed called", (long)2L, (long)hookCalled[1]);
            Assert.assertEquals((String)"listener removed", (long)size, (long)result.size());
        }
        finally {
            if (regHook != null) {
                regHook.unregister();
            }
        }
    }

    @Test
    public void testMultiImplementHook() {
        BundleContext testContext = OSGiTestsActivator.getContext();
        MultiImplementHook hook = new MultiImplementHook();
        ServiceRegistration regHook = testContext.registerService(new String[]{FindHook.class.getName(), EventListenerHook.class.getName(), Runnable.class.getName()}, (Object)hook, FrameworkUtil.asDictionary(Collections.singletonMap("testMultiImplementHook", "true")));
        ServiceRegistration testReg = null;
        try {
            try {
                Collection runnables = testContext.getServiceReferences(Runnable.class, "(testMultiImplementHook=true)");
                Assert.assertEquals((String)"Wrong number of runnables", (long)1L, (long)runnables.size());
                testReg = testContext.registerService(Object.class, new Object(), null);
                Assert.assertFalse((String)("Wrong number of events: " + String.valueOf(hook.events)), (boolean)hook.events.isEmpty());
                Assert.assertFalse((String)("Wrong number of finds: " + String.valueOf(hook.findClasses)), (boolean)hook.findClasses.isEmpty());
                ServiceRegistration unregister = regHook;
                regHook = null;
                unregister.unregister();
                unregister = testReg;
                testReg = null;
                unregister.unregister();
                hook.events.clear();
                hook.findClasses.clear();
                testReg = testContext.registerService(Object.class, new Object(), null);
                testContext.getServiceReferences(Runnable.class, "(testMultiImplementHook=true)");
                Assert.assertTrue((String)("Wrong number of events: " + String.valueOf(hook.events)), (boolean)hook.events.isEmpty());
                Assert.assertTrue((String)("Wrong number of finds: " + String.valueOf(hook.findClasses)), (boolean)hook.findClasses.isEmpty());
                runnables = testContext.getServiceReferences(Runnable.class, "(testMultiImplementHook=true)");
                Assert.assertEquals((String)"Wrong number of runnables", (long)0L, (long)runnables.size());
            }
            catch (InvalidSyntaxException e) {
                Assert.fail((String)e.getMessage());
                if (regHook != null) {
                    regHook.unregister();
                }
                if (testReg != null) {
                    testReg.unregister();
                }
            }
        }
        finally {
            if (regHook != null) {
                regHook.unregister();
            }
            if (testReg != null) {
                testReg.unregister();
            }
        }
    }

    public static class MultiImplementHook
    implements FindHook,
    EventListenerHook,
    Runnable {
        List<ServiceEvent> events = new ArrayList<ServiceEvent>();
        List<String> findClasses = new ArrayList<String>();

        @Override
        public void run() {
        }

        public void event(ServiceEvent event, Map<BundleContext, Collection<ListenerHook.ListenerInfo>> listeners) {
            this.events.add(event);
        }

        public void find(BundleContext context, String name, String filter, boolean allServices, Collection<ServiceReference<?>> references) {
            this.findClasses.add(name);
        }
    }
}

