/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.serviceregistry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.util.MapDictionary;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistryTests
extends AbstractBundleTests {
    @Test
    public void testServiceListener01() throws InvalidSyntaxException {
        String testMethodName = this.getName();
        Runnable runIt = () -> {};
        boolean[] results = new boolean[4];
        ServiceListener testListener = event -> {
            switch (event.getType()) {
                case 1: {
                    blArray[0] = true;
                    break;
                }
                case 2: {
                    blArray[1] = true;
                    break;
                }
                case 8: {
                    blArray[2] = true;
                    break;
                }
                case 4: {
                    blArray[3] = true;
                }
            }
        };
        OSGiTestsActivator.getContext().addServiceListener(testListener, "(&(objectclass=java.lang.Runnable)(" + testMethodName.toLowerCase() + "=true))");
        ServiceRegistration reg = null;
        try {
            Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
            props.put(testMethodName, Boolean.TRUE);
            reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
            Assert.assertTrue((String)"Did not get ServiceEvent.REGISTERED", (boolean)results[0]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            Assert.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.FALSE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            Assert.assertTrue((String)"Did not get ServiceEvent.MODIFIED", (boolean)results[1]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            Assert.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.FALSE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            Assert.assertTrue((String)"Did not get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            Assert.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.TRUE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            Assert.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.TRUE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            Assert.assertTrue((String)"Did not get ServiceEvent.MODIFIED", (boolean)results[1]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            Assert.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            reg.unregister();
            reg = null;
            Assert.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            Assert.assertTrue((String)"Did not get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
        }
        finally {
            OSGiTestsActivator.getContext().removeServiceListener(testListener);
            if (reg != null) {
                reg.unregister();
            }
        }
    }

    @Test
    public void testServiceListener02() throws InvalidSyntaxException {
        String testMethodName = this.getName();
        Runnable runIt = () -> {};
        boolean[] results = new boolean[4];
        ServiceListener testListener = event -> {
            switch (event.getType()) {
                case 1: {
                    blArray[0] = true;
                    break;
                }
                case 2: {
                    blArray[1] = true;
                    break;
                }
                case 8: {
                    blArray[2] = true;
                    break;
                }
                case 4: {
                    blArray[3] = true;
                }
            }
        };
        OSGiTestsActivator.getContext().addServiceListener(testListener, "(&(objectclass=java.lang.Runnable)(" + testMethodName.toLowerCase() + "=true))");
        ServiceRegistration reg = null;
        try {
            Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
            props.put(testMethodName, Boolean.FALSE);
            reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
            Assert.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            Assert.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.FALSE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            Assert.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.TRUE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            Assert.assertTrue((String)"Did not get ServiceEvent.MODIFIED", (boolean)results[1]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            Assert.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.TRUE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            Assert.assertTrue((String)"Did not get ServiceEvent.MODIFIED", (boolean)results[1]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            Assert.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.FALSE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            Assert.assertTrue((String)"Did not get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            Assert.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            reg.unregister();
            reg = null;
            Assert.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            Assert.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            Assert.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
        }
        finally {
            OSGiTestsActivator.getContext().removeServiceListener(testListener);
            if (reg != null) {
                reg.unregister();
            }
        }
    }

    @Test
    public void testServiceListener03() throws InvalidSyntaxException {
        String testMethodName = this.getName();
        Runnable runIt = () -> {};
        int[] results = new int[4];
        ServiceListener testListener = event -> {
            switch (event.getType()) {
                case 1: {
                    nArray[0] = results[0] + 1;
                    break;
                }
                case 2: {
                    nArray[1] = results[1] + 1;
                    break;
                }
                case 8: {
                    nArray[2] = results[2] + 1;
                    break;
                }
                case 4: {
                    nArray[3] = results[3] + 1;
                }
            }
        };
        OSGiTestsActivator.getContext().addServiceListener(testListener, "(&(objectclass=java.lang.Runnable)(" + testMethodName.toLowerCase() + "=true))");
        ServiceRegistration reg1 = null;
        ServiceRegistration reg2 = null;
        try {
            Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
            props.put(testMethodName, Boolean.FALSE);
            reg1 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
            reg2 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
            Assert.assertEquals((String)"Did get ServiceEvent.REGISTERED", (long)0L, (long)results[0]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED", (long)0L, (long)results[1]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (long)0L, (long)results[2]);
            Assert.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (long)0L, (long)results[3]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.FALSE);
            reg1.setProperties(props);
            Assert.assertEquals((String)"Did get ServiceEvent.REGISTERED", (long)0L, (long)results[0]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED", (long)0L, (long)results[1]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (long)0L, (long)results[2]);
            Assert.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (long)0L, (long)results[3]);
            this.clearResults(results);
            reg2.setProperties(props);
            Assert.assertEquals((String)"Did get ServiceEvent.REGISTERED", (long)0L, (long)results[0]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED", (long)0L, (long)results[1]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (long)0L, (long)results[2]);
            Assert.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (long)0L, (long)results[3]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.TRUE);
            reg1.setProperties(props);
            Assert.assertEquals((String)"Did get ServiceEvent.REGISTERED", (long)0L, (long)results[0]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED", (long)1L, (long)results[1]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (long)0L, (long)results[2]);
            Assert.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (long)0L, (long)results[3]);
            this.clearResults(results);
            reg2.setProperties(props);
            Assert.assertEquals((String)"Did get ServiceEvent.REGISTERED", (long)0L, (long)results[0]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED", (long)1L, (long)results[1]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (long)0L, (long)results[2]);
            Assert.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (long)0L, (long)results[3]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.TRUE);
            reg1.setProperties(props);
            Assert.assertEquals((String)"Did get ServiceEvent.REGISTERED", (long)0L, (long)results[0]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED", (long)1L, (long)results[1]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (long)0L, (long)results[2]);
            Assert.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (long)0L, (long)results[3]);
            this.clearResults(results);
            reg2.setProperties(props);
            Assert.assertEquals((String)"Did get ServiceEvent.REGISTERED", (long)0L, (long)results[0]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED", (long)1L, (long)results[1]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (long)0L, (long)results[2]);
            Assert.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (long)0L, (long)results[3]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.FALSE);
            reg1.setProperties(props);
            Assert.assertEquals((String)"Did get ServiceEvent.REGISTERED", (long)0L, (long)results[0]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED", (long)0L, (long)results[1]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (long)1L, (long)results[2]);
            Assert.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (long)0L, (long)results[3]);
            this.clearResults(results);
            reg2.setProperties(props);
            Assert.assertEquals((String)"Did get ServiceEvent.REGISTERED", (long)0L, (long)results[0]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED", (long)0L, (long)results[1]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (long)1L, (long)results[2]);
            Assert.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (long)0L, (long)results[3]);
            this.clearResults(results);
            reg1.unregister();
            reg1 = null;
            Assert.assertEquals((String)"Did get ServiceEvent.REGISTERED", (long)0L, (long)results[0]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED", (long)0L, (long)results[1]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (long)0L, (long)results[2]);
            Assert.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (long)0L, (long)results[3]);
            this.clearResults(results);
            reg2.unregister();
            reg2 = null;
            Assert.assertEquals((String)"Did get ServiceEvent.REGISTERED", (long)0L, (long)results[0]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED", (long)0L, (long)results[1]);
            Assert.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (long)0L, (long)results[2]);
            Assert.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (long)0L, (long)results[3]);
            this.clearResults(results);
        }
        finally {
            OSGiTestsActivator.getContext().removeServiceListener(testListener);
            if (reg1 != null) {
                reg1.unregister();
            }
            if (reg2 != null) {
                reg2.unregister();
            }
        }
    }

    @Test
    public void testServiceOrdering01() {
        String testMethodName = this.getName();
        Runnable runIt = () -> {};
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("name", testMethodName);
        props.put("service.description", "min value");
        props.put("service.ranking", Integer.MIN_VALUE);
        ServiceRegistration reg1 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.description", "max value first");
        props.put("service.ranking", Integer.MAX_VALUE);
        ServiceRegistration reg2 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.description", "max value second");
        props.put("service.ranking", Integer.MAX_VALUE);
        ServiceRegistration reg3 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        try {
            ServiceReference ref = null;
            ref = OSGiTestsActivator.getContext().getServiceReference(Runnable.class.getName());
            Assert.assertNotNull((String)"service ref is null", (Object)ref);
            Assert.assertEquals((String)"Wrong references", (Object)reg2.getReference(), (Object)ref);
        }
        finally {
            if (reg1 != null) {
                reg1.unregister();
            }
            if (reg2 != null) {
                reg2.unregister();
            }
            if (reg3 != null) {
                reg3.unregister();
            }
        }
    }

    @Test
    public void testDuplicateObjectClass() {
        ServiceRegistration reg = null;
        try {
            reg = OSGiTestsActivator.getContext().registerService(new String[]{Runnable.class.getName(), Object.class.getName(), Object.class.getName()}, () -> {}, null);
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
        }
    }

    @Test
    public void testServiceReferenceCompare01() {
        String testMethodName = this.getName();
        Runnable runIt = () -> {};
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("name", testMethodName);
        props.put("service.description", "min value");
        props.put("service.ranking", Integer.MIN_VALUE);
        ServiceRegistration reg1 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.description", "max value first");
        props.put("service.ranking", Integer.MAX_VALUE);
        ServiceRegistration reg2 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.description", "max value second");
        props.put("service.ranking", Integer.MAX_VALUE);
        ServiceRegistration reg3 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        try {
            ServiceReference ref = OSGiTestsActivator.getContext().getServiceReference(Runnable.class.getName());
            ServiceReference ref1 = reg1.getReference();
            ServiceReference ref2 = reg2.getReference();
            ServiceReference ref3 = reg3.getReference();
            Assert.assertNotNull((String)"service ref is null", (Object)ref);
            Assert.assertEquals((String)"Wrong reference", (Object)ref2, (Object)ref);
            Assert.assertEquals((String)"Wrong references", (long)0L, (long)ref2.compareTo((Object)ref));
            Assert.assertEquals((String)"Wrong references", (long)0L, (long)ref.compareTo((Object)ref2));
            Assert.assertTrue((String)("Wrong compareTo value: " + ref1.compareTo((Object)ref1)), (ref1.compareTo((Object)ref1) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Wrong compareTo value: " + ref1.compareTo((Object)ref2)), (ref1.compareTo((Object)ref2) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Wrong compareTo value: " + ref1.compareTo((Object)ref3)), (ref1.compareTo((Object)ref3) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Wrong compareTo value: " + ref2.compareTo((Object)ref1)), (ref2.compareTo((Object)ref1) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Wrong compareTo value: " + ref2.compareTo((Object)ref2)), (ref2.compareTo((Object)ref2) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Wrong compareTo value: " + ref2.compareTo((Object)ref3)), (ref2.compareTo((Object)ref3) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Wrong compareTo value: " + ref3.compareTo((Object)ref1)), (ref3.compareTo((Object)ref1) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Wrong compareTo value: " + ref3.compareTo((Object)ref2)), (ref3.compareTo((Object)ref2) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Wrong compareTo value: " + ref3.compareTo((Object)ref3)), (ref3.compareTo((Object)ref3) == 0 ? 1 : 0) != 0);
        }
        finally {
            if (reg1 != null) {
                reg1.unregister();
            }
            if (reg2 != null) {
                reg2.unregister();
            }
            if (reg3 != null) {
                reg3.unregister();
            }
        }
    }

    @Test
    public void testModifiedRanking() {
        Runnable runIt = () -> {};
        Hashtable<String, Comparable<Boolean>> props = new Hashtable<String, Comparable<Boolean>>();
        props.put(this.getName(), Boolean.TRUE);
        props.put("service.ranking", Integer.valueOf(15));
        ServiceRegistration reg1 = this.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.ranking", Integer.valueOf(10));
        ServiceRegistration reg2 = this.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        try {
            Assert.assertEquals((String)"wrong service reference", (Object)reg1.getReference(), (Object)this.getContext().getServiceReference("java.lang.Runnable"));
            props.put("service.ranking", Integer.valueOf(20));
            reg2.setProperties(props);
            Assert.assertEquals((String)"wrong service reference", (Object)reg2.getReference(), (Object)this.getContext().getServiceReference("java.lang.Runnable"));
        }
        finally {
            if (reg1 != null) {
                reg1.unregister();
            }
            if (reg2 != null) {
                reg2.unregister();
            }
        }
    }

    @Test
    public void testInvalidRanking() throws InterruptedException {
        CountDownLatch warning = new CountDownLatch(1);
        FrameworkListener warningListener = event -> {
            if (16 == event.getType() && OSGiTestsActivator.getBundle().equals(event.getBundle())) {
                warning.countDown();
            }
        };
        Runnable runIt = () -> {};
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put(this.getName(), Boolean.TRUE);
        props.put("service.ranking", "15");
        ServiceRegistration reg1 = null;
        try {
            OSGiTestsActivator.getContext().addFrameworkListener(warningListener);
            reg1 = this.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        }
        finally {
            if (reg1 != null) {
                reg1.unregister();
            }
            OSGiTestsActivator.getContext().removeFrameworkListener(warningListener);
        }
        Assert.assertTrue((String)"Timeout waiting for the warning.", (boolean)warning.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testNullValue() throws InvalidSyntaxException {
        ServiceRegistration reg = null;
        try {
            MapDictionary<String, String> nullProps = new MapDictionary<String, String>();
            ((Dictionary)nullProps).put("test.null", null);
            ((Dictionary)nullProps).put("test.non.null", "v1");
            reg = OSGiTestsActivator.getContext().registerService(Object.class, new Object(), nullProps);
            Assert.assertFalse((boolean)OSGiTestsActivator.getContext().createFilter("(test.null=*)").match(reg.getReference()));
            Assert.assertFalse((boolean)OSGiTestsActivator.getContext().createFilter("(test.null=*)").match(reg.getReference().getProperties()));
            Assert.assertTrue((boolean)OSGiTestsActivator.getContext().createFilter("(&(!(test.null=*))(test.non.null=v1))").match(reg.getReference()));
            Assert.assertTrue((boolean)OSGiTestsActivator.getContext().createFilter("(&(!(test.null=*))(test.non.null=v1))").match(reg.getReference().getProperties()));
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
        }
    }

    @Test
    public void testNullKey() throws InvalidSyntaxException {
        ServiceRegistration reg = null;
        try {
            MapDictionary<String, String> nullProps = new MapDictionary<String, String>();
            ((Dictionary)nullProps).put(null, "null.v1");
            ((Dictionary)nullProps).put("test.non.null", "v1");
            reg = OSGiTestsActivator.getContext().registerService(Object.class, new Object(), nullProps);
            Assert.assertTrue((boolean)OSGiTestsActivator.getContext().createFilter("(test.non.null=v1)").match(reg.getReference()));
            Assert.assertTrue((boolean)OSGiTestsActivator.getContext().createFilter("(test.non.null=v1)").match(reg.getReference().getProperties()));
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
        }
    }

    @Test
    public void testWrongServiceFactoryObject() throws InterruptedException {
        AtomicReference errorMsg = new AtomicReference();
        CountDownLatch gotEvent = new CountDownLatch(1);
        FrameworkListener fwkListener = e -> {
            if (e.getType() == 2 && e.getThrowable() != null) {
                errorMsg.set(e.getThrowable().getMessage());
                gotEvent.countDown();
            }
        };
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(Runnable.class, new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                return "Wrong object!!";
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }
        }, null);
        OSGiTestsActivator.getContext().addFrameworkListener(fwkListener);
        try {
            ServiceReference ref = reg.getReference();
            Runnable service = (Runnable)OSGiTestsActivator.getContext().getService(ref);
            Assert.assertNull((Object)service);
            gotEvent.await(30L, TimeUnit.SECONDS);
            Assert.assertNotNull(errorMsg.get());
            Assert.assertTrue((String)("Wrong error message: " + (String)errorMsg.get()), (boolean)((String)errorMsg.get()).contains(String.class.getName()));
        }
        finally {
            OSGiTestsActivator.getContext().removeFrameworkListener(fwkListener);
            reg.unregister();
        }
    }

    @Test
    public void testFilterObjectClassOptimization() throws InvalidSyntaxException {
        String TEST_KEY = "test.key";
        ArrayList registrations = new ArrayList();
        BundleContext bc = OSGiTestsActivator.getContext();
        try {
            ServiceRegistration<?> allObjectClass_noServiceProp = this.registerFilteredService(bc, registrations, new TestObjectClassOptimizationService(), Collections.emptyMap(), Runnable.class, Callable.class, Object.class);
            ServiceRegistration<?> allObjectClass_withServiceProp = this.registerFilteredService(bc, registrations, new TestObjectClassOptimizationService(), Collections.singletonMap("test.key", Boolean.TRUE), Runnable.class, Callable.class, Object.class);
            ServiceRegistration<?> callableObjectClass_noServiceProp = this.registerFilteredService(bc, registrations, new TestObjectClassOptimizationService(), Collections.emptyMap(), Callable.class);
            ServiceRegistration<?> callableObjectClass_withServiceProp = this.registerFilteredService(bc, registrations, new TestObjectClassOptimizationService(), Collections.singletonMap("test.key", Boolean.TRUE), Callable.class);
            this.validateFoundServices(bc, "(test.key=*)", allObjectClass_withServiceProp, callableObjectClass_withServiceProp);
            this.validateFoundServices(bc, "(|(objectClass=nothing.Service)(test.key=*))", allObjectClass_withServiceProp, callableObjectClass_withServiceProp);
            this.validateFoundServices(bc, "(objectClass=" + Runnable.class.getName() + ")", allObjectClass_withServiceProp, allObjectClass_noServiceProp);
            this.validateFoundServices(bc, "(objectClass=" + Callable.class.getName() + ")", allObjectClass_noServiceProp, allObjectClass_withServiceProp, callableObjectClass_noServiceProp, callableObjectClass_withServiceProp);
            this.validateFoundServices(bc, "(&(objectClass=" + Callable.class.getName() + ")(test.key=*))", allObjectClass_withServiceProp, callableObjectClass_withServiceProp);
            this.validateFoundServices(bc, "(|(objectClass=" + Callable.class.getName() + ")(test.key=*))", allObjectClass_withServiceProp, allObjectClass_noServiceProp, callableObjectClass_withServiceProp, callableObjectClass_noServiceProp);
            this.validateFoundServices(bc, "(&(&(objectClass=" + Callable.class.getName() + ")(!(objectClass=" + Runnable.class.getName() + ")))(test.key=*))", callableObjectClass_withServiceProp);
            this.validateFoundServices(bc, "(&(objectClass=" + Callable.class.getName() + ")(!(objectClass=" + Runnable.class.getName() + ")))", callableObjectClass_withServiceProp, callableObjectClass_noServiceProp);
            this.validateFoundServices(bc, "(&(!(objectClass=" + Runnable.class.getName() + "))(objectClass=" + Callable.class.getName() + "))", callableObjectClass_withServiceProp, callableObjectClass_noServiceProp);
        }
        finally {
            registrations.forEach(ServiceRegistration::unregister);
        }
    }

    private void validateFoundServices(BundleContext bc, String filter, ServiceRegistration<?> ... expectedRegs) throws InvalidSyntaxException {
        ServiceReference[] foundArray = bc.getServiceReferences(null, filter);
        List<Object> found = foundArray == null ? Collections.emptyList() : Arrays.asList(foundArray);
        Assert.assertEquals((String)("Wrong number of services found: " + String.valueOf(found)), (long)expectedRegs.length, (long)found.size());
        ServiceRegistration<?>[] serviceRegistrationArray = expectedRegs;
        int n = expectedRegs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceRegistration<?> expected = serviceRegistrationArray[n2];
            Assert.assertTrue((String)("Wrong services found: " + String.valueOf(found)), (boolean)found.contains(expected.getReference()));
            ++n2;
        }
    }

    private ServiceRegistration<?> registerFilteredService(BundleContext bc, Collection<ServiceRegistration<?>> registrations, TestObjectClassOptimizationService testObjectClassOptimizationService, Map<String, ?> props, Class<?> ... clazzes) {
        if (clazzes == null) {
            Assert.fail();
        }
        String[] clazzNames = new String[clazzes.length];
        int i = 0;
        while (i < clazzes.length) {
            clazzNames[i] = clazzes[i].getName();
            ++i;
        }
        ServiceRegistration reg = bc.registerService(clazzNames, (Object)testObjectClassOptimizationService, FrameworkUtil.asDictionary(props));
        registrations.add(reg);
        return reg;
    }

    private void clearResults(boolean[] results) {
        int i = 0;
        while (i < results.length) {
            results[i] = false;
            ++i;
        }
    }

    private void clearResults(int[] results) {
        int i = 0;
        while (i < results.length) {
            results[i] = 0;
            ++i;
        }
    }

    static class TestObjectClassOptimizationService
    implements Runnable,
    Callable<Void> {
        TestObjectClassOptimizationService() {
        }

        @Override
        public Void call() throws Exception {
            return null;
        }

        @Override
        public void run() {
        }
    }
}

