/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.serviceregistry;

import java.util.Hashtable;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerTests
extends AbstractBundleTests {
    @Test
    public void testServiceTracker01() throws InvalidSyntaxException {
        String testMethodName = this.getName();
        Runnable runIt = () -> {};
        Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
        props.put(testMethodName, Boolean.TRUE);
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        ServiceTracker testTracker = null;
        try {
            final boolean[] results = new boolean[3];
            ServiceTrackerCustomizer testCustomizer = new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    results[0] = true;
                    return reference;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                    results[1] = true;
                }

                public void removedService(ServiceReference reference, Object service) {
                    results[2] = true;
                }
            };
            Filter filter = FrameworkUtil.createFilter((String)("(&(objectclass=java.lang.Runnable)(" + testMethodName.toLowerCase() + "=true))"));
            testTracker = new ServiceTracker(OSGiTestsActivator.getContext(), filter, testCustomizer);
            testTracker.open();
            Assert.assertTrue((String)"Did not call addingService", (boolean)results[0]);
            Assert.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            Assert.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.FALSE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did call addingService", (boolean)results[0]);
            Assert.assertTrue((String)"Did not call modifiedService", (boolean)results[1]);
            Assert.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.FALSE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did call addingService", (boolean)results[0]);
            Assert.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            Assert.assertTrue((String)"Did not call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.TRUE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did call addingService", (boolean)results[0]);
            Assert.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            Assert.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.TRUE);
            reg.setProperties(props);
            Assert.assertTrue((String)"Did not call addingService", (boolean)results[0]);
            Assert.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            Assert.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
            if (testTracker != null) {
                testTracker.close();
            }
        }
    }

    @Test
    public void testServiceTracker02() throws InvalidSyntaxException {
        String testMethodName = this.getName();
        Runnable runIt = () -> {};
        Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
        props.put(testMethodName, Boolean.FALSE);
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        ServiceTracker testTracker = null;
        try {
            final boolean[] results = new boolean[3];
            ServiceTrackerCustomizer testCustomizer = new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    results[0] = true;
                    return reference;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                    results[1] = true;
                }

                public void removedService(ServiceReference reference, Object service) {
                    results[2] = true;
                }
            };
            Filter filter = FrameworkUtil.createFilter((String)("(&(objectclass=java.lang.Runnable)(" + testMethodName.toLowerCase() + "=true))"));
            testTracker = new ServiceTracker(OSGiTestsActivator.getContext(), filter, testCustomizer);
            testTracker.open();
            Assert.assertFalse((String)"Did call addingService", (boolean)results[0]);
            Assert.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            Assert.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.TRUE);
            reg.setProperties(props);
            Assert.assertTrue((String)"Did not call addingService", (boolean)results[0]);
            Assert.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            Assert.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.TRUE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did call addingService", (boolean)results[0]);
            Assert.assertTrue((String)"Did not call modifiedService", (boolean)results[1]);
            Assert.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.FALSE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did call addingService", (boolean)results[0]);
            Assert.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            Assert.assertTrue((String)"Did not call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.FALSE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did call addingService", (boolean)results[0]);
            Assert.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            Assert.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
            if (testTracker != null) {
                testTracker.close();
            }
        }
    }

    @Test
    public void testServiceTracker03() throws InvalidSyntaxException {
        String testMethodName = this.getName();
        Runnable runIt = () -> {};
        Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
        props.put(testMethodName, Boolean.TRUE);
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        ServiceTracker testTracker = null;
        try {
            final boolean[] results = new boolean[3];
            ServiceTrackerCustomizer testCustomizer = new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    results[0] = true;
                    return reference;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                    results[1] = true;
                }

                public void removedService(ServiceReference reference, Object service) {
                    results[2] = true;
                }
            };
            Filter filter = FrameworkUtil.createFilter((String)("(&(objectclass=java.lang.Runnable)(" + testMethodName.toLowerCase() + "=true))"));
            testTracker = new ServiceTracker(OSGiTestsActivator.getContext(), filter, testCustomizer);
            testTracker.open();
            Assert.assertTrue((String)"Did not call addingService", (boolean)results[0]);
            Assert.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            Assert.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.FALSE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did call addingService", (boolean)results[0]);
            Assert.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            Assert.assertTrue((String)"Did not call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.TRUE);
            reg.setProperties(props);
            Assert.assertTrue((String)"Did not call addingService", (boolean)results[0]);
            Assert.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            Assert.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.FALSE);
            reg.setProperties(props);
            Assert.assertFalse((String)"Did call addingService", (boolean)results[0]);
            Assert.assertTrue((String)"Did not call modifiedService", (boolean)results[1]);
            Assert.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
            if (testTracker != null) {
                testTracker.close();
            }
        }
    }

    private void clearResults(boolean[] results) {
        int i = 0;
        while (i < results.length) {
            results[i] = false;
            ++i;
        }
    }
}

