/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.datalocation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import junit.framework.AssertionFailedError;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;

public class BasicLocationTests {
    @Rule
    public TestName testName = new TestName();
    String prefix = "";
    ServiceTracker<Location, Location> configLocationTracker = null;
    ServiceTracker<Location, Location> instanceLocationTracker = null;
    private static final String INSTANCE_DATA_AREA_PREFIX = ".metadata/.plugins/";

    @Before
    public void setUp() throws Exception {
        this.prefix = Platform.OS.isWindows() ? "c:" : "";
        this.configLocationTracker = new ServiceTracker(OSGiTestsActivator.getContext(), OSGiTestsActivator.getContext().createFilter(Location.CONFIGURATION_FILTER), null);
        this.instanceLocationTracker = new ServiceTracker(OSGiTestsActivator.getContext(), OSGiTestsActivator.getContext().createFilter(Location.INSTANCE_FILTER), null);
        this.configLocationTracker.open();
        this.instanceLocationTracker.open();
    }

    @After
    public void tearDown() throws Exception {
        this.configLocationTracker.close();
        this.instanceLocationTracker.close();
    }

    private void checkSlashes(Map<String, Location> locations) {
        this.checkLocation(locations.get(Location.USER_FILTER), true, true, null);
        this.checkLocation(locations.get(Location.INSTANCE_FILTER), true, true, null);
        this.checkLocation(locations.get(Location.CONFIGURATION_FILTER), true, true, null);
        this.checkLocation(locations.get(Location.INSTALL_FILTER), true, true, null);
    }

    private void checkLocation(Location location, boolean leading, boolean trailing, String scheme) {
        if (location == null) {
            return;
        }
        URL url = location.getURL();
        if (scheme != null) {
            Assert.assertEquals((Object)scheme, (Object)url.getProtocol());
        }
        if (!url.getProtocol().equals("file")) {
            return;
        }
        Assert.assertTrue((String)(url.toExternalForm() + " should " + (trailing ? "" : "not") + " have a trailing slash"), (url.getFile().endsWith("/") == trailing ? 1 : 0) != 0);
        if (Platform.OS.isWindows()) {
            Assert.assertTrue((String)(url.toExternalForm() + " should " + (leading ? "" : "not") + " have a leading slash"), (url.getFile().startsWith("/") == leading ? 1 : 0) != 0);
        }
    }

    private void fail(String message, Throwable exception) {
        AssertionFailedError error = new AssertionFailedError(message);
        error.initCause(exception);
        throw error;
    }

    @Test
    public void testCreateLocation01() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testCreateLocation01");
        Location testLocation = configLocation.createLocation(null, null, false);
        try {
            testLocation.set(testLocationFile.toURL(), false);
        }
        catch (Throwable t) {
            this.fail("Failed to set location", t);
        }
        try {
            Assert.assertTrue((String)"Could not lock location", (boolean)testLocation.lock());
        }
        catch (IOException e) {
            this.fail("Failed to lock location", e);
        }
        testLocation.release();
    }

    @Test
    public void testCreateLocation02() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testCreateLocation02");
        Location testLocation = configLocation.createLocation(null, null, true);
        try {
            testLocation.set(testLocationFile.toURL(), false);
        }
        catch (Throwable t) {
            this.fail("Failed to set location", t);
        }
        Assert.assertThrows((String)"Should not be able to lock read-only location", IOException.class, () -> {
            Assert.assertTrue((String)"Could not lock location", (boolean)testLocation.lock());
            testLocation.release();
        });
    }

    @Test
    public void testCreateLocation03() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testCreateLocation03");
        Location testLocation = configLocation.createLocation(null, null, false);
        try {
            testLocation.set(testLocationFile.toURL(), true);
        }
        catch (Throwable t) {
            this.fail("Failed to set location", t);
        }
        try {
            Assert.assertTrue((String)"Could not lock location", (boolean)testLocation.isLocked());
        }
        catch (IOException e) {
            this.fail("Failed to lock location", e);
        }
        testLocation.release();
    }

    @Test
    public void testCreateLocation04() throws IllegalStateException, MalformedURLException, IOException {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testCreateLocation04");
        Location testLocation = configLocation.createLocation(null, null, true);
        Assert.assertFalse((String)"Could not set location", (boolean)testLocation.set(testLocationFile.toURL(), true));
        Assert.assertTrue((String)"Location should be set", (boolean)testLocation.isSet());
        Assert.assertThrows((String)"Should not be able to lock read-only location", IOException.class, () -> {
            Assert.assertTrue((String)"Could not lock location", (boolean)testLocation.lock());
            testLocation.release();
        });
    }

    @Test
    public void testCreateLocation05() throws IllegalStateException, MalformedURLException, IOException {
        Location testLocation;
        block10: {
            Location configLocation = (Location)this.configLocationTracker.getService();
            File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testCreateLocation01");
            testLocation = configLocation.createLocation(null, null, false);
            Assert.assertTrue((String)"Could not set location", (boolean)testLocation.set(testLocationFile.toURL(), false));
            Assert.assertTrue((String)"Location should be set", (boolean)testLocation.isSet());
            try {
                try {
                    Assert.assertTrue((String)"Could not lock location", (boolean)testLocation.lock());
                    Assert.assertFalse((String)"Could lock a secend time", (boolean)testLocation.lock());
                    Assert.assertFalse((String)"Could lock a third time", (boolean)testLocation.lock());
                }
                catch (IOException e) {
                    this.fail("Failed to lock location", e);
                    testLocation.release();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                testLocation.release();
                throw throwable;
            }
            testLocation.release();
        }
        try {
            try {
                Assert.assertTrue((String)"Could not lock location", (boolean)testLocation.lock());
            }
            catch (IOException e) {
                this.fail("Failed to lock location", e);
                testLocation.release();
            }
        }
        finally {
            testLocation.release();
        }
    }

    @Test
    public void testLocationDataArea01() {
        Location instance = (Location)this.instanceLocationTracker.getService();
        this.doAllTestLocationDataArea(instance, INSTANCE_DATA_AREA_PREFIX);
        Location configuration = (Location)this.configLocationTracker.getService();
        this.doAllTestLocationDataArea(configuration, "");
    }

    private void doAllTestLocationDataArea(Location location, String dataAreaPrefix) {
        this.doTestLocateDataArea(location, dataAreaPrefix, this.testName.getMethodName());
        this.doTestLocateDataArea(location, dataAreaPrefix, "");
        this.doTestLocateDataArea(location, dataAreaPrefix, "test/multiple/paths");
        this.doTestLocateDataArea(location, dataAreaPrefix, "test/multiple/../paths");
        this.doTestLocateDataArea(location, dataAreaPrefix, "test\\multiple\\paths");
        this.doTestLocateDataArea(location, dataAreaPrefix, "/test/begin/slash");
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/" + this.testName.getMethodName());
        Location createdLocation = location.createLocation(null, null, false);
        try {
            createdLocation.set(testLocationFile.toURL(), false);
        }
        catch (Exception e) {
            this.fail("Failed to set location", e);
        }
        this.doTestLocateDataArea(createdLocation, dataAreaPrefix, this.testName.getMethodName());
        this.doTestLocateDataArea(createdLocation, dataAreaPrefix, "");
        this.doTestLocateDataArea(createdLocation, dataAreaPrefix, "test/multiple/paths");
        this.doTestLocateDataArea(createdLocation, dataAreaPrefix, "test/multiple/../paths");
        this.doTestLocateDataArea(location, dataAreaPrefix, "test\\multiple\\paths");
        this.doTestLocateDataArea(location, dataAreaPrefix, "/test/begin/slash");
        Location recreatedLocation = location.createLocation(null, null, false);
        Assert.assertThrows((String)"expected failure when location is not set", IOException.class, () -> {
            URL uRL = recreatedLocation.getDataArea("shouldFail");
        });
    }

    private void doTestLocateDataArea(Location location, String dataAreaPrefix, String namespace) {
        Assert.assertTrue((String)"Location is not set", (boolean)location.isSet());
        URL dataArea = null;
        try {
            dataArea = location.getDataArea(namespace);
        }
        catch (IOException e) {
            this.fail("Failed to get data area.", e);
        }
        Assert.assertNotNull((String)"Data area is null.", (Object)dataArea);
        namespace = namespace.replace('\\', '/');
        if (namespace.startsWith("/")) {
            namespace = namespace.substring(1);
        }
        Assert.assertTrue((String)("Data area is not the expected value: " + dataArea.toExternalForm()), (boolean)dataArea.toExternalForm().endsWith(dataAreaPrefix + namespace));
    }

    @Test
    public void testSetLocationWithEmptyLockFile() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testSetLocationWithEmptyLockFile");
        Location testLocation = configLocation.createLocation(null, null, false);
        try {
            testLocation.set(testLocationFile.toURL(), true, "");
            File lockFile = new File(testLocationFile, ".metadata/.lock");
            Assert.assertTrue((String)"Lock file does not exist!", (boolean)lockFile.exists());
        }
        catch (Throwable t) {
            this.fail("Failed to set location", t);
        }
        try {
            Assert.assertTrue((String)"Could not lock location", (boolean)testLocation.isLocked());
        }
        catch (IOException e) {
            this.fail("Failed to lock location", e);
        }
        testLocation.release();
    }

    @Test
    public void testSetLocationWithRelLockFile() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testSetLocationWithRelLockFile");
        Location testLocation = configLocation.createLocation(null, null, false);
        try {
            testLocation.set(testLocationFile.toURL(), true, ".mocklock");
            File lockFile = new File(testLocationFile, ".mocklock");
            Assert.assertTrue((String)"Lock file does not exist!", (boolean)lockFile.exists());
        }
        catch (Throwable t) {
            this.fail("Failed to set location", t);
        }
        try {
            Assert.assertTrue((String)"Could not lock location", (boolean)testLocation.isLocked());
        }
        catch (IOException e) {
            this.fail("Failed to lock location", e);
        }
        testLocation.release();
    }

    @Test
    public void testSetLocationWithAbsLockFile() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testSetLocationWithAbsLockFile");
        File testLocationLockFile = OSGiTestsActivator.getContext().getDataFile("testLocations/mock.lock");
        Assert.assertTrue((boolean)testLocationLockFile.isAbsolute());
        Location testLocation = configLocation.createLocation(null, null, false);
        try {
            testLocation.set(testLocationFile.toURL(), true, testLocationLockFile.getAbsolutePath());
            Assert.assertTrue((String)"The lock file should be present!", (boolean)testLocationLockFile.exists());
        }
        catch (Throwable t) {
            this.fail("Failed to set location", t);
        }
        try {
            Assert.assertTrue((String)"Could not lock location", (boolean)testLocation.isLocked());
        }
        catch (IOException e) {
            this.fail("Failed to lock location", e);
        }
        testLocation.release();
        Assert.assertTrue((String)"The lock file could not be removed!", (boolean)testLocationLockFile.delete());
    }

    @Test
    public void testSlashes() throws BundleException, InvalidSyntaxException {
        HashMap<String, Object> fwkConfig = new HashMap<String, Object>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.user.area", this.prefix + "/a");
        fwkConfig.put("osgi.instance.area", this.prefix + "/c/d");
        fwkConfig.put("osgi.configuration.area", this.prefix + "/e/f");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            this.checkSlashes(BasicLocationTests.getLocations(equinox));
        }
        finally {
            equinox.stop();
        }
    }

    private static Map<String, Location> getLocations(Equinox equinox) throws InvalidSyntaxException {
        HashMap<String, Location> locations = new HashMap<String, Location>();
        BundleContext context = equinox.getBundleContext();
        BasicLocationTests.addLocation(context, Location.CONFIGURATION_FILTER, locations);
        BasicLocationTests.addLocation(context, Location.INSTALL_FILTER, locations);
        BasicLocationTests.addLocation(context, Location.INSTANCE_FILTER, locations);
        BasicLocationTests.addLocation(context, Location.USER_FILTER, locations);
        return locations;
    }

    private static void addLocation(BundleContext context, String filter, Map<String, Location> locations) throws InvalidSyntaxException {
        Collection locationRefs = context.getServiceReferences(Location.class, filter);
        if (!locationRefs.isEmpty()) {
            locations.put(filter, (Location)context.getService((ServiceReference)locationRefs.iterator().next()));
        }
    }

    @Test
    public void testSchemes() throws Exception {
        HashMap<String, Object> fwkConfig = new HashMap<String, Object>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.user.area", "http://example.com/a");
        fwkConfig.put("osgi.instance.area", "ftp://example.com/c/d");
        fwkConfig.put("osgi.configuration.area", "platform:/base/e/f");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            this.checkSlashes(locations);
            this.checkLocation(locations.get(Location.USER_FILTER), true, true, "http");
            this.checkLocation(locations.get(Location.INSTANCE_FILTER), true, true, "ftp");
            this.checkLocation(locations.get(Location.CONFIGURATION_FILTER), true, true, "platform");
            this.checkLocation(locations.get(Location.INSTALL_FILTER), true, true, "file");
        }
        finally {
            equinox.stop();
        }
    }

    @Test
    public void testNone() throws Exception {
        HashMap<String, Object> fwkConfig = new HashMap<String, Object>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.user.area", "@none");
        fwkConfig.put("osgi.instance.area", "@none");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            Assert.assertNull((String)"User location should be null", (Object)locations.get(Location.USER_FILTER));
            Assert.assertNull((String)"Instance location should be null", (Object)locations.get(Location.INSTANCE_FILTER));
        }
        finally {
            equinox.stop();
        }
    }

    @Test
    public void testNoDefault() throws Exception {
        HashMap<String, Object> fwkConfig = new HashMap<String, Object>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        fwkConfig.put("osgi.instance.area", "@noDefault");
        fwkConfig.put("osgi.user.area", "@noDefault");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            Location userLocation = locations.get(Location.USER_FILTER);
            Location instanceLocation = locations.get(Location.INSTANCE_FILTER);
            Assert.assertNull((String)"User locatoin is not null.", (Object)userLocation.getURL());
            Assert.assertNull((String)"Instance location is not null.", (Object)instanceLocation.getURL());
        }
        finally {
            equinox.stop();
        }
    }

    @Test
    public void testSetUrl() throws Exception {
        HashMap<String, Object> fwkConfig = new HashMap<String, Object>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        fwkConfig.put("osgi.instance.area", "@noDefault");
        fwkConfig.put("osgi.user.area", "@noDefault");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            BundleContext context = equinox.getBundleContext();
            ServiceTracker tracker = new ServiceTracker(context, context.createFilter(Location.INSTANCE_FILTER), null);
            tracker.open();
            SortedMap serviceMap = tracker.getTracked();
            Assert.assertTrue((String)("no service matching " + Location.INSTANCE_FILTER + " found!"), (serviceMap.size() == 1 ? 1 : 0) != 0);
            Map.Entry entry = serviceMap.entrySet().iterator().next();
            Location location = (Location)entry.getValue();
            Assert.assertNull((String)"Instance location is not null.", (Object)location.getURL());
            ServiceReference serviceReference = (ServiceReference)entry.getKey();
            Assert.assertNull((String)"Url property is set!", (Object)serviceReference.getProperty("url"));
            File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testseturl");
            location.set(testLocationFile.toURL(), false);
            Assert.assertNotNull((String)"Instance location is still null.", (Object)location.getURL());
            Assert.assertEquals((String)"Url not set to the service properties", (Object)location.getURL().toExternalForm(), (Object)serviceReference.getProperty("url"));
        }
        finally {
            equinox.stop();
        }
    }

    @Test
    public void testUserDir() throws Exception {
        HashMap<String, Object> fwkConfig = new HashMap<String, Object>();
        fwkConfig.put("osgi.user.area", "@user.dir");
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.instance.area", "@user.dir");
        fwkConfig.put("osgi.configuration.area", "@user.dir");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            this.checkLocation(locations.get(Location.USER_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.INSTANCE_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.CONFIGURATION_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.INSTALL_FILTER), true, true, "file");
        }
        finally {
            equinox.stop();
        }
    }

    @Test
    public void testUserHome() throws Exception {
        HashMap<String, Object> fwkConfig = new HashMap<String, Object>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.user.area", "@user.home");
        fwkConfig.put("osgi.instance.area", "@user.home");
        fwkConfig.put("osgi.configuration.area", "@user.home");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            this.checkLocation(locations.get(Location.USER_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.INSTANCE_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.CONFIGURATION_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.INSTALL_FILTER), true, true, "file");
        }
        finally {
            equinox.stop();
        }
    }

    @Test
    public void testUNC() throws Exception {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        HashMap<String, String> fwkConfig = new HashMap<String, String>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.user.area", "//server/share/a");
        fwkConfig.put("osgi.instance.area", "//server/share/b");
        fwkConfig.put("osgi.configuration.area", "//server/share/c");
        fwkConfig.put("osgi.install.area", "file://server/share/g");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            this.checkLocation(locations.get(Location.USER_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.INSTANCE_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.CONFIGURATION_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.INSTALL_FILTER), true, true, "file");
        }
        finally {
            equinox.stop();
        }
    }

    @Test
    public void testDebugLogOnGetURL() throws Exception {
        Properties debugOptions = new Properties();
        debugOptions.put("org.eclipse.osgi/debug/location", "true");
        File debugOptionsFile = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName() + ".options");
        debugOptions.store(new FileOutputStream(debugOptionsFile), this.testName.getMethodName());
        HashMap<String, Object> fwkConfig = new HashMap<String, Object>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        fwkConfig.put("osgi.debug", debugOptionsFile.getAbsolutePath());
        fwkConfig.put("eclipse.consoleLog", "true");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            ArrayList logEntries = new ArrayList();
            LogReaderService logReaderService = this.getLogReaderService(equinox);
            SynchronousLogListener logListener = logEntries::add;
            logReaderService.addLogListener((LogListener)logListener);
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            Location userLocation = locations.get(Location.USER_FILTER);
            Location instanceLocation = locations.get(Location.INSTANCE_FILTER);
            Assert.assertNotNull((String)"User locatoin is not null.", (Object)userLocation.getURL());
            Assert.assertNotNull((String)"Instance location is not null.", (Object)instanceLocation.getURL());
            Assert.assertEquals((String)"Wrong number of log entries", (long)2L, (long)logEntries.size());
        }
        finally {
            equinox.stop();
        }
    }

    private LogReaderService getLogReaderService(Equinox equinox) {
        return (LogReaderService)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(LogReaderService.class));
    }
}

