/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.datalocation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.rules.TestName;

public class FileManagerTests {
    @Rule
    public TestName testName = new TestName();
    StorageManager manager1;
    StorageManager manager2;
    File base;

    @Before
    public void setUp() throws Exception {
        this.base = new File(Platform.getConfigurationLocation().getURL().getPath(), "FileManagerTests");
        this.manager1 = null;
        this.manager2 = null;
    }

    @After
    public void tearDown() throws Exception {
        if (this.manager1 != null) {
            this.manager1.close();
        }
        if (this.manager2 != null) {
            this.manager2.close();
        }
        this.rm(this.base);
    }

    private void rm(File folder) {
        File[] files;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.rm(file);
                ++n2;
            }
        }
        folder.delete();
    }

    @Test
    public void testReadOnly() throws IOException {
        File testDir = new File(this.base, "readOnlyManager");
        String fileName = "testReadOnly";
        testDir.mkdirs();
        String[] files = testDir.list();
        Assert.assertEquals((long)files.length, (long)0L);
        this.manager1 = new StorageManager(testDir, null, true);
        this.manager1.open(true);
        files = testDir.list();
        Assert.assertEquals((long)files.length, (long)0L);
        try {
            this.manager1.add(fileName);
            Assert.fail((String)"add succedded");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.manager1.lookup(fileName, true);
            Assert.fail((String)"lookup succedded");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.manager1.createTempFile(fileName);
            Assert.fail((String)"create temp file succedded");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        files = testDir.list();
        Assert.assertEquals((long)files.length, (long)0L);
        this.manager1.close();
        this.manager1 = null;
        this.manager2 = new StorageManager(testDir, null, false);
        this.manager2.open(true);
        this.manager2.lookup(fileName, true);
        File tmpFile = this.manager2.createTempFile(fileName);
        this.writeToFile(tmpFile, "This file exists");
        this.manager2.update(new String[]{fileName}, new String[]{tmpFile.getName()});
        this.manager2.close();
        this.manager2 = null;
    }

    void writeToFile(File file, String str) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(str.getBytes());
            fos.flush();
            fos.getFD().sync();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getInputStreamContents(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        byte[] data = new byte[64];
        try {
            int len;
            while ((len = is.read(data)) != -1) {
                sb.append(new String(data, 0, len));
            }
        }
        finally {
            is.close();
        }
        return sb.toString();
    }

    @Test
    public void testExistingVersion() throws IOException {
        String testFile = "testExistingVersion.txt";
        this.manager1 = new StorageManager(this.base, null);
        this.manager1.open(false);
        File file1 = new File(this.base, testFile + ".1");
        File file2 = new File(this.base, testFile + ".2");
        File file3 = new File(this.base, testFile + ".3");
        File file4 = new File(this.base, testFile + ".4");
        if (file1.exists() || file2.exists() || file3.exists() || file4.exists()) {
            Assert.fail((String)"Test files already exists.");
            return;
        }
        this.manager1.add(testFile);
        File file = this.manager1.createTempFile(testFile);
        this.writeToFile(file, "contents irrelevant");
        this.manager1.update(new String[]{testFile}, new String[]{file.getName()});
        if (!file1.exists() || file2.exists() || file3.exists() || file4.exists()) {
            Assert.fail((String)"Failed to create a single test file");
            return;
        }
        this.writeToFile(file2, "file2 exists");
        file = this.manager1.createTempFile(testFile);
        this.writeToFile(file, "file 3 contents");
        this.manager1.update(new String[]{testFile}, new String[]{file.getName()});
        if (!file3.exists() || file4.exists()) {
            Assert.fail((String)"Failed to skip existing filemanager file.");
            return;
        }
        this.manager2 = new StorageManager(this.base, null);
        this.manager2.open(true);
        file = this.manager2.lookup(testFile, false);
        if (file == null) {
            Assert.fail((String)"Unable to lookup exising file");
            return;
        }
        Assert.assertTrue((boolean)file.getName().endsWith(".3"));
        Assert.assertTrue((boolean)file.exists());
        FileInputStream fis = new FileInputStream(file);
        Assert.assertEquals((Object)this.getInputStreamContents(fis), (Object)"file 3 contents");
        this.manager2.close();
        this.manager2 = null;
        this.manager1.close();
        this.manager1 = null;
    }

    @Test
    public void testNotOpen() throws Throwable {
        String permanentFile = "testNotOpen.txt";
        String scratchFile = "testNotOpenScratch";
        this.manager1 = new StorageManager(this.base, null);
        this.manager1.open(true);
        this.manager1.add(permanentFile);
        File tmpFile = this.manager1.createTempFile(permanentFile);
        this.writeToFile(tmpFile, "File exists");
        this.manager1.update(new String[]{permanentFile}, new String[]{tmpFile.getName()});
        this.manager1.add(scratchFile);
        this.manager2 = new StorageManager(this.base, null);
        this.checkOpen(false, permanentFile, scratchFile);
        this.manager2.open(true);
        this.checkOpen(true, permanentFile, scratchFile);
        this.manager2.close();
        this.checkOpen(false, permanentFile, scratchFile);
        this.manager2 = null;
        this.manager1.close();
        this.manager1 = null;
    }

    void checkOpen(boolean open, String permanentFile, String scratchFile) throws Throwable {
        ThrowingRunnable addOperation = () -> this.manager2.add("failFile");
        if (open) {
            addOperation.run();
            this.manager2.remove("failFile");
        } else {
            Assert.assertThrows((String)"add did not fail", IOException.class, (ThrowingRunnable)addOperation);
        }
        ThrowingRunnable lookupOperation = () -> {
            File file = this.manager2.lookup(permanentFile, false);
        };
        if (open) {
            lookupOperation.run();
        } else {
            Assert.assertThrows((String)"lookup did not fail", IOException.class, (ThrowingRunnable)lookupOperation);
        }
        File tmpFile = this.manager2.createTempFile("openTest");
        this.writeToFile(tmpFile, "contents irrelevant");
        if (tmpFile != null) {
            ThrowingRunnable updateOperation = () -> this.manager2.update(new String[]{permanentFile}, new String[]{tmpFile.getName()});
            if (open) {
                updateOperation.run();
            } else {
                Assert.assertThrows((String)"update did not fail", IOException.class, (ThrowingRunnable)updateOperation);
            }
        }
        ThrowingRunnable removeOperation = () -> this.manager2.remove(scratchFile);
        if (open) {
            removeOperation.run();
            this.manager2.add(scratchFile);
        } else {
            Assert.assertThrows((String)"update did not fail", IOException.class, (ThrowingRunnable)removeOperation);
        }
    }

    @Test
    public void testRemoveThenAdd() throws IOException {
        String fileName = "testRemoveThenAdd.txt";
        File file1 = new File(this.base, fileName + ".1");
        File file2 = new File(this.base, fileName + ".2");
        File file3 = new File(this.base, fileName + ".3");
        this.manager1 = new StorageManager(this.base, null);
        this.manager1.open(true);
        this.manager1.add(fileName);
        File tmpFile = this.manager1.createTempFile(fileName);
        this.writeToFile(tmpFile, "File exists");
        this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
        tmpFile = this.manager1.createTempFile(fileName);
        this.writeToFile(tmpFile, "File exists #2");
        this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
        this.manager1.close();
        this.manager1 = null;
        if (file1.exists() || !file2.exists() || file3.exists()) {
            Assert.fail((String)"Failed creating a file revision");
        }
        this.manager2 = new StorageManager(this.base, null);
        this.manager2.open(true);
        this.manager2.remove(fileName);
        File testFile = this.manager2.lookup(fileName, false);
        Assert.assertNull((Object)testFile);
        this.manager2.add(fileName);
        testFile = this.manager2.lookup(fileName, false);
        Assert.assertNotNull((Object)testFile);
        Assert.assertTrue((boolean)testFile.getName().endsWith(".0"));
        tmpFile = this.manager2.createTempFile(fileName);
        this.writeToFile(tmpFile, "File exists #3");
        this.manager2.update(new String[]{fileName}, new String[]{tmpFile.getName()});
        testFile = this.manager2.lookup(fileName, false);
        Assert.assertNotNull((Object)testFile);
        Assert.assertTrue((boolean)testFile.getName().endsWith(".3"));
        Assert.assertTrue((boolean)file3.exists());
        this.manager1 = new StorageManager(this.base, null);
        this.manager1.open(true);
        testFile = this.manager1.lookup(fileName, false);
        Assert.assertNotNull((Object)testFile);
        Assert.assertTrue((boolean)testFile.getName().endsWith(".3"));
        this.manager1.close();
        this.manager1 = null;
        this.manager2.close();
        this.manager2 = null;
    }

    @Test
    public void testMultipleFileManagers() throws IOException {
        String ee = System.getProperty("org.osgi.framework.executionenvironment");
        if (!"win32".equalsIgnoreCase(System.getProperty("osgi.os")) && ee.indexOf("JavaSE-1.6") == -1) {
            return;
        }
        String fileName = "testMultipleFileManagers.txt";
        File file1 = new File(this.base, fileName + ".1");
        File file2 = new File(this.base, fileName + ".2");
        this.manager1 = new StorageManager(this.base, null);
        this.manager1.open(true);
        File file = this.manager1.lookup(fileName, true);
        Assert.assertNotNull((Object)file);
        file = this.manager1.createTempFile(fileName);
        this.writeToFile(file, "test contents #1");
        this.manager1.update(new String[]{fileName}, new String[]{file.getName()});
        file = this.manager1.lookup(fileName, false);
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.getName().endsWith(".1"));
        Assert.assertTrue((boolean)file1.exists());
        this.manager2 = new StorageManager(this.base, null);
        this.manager2.open(true);
        file = this.manager2.lookup(fileName, false);
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.getName().endsWith(".1"));
        Assert.assertTrue((file1.exists() && !file2.exists() ? 1 : 0) != 0);
        file = this.manager1.createTempFile(fileName);
        this.writeToFile(file, "test contents #2");
        this.manager1.update(new String[]{fileName}, new String[]{file.getName()});
        Assert.assertTrue((boolean)file1.exists());
        Assert.assertTrue((boolean)file2.exists());
        this.manager1.close();
        this.manager1 = null;
        Assert.assertTrue((boolean)file1.exists());
        Assert.assertTrue((boolean)file2.exists());
        file = this.manager2.lookup(fileName, false);
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.getName().endsWith(".1"));
        this.manager2.close();
        this.manager2 = null;
        Assert.assertTrue((!file1.exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)file2.exists());
        this.manager1 = new StorageManager(this.base, null);
        this.manager1.open(true);
        file = this.manager1.lookup(fileName, false);
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.getName().endsWith(".2"));
        this.manager1.close();
        this.manager1 = null;
    }

    @Test
    public void testJavaIOLocking() throws FileNotFoundException, IOException {
        if (!"win32".equalsIgnoreCase(System.getProperty("osgi.os"))) {
            return;
        }
        String fileName = "testJavaIOLocking";
        File lockFile = new File(new File(this.base, ".manager"), ".fileTableLock");
        lockFile.getParentFile().mkdirs();
        new FileOutputStream(lockFile).close();
        Assert.assertTrue((boolean)lockFile.exists());
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(lockFile);
            this.manager1 = new StorageManager(this.base, "java.io");
            try {
                this.manager1.open(true);
                Assert.fail((String)"open with lock succedded");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.manager1.open(false);
            try {
                this.manager1.add(fileName);
                Assert.fail((String)"add succedded");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Assert.assertNull((Object)this.manager1.lookup(fileName, false));
            this.manager1.close();
            this.manager1 = null;
        }
    }

    @Test
    public void testCleanupOnOpen() throws IOException {
        String fileName = this.testName.getMethodName() + ".txt";
        File file1 = new File(this.base, fileName + ".1");
        File file2 = new File(this.base, fileName + ".2");
        File file3 = new File(this.base, fileName + ".3");
        System.setProperty("osgi.embedded.cleanupOnOpen", "true");
        try {
            this.manager1 = new StorageManager(this.base, null);
            this.manager1.open(true);
            this.manager1.add(fileName);
            File tmpFile = this.manager1.createTempFile(fileName);
            this.writeToFile(tmpFile, "File exists #1");
            this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
            Assert.assertTrue((String)file1.toString(), (boolean)file1.exists());
            Assert.assertFalse((String)file2.toString(), (boolean)file2.exists());
            Assert.assertFalse((String)file3.toString(), (boolean)file3.exists());
            tmpFile = this.manager1.createTempFile(fileName);
            this.writeToFile(tmpFile, "File exists #2");
            this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
            Assert.assertTrue((String)file1.toString(), (boolean)file1.exists());
            Assert.assertTrue((String)file2.toString(), (boolean)file2.exists());
            Assert.assertFalse((String)file3.toString(), (boolean)file3.exists());
            tmpFile = this.manager1.createTempFile(fileName);
            this.writeToFile(tmpFile, "File exists #3");
            this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
            Assert.assertTrue((String)file1.toString(), (boolean)file1.exists());
            Assert.assertTrue((String)file2.toString(), (boolean)file2.exists());
            Assert.assertTrue((String)file3.toString(), (boolean)file3.exists());
            String ee = System.getProperty("org.osgi.framework.executionenvironment");
            if ("win32".equalsIgnoreCase(System.getProperty("osgi.os")) || ee.indexOf("JavaSE-1.6") != -1) {
                this.manager2 = new StorageManager(this.base, null);
                this.manager2.open(true);
                this.manager2.close();
                Assert.assertTrue((String)file1.toString(), (boolean)file1.exists());
                Assert.assertTrue((String)file2.toString(), (boolean)file2.exists());
                Assert.assertTrue((String)file3.toString(), (boolean)file3.exists());
            }
            this.manager1.close();
            Assert.assertFalse((String)file1.toString(), (boolean)file1.exists());
            Assert.assertFalse((String)file2.toString(), (boolean)file2.exists());
            Assert.assertTrue((String)file3.toString(), (boolean)file3.exists());
            this.writeToFile(file1, "File exists #1");
            this.writeToFile(file2, "File exists #2");
            Assert.assertTrue((String)file1.toString(), (boolean)file1.exists());
            Assert.assertTrue((String)file2.toString(), (boolean)file2.exists());
            this.manager1.open(true);
            Assert.assertFalse((String)file1.toString(), (boolean)file1.exists());
            Assert.assertFalse((String)file2.toString(), (boolean)file2.exists());
            Assert.assertTrue((String)file3.toString(), (boolean)file3.exists());
            this.manager1.close();
            this.manager1 = null;
            Assert.assertFalse((String)file1.toString(), (boolean)file1.exists());
            Assert.assertFalse((String)file2.toString(), (boolean)file2.exists());
            Assert.assertTrue((String)file3.toString(), (boolean)file3.exists());
        }
        finally {
            System.setProperty("osgi.embedded.cleanupOnOpen", "false");
        }
    }

    @Test
    public void testCleanupOnSave() throws IOException {
        String fileName = this.testName.getMethodName() + ".txt";
        File file1 = new File(this.base, fileName + ".1");
        File file2 = new File(this.base, fileName + ".2");
        File file3 = new File(this.base, fileName + ".3");
        System.setProperty("osgi.embedded.cleanupOnSave", "true");
        try {
            this.manager1 = new StorageManager(this.base, null);
            this.manager1.open(true);
            this.manager1.add(fileName);
            File tmpFile = this.manager1.createTempFile(fileName);
            this.writeToFile(tmpFile, "File exists #1");
            this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
            Assert.assertTrue((String)file1.toString(), (boolean)file1.exists());
            Assert.assertFalse((String)file2.toString(), (boolean)file2.exists());
            Assert.assertFalse((String)file3.toString(), (boolean)file3.exists());
            tmpFile = this.manager1.createTempFile(fileName);
            this.writeToFile(tmpFile, "File exists #2");
            this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
            Assert.assertFalse((String)file1.toString(), (boolean)file1.exists());
            Assert.assertTrue((String)file2.toString(), (boolean)file2.exists());
            Assert.assertFalse((String)file3.toString(), (boolean)file3.exists());
            tmpFile = this.manager1.createTempFile(fileName);
            this.writeToFile(tmpFile, "File exists #3");
            this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
            Assert.assertFalse((String)file1.toString(), (boolean)file1.exists());
            Assert.assertFalse((String)file2.toString(), (boolean)file2.exists());
            Assert.assertTrue((String)file3.toString(), (boolean)file3.exists());
            this.manager1.close();
            this.manager1 = null;
            Assert.assertFalse((String)file1.toString(), (boolean)file1.exists());
            Assert.assertFalse((String)file2.toString(), (boolean)file2.exists());
            Assert.assertTrue((String)file3.toString(), (boolean)file3.exists());
        }
        finally {
            System.setProperty("osgi.embedded.cleanupOnSave", "false");
        }
    }
}

