/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.datalocation;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.core.tests.session.SetupManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class LocationAreaSessionTest
extends TestCase {
    private static final String JAVA_NIO = "java.nio";
    private static final String JAVA_IO = "java.io";
    private static final String TEST_LOCATION_DIR = "osgi.test.location.dir";
    private static Location lockedTestLocation;
    static String testLocationLockDir;

    static {
        testLocationLockDir = OSGiTestsActivator.getContext().getDataFile("testLocation").getAbsolutePath();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(LocationAreaSessionTest.class.getName());
        suite.addTest((Test)new TestCase("testLockJavaNIO"){

            public void runBare() throws Throwable {
                LocationAreaSessionTest.doLock(testLocationLockDir, LocationAreaSessionTest.JAVA_NIO, false, true);
            }
        });
        ConfigurationSessionTestSuite sessionLock = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", LocationAreaSessionTest.class.getName());
        OSGiTestsActivator.addRequiredOSGiTestsBundles(sessionLock);
        try {
            sessionLock.getSetup().setSystemProperty(TEST_LOCATION_DIR, testLocationLockDir);
        }
        catch (SetupManager.SetupException e) {
            e.printStackTrace();
        }
        sessionLock.addTest((Test)new LocationAreaSessionTest("testSessionFailLockJavaNIO"));
        suite.addTest((Test)sessionLock);
        suite.addTest((Test)new TestCase("testReleaseJavaNIO"){

            public void runBare() throws Throwable {
                LocationAreaSessionTest.doRelease();
            }
        });
        sessionLock = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", LocationAreaSessionTest.class.getName());
        OSGiTestsActivator.addRequiredOSGiTestsBundles(sessionLock);
        try {
            sessionLock.getSetup().setSystemProperty(TEST_LOCATION_DIR, testLocationLockDir);
        }
        catch (SetupManager.SetupException e) {
            e.printStackTrace();
        }
        sessionLock.addTest((Test)new LocationAreaSessionTest("testSessionSuccessLockJavaNIO"));
        suite.addTest((Test)sessionLock);
        suite.addTest((Test)new TestCase("testLockJavaIO"){

            public void runBare() throws Throwable {
                if (!"win32".equals(System.getProperty("osgi.os"))) {
                    return;
                }
                LocationAreaSessionTest.doLock(testLocationLockDir, LocationAreaSessionTest.JAVA_IO, false, true);
            }
        });
        sessionLock = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", LocationAreaSessionTest.class.getName());
        OSGiTestsActivator.addRequiredOSGiTestsBundles(sessionLock);
        try {
            sessionLock.getSetup().setSystemProperty(TEST_LOCATION_DIR, testLocationLockDir);
        }
        catch (SetupManager.SetupException e) {
            e.printStackTrace();
        }
        sessionLock.addTest((Test)new LocationAreaSessionTest("testSessionFailLockJavaIO"));
        suite.addTest((Test)sessionLock);
        suite.addTest((Test)new TestCase("testReleaseJavaIO"){

            public void runBare() throws Throwable {
                if (!"win32".equals(System.getProperty("osgi.os"))) {
                    return;
                }
                LocationAreaSessionTest.doRelease();
            }
        });
        sessionLock = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", LocationAreaSessionTest.class.getName());
        OSGiTestsActivator.addRequiredOSGiTestsBundles(sessionLock);
        try {
            sessionLock.getSetup().setSystemProperty(TEST_LOCATION_DIR, testLocationLockDir);
        }
        catch (SetupManager.SetupException e) {
            e.printStackTrace();
        }
        sessionLock.addTest((Test)new LocationAreaSessionTest("testSessionSuccessLockJavaIO"));
        suite.addTest((Test)sessionLock);
        return suite;
    }

    public LocationAreaSessionTest(String name) {
        super(name);
    }

    static void doLock(String testLocationDir, String type, boolean release, boolean succeed) throws InvalidSyntaxException, IOException {
        String oldLockingValue = System.setProperty("osgi.locking", type);
        try {
            LocationAreaSessionTest.doLock(testLocationDir, release, succeed);
        }
        finally {
            if (oldLockingValue == null) {
                System.getProperties().remove("osgi.locking");
            } else {
                System.setProperty("osgi.locking", oldLockingValue);
            }
        }
    }

    static void doLock(String testLocationDir, boolean release, boolean succeed) throws InvalidSyntaxException, IOException {
        LocationAreaSessionTest.assertNotNull((String)"The testLocationDir is not set", (Object)testLocationDir);
        ServiceReference[] refs = OSGiTestsActivator.getContext().getServiceReferences(Location.class.getName(), "(type=osgi.configuration.area)");
        Location configLocation = (Location)OSGiTestsActivator.getContext().getService(refs[0]);
        Location testLocation = null;
        try {
            testLocation = configLocation.createLocation(null, new File(testLocationDir).toURL(), false);
            testLocation.setURL(testLocation.getDefault(), false);
            if (succeed ? testLocation.isLocked() : !testLocation.isLocked()) {
                LocationAreaSessionTest.fail((String)("location should " + (succeed ? "not " : "") + "be locked"));
            }
            if (succeed ? !testLocation.lock() : testLocation.lock()) {
                LocationAreaSessionTest.fail((String)((succeed ? "Could not" : "Could") + " lock location"));
            }
            if (!testLocation.isLocked()) {
                LocationAreaSessionTest.fail((String)"location should be locked");
            }
        }
        finally {
            if (release && testLocation != null) {
                testLocation.release();
            }
            if (!release) {
                lockedTestLocation = testLocation;
            }
            OSGiTestsActivator.getContext().ungetService(refs[0]);
        }
    }

    static void doRelease() throws IOException {
        try {
            if (lockedTestLocation == null) {
                LocationAreaSessionTest.fail((String)"lockedTestLocation == null !!");
            }
            if (!lockedTestLocation.isLocked()) {
                LocationAreaSessionTest.fail((String)"lockedTestLocation is not locked!!");
            }
            lockedTestLocation.release();
            if (lockedTestLocation.isLocked()) {
                LocationAreaSessionTest.fail((String)"lockedTestLocation is still locked!!");
            }
        }
        finally {
            lockedTestLocation = null;
        }
    }

    public void testSessionFailLockJavaNIO() throws Exception {
        LocationAreaSessionTest.doLock(System.getProperty(TEST_LOCATION_DIR), JAVA_NIO, true, false);
    }

    public void testSessionSuccessLockJavaNIO() throws Exception {
        LocationAreaSessionTest.doLock(System.getProperty(TEST_LOCATION_DIR), JAVA_NIO, true, true);
    }

    public void testSessionFailLockJavaIO() throws Exception {
        if (!"win32".equals(System.getProperty("osgi.os"))) {
            return;
        }
        LocationAreaSessionTest.doLock(System.getProperty(TEST_LOCATION_DIR), JAVA_IO, true, false);
    }

    public void testSessionSuccessLockJavaIO() throws Exception {
        if (!"win32".equals(System.getProperty("osgi.os"))) {
            return;
        }
        LocationAreaSessionTest.doLock(System.getProperty(TEST_LOCATION_DIR), JAVA_IO, true, true);
    }
}

