/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.datalocation;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.storagemanager.ManagedOutputStream;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StreamManagerTests {
    @Rule
    public TestName testName = new TestName();
    StorageManager manager1;
    StorageManager manager2;
    File base;
    String reliableFile;

    @Before
    public void setUp() throws Exception {
        this.base = new File(Platform.getConfigurationLocation().getURL().getPath(), "StreamManagerTests");
        this.manager1 = null;
        this.manager2 = null;
        this.reliableFile = System.getProperty("osgi.useReliableFiles");
    }

    @After
    public void tearDown() throws Exception {
        if (this.manager1 != null) {
            this.manager1.close();
        }
        if (this.manager2 != null) {
            this.manager2.close();
        }
        this.rm(this.base);
        if (this.reliableFile == null) {
            System.getProperties().remove("osgi.useReliableFiles");
        } else {
            System.setProperty("osgi.useReliableFiles", this.reliableFile);
        }
    }

    private void rm(File folder) {
        File[] files;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.rm(file);
                ++n2;
            }
        }
        folder.delete();
    }

    private String getInputStreamContents(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        byte[] data = new byte[64];
        try {
            int len;
            while ((len = is.read(data)) != -1) {
                sb.append(new String(data, 0, len));
            }
        }
        finally {
            is.close();
        }
        return sb.toString();
    }

    void writeToFile(File file, String str) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(str.getBytes());
            fos.flush();
            fos.getFD().sync();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testReliableFile() throws Exception {
        String fileName = "testReliableFile.txt";
        File file1 = new File(this.base, fileName + ".1");
        File file2 = new File(this.base, fileName + ".2");
        File file3 = new File(this.base, fileName + ".3");
        String contents1 = "test reliable file cOntents #1";
        String contents2 = "test reliable file cOntents #2";
        try {
            System.setProperty("osgi.useReliableFiles", "true");
            this.manager1 = new StorageManager(this.base, null);
            this.manager1.open(true);
            ManagedOutputStream fmos = this.manager1.getOutputStream(fileName);
            Assert.assertNotNull((Object)fmos);
            fmos.write(contents1.getBytes());
            fmos.close();
            fmos = this.manager1.getOutputStream(fileName);
            Assert.assertNotNull((Object)fmos);
            fmos.write(contents2.getBytes());
            fmos.close();
            Assert.assertTrue((boolean)file1.exists());
            Assert.assertTrue((boolean)file2.exists());
            Assert.assertTrue((!file3.exists() ? 1 : 0) != 0);
            this.manager1.close();
            this.manager1 = null;
            System.setProperty("osgi.useReliableFiles", "true");
            this.manager2 = new StorageManager(this.base, null);
            this.manager2.open(true);
            InputStream is = this.manager2.getInputStream(fileName);
            Assert.assertNotNull((Object)is);
            Assert.assertEquals((Object)contents2, (Object)this.getInputStreamContents(is));
            this.manager2.close();
            this.manager2 = null;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            RandomAccessFile raf = new RandomAccessFile(file2, "rw");
            raf.seek(20L);
            raf.write(48);
            raf.close();
            System.setProperty("osgi.useReliableFiles", "true");
            this.manager1 = new StorageManager(this.base, null);
            this.manager1.open(true);
            is = this.manager1.getInputStream(fileName);
            Assert.assertNotNull((Object)is);
            Assert.assertEquals((Object)contents1, (Object)this.getInputStreamContents(is));
            try {
                InputStream[] isSet;
                InputStream[] inputStreamArray = isSet = this.manager1.getInputStreamSet(new String[]{fileName});
                int n = isSet.length;
                int n2 = 0;
                while (n2 < n) {
                    InputStream set = inputStreamArray[n2];
                    if (set != null) {
                        set.close();
                    }
                    ++n2;
                }
                Assert.fail((String)"getInputStreamSet was successful");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            raf = new RandomAccessFile(file1, "rw");
            raf.seek(20L);
            raf.write(48);
            raf.close();
            try {
                is = this.manager1.getInputStream(fileName);
                Assert.fail((String)"get input stream succedded");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.manager1.close();
            this.manager1 = null;
        }
        finally {
            System.setProperty("osgi.useReliableFiles", "false");
        }
    }

    @Test
    public void testBigReliableFile() throws IOException {
        int i;
        Object var6_12;
        Throwable throwable;
        String fileName = this.testName.getMethodName() + ".txt";
        System.setProperty("osgi.useReliableFiles", "true");
        this.manager1 = new StorageManager(this.base, null);
        this.manager1.open(true);
        Throwable throwable2 = null;
        Object var3_5 = null;
        try (ManagedOutputStream fmos = this.manager1.getOutputStream(fileName);){
            Assert.assertNotNull((Object)fmos);
            throwable = null;
            var6_12 = null;
            try (DataOutputStream bufferedOut = new DataOutputStream(new BufferedOutputStream((OutputStream)fmos));){
                i = 0;
                while (i < 51200) {
                    bufferedOut.writeInt(i);
                    ++i;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        this.manager1.close();
        this.manager1 = null;
        System.setProperty("osgi.useReliableFiles", "true");
        this.manager2 = new StorageManager(this.base, null);
        this.manager2.open(true);
        throwable2 = null;
        var3_5 = null;
        try (InputStream is = this.manager2.getInputStream(fileName);){
            Assert.assertNotNull((Object)is);
            throwable = null;
            var6_12 = null;
            try (DataInputStream bufferedIn = new DataInputStream(new BufferedInputStream(is));){
                i = 0;
                while (i < 51200) {
                    Assert.assertEquals((String)"Wrong content found", (long)i, (long)bufferedIn.readInt());
                    ++i;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable6) {
            if (throwable2 == null) {
                throwable2 = throwable6;
            } else if (throwable2 != throwable6) {
                throwable2.addSuppressed(throwable6);
            }
            throw throwable2;
        }
        this.manager2.close();
        this.manager2 = null;
    }

    @Test
    public void testMigration() throws IOException {
        File testDir = new File(this.base, "testMigrationManager");
        File managerDir = new File(testDir, ".manager");
        String fileName = "testMigration.txt";
        File file2 = new File(testDir, fileName + ".2");
        File file5 = new File(testDir, fileName + ".5");
        File fileTable = new File(managerDir, ".fileTable");
        File fileTable1 = new File(managerDir, ".fileTable.1");
        File fileTable2 = new File(managerDir, ".fileTable.2");
        File fileTable3 = new File(managerDir, ".fileTable.3");
        String contents1 = "test reliable file contents #1";
        String contents2 = "test reliable file contents #2";
        String contents3 = "test reliable file contents #3";
        managerDir.mkdirs();
        this.writeToFile(fileTable, "#safe table\n" + fileName + "=2\n");
        this.writeToFile(file2, contents1);
        this.manager1 = new StorageManager(testDir, null);
        this.manager1.open(true);
        File test = this.manager1.lookup(fileName, false);
        Assert.assertNotNull((Object)test);
        Assert.assertTrue((boolean)test.exists());
        File testFile = this.manager1.createTempFile(fileName);
        this.writeToFile(testFile, contents2);
        this.manager1.update(new String[]{fileName}, new String[]{testFile.getName()});
        testFile = this.manager1.createTempFile(fileName);
        this.writeToFile(testFile, contents3);
        this.manager1.update(new String[]{fileName}, new String[]{testFile.getName()});
        testFile = this.manager1.createTempFile(fileName);
        this.writeToFile(testFile, contents1);
        this.manager1.update(new String[]{fileName}, new String[]{testFile.getName()});
        this.manager1.close();
        this.manager1 = null;
        String[] files = managerDir.list();
        Assert.assertEquals((long)4L, (long)files.length);
        Assert.assertTrue((boolean)fileTable.exists());
        Assert.assertFalse((boolean)fileTable1.exists());
        Assert.assertTrue((boolean)fileTable2.exists());
        Assert.assertTrue((boolean)fileTable3.exists());
        files = testDir.list();
        Assert.assertEquals((long)2L, (long)files.length);
        Assert.assertTrue((boolean)file5.exists());
        this.manager2 = new StorageManager(testDir, null);
        this.manager2.open(true);
        testFile = this.manager2.lookup(fileName, false);
        Assert.assertNotNull((Object)testFile);
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((boolean)testFile.getName().endsWith(".5"));
        this.manager2.close();
        this.manager2 = null;
    }

    @Test
    public void testAbort() throws IOException {
        this.testAbort(true);
        this.testAbort(false);
    }

    private void testAbort(boolean reliable) throws IOException {
        String fileName = reliable ? "abortFileReliable.txt" : "abortFileStd.txt";
        File file1 = new File(this.base, fileName + ".1");
        File file2 = new File(this.base, fileName + ".2");
        File file3 = new File(this.base, fileName + ".3");
        String contents1 = "test reliable file contents #1";
        String contents2 = "test reliable file contents #2";
        System.setProperty("osgi.useReliableFiles", "true");
        this.manager1 = new StorageManager(this.base, null);
        this.manager1.open(true);
        ManagedOutputStream smos = this.manager1.getOutputStream(fileName);
        smos.write(contents1.getBytes());
        smos.close();
        smos = this.manager1.getOutputStream(fileName);
        smos.write(contents2.getBytes());
        smos.abort();
        smos.close();
        Assert.assertEquals((long)1L, (long)this.manager1.getId(fileName));
        InputStream is = this.manager1.getInputStream(fileName);
        Assert.assertNotNull((Object)is);
        Assert.assertEquals((Object)contents1, (Object)this.getInputStreamContents(is));
        this.manager1.close();
        this.manager1 = null;
        System.setProperty("osgi.useReliableFiles", "true");
        this.manager2 = new StorageManager(this.base, null);
        this.manager2.open(true);
        Assert.assertEquals((long)1L, (long)this.manager2.getId(fileName));
        is = this.manager2.getInputStream(fileName);
        Assert.assertNotNull((Object)is);
        Assert.assertEquals((Object)contents1, (Object)this.getInputStreamContents(is));
        this.manager2.close();
        this.manager2 = null;
        Assert.assertTrue((boolean)file1.exists());
        Assert.assertFalse((boolean)file2.exists());
        Assert.assertFalse((boolean)file3.exists());
    }

    @Test
    public void testGetOutputStreamSet() throws IOException {
        this.testGetOutputStreamSet(true);
        this.testGetOutputStreamSet(false);
    }

    private void testGetOutputStreamSet(boolean reliable) throws IOException {
        File mgrDir = reliable ? new File(this.base, "getSetReliable") : new File(this.base, "getSetStd");
        String fileName1 = "testSet1.txt";
        String fileName2 = "testSet2.txt";
        File file1_1 = new File(mgrDir, fileName1 + ".1");
        File file1_2 = new File(mgrDir, fileName1 + ".2");
        File file2_1 = new File(mgrDir, fileName2 + ".1");
        File file2_2 = new File(mgrDir, fileName2 + ".2");
        String contents1 = "test reliable file contents #1";
        String contents2 = "test reliable file contents #2";
        System.setProperty("osgi.useReliableFiles", reliable ? "true" : "false");
        this.manager1 = new StorageManager(mgrDir, null);
        this.manager1.open(true);
        ManagedOutputStream[] outs = this.manager1.getOutputStreamSet(new String[]{fileName1, fileName2});
        Assert.assertNotNull((Object)outs);
        Assert.assertEquals((long)2L, (long)outs.length);
        outs[0].write(contents1.getBytes());
        outs[1].write(contents2.getBytes());
        outs[1].close();
        Assert.assertFalse((boolean)file1_1.exists());
        Assert.assertFalse((boolean)file2_1.exists());
        outs[0].close();
        Assert.assertTrue((boolean)file1_1.exists());
        Assert.assertTrue((boolean)file2_1.exists());
        outs = this.manager1.getOutputStreamSet(new String[]{fileName1, fileName2});
        Assert.assertNotNull((Object)outs);
        outs[0].write("new data #1".getBytes());
        outs[1].write("new data #2".getBytes());
        outs[0].close();
        Assert.assertFalse((boolean)file1_2.exists());
        Assert.assertFalse((boolean)file2_2.exists());
        outs[1].close();
        Assert.assertTrue((boolean)file1_2.exists());
        Assert.assertTrue((boolean)file2_2.exists());
        this.manager1.close();
        this.manager1 = null;
        if (reliable) {
            Assert.assertTrue((boolean)file1_1.exists());
            Assert.assertTrue((boolean)file2_1.exists());
        } else {
            Assert.assertFalse((boolean)file1_1.exists());
            Assert.assertFalse((boolean)file2_1.exists());
        }
    }

    @Test
    public void testAbortStreamSet() throws IOException {
        this.testAbortSet(true);
        this.testAbortSet(false);
    }

    private void testAbortSet(boolean reliable) throws IOException {
        File mgrDir = reliable ? new File(this.base, "abortSetReliable") : new File(this.base, "abortSetStd");
        String fileName1 = "test1.txt";
        String fileName2 = "test2.txt";
        String fileName3 = "test3.txt";
        String fileName4 = "test4.txt";
        String contents1 = "test reliable file contents #1";
        String contents2 = "test reliable file contents #2";
        mgrDir.mkdirs();
        String[] list = mgrDir.list();
        Assert.assertEquals((long)0L, (long)list.length);
        System.setProperty("osgi.useReliableFiles", reliable ? "true" : "false");
        this.manager1 = new StorageManager(mgrDir, null);
        this.manager1.open(true);
        ManagedOutputStream[] outs = this.manager1.getOutputStreamSet(new String[]{fileName1, fileName2, fileName3, fileName4});
        Assert.assertNotNull((Object)outs);
        outs[0].write(contents1.getBytes());
        outs[1].write(contents2.getBytes());
        outs[2].write(contents2.getBytes());
        outs[3].write(contents1.getBytes());
        list = mgrDir.list();
        Assert.assertEquals((long)5L, (long)list.length);
        outs[2].close();
        outs[1].abort();
        outs[0].close();
        outs[3].close();
        outs[2].close();
        outs[1].close();
        list = mgrDir.list();
        Assert.assertEquals((long)1L, (long)list.length);
        Assert.assertNull((Object)this.manager1.lookup(fileName1, false));
        Assert.assertNull((Object)this.manager1.lookup(fileName2, false));
        Assert.assertNull((Object)this.manager1.lookup(fileName3, false));
        Assert.assertNull((Object)this.manager1.lookup(fileName4, false));
        this.manager1.close();
        this.manager1 = null;
        System.setProperty("osgi.useReliableFiles", reliable ? "true" : "false");
        this.manager2 = new StorageManager(mgrDir, null);
        this.manager2.open(true);
        Assert.assertNull((Object)this.manager2.lookup(fileName1, false));
        Assert.assertNull((Object)this.manager2.lookup(fileName2, false));
        Assert.assertNull((Object)this.manager2.lookup(fileName3, false));
        Assert.assertNull((Object)this.manager2.lookup(fileName4, false));
        list = mgrDir.list();
        Assert.assertEquals((long)1L, (long)list.length);
        this.manager2.close();
        this.manager2 = null;
    }
}

