/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public abstract class AbstractStateTest {
    private ServiceReference platformAdminRef;
    protected PlatformAdmin platformAdminService;

    @Before
    public void setUp() throws Exception {
        this.platformAdminRef = OSGiTestsActivator.getContext().getServiceReference(PlatformAdmin.class);
        this.platformAdminService = (PlatformAdmin)OSGiTestsActivator.getContext().getService(this.platformAdminRef);
    }

    @After
    public void tearDown() throws Exception {
        OSGiTestsActivator.getContext().ungetService(this.platformAdminRef);
    }

    public void assertContains(String tag, Object[] array, Object element) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o == element) {
                return;
            }
            ++n2;
        }
        Assert.fail((String)tag);
    }

    public void assertEquals(Object expected, Object actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(String message, Object expected, Object actual) {
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertEquals(State original, State copy) {
        this.assertEquals("", original, copy);
    }

    public void assertEquals(String tag, BundleDescription original, BundleDescription copy) {
        if (original == copy) {
            return;
        }
        this.assertEquals(tag + ".0", original.getBundleId(), copy.getBundleId());
        this.assertEquals(tag + ".1", original.getSymbolicName(), copy.getSymbolicName());
        this.assertEquals(tag + ".2", original.getVersion(), copy.getVersion());
        this.assertEquals(tag + ".3", original.getLocation(), copy.getLocation());
        this.assertEquals(tag + ".4", original.isResolved(), copy.isResolved());
        this.assertEquals(tag + ".5", original.getHost(), copy.getHost());
        ExportPackageDescription[] originalExportPackages = original.getExportPackages();
        ExportPackageDescription[] copyExportPackages = copy.getExportPackages();
        this.assertEquals(tag + ".6", originalExportPackages.length, copyExportPackages.length);
        int i = 0;
        while (i < originalExportPackages.length) {
            this.assertEquals(tag + ".7." + i, originalExportPackages[i], copyExportPackages[i]);
            ++i;
        }
        ImportPackageSpecification[] originalImportPackages = original.getImportPackages();
        ImportPackageSpecification[] copyImportPackages = copy.getImportPackages();
        this.assertEquals(tag + ".8", originalImportPackages.length, copyImportPackages.length);
        int i2 = 0;
        while (i2 < originalImportPackages.length) {
            this.assertEquals(tag + ".9." + i2, originalImportPackages[i2], copyImportPackages[i2]);
            ++i2;
        }
        BundleSpecification[] originalRequiredBundles = original.getRequiredBundles();
        BundleSpecification[] copyRequiredBundles = copy.getRequiredBundles();
        this.assertEquals(tag + ".10", originalRequiredBundles.length, copyRequiredBundles.length);
        int i3 = 0;
        while (i3 < originalRequiredBundles.length) {
            this.assertEquals(tag + ".11." + i3, originalRequiredBundles[i3], copyRequiredBundles[i3]);
            ++i3;
        }
        ExportPackageDescription[] originalResolvedImports = original.getResolvedImports();
        ExportPackageDescription[] copyResolvedImports = copy.getResolvedImports();
        this.assertEquals(tag + ".12", originalResolvedImports.length, copyResolvedImports.length);
        int i4 = 0;
        while (i4 < originalResolvedImports.length) {
            this.assertEquals(tag + ".13." + i4, originalResolvedImports[i4], copyResolvedImports[i4]);
            ++i4;
        }
        BundleDescription[] originalResolvedRequires = original.getResolvedRequires();
        BundleDescription[] copyResolvedRequires = copy.getResolvedRequires();
        this.assertEquals(tag + ".14", originalResolvedRequires.length, copyResolvedRequires.length);
        int i5 = 0;
        while (i5 < originalResolvedRequires.length) {
            this.assertEquals(tag + ".15." + i5, originalResolvedRequires[i5], copyResolvedRequires[i5]);
            ++i5;
        }
    }

    public void assertEquals(String tag, ExportPackageDescription original, ExportPackageDescription copy) {
        this.assertEquals(tag + ".0", original.getName(), copy.getName());
        this.assertEquals(tag + ".1", original.getVersion(), copy.getVersion());
        this.assertEquals(tag + ".2", original.getAttributes(), copy.getAttributes());
        this.assertEquals(tag + ".3", original.getDirectives(), original.getDirectives());
    }

    public void assertEquals(String tag, State original, State copy) {
        BundleDescription[] originalBundles = original.getBundles();
        BundleDescription[] copyBundles = copy.getBundles();
        this.assertEquals(tag + ".1", originalBundles.length, copyBundles.length);
        int i = 0;
        while (i < originalBundles.length) {
            this.assertEquals(tag + ".2." + i, originalBundles[i], copyBundles[i]);
            ++i;
        }
        this.assertEquals(tag + ".3", original.isResolved(), copy.isResolved());
        BundleDescription[] originalResolvedBundles = original.getResolvedBundles();
        BundleDescription[] copyResolvedBundles = copy.getResolvedBundles();
        this.assertEquals(tag + ".4", originalResolvedBundles.length, copyResolvedBundles.length);
        int i2 = 0;
        while (i2 < originalResolvedBundles.length) {
            this.assertEquals(tag + ".5." + i2, originalResolvedBundles[i2], copyResolvedBundles[i2]);
            ++i2;
        }
    }

    private void assertVersionConstraintEquals(String tag, VersionConstraint original, VersionConstraint copy) {
        this.assertEquals(tag + ".0", original == null, copy == null);
        if (original == null) {
            return;
        }
        this.assertEquals(tag + ".1", original.getName(), copy.getName());
        this.assertEquals(tag + ".2", original.getVersionRange(), copy.getVersionRange());
        this.assertEquals(tag + ".4", original.getSupplier() == null, copy.getSupplier() == null);
        if (original.getSupplier() != null) {
            BaseDescription o = original.getSupplier();
            if (o instanceof BundleDescription) {
                this.assertEquals(tag + ".5", (BundleDescription)original.getSupplier(), (BundleDescription)copy.getSupplier());
            } else {
                this.assertEquals(tag + ".5", (ExportPackageDescription)original.getSupplier(), (ExportPackageDescription)copy.getSupplier());
            }
        }
    }

    public void assertEquals(String tag, BundleSpecification original, BundleSpecification copy) {
        this.assertVersionConstraintEquals(tag + ".0", (VersionConstraint)original, (VersionConstraint)copy);
        if (original == null) {
            return;
        }
        this.assertEquals(tag + ".1", original.isExported(), copy.isExported());
        this.assertEquals(tag + ".2", original.isOptional(), copy.isOptional());
    }

    public void assertEquals(String tag, ImportPackageSpecification original, ImportPackageSpecification copy) {
        this.assertVersionConstraintEquals(tag + ".0", (VersionConstraint)original, (VersionConstraint)copy);
        if (original == null) {
            return;
        }
        this.assertEquals(tag + ".1", original.getAttributes(), copy.getAttributes());
        this.assertEquals(tag + ".2", original.getBundleSymbolicName(), copy.getBundleSymbolicName());
        this.assertEquals(tag + ".3", original.getBundleVersionRange(), copy.getBundleVersionRange());
        this.assertEquals(tag + ".5", original.getDirectives(), original.getDirectives());
    }

    public void assertEquals(String tag, HostSpecification original, HostSpecification copy) {
        this.assertVersionConstraintEquals(tag + ".0", (VersionConstraint)original, (VersionConstraint)copy);
        if (original == null) {
            return;
        }
        BundleDescription[] originalHosts = original.getHosts();
        BundleDescription[] copyHosts = copy.getHosts();
        this.assertEquals(tag + ".1", originalHosts == null, copyHosts == null);
        if (originalHosts == null) {
            return;
        }
        this.assertEquals(tag + ".2", originalHosts.length, copyHosts.length);
        int i = 0;
        while (i < originalHosts.length) {
            this.assertEquals(tag + ".3." + i, originalHosts[i], copyHosts[i]);
            ++i;
        }
    }

    public void assertFullyResolved(String tag, BundleDescription bundle) {
        Assert.assertTrue((String)(tag + "a"), (boolean)bundle.isResolved());
        ImportPackageSpecification[] packages = bundle.getImportPackages();
        int i = 0;
        while (i < packages.length) {
            Assert.assertNotNull((String)(tag + "b_" + i), (Object)packages[i].getSupplier());
            ++i;
        }
        HostSpecification host = bundle.getHost();
        if (host != null) {
            Assert.assertNotNull((String)(tag + "c"), (Object)host.getHosts());
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        int i2 = 0;
        while (i2 < requiredBundles.length) {
            Assert.assertNotNull((String)(tag + "d_" + i2), (Object)requiredBundles[i2].getSupplier());
            ++i2;
        }
    }

    public void assertFullyUnresolved(String tag, BundleDescription bundle) {
        Assert.assertFalse((String)(tag + "a"), (boolean)bundle.isResolved());
        ImportPackageSpecification[] packages = bundle.getImportPackages();
        int i = 0;
        while (i < packages.length) {
            Assert.assertNull((String)(tag + "b_" + i), (Object)packages[i].getSupplier());
            ++i;
        }
        HostSpecification host = bundle.getHost();
        if (host != null) {
            Assert.assertNull((String)(tag + "c"), (Object)host.getHosts());
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        int i2 = 0;
        while (i2 < requiredBundles.length) {
            Assert.assertNull((String)(tag + "d_" + i2), (Object)requiredBundles[i2].getSupplier());
            ++i2;
        }
    }

    public void assertIdentical(String tag, State original, State copy) {
        this.assertEquals(tag + ".0a", original.isResolved(), copy.isResolved());
        this.assertEquals(tag + ".0b", original.getTimeStamp(), copy.getTimeStamp());
        this.assertEquals(tag, original, copy);
    }

    public State buildComplexState() throws BundleException {
        State state = this.buildEmptyState();
        String B1_LOCATION = "org.eclipse.b1";
        String B1_MANIFEST = "Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 1.0\nExport-Package: org.eclipse.p1;specification-version=1.0\nImport-Package: org.eclipse.p2";
        BundleDescription b1 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 1.0\nExport-Package: org.eclipse.p1;specification-version=1.0\nImport-Package: org.eclipse.p2"), "org.eclipse.b1", 1L);
        state.addBundle(b1);
        String B2_LOCATION = "org.eclipse.b2";
        String B2_MANIFEST = "Bundle-SymbolicName: org.eclipse.b2\nBundle-Version: 2.0\nExport-Package: org.eclipse.p2\nImport-Package: org.eclipse.p1";
        BundleDescription b2 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b2\nBundle-Version: 2.0\nExport-Package: org.eclipse.p2\nImport-Package: org.eclipse.p1"), "org.eclipse.b2", 2L);
        state.addBundle(b2);
        String B3_LOCATION = "org.eclipse.b3";
        String B3_MANIFEST = "Bundle-SymbolicName: org.eclipse.b3\nBundle-Version: 2.0\nExport-Package: org.eclipse.p2; specification-version=2.0";
        BundleDescription b3 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b3\nBundle-Version: 2.0\nExport-Package: org.eclipse.p2; specification-version=2.0"), "org.eclipse.b3", 3L);
        state.addBundle(b3);
        String B4_LOCATION = "org.eclipse.b4";
        String B4_MANIFEST = "Bundle-SymbolicName: org.eclipse.b4\nBundle-Version: 2.0\nRequire-Bundle: org.eclipse.b1";
        BundleDescription b4 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b4\nBundle-Version: 2.0\nRequire-Bundle: org.eclipse.b1"), "org.eclipse.b4", 4L);
        state.addBundle(b4);
        String B5_LOCATION = "org.eclipse.b5";
        String B5_MANIFEST = "Bundle-SymbolicName: org.eclipse.b5\nBundle-Version: 1.0\nFragment-Host: org.eclipse.b3";
        BundleDescription b5 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b5\nBundle-Version: 1.0\nFragment-Host: org.eclipse.b3"), "org.eclipse.b5", 5L);
        state.addBundle(b5);
        String B6_LOCATION = "org.eclipse.b6";
        String B6_MANIFEST = "Bundle-SymbolicName: org.eclipse.b6\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.b4";
        BundleDescription b6 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b6\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.b4"), "org.eclipse.b6", 6L);
        state.addBundle(b6);
        return state;
    }

    public State buildEmptyState() {
        return StateObjectFactory.defaultFactory.createState(true);
    }

    public State buildInitialState() throws BundleException {
        State state = this.buildEmptyState();
        String SYSTEM_BUNDLE_LOCATION = "org.eclipse.b1";
        String SYSTEM_BUNDLE_MANIFEST = "Bundle-SymbolicName: org.osgi.framework\nBundle-Version: 3.0\nExport-Package: org.osgi.framework; specification-version=3.0";
        BundleDescription b0 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.osgi.framework\nBundle-Version: 3.0\nExport-Package: org.osgi.framework; specification-version=3.0"), "org.eclipse.b1", 0L);
        state.addBundle(b0);
        return state;
    }

    public State buildSimpleState() throws BundleException {
        State state = this.buildEmptyState();
        String B1_LOCATION = "org.eclipse.b1";
        String B1_MANIFEST = "Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 1.0\nExport-Package: org.eclipse.p1;specification-version=1.0\nImport-Package: org.eclipse.p2";
        BundleDescription b1 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 1.0\nExport-Package: org.eclipse.p1;specification-version=1.0\nImport-Package: org.eclipse.p2"), "org.eclipse.b1", 1L);
        state.addBundle(b1);
        String B2_LOCATION = "org.eclipse.b2";
        String B2_MANIFEST = "Bundle-SymbolicName: org.eclipse.b2\nBundle-Version: 2.0\nExport-Package: org.eclipse.p2\nImport-Package: org.eclipse.p1";
        BundleDescription b2 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b2\nBundle-Version: 2.0\nExport-Package: org.eclipse.p2\nImport-Package: org.eclipse.p1"), "org.eclipse.b2", 2L);
        state.addBundle(b2);
        String B3_LOCATION = "org.eclipse.b3";
        String B3_MANIFEST = "Bundle-SymbolicName: org.eclipse.b3\nBundle-Version: 2.0\nImport-Package: org.eclipse.p1; specification-version=2.0";
        BundleDescription b3 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b3\nBundle-Version: 2.0\nImport-Package: org.eclipse.p1; specification-version=2.0"), "org.eclipse.b3", 3L);
        state.addBundle(b3);
        return state;
    }

    public static Dictionary parseManifest(String manifest) {
        Hashtable<String, String> entries = new Hashtable<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(manifest, ":\n");
        while (tokenizer.hasMoreTokens()) {
            String key = tokenizer.nextToken();
            String value = tokenizer.hasMoreTokens() ? tokenizer.nextToken().trim() : "";
            ((Dictionary)entries).put(key, value);
        }
        return entries;
    }
}

