/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class DevModeTest
extends AbstractStateTest {
    private State buildDevModeState() {
        State state = this.buildEmptyState();
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("osgi.resolverMode", "development");
        state.setPlatformProperties(props);
        return state;
    }

    @Test
    public void testDevModeDomino02() throws BundleException {
        State state = this.buildDevModeState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "a");
        manifest.put("Import-Package", "x, d");
        manifest.put("Require-Bundle", "X, E");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "d");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "e");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.resolve();
        Assert.assertFalse((String)"0.1", (boolean)a.isResolved());
        Assert.assertTrue((String)"0.3", (boolean)b.isResolved());
        Assert.assertTrue((String)"0.4", (boolean)c.isResolved());
        Assert.assertTrue((String)"0.5", (boolean)d.isResolved());
        Assert.assertTrue((String)"0.5", (boolean)e.isResolved());
        BundleDescription[] aRequired = a.getResolvedRequires();
        Assert.assertTrue((String)"1.1", (aRequired.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.2", (aRequired[0] == e ? 1 : 0) != 0);
        ExportPackageDescription[] aImported = a.getResolvedImports();
        Assert.assertTrue((String)"1.3", (aImported.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.4", (aImported[0].getExporter() == d ? 1 : 0) != 0);
        BundleDescription[] bRequired = b.getResolvedRequires();
        Assert.assertTrue((String)"2.1", (bRequired.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (bRequired[0] == a ? 1 : 0) != 0);
        BundleDescription[] cRequired = c.getResolvedRequires();
        Assert.assertTrue((String)"3.1", (cRequired.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.2", (cRequired[0] == a ? 1 : 0) != 0);
    }

    @Test
    public void testDevModeDomino01() throws BundleException {
        State state = this.buildDevModeState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "a");
        manifest.put("Import-Package", "x");
        manifest.put("Require-Bundle", "X");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.resolve();
        Assert.assertFalse((String)"0.1", (boolean)a.isResolved());
        Assert.assertTrue((String)"0.3", (boolean)b.isResolved());
        Assert.assertTrue((String)"0.4", (boolean)c.isResolved());
        BundleDescription[] bRequired = b.getResolvedRequires();
        Assert.assertTrue((String)"1.1", (bRequired.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.2", (bRequired[0] == a ? 1 : 0) != 0);
        BundleDescription[] cRequired = c.getResolvedRequires();
        Assert.assertTrue((String)"2.1", (cRequired.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (cRequired[0] == a ? 1 : 0) != 0);
    }

    @Test
    public void testDevModeFragment01() throws BundleException {
        State state = this.buildDevModeState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "a");
        manifest.put("Import-Package", "c");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "AFrag");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "A");
        manifest.put("Export-Package", "a.frag");
        BundleDescription aFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "a, a.frag");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "c");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(a);
        state.addBundle(aFrag);
        state.addBundle(b);
        state.resolve();
        Assert.assertFalse((String)"0.1", (boolean)a.isResolved());
        Assert.assertTrue((String)"0.2", (boolean)aFrag.isResolved());
        Assert.assertTrue((String)"0.3", (boolean)b.isResolved());
        ExportPackageDescription[] aExports = a.getSelectedExports();
        ExportPackageDescription[] bImports = b.getResolvedImports();
        Assert.assertTrue((String)"1.1", (aExports.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.2", (bImports.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.3", (aExports[0] == bImports[0] ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.4", (aExports[1] == bImports[1] ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.5", (aFrag.getHost().getSupplier() == a ? 1 : 0) != 0);
        state.addBundle(c);
        state.resolve();
        Assert.assertTrue((String)"2.1", (boolean)a.isResolved());
        Assert.assertTrue((String)"2.2", (boolean)aFrag.isResolved());
        Assert.assertTrue((String)"2.3", (boolean)b.isResolved());
        Assert.assertTrue((String)"2.4", (boolean)c.isResolved());
        aExports = a.getSelectedExports();
        bImports = b.getResolvedImports();
        Assert.assertTrue((String)"3.1", (aExports.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.2", (bImports.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.3", (aExports[0] == bImports[0] ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.4", (aExports[1] == bImports[1] ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.5", (aFrag.getHost().getSupplier() == a ? 1 : 0) != 0);
    }

    @Test
    public void testDevModeSingleton01() throws BundleException {
        State state = this.buildDevModeState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "a");
        BundleDescription a1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Export-Package", "a");
        BundleDescription a2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "A; bundle-version=2.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "A; bundle-version=\"[1.0,2.0)\"");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(a1);
        state.addBundle(a2);
        state.addBundle(b);
        state.addBundle(c);
        state.resolve();
        Assert.assertTrue((String)"0.1", (boolean)a1.isResolved());
        Assert.assertTrue((String)"0.2", (boolean)a2.isResolved());
        Assert.assertTrue((String)"0.3", (boolean)b.isResolved());
        Assert.assertTrue((String)"0.4", (boolean)c.isResolved());
        BundleDescription[] bRequired = b.getResolvedRequires();
        Assert.assertTrue((String)"1.1", (bRequired.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.2", (bRequired[0] == a2 ? 1 : 0) != 0);
        BundleDescription[] cRequired = c.getResolvedRequires();
        Assert.assertTrue((String)"2.1", (cRequired.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (cRequired[0] == a1 ? 1 : 0) != 0);
    }

    @Test
    public void testDevModeSingleton02() throws BundleException {
        State state = this.buildDevModeState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "a");
        manifest.put("Import-Package", "x");
        BundleDescription a1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Export-Package", "a");
        BundleDescription a2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "A; bundle-version=2.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "A; bundle-version=\"[1.0,2.0)\"");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(a1);
        state.addBundle(a2);
        state.addBundle(b);
        state.addBundle(c);
        state.resolve();
        Assert.assertFalse((String)"0.1", (boolean)a1.isResolved());
        Assert.assertTrue((String)"0.2", (boolean)a2.isResolved());
        Assert.assertTrue((String)"0.3", (boolean)b.isResolved());
        Assert.assertTrue((String)"0.4", (boolean)c.isResolved());
        BundleDescription[] bRequired = b.getResolvedRequires();
        Assert.assertTrue((String)"1.1", (bRequired.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.2", (bRequired[0] == a2 ? 1 : 0) != 0);
        BundleDescription[] cRequired = c.getResolvedRequires();
        Assert.assertTrue((String)"2.1", (cRequired.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (cRequired[0] == a1 ? 1 : 0) != 0);
    }

    @Test
    public void testDevModeGenericCapability() throws BundleException {
        State state = this.buildDevModeState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Capability", "osgi.service; filter:=\"(objectClass=foo.Bar)\";\n  effective:=\"active\"");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(a);
        state.resolve();
        Assert.assertFalse((String)"0.1", (boolean)a.isResolved());
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Provide-Capability", "osgi.service; objectClass:List<String>=\"foo.Bar\"");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(b);
        state.resolve();
        Assert.assertTrue((String)"0.2", (boolean)a.isResolved());
    }
}

