/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.io.File;
import java.io.IOException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class DisabledInfoTest
extends AbstractStateTest {
    private final String B1_LOCATION = "b1";
    private final String B2_LOCATION = "b2";
    private final String B3_LOCATION = "b3";
    private final String POLICY = "test.policy";

    @Test
    public void testDisabledInfo01() throws BundleException {
        State state = this.buildTestState();
        BundleDescription b1 = state.getBundleByLocation("b1");
        BundleDescription b2 = state.getBundleByLocation("b2");
        BundleDescription b3 = state.getBundleByLocation("b3");
        DisabledInfo info1 = new DisabledInfo("test.policy", "message 1", b1);
        DisabledInfo info2 = new DisabledInfo("test.policy", "message 1", b2);
        DisabledInfo info3 = new DisabledInfo("test.policy", "message 1", b3);
        state.addDisabledInfo(info1);
        state.addDisabledInfo(info2);
        state.addDisabledInfo(info3);
        State copy = state.getFactory().createState(state);
        BundleDescription copyB1 = copy.getBundleByLocation("b1");
        BundleDescription copyB2 = copy.getBundleByLocation("b2");
        BundleDescription copyB3 = copy.getBundleByLocation("b3");
        DisabledInfo copyInfo1 = copy.getDisabledInfo(copyB1, "test.policy");
        DisabledInfo copyInfo2 = copy.getDisabledInfo(copyB2, "test.policy");
        DisabledInfo copyInfo3 = copy.getDisabledInfo(copyB3, "test.policy");
        Assert.assertNotNull((String)"copyInfo1", (Object)copyInfo1);
        Assert.assertNotNull((String)"copyInfo2", (Object)copyInfo2);
        Assert.assertNotNull((String)"copyInfo3", (Object)copyInfo3);
        Assert.assertTrue((String)"copyInfo1 bundle", (copyInfo1.getBundle() == copyB1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"copyInfo2 bundle", (copyInfo2.getBundle() == copyB2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"copyInfo3 bundle", (copyInfo3.getBundle() == copyB3 ? 1 : 0) != 0);
    }

    @Test
    public void testDisabledInfo02() throws BundleException {
        State state = this.buildTestState();
        BundleDescription b1 = state.getBundleByLocation("b1");
        BundleDescription b2 = state.getBundleByLocation("b2");
        BundleDescription b3 = state.getBundleByLocation("b3");
        DisabledInfo info1 = new DisabledInfo("test.policy", "message 1", b1);
        DisabledInfo info2 = new DisabledInfo("test.policy", "message 1", b2);
        DisabledInfo info3 = new DisabledInfo("test.policy", "message 1", b3);
        state.resolve();
        Assert.assertTrue((String)"b1 resolved", (boolean)b1.isResolved());
        Assert.assertTrue((String)"b2 resolved", (boolean)b2.isResolved());
        Assert.assertTrue((String)"b3 resolved", (boolean)b3.isResolved());
        state.addDisabledInfo(info1);
        state.addDisabledInfo(info2);
        state.addDisabledInfo(info3);
        state.resolve(false);
        Assert.assertFalse((String)"b1 resolved", (boolean)b1.isResolved());
        Assert.assertFalse((String)"b2 resolved", (boolean)b2.isResolved());
        Assert.assertFalse((String)"b3 resolved", (boolean)b3.isResolved());
    }

    @Test
    public void testDisabledInfo03() throws BundleException, IOException {
        State state = this.buildTestState();
        BundleDescription b1 = state.getBundleByLocation("b1");
        BundleDescription b2 = state.getBundleByLocation("b2");
        BundleDescription b3 = state.getBundleByLocation("b3");
        DisabledInfo info1 = new DisabledInfo("test.policy", "message 1", b1);
        DisabledInfo info2 = new DisabledInfo("test.policy", "message 1", b2);
        DisabledInfo info3 = new DisabledInfo("test.policy", "message 1", b3);
        state.addDisabledInfo(info1);
        state.addDisabledInfo(info2);
        state.addDisabledInfo(info3);
        BundleContext context = OSGiTestsActivator.getContext();
        File stateDir = context.getDataFile("testDisabledInfo03");
        stateDir.mkdirs();
        state.getFactory().writeState(state, stateDir);
        State copy = state.getFactory().readState(stateDir);
        BundleDescription copyB1 = copy.getBundleByLocation("b1");
        BundleDescription copyB2 = copy.getBundleByLocation("b2");
        BundleDescription copyB3 = copy.getBundleByLocation("b3");
        DisabledInfo copyInfo1 = copy.getDisabledInfo(copyB1, "test.policy");
        DisabledInfo copyInfo2 = copy.getDisabledInfo(copyB2, "test.policy");
        DisabledInfo copyInfo3 = copy.getDisabledInfo(copyB3, "test.policy");
        Assert.assertNotNull((String)"copyInfo1", (Object)copyInfo1);
        Assert.assertNotNull((String)"copyInfo2", (Object)copyInfo2);
        Assert.assertNotNull((String)"copyInfo3", (Object)copyInfo3);
        Assert.assertTrue((String)"copyInfo1 bundle", (copyInfo1.getBundle() == copyB1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"copyInfo2 bundle", (copyInfo2.getBundle() == copyB2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"copyInfo3 bundle", (copyInfo3.getBundle() == copyB3 ? 1 : 0) != 0);
    }

    @Test
    public void testDisabledInfo04() throws BundleException {
        State state = this.buildTestState();
        BundleDescription b1 = state.getBundleByLocation("b1");
        BundleDescription b2 = state.getBundleByLocation("b2");
        BundleDescription b3 = state.getBundleByLocation("b3");
        DisabledInfo info1 = new DisabledInfo("test.policy", "message 1", b1);
        DisabledInfo info2 = new DisabledInfo("test.policy", "message 1", b2);
        DisabledInfo info3 = new DisabledInfo("test.policy", "message 1", b3);
        state.resolve();
        Assert.assertTrue((String)"b1 resolved", (boolean)b1.isResolved());
        Assert.assertTrue((String)"b2 resolved", (boolean)b2.isResolved());
        Assert.assertTrue((String)"b3 resolved", (boolean)b3.isResolved());
        state.addDisabledInfo(info1);
        state.addDisabledInfo(info2);
        state.addDisabledInfo(info3);
        BundleDescription[] disabledBundles = state.getDisabledBundles();
        Assert.assertNotNull((String)"disabledBundles", (Object)disabledBundles);
        this.assertEquals("disabledBundles length", 3, disabledBundles.length);
        Assert.assertTrue((String)"b1 not found", (disabledBundles[0] == b1 || disabledBundles[1] == b1 || disabledBundles[2] == b1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"b2 not found", (disabledBundles[0] == b2 || disabledBundles[1] == b2 || disabledBundles[2] == b2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"b3 not found", (disabledBundles[0] == b3 || disabledBundles[1] == b3 || disabledBundles[2] == b3 ? 1 : 0) != 0);
        state.removeDisabledInfo(info1);
        disabledBundles = state.getDisabledBundles();
        Assert.assertNotNull((String)"disabledBundles", (Object)disabledBundles);
        this.assertEquals("disabledBundles length", 2, disabledBundles.length);
        Assert.assertTrue((String)"b2 not found", (disabledBundles[0] == b2 || disabledBundles[1] == b2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"b3 not found", (disabledBundles[0] == b3 || disabledBundles[1] == b3 ? 1 : 0) != 0);
        state.removeDisabledInfo(info2);
        disabledBundles = state.getDisabledBundles();
        Assert.assertNotNull((String)"disabledBundles", (Object)disabledBundles);
        this.assertEquals("disabledBundles length", 1, disabledBundles.length);
        Assert.assertTrue((String)"b3 not found", (disabledBundles[0] == b3 ? 1 : 0) != 0);
        state.removeDisabledInfo(info3);
        disabledBundles = state.getDisabledBundles();
        Assert.assertNotNull((String)"disabledBundles", (Object)disabledBundles);
        this.assertEquals("disabledBundles length", 0, disabledBundles.length);
    }

    @Test
    public void testBug251427() throws BundleException {
        State state = this.buildTestState();
        BundleDescription b1 = state.getBundleByLocation("b1");
        BundleDescription b2 = state.getBundleByLocation("b2");
        DisabledInfo info11 = new DisabledInfo("test.policy", "message 1", b1);
        DisabledInfo info12 = new DisabledInfo("test.policy", "message 1", b1);
        DisabledInfo info21 = new DisabledInfo("test.policy", "message 1", b2);
        DisabledInfo info22 = new DisabledInfo("test.policy", "message 1", b2);
        this.assertEquals("infos not equal", info11, info12);
        this.assertEquals("infos hashCode not equal", info11.hashCode(), info12.hashCode());
        this.assertEquals("infos not equal", info21, info22);
        this.assertEquals("infos hashCode not equal", info21.hashCode(), info22.hashCode());
    }

    private State buildTestState() throws BundleException {
        State state = this.buildEmptyState();
        String B1_MANIFEST = "Bundle-ManifestVersion: 1\nBundle-SymbolicName: b1\nBundle-Version: 1.0\nImport-Package: b2";
        BundleDescription b1 = state.getFactory().createBundleDescription(state, DisabledInfoTest.parseManifest("Bundle-ManifestVersion: 1\nBundle-SymbolicName: b1\nBundle-Version: 1.0\nImport-Package: b2"), "b1", 1L);
        state.addBundle(b1);
        String B2_MANIFEST = "Bundle-ManifestVersion: 1\nBundle-SymbolicName: b2\nBundle-Version: 1.0\nExport-Package: b2\nImport-Package: b3";
        BundleDescription b2 = state.getFactory().createBundleDescription(state, DisabledInfoTest.parseManifest("Bundle-ManifestVersion: 1\nBundle-SymbolicName: b2\nBundle-Version: 1.0\nExport-Package: b2\nImport-Package: b3"), "b2", 2L);
        state.addBundle(b2);
        String B3_MANIFEST = "Bundle-ManifestVersion: 1\nBundle-SymbolicName: b3\nBundle-Version: 1.0\nExport-Package: b3; version=1.0";
        BundleDescription b3 = state.getFactory().createBundleDescription(state, DisabledInfoTest.parseManifest("Bundle-ManifestVersion: 1\nBundle-SymbolicName: b3\nBundle-Version: 1.0\nExport-Package: b3; version=1.0"), "b3", 3L);
        state.addBundle(b3);
        return state;
    }
}

