/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class GenericCapabilityTest
extends AbstractStateTest {
    static final String GENERIC_REQUIRE = "Eclipse-GenericRequire";
    static final String GENERIC_CAPABILITY = "Eclipse-GenericCapability";

    @Test
    public void testGenericsBasics() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuilder capabililty = new StringBuilder();
        capabililty.append("foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.0\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuilder required = new StringBuilder();
        required.append("genericCapability:osgi.identity; selection-filter=\"(version=1.0)\",");
        required.append("foo; selection-filter=\"(version>=1.3.0)\",");
        required.append("bar:bartype; selection-filter=\"(attr1=value1)\",");
        required.append("test.types:testtype; selection-filter=\"(&(aVersion>=2.0.0)(aLong>=5555)(aDouble>=1.00)(aUri=file:/test)(aSet=c)(aString=someString))\"");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genReq);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        Assert.assertTrue((String)"2.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        this.assertEquals("2.1.1", genSpecs[0].getSupplier(), genCap.getGenericCapabilities()[0]);
        Assert.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        this.assertEquals("2.2.1", genSpecs[1].getSupplier(), genCap.getGenericCapabilities()[1]);
        Assert.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        this.assertEquals("2.3.1", genSpecs[2].getSupplier(), genCap.getGenericCapabilities()[2]);
        Assert.assertTrue((String)"2.4", (boolean)genSpecs[3].isResolved());
        this.assertEquals("2.4.1", genSpecs[3].getSupplier(), genCap.getGenericCapabilities()[3]);
    }

    @Test
    public void testGenericsUpdate() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuilder capabililty = new StringBuilder();
        capabililty.append("foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.0\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuilder required = new StringBuilder();
        required.append("genericCapability:osgi.identity; selection-filter=\"(version>=1.0)\",");
        required.append("foo; selection-filter=\"(version>=1.3.0)\",");
        required.append("bar:bartype; selection-filter=\"(attr1=value1)\",");
        required.append("test.types:testtype; selection-filter=\"(&(aVersion>=2.0.0)(aLong>=5555)(aDouble>=1.00)(aUri=file:/test)(aSet=c)(aString=someString))\"");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genReq);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        Assert.assertTrue((String)"2.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        this.assertEquals("2.1.1", genSpecs[0].getSupplier(), genCap.getGenericCapabilities()[0]);
        Assert.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        this.assertEquals("2.2.1", genSpecs[1].getSupplier(), genCap.getGenericCapabilities()[1]);
        Assert.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        this.assertEquals("2.3.1", genSpecs[2].getSupplier(), genCap.getGenericCapabilities()[2]);
        Assert.assertTrue((String)"2.4", (boolean)genSpecs[3].isResolved());
        this.assertEquals("2.4.1", genSpecs[3].getSupplier(), genCap.getGenericCapabilities()[3]);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "2.0.0");
        capabililty = new StringBuilder();
        capabililty.append("foo; version=\"1.3.2\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.2\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.1\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCap2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), genCap.getBundleId());
        state.updateBundle(genCap2);
        state.resolve(new BundleDescription[]{genCap2});
        Assert.assertTrue((String)"3.0", (boolean)genCap2.isResolved());
        Assert.assertTrue((String)"3.1", (boolean)genReq.isResolved());
        genSpecs = genReq.getGenericRequires();
        Assert.assertTrue((String)"4.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)"4.1", (boolean)genSpecs[0].isResolved());
        this.assertEquals("4.1.1", genSpecs[0].getSupplier(), genCap2.getGenericCapabilities()[0]);
        Assert.assertTrue((String)"4.2", (boolean)genSpecs[1].isResolved());
        this.assertEquals("4.2.1", genSpecs[1].getSupplier(), genCap2.getGenericCapabilities()[1]);
        Assert.assertTrue((String)"4.3", (boolean)genSpecs[2].isResolved());
        this.assertEquals("4.3.1", genSpecs[2].getSupplier(), genCap2.getGenericCapabilities()[2]);
        Assert.assertTrue((String)"4.4", (boolean)genSpecs[3].isResolved());
        this.assertEquals("4.4.1", genSpecs[3].getSupplier(), genCap2.getGenericCapabilities()[3]);
    }

    @Test
    public void testGenericsRefresh() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuilder capabililty = new StringBuilder();
        capabililty.append("foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.0\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuilder required = new StringBuilder();
        required.append("genericCapability:osgi.identity; selection-filter=\"(version>=1.0)\",");
        required.append("foo; selection-filter=\"(version>=1.3.0)\",");
        required.append("bar:bartype; selection-filter=\"(attr1=value1)\",");
        required.append("test.types:testtype; selection-filter=\"(&(aVersion>=2.0.0)(aLong>=5555)(aDouble>=1.00)(aUri=file:/test)(aSet=c)(aString=someString))\"");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genReq);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        Assert.assertTrue((String)"2.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        this.assertEquals("2.1.1", genSpecs[0].getSupplier(), genCap.getGenericCapabilities()[0]);
        Assert.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        this.assertEquals("2.2.1", genSpecs[1].getSupplier(), genCap.getGenericCapabilities()[1]);
        Assert.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        this.assertEquals("2.3.1", genSpecs[2].getSupplier(), genCap.getGenericCapabilities()[2]);
        Assert.assertTrue((String)"2.4", (boolean)genSpecs[3].isResolved());
        this.assertEquals("2.4.1", genSpecs[3].getSupplier(), genCap.getGenericCapabilities()[3]);
        state.resolve(new BundleDescription[]{genCap});
        Assert.assertTrue((String)"3.0", (boolean)genCap.isResolved());
        Assert.assertTrue((String)"3.1", (boolean)genReq.isResolved());
        genSpecs = genReq.getGenericRequires();
        Assert.assertTrue((String)"4.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)"4.1", (boolean)genSpecs[0].isResolved());
        this.assertEquals("4.1.1", genSpecs[0].getSupplier(), genCap.getGenericCapabilities()[0]);
        Assert.assertTrue((String)"4.2", (boolean)genSpecs[1].isResolved());
        this.assertEquals("4.2.1", genSpecs[1].getSupplier(), genCap.getGenericCapabilities()[1]);
        Assert.assertTrue((String)"4.3", (boolean)genSpecs[2].isResolved());
        this.assertEquals("4.3.1", genSpecs[2].getSupplier(), genCap.getGenericCapabilities()[2]);
        Assert.assertTrue((String)"4.4", (boolean)genSpecs[3].isResolved());
        this.assertEquals("4.4.1", genSpecs[3].getSupplier(), genCap.getGenericCapabilities()[3]);
    }

    @Test
    public void testGenericsFrags() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuilder capabililty = new StringBuilder();
        capabililty.append("foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.0\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability.frag1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "genericCapability;bundle-version=\"[1.0.0,2.0.0)\"");
        capabililty = new StringBuilder();
        capabililty.append("fragmentStuff");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCapFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuilder required = new StringBuilder();
        required.append("genericCapability:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.bundle))\",");
        required.append("foo; selection-filter=\"(version>=1.3.0)\",");
        required.append("bar:bartype; selection-filter=\"(attr1=value1)\",");
        required.append("test.types:testtype; selection-filter=\"(&(aVersion>=2.0.0)(aLong>=5555)(aDouble>=1.00)(aUri=file:/test)(aSet=c)(aString=someString))\",");
        required.append("fragmentStuff,");
        required.append("genericCapability.frag1:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.fragment))\"");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genCapFrag);
        state.addBundle(genReq);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)genCapFrag.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        GenericDescription[] selectedHostCapabilities = genCap.getSelectedGenericCapabilities();
        GenericDescription[] selectedFragCapabilities = genCapFrag.getSelectedGenericCapabilities();
        Assert.assertTrue((String)"2.0", (genSpecs.length == 6 ? 1 : 0) != 0);
        this.assertEquals("Wrong number of selected capabilities", 5, selectedHostCapabilities.length);
        this.assertEquals("Wrong number of selected capabilities", 1, selectedFragCapabilities.length);
        Assert.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        this.assertEquals("2.1.1", genSpecs[0].getSupplier(), selectedHostCapabilities[0]);
        Assert.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        this.assertEquals("2.2.1", genSpecs[1].getSupplier(), selectedHostCapabilities[1]);
        Assert.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        this.assertEquals("2.3.1", genSpecs[2].getSupplier(), selectedHostCapabilities[2]);
        Assert.assertTrue((String)"2.4", (boolean)genSpecs[3].isResolved());
        this.assertEquals("2.4.1", genSpecs[3].getSupplier(), selectedHostCapabilities[3]);
        Assert.assertTrue((String)"2.5", (boolean)genSpecs[4].isResolved());
        this.assertEquals("2.5.1", genSpecs[4].getSupplier(), selectedHostCapabilities[4]);
        Assert.assertTrue((String)"2.6", (boolean)genSpecs[5].isResolved());
        this.assertEquals("2.6.1", genSpecs[5].getSupplier(), selectedFragCapabilities[0]);
    }

    @Test
    public void testGenericsIntraFrags() throws BundleException {
        State state = this.buildEmptyState();
        long bundleID = 0L;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.equinox.generic.frag.a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "org.eclipse.equinox.generic.host;bundle-version=\"1.0.0\"");
        manifest.put(GENERIC_CAPABILITY, "frag.a");
        BundleDescription genFragA = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.equinox.generic.host");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription genHost = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.equinox.generic.frag.b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "org.eclipse.equinox.generic.host;bundle-version=\"1.0.0\"");
        StringBuilder required = new StringBuilder();
        required.append("org.eclipse.equinox.generic.host:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.bundle))\",");
        required.append("frag.a,");
        required.append("org.eclipse.equinox.generic.frag.a:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.fragment))\",");
        required.append("org.eclipse.equinox.generic.frag.b:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.fragment))\"");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genFragB = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genHost);
        state.addBundle(genFragA);
        state.addBundle(genFragB);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)genHost.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)genFragA.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)genFragB.isResolved());
        GenericSpecification[] genSpecs = genFragB.getGenericRequires();
        GenericDescription[] selected = genHost.getSelectedGenericCapabilities();
        this.assertEquals("Wrong number of selected", 2, selected.length);
        Assert.assertTrue((String)"2.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        GenericDescription[] selectedHostCapabilities = genHost.getSelectedGenericCapabilities();
        GenericDescription[] selectedFragACapabilities = genFragA.getSelectedGenericCapabilities();
        GenericDescription[] selectedFragBCapabilities = genFragB.getSelectedGenericCapabilities();
        this.assertEquals("Wrong number of selected capabilities", 2, selectedHostCapabilities.length);
        this.assertEquals("Wrong number of selected capabilities", 1, selectedFragACapabilities.length);
        this.assertEquals("Wrong number of selected capabilities", 1, selectedFragBCapabilities.length);
        Assert.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        this.assertEquals("2.1.1", genSpecs[0].getSupplier(), selectedHostCapabilities[0]);
        Assert.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        this.assertEquals("2.2.1", genSpecs[1].getSupplier(), selectedHostCapabilities[1]);
        Assert.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        this.assertEquals("2.3.1", genSpecs[2].getSupplier(), selectedFragACapabilities[0]);
        Assert.assertTrue((String)"2.4", (boolean)genSpecs[3].isResolved());
        this.assertEquals("2.4.1", genSpecs[3].getSupplier(), selectedFragBCapabilities[0]);
    }

    @Test
    public void testGenericsAliases() throws BundleException {
        State state = this.buildEmptyState();
        Dictionary[] allPlatProps = state.getPlatformProperties();
        Dictionary platProps = (Dictionary)((Hashtable)allPlatProps[0]).clone();
        platProps.put("osgi.genericAliases", "Export-Service:Import-Service:service,TJW-Export:TJW-Import:tjw");
        state.setPlatformProperties(platProps);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Service", "org.osgi.service.log.LogService; version=1.2");
        manifest.put("TJW-Export", "my.great.stuff; aLong:long=5150; aDouble:double=3.14; aVersion:version=1.2.0");
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Service", "org.osgi.service.log.LogService; selection-filter=(version>=1.0.0)");
        manifest.put("TJW-Import", "my.great.stuff; selection-filter=(&(aLong<=10000)(aLong>=5000))");
        manifest.put(GENERIC_REQUIRE, "genericCapability:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.bundle))\"");
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genReq);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        Assert.assertTrue((String)"2.0", (genSpecs.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        this.assertEquals("2.1.1", genSpecs[0].getSupplier(), genCap.getGenericCapabilities()[1]);
        Assert.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        this.assertEquals("2.2.1", genSpecs[1].getSupplier(), genCap.getGenericCapabilities()[2]);
        Assert.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        this.assertEquals("2.3.1", genSpecs[2].getSupplier(), genCap.getGenericCapabilities()[0]);
    }

    @Test
    public void testGenericsOptionalMultiple() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuilder capabililty = new StringBuilder();
        capabililty.append("foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.0\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\",");
        capabililty.append("test.real.optional:thisisoptional,");
        capabililty.append("test.real.multiple:thisismultiple; version=1.0,");
        capabililty.append("test.real.multiple:thisismultiple; version=2.0");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuilder required = new StringBuilder();
        required.append("genericCapability:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.bundle))\",");
        required.append("foo; selection-filter=\"(version>=1.3.0)\",");
        required.append("bar:bartype; selection-filter=\"(attr1=value1)\",");
        required.append("test.types:testtype; selection-filter=\"(&(aVersion>=2.0.0)(aLong>=5555)(aDouble>=1.00)(aUri=file:/test)(aSet=c)(aString=someString))\",");
        required.append("test.optional:thisisoptional; optional=true,");
        required.append("test.real.optional:thisisoptional; optional=true,");
        required.append("test.real.multiple:thisismultiple; multiple=true");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genReq);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        Assert.assertTrue((String)"2.0", (genSpecs.length == 7 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        this.assertEquals("2.1.1", genSpecs[0].getSupplier(), genCap.getGenericCapabilities()[0]);
        Assert.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        this.assertEquals("2.2.1", genSpecs[1].getSupplier(), genCap.getGenericCapabilities()[1]);
        Assert.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        this.assertEquals("2.3.1", genSpecs[2].getSupplier(), genCap.getGenericCapabilities()[2]);
        Assert.assertTrue((String)"2.3", (boolean)genSpecs[3].isResolved());
        this.assertEquals("2.3.1", genSpecs[3].getSupplier(), genCap.getGenericCapabilities()[3]);
        Assert.assertFalse((String)"2.4", (boolean)genSpecs[4].isResolved());
        Assert.assertTrue((String)"2.5", (boolean)genSpecs[5].isResolved());
        this.assertEquals("2.5.1", genSpecs[5].getSupplier(), genCap.getGenericCapabilities()[4]);
        Assert.assertTrue((String)"2.6", (boolean)genSpecs[6].isResolved());
        GenericDescription[] suppliers = genSpecs[6].getSuppliers();
        Assert.assertTrue((String)"2.6.1", (suppliers != null && suppliers.length == 2 ? 1 : 0) != 0);
        this.assertEquals("2.6.2", suppliers[0], genCap.getGenericCapabilities()[6]);
        this.assertEquals("2.6.3", suppliers[1], genCap.getGenericCapabilities()[5]);
    }

    @Test
    public void testGenericsCycles() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapablity");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuilder capabililty = new StringBuilder();
        capabililty.append("foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.0\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        StringBuilder required = new StringBuilder();
        required.append("foo:cycle; selection-filter=\"(version>=1.3.0)\"");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability.frag1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "genericCapablity;bundle-version=\"[1.0.0,2.0.0)\"");
        capabililty = new StringBuilder();
        capabililty.append("fragmentStuff");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCapFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        capabililty = new StringBuilder();
        capabililty.append("foo:cycle; version:version=\"2.0\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        required = new StringBuilder();
        required.append("foo; selection-filter=\"(version>=1.3.0)\",");
        required.append("bar:bartype; selection-filter=\"(attr1=value1)\",");
        required.append("test.types:testtype; selection-filter=\"(&(aVersion>=2.0.0)(aLong>=5555)(aDouble>=1.00)(aUri=file:/test)(aSet=c)(aString=someString))\",");
        required.append("fragmentStuff");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genCapFrag);
        state.addBundle(genReq);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)genCapFrag.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        GenericDescription[] selected = genCap.getSelectedGenericCapabilities();
        Assert.assertTrue((String)"2.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        this.assertEquals("Wrong number of selected", 5, selected.length);
        Assert.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        this.assertEquals("2.1.1", genSpecs[0].getSupplier(), selected[1]);
        Assert.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        this.assertEquals("2.2.1", genSpecs[1].getSupplier(), selected[2]);
        Assert.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        this.assertEquals("2.3.1", genSpecs[2].getSupplier(), selected[3]);
        Assert.assertTrue((String)"2.4", (boolean)genSpecs[3].isResolved());
        this.assertEquals("2.4.1", genSpecs[3].getSupplier(), selected[4]);
        genSpecs = genCap.getGenericRequires();
        Assert.assertTrue((String)"3.0", (genSpecs.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.1", (boolean)genSpecs[0].isResolved());
        this.assertEquals("3.1.1", genSpecs[0].getSupplier(), genReq.getGenericCapabilities()[1]);
    }
}

