/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.eclipse.osgi.util.ManifestElement;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class OSGiCapabilityTest
extends AbstractStateTest {
    private static final String MANIFEST_ROOT = "test_files/genericCapability/";
    @Rule
    public TestName testName = new TestName();
    private static final String notEffective = "not.effective";

    private Dictionary loadManifest(String manifest) throws IOException, BundleException {
        URL url = OSGiTestsActivator.getContext().getBundle().getEntry(MANIFEST_ROOT + manifest);
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap();
        ManifestElement.parseBundleManifest((InputStream)url.openStream(), (Map)headers);
        return headers.asUnmodifiableDictionary();
    }

    @Test
    public void testGenericsOSGiOSGi() throws Exception {
        this.doGenericBasicsTest("p1.osgi.MF", "p2.osgi.MF", "p3.osgi.MF", "c1.osgi.MF", "c2.osgi.MF", "c3.osgi.MF");
    }

    @Test
    public void testGenericsOSGiEquinox() throws Exception {
        this.doGenericBasicsTest("p1.osgi.MF", "p2.osgi.MF", "p3.osgi.MF", "c1.equinox.MF", "c2.equinox.MF", "c3.equinox.MF");
    }

    @Test
    public void testGenericsOSGiNameEquinox() throws Exception {
        this.doGenericBasicsTest("p1.osgi.name.MF", "p2.osgi.name.MF", "p3.osgi.name.MF", "c1.equinox.MF", "c2.equinox.MF", "c3.equinox.MF");
    }

    @Test
    public void testGenericsOSGiNameOSGi() throws Exception {
        this.doGenericBasicsTest("p1.osgi.name.MF", "p2.osgi.name.MF", "p3.osgi.name.MF", "c1.osgi.MF", "c2.osgi.MF", "c3.osgi.MF");
    }

    @Test
    public void testGenericsOSGiNameEquinoxName() throws Exception {
        this.doGenericBasicsTest("p1.osgi.name.MF", "p2.osgi.name.MF", "p3.osgi.name.MF", "c1.equinox.name.MF", "c2.equinox.name.MF", "c3.equinox.name.MF");
    }

    @Test
    public void testGenericsEquinoxOSGi() throws Exception {
        this.doGenericBasicsTest("p1.equinox.MF", "p2.equinox.MF", "p3.equinox.MF", "c1.osgi.MF", "c2.osgi.MF", "c3.osgi.MF");
    }

    @Test
    public void testGenericsEquinoxEquinox() throws Exception {
        this.doGenericBasicsTest("p1.equinox.MF", "p2.equinox.MF", "p3.equinox.MF", "c1.equinox.MF", "c2.equinox.MF", "c3.equinox.MF");
    }

    private void doGenericBasicsTest(String p1Manifest, String p2Manifest, String p3Manifest, String c1Manifest, String c2Manifest, String c3Manifest) throws BundleException, IOException {
        State state = this.buildEmptyState();
        long bundleID = 0L;
        Dictionary manifest = this.loadManifest(p1Manifest);
        BundleDescription p1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest(p2Manifest);
        BundleDescription p2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest(p3Manifest);
        BundleDescription p3 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest(c1Manifest);
        BundleDescription c1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest(c2Manifest);
        BundleDescription c2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest(c3Manifest);
        BundleDescription c3 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(p3);
        state.addBundle(p2);
        state.addBundle(p1);
        state.addBundle(c1);
        state.addBundle(c2);
        state.addBundle(c3);
        state.resolve();
        Assert.assertTrue((String)"p1", (boolean)p1.isResolved());
        Assert.assertTrue((String)"p2", (boolean)p2.isResolved());
        Assert.assertTrue((String)"p3", (boolean)p3.isResolved());
        Assert.assertTrue((String)"c1", (boolean)c1.isResolved());
        Assert.assertTrue((String)"c2", (boolean)c2.isResolved());
        Assert.assertTrue((String)"c3", (boolean)c3.isResolved());
        this.checkGenericBasics(4, c1.getResolvedGenericRequires(), p1.getSelectedGenericCapabilities());
        this.checkGenericBasics(4, c2.getResolvedGenericRequires(), p2.getSelectedGenericCapabilities());
        this.checkGenericBasics(4, c3.getResolvedGenericRequires(), p3.getSelectedGenericCapabilities());
        if (p1Manifest.indexOf(".osgi.") != -1) {
            this.checkForNonEffectiveCapability(p1);
            this.checkForNonEffectiveCapability(p2);
            this.checkForNonEffectiveCapability(p3);
        }
        if (c1Manifest.indexOf(".osgi.") != -1) {
            this.checkForNonEffectiveRequirement(c1);
            this.checkForNonEffectiveRequirement(c2);
            this.checkForNonEffectiveRequirement(c3);
        }
        File stateDir = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName());
        stateDir.mkdirs();
        state.getFactory().writeState(state, stateDir);
        state = state.getFactory().readState(stateDir);
        p1 = state.getBundle(p1.getBundleId());
        p2 = state.getBundle(p2.getBundleId());
        p3 = state.getBundle(p3.getBundleId());
        c1 = state.getBundle(c1.getBundleId());
        c2 = state.getBundle(c2.getBundleId());
        c3 = state.getBundle(c3.getBundleId());
        Assert.assertTrue((String)"p1", (boolean)p1.isResolved());
        Assert.assertTrue((String)"p2", (boolean)p2.isResolved());
        Assert.assertTrue((String)"p3", (boolean)p3.isResolved());
        Assert.assertTrue((String)"c1", (boolean)c1.isResolved());
        Assert.assertTrue((String)"c2", (boolean)c2.isResolved());
        Assert.assertTrue((String)"c3", (boolean)c3.isResolved());
        this.checkGenericBasics(4, c1.getResolvedGenericRequires(), p1.getSelectedGenericCapabilities());
        this.checkGenericBasics(4, c2.getResolvedGenericRequires(), p2.getSelectedGenericCapabilities());
        this.checkGenericBasics(4, c3.getResolvedGenericRequires(), p3.getSelectedGenericCapabilities());
        if (p1Manifest.indexOf(".osgi.") != -1) {
            this.checkForNonEffectiveCapability(p1);
            this.checkForNonEffectiveCapability(p2);
            this.checkForNonEffectiveCapability(p3);
        }
        if (c1Manifest.indexOf(".osgi.") != -1) {
            this.checkForNonEffectiveRequirement(c1);
            this.checkForNonEffectiveRequirement(c2);
            this.checkForNonEffectiveRequirement(c3);
        }
    }

    private void checkForNonEffectiveCapability(BundleDescription p1) {
        List nonEffectiveCaps = p1.getCapabilities(notEffective);
        Assert.assertNotNull((Object)nonEffectiveCaps);
        this.assertEquals("Wrong number of not.effective", 1, nonEffectiveCaps.size());
        Capability c = (Capability)nonEffectiveCaps.get(0);
        this.assertEquals("Wrong effective value", "active", c.getDirectives().get("effective"));
    }

    private void checkForNonEffectiveRequirement(BundleDescription c1) {
        List nonEffectiveReqs = c1.getRequirements(notEffective);
        Assert.assertNotNull((Object)nonEffectiveReqs);
        this.assertEquals("Wrong number of not.effective", 1, nonEffectiveReqs.size());
        Requirement r = (Requirement)nonEffectiveReqs.get(0);
        this.assertEquals("Wrong effective value", "active", r.getDirectives().get("effective"));
    }

    private void checkGenericBasics(int expectedCnt, GenericDescription[] genRequired, GenericDescription[] genProvided) {
        this.checkGenericBasics(expectedCnt, genRequired, genProvided, null);
    }

    private void checkGenericBasics(int expectedCnt, GenericDescription[] genRequired, GenericDescription[] genProvided, GenericDescription fragIdentity) {
        this.assertEquals("Expected number of capabilities do not match", expectedCnt, genRequired.length);
        this.assertEquals("Specs do not match Descs", genRequired.length, genProvided.length + (fragIdentity == null ? 0 : 1));
        ArrayList<GenericDescription> providedCollection = new ArrayList<GenericDescription>(Arrays.asList(genProvided));
        GenericDescription[] genericDescriptionArray = genRequired;
        int n = genRequired.length;
        int n2 = 0;
        while (n2 < n) {
            GenericDescription requiredDescription = genericDescriptionArray[n2];
            if ("osgi.identity".equals(requiredDescription.getType()) && requiredDescription.getSupplier().getHost() != null) {
                this.assertEquals("Wrong fragment provider: " + String.valueOf(requiredDescription), fragIdentity, requiredDescription);
            } else {
                Assert.assertTrue((String)("Wrong provider for requirement: " + String.valueOf(requiredDescription)), (boolean)providedCollection.remove(requiredDescription));
            }
            ++n2;
        }
    }

    @Test
    public void testGenericFragments01() throws BundleException, IOException {
        State state = this.buildEmptyState();
        long bundleID = 0L;
        Dictionary manifest = this.loadManifest("p1.osgi.MF");
        BundleDescription p1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p1.osgi.frag.MF");
        BundleDescription p1Frag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c1.osgi.MF");
        BundleDescription c1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c1.osgi.frag.MF");
        BundleDescription c1Frag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p4.osgi.MF");
        BundleDescription p4 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(p1);
        state.addBundle(p1Frag);
        state.addBundle(c1);
        state.addBundle(c1Frag);
        state.addBundle(p4);
        state.resolve();
        Assert.assertTrue((String)"p1", (boolean)p1.isResolved());
        Assert.assertTrue((String)"p1Frag", (boolean)p1Frag.isResolved());
        Assert.assertTrue((String)"c1", (boolean)c1.isResolved());
        Assert.assertTrue((String)"c1Frag", (boolean)c1Frag.isResolved());
        Assert.assertTrue((String)"p4", (boolean)p4.isResolved());
        this.checkGenericBasics(6, c1.getResolvedGenericRequires(), p1.getSelectedGenericCapabilities(), p1Frag.getSelectedGenericCapabilities()[0]);
        File stateDir = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName());
        stateDir.mkdirs();
        state.getFactory().writeState(state, stateDir);
        state = state.getFactory().readState(stateDir);
        p1 = state.getBundle(p1.getBundleId());
        p1Frag = state.getBundle(p1Frag.getBundleId());
        c1 = state.getBundle(c1.getBundleId());
        c1Frag = state.getBundle(c1Frag.getBundleId());
        p4 = state.getBundle(p4.getBundleId());
        Assert.assertTrue((String)"p1", (boolean)p1.isResolved());
        Assert.assertTrue((String)"p1Frag", (boolean)p1Frag.isResolved());
        Assert.assertTrue((String)"c1", (boolean)c1.isResolved());
        Assert.assertTrue((String)"c1Frag", (boolean)c1Frag.isResolved());
        Assert.assertTrue((String)"p4", (boolean)p4.isResolved());
        this.checkGenericBasics(6, c1.getResolvedGenericRequires(), p1.getSelectedGenericCapabilities(), p1Frag.getSelectedGenericCapabilities()[0]);
        state.setResolver(this.platformAdminService.createResolver());
        state.resolve(new BundleDescription[]{p1});
        Assert.assertTrue((String)"p1", (boolean)p1.isResolved());
        Assert.assertTrue((String)"p1Frag", (boolean)p1Frag.isResolved());
        Assert.assertTrue((String)"c1", (boolean)c1.isResolved());
        Assert.assertTrue((String)"c1Frag", (boolean)c1Frag.isResolved());
        Assert.assertTrue((String)"p4", (boolean)p4.isResolved());
        this.checkGenericBasics(6, c1.getResolvedGenericRequires(), p1.getSelectedGenericCapabilities(), p1Frag.getSelectedGenericCapabilities()[0]);
    }

    @Test
    public void testGenericFragments02() throws BundleException, IOException {
        State state = this.buildEmptyState();
        long bundleID = 0L;
        Dictionary manifest = this.loadManifest("p1.osgi.MF");
        BundleDescription p1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p1.osgi.frag.MF");
        BundleDescription p1Frag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c1.osgi.MF");
        BundleDescription c1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c1.osgi.frag.MF");
        BundleDescription c1Frag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(p1);
        state.addBundle(p1Frag);
        state.addBundle(c1);
        state.addBundle(c1Frag);
        state.resolve();
        Assert.assertTrue((String)"p1", (boolean)p1.isResolved());
        Assert.assertFalse((String)"p1Frag", (boolean)p1Frag.isResolved());
        Assert.assertTrue((String)"c1", (boolean)c1.isResolved());
        Assert.assertFalse((String)"c1Frag", (boolean)c1Frag.isResolved());
        this.checkGenericBasics(4, c1.getResolvedGenericRequires(), p1.getSelectedGenericCapabilities());
        File stateDir = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName() + "1");
        stateDir.mkdirs();
        state.getFactory().writeState(state, stateDir);
        state = state.getFactory().readState(stateDir);
        state.setResolver(this.platformAdminService.createResolver());
        p1 = state.getBundle(p1.getBundleId());
        p1Frag = state.getBundle(p1Frag.getBundleId());
        c1 = state.getBundle(c1.getBundleId());
        c1Frag = state.getBundle(c1Frag.getBundleId());
        Assert.assertTrue((String)"p1", (boolean)p1.isResolved());
        Assert.assertFalse((String)"p1Frag", (boolean)p1Frag.isResolved());
        Assert.assertTrue((String)"c1", (boolean)c1.isResolved());
        Assert.assertFalse((String)"c1Frag", (boolean)c1Frag.isResolved());
        this.checkGenericBasics(4, c1.getResolvedGenericRequires(), p1.getSelectedGenericCapabilities());
        manifest = this.loadManifest("p4.osgi.MF");
        BundleDescription p4 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(p4);
        state.resolve(new BundleDescription[]{p1});
        Assert.assertTrue((String)"p1", (boolean)p1.isResolved());
        Assert.assertTrue((String)"p1Frag", (boolean)p1Frag.isResolved());
        Assert.assertTrue((String)"c1", (boolean)c1.isResolved());
        Assert.assertTrue((String)"c1Frag", (boolean)c1Frag.isResolved());
        Assert.assertTrue((String)"p4", (boolean)p4.isResolved());
        this.checkGenericBasics(6, c1.getResolvedGenericRequires(), p1.getSelectedGenericCapabilities(), p1Frag.getSelectedGenericCapabilities()[0]);
        stateDir = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName() + "2");
        stateDir.mkdirs();
        state.getFactory().writeState(state, stateDir);
        state = state.getFactory().readState(stateDir);
        p1 = state.getBundle(p1.getBundleId());
        p1Frag = state.getBundle(p1Frag.getBundleId());
        c1 = state.getBundle(c1.getBundleId());
        c1Frag = state.getBundle(c1Frag.getBundleId());
        p4 = state.getBundle(p4.getBundleId());
        Assert.assertTrue((String)"p1", (boolean)p1.isResolved());
        Assert.assertTrue((String)"p1Frag", (boolean)p1Frag.isResolved());
        Assert.assertTrue((String)"c1", (boolean)c1.isResolved());
        Assert.assertTrue((String)"c1Frag", (boolean)c1Frag.isResolved());
        Assert.assertTrue((String)"p4", (boolean)p4.isResolved());
        this.checkGenericBasics(6, c1.getResolvedGenericRequires(), p1.getSelectedGenericCapabilities(), p1Frag.getSelectedGenericCapabilities()[0]);
    }

    @Test
    public void testGenericUses() throws Exception {
        State state = this.buildEmptyState();
        long bundleID = 0L;
        Dictionary manifest = this.loadManifest("p5.v100.osgi.MF");
        BundleDescription p5v100 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p5.v110.osgi.MF");
        BundleDescription p5v110 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p6.v100.osgi.MF");
        BundleDescription p6v100 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p6.v110.osgi.MF");
        BundleDescription p6v110 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p7.v100.osgi.MF");
        BundleDescription p7v100 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p7.v110.osgi.MF");
        BundleDescription p7v110 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c4.v100.osgi.MF");
        BundleDescription c4v100 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c4.v110.osgi.MF");
        BundleDescription c4v110 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c4.v120.osgi.MF");
        BundleDescription c4v120 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c4.v130.osgi.MF");
        BundleDescription c4v130 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(p5v100);
        state.addBundle(p5v110);
        state.addBundle(p6v100);
        state.addBundle(p6v110);
        state.addBundle(p7v100);
        state.addBundle(p7v110);
        state.addBundle(c4v100);
        state.addBundle(c4v110);
        state.addBundle(c4v120);
        state.addBundle(c4v130);
        state.resolve();
        Assert.assertTrue((String)"p5v100", (boolean)p5v100.isResolved());
        Assert.assertTrue((String)"p5v110", (boolean)p5v110.isResolved());
        Assert.assertTrue((String)"p6v100", (boolean)p6v100.isResolved());
        Assert.assertTrue((String)"p6v110", (boolean)p6v110.isResolved());
        Assert.assertTrue((String)"p7v100", (boolean)p7v100.isResolved());
        Assert.assertTrue((String)"p7v110", (boolean)p7v110.isResolved());
        Assert.assertTrue((String)"c4v100", (boolean)c4v100.isResolved());
        Assert.assertTrue((String)"c4v110", (boolean)c4v110.isResolved());
        Assert.assertTrue((String)"c4v120", (boolean)c4v120.isResolved());
        Assert.assertTrue((String)"c4v130", (boolean)c4v130.isResolved());
        state.linkDynamicImport(c4v120, "p6");
        state.linkDynamicImport(c4v120, "p7");
        GenericDescription[] p5v100Capability = p5v100.getSelectedGenericCapabilities();
        ExportPackageDescription[] p6v100Exports = p6v100.getSelectedExports();
        ExportPackageDescription[] p7v100Exports = p7v100.getSelectedExports();
        ExportPackageDescription[] expectedPackages = new ExportPackageDescription[]{p6v100Exports[0], p7v100Exports[0]};
        this.checkUsedImports(c4v100, expectedPackages);
        this.checkUsedImports(c4v110, expectedPackages);
        this.checkUsedImports(c4v120, expectedPackages);
        BundleDescription[] expectedRequired = new BundleDescription[]{p6v100, p7v100};
        this.checkUsedRequires(c4v130, expectedRequired);
        this.checkUsedCapability(c4v100, p5v100Capability);
        this.checkUsedCapability(c4v110, p5v100Capability);
        this.checkUsedCapability(c4v120, p5v100Capability);
        this.checkUsedCapability(c4v130, p5v100Capability);
    }

    @Test
    public void testOSGiCardinalityUses() throws Exception {
        State state = this.buildEmptyState();
        long bundleID = 0L;
        Dictionary manifest = this.loadManifest("p5.v100.osgi.MF");
        BundleDescription p5v100 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p5.v101.osgi.MF");
        BundleDescription p5v101 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p5.v110.osgi.MF");
        BundleDescription p5v110 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p6.v100.osgi.MF");
        BundleDescription p6v100 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p6.v110.osgi.MF");
        BundleDescription p6v110 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p7.v100.osgi.MF");
        BundleDescription p7v100 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p7.v110.osgi.MF");
        BundleDescription p7v110 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c6.v100.osgi.MF");
        BundleDescription c6v100 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c6.v110.osgi.MF");
        BundleDescription c6v110 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c6.v120.osgi.MF");
        BundleDescription c6v120 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c6.v130.osgi.MF");
        BundleDescription c6v130 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c6.v140.osgi.MF");
        BundleDescription c6v140 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(p5v100);
        state.addBundle(p5v101);
        state.addBundle(p5v110);
        state.addBundle(p6v100);
        state.addBundle(p6v110);
        state.addBundle(p7v100);
        state.addBundle(p7v110);
        state.addBundle(c6v100);
        state.addBundle(c6v110);
        state.addBundle(c6v120);
        state.addBundle(c6v130);
        state.addBundle(c6v140);
        state.resolve();
        Assert.assertTrue((String)"p5v100", (boolean)p5v100.isResolved());
        Assert.assertTrue((String)"p5v100", (boolean)p5v101.isResolved());
        Assert.assertTrue((String)"p5v110", (boolean)p5v110.isResolved());
        Assert.assertTrue((String)"p6v100", (boolean)p6v100.isResolved());
        Assert.assertTrue((String)"p6v110", (boolean)p6v110.isResolved());
        Assert.assertTrue((String)"p7v100", (boolean)p7v100.isResolved());
        Assert.assertTrue((String)"p7v110", (boolean)p7v110.isResolved());
        Assert.assertTrue((String)"c6v100", (boolean)c6v100.isResolved());
        Assert.assertTrue((String)"c6v110", (boolean)c6v110.isResolved());
        Assert.assertTrue((String)"c6v120", (boolean)c6v120.isResolved());
        Assert.assertTrue((String)"c6v130", (boolean)c6v130.isResolved());
        Assert.assertTrue((String)"c6v140", (boolean)c6v140.isResolved());
        state.linkDynamicImport(c6v120, "p6");
        state.linkDynamicImport(c6v120, "p7");
        GenericDescription[] p5v100Capability = p5v100.getSelectedGenericCapabilities();
        GenericDescription[] p5v101Capability = p5v101.getSelectedGenericCapabilities();
        ArrayList<GenericDescription> expectedCapabilityList = new ArrayList<GenericDescription>();
        expectedCapabilityList.addAll(Arrays.asList(p5v100Capability));
        expectedCapabilityList.addAll(Arrays.asList(p5v101Capability));
        Iterator iCapabilities = expectedCapabilityList.iterator();
        while (iCapabilities.hasNext()) {
            if ("namespace.5".equals(((GenericDescription)iCapabilities.next()).getType())) continue;
            iCapabilities.remove();
        }
        ExportPackageDescription[] p6v100Exports = p6v100.getSelectedExports();
        ExportPackageDescription[] p7v100Exports = p7v100.getSelectedExports();
        ExportPackageDescription[] expectedPackages = new ExportPackageDescription[]{p6v100Exports[0], p7v100Exports[0]};
        this.checkUsedImports(c6v100, expectedPackages);
        this.checkUsedImports(c6v110, expectedPackages);
        this.checkUsedImports(c6v120, expectedPackages);
        BundleDescription[] expectedRequired = new BundleDescription[]{p6v100, p7v100};
        this.checkUsedRequires(c6v130, expectedRequired);
        this.checkUsedRequires(c6v140, expectedRequired);
        GenericDescription[] expectedCapabilities = expectedCapabilityList.toArray(new GenericDescription[expectedCapabilityList.size()]);
        this.checkUsedCapability(c6v100, expectedCapabilities);
        this.checkUsedCapability(c6v110, expectedCapabilities);
        this.checkUsedCapability(c6v120, expectedCapabilities);
        this.checkUsedCapability(c6v130, expectedCapabilities);
        this.checkUsedCapability(c6v140, expectedCapabilities);
        manifest = this.loadManifest("c6.v150.osgi.MF");
        BundleDescription c6v150 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c6.v160.osgi.MF");
        BundleDescription c6v160 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(c6v150);
        state.addBundle(c6v160);
        state.resolve();
        Assert.assertFalse((String)"c6v150", (boolean)c6v150.isResolved());
        Assert.assertFalse((String)"c6v160", (boolean)c6v160.isResolved());
    }

    @Test
    public void testDeclaringIdentityCapability() {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuilder capabililty = new StringBuilder();
        capabililty.append("testFailure:osgi.identity; test=failure");
        manifest.put("Eclipse-GenericCapability", capabililty.toString());
        try {
            state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
            Assert.fail((String)"Expected failure to create description that specifies osgi.identity capability");
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
        manifest.remove("Eclipse-GenericCapability");
        manifest.put("Provide-Capability", "osgi.identity; osgi.identity=testFailure; test=failure");
        try {
            state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
            Assert.fail((String)"Expected failure to create description that specifies osgi.identity capability");
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
    }

    @Test
    public void testOSGiCardinality() throws Exception {
        State state = this.buildEmptyState();
        long bundleID = 0L;
        Dictionary manifest = this.loadManifest("p1.osgi.MF");
        BundleDescription p1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p2.osgi.MF");
        BundleDescription p2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p3.osgi.MF");
        BundleDescription p3 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c5.osgi.MF");
        BundleDescription c5 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(p1);
        state.addBundle(p2);
        state.addBundle(p3);
        state.addBundle(c5);
        state.resolve();
        Assert.assertTrue((String)"p1", (boolean)p1.isResolved());
        Assert.assertTrue((String)"p2", (boolean)p2.isResolved());
        Assert.assertTrue((String)"p3", (boolean)p3.isResolved());
        Assert.assertTrue((String)"c5", (boolean)c5.isResolved());
        BundleWiring c5Wiring = c5.getWiring();
        List requiredWires = c5Wiring.getRequiredWires(null);
        this.assertEquals("Wrong number of required wires.", 3, requiredWires.size());
        ArrayList expectedCapabilities = new ArrayList();
        expectedCapabilities.addAll(p1.getCapabilities("namespace.1"));
        expectedCapabilities.addAll(p2.getCapabilities("namespace.1"));
        expectedCapabilities.addAll(p3.getCapabilities("namespace.1"));
        for (Object requiredWire : requiredWires) {
            BundleWire wire = (BundleWire)requiredWire;
            expectedCapabilities.remove(wire.getCapability());
        }
        Assert.assertTrue((String)("Unexpected capability wire: " + String.valueOf(requiredWires)), (boolean)expectedCapabilities.isEmpty());
    }

    private void checkUsedImports(BundleDescription importer, ExportPackageDescription[] expectedPackages) {
        ExportPackageDescription[] imported = importer.getResolvedImports();
        this.assertEquals("Wrong number of imports for bundle: " + String.valueOf(importer), expectedPackages.length, imported.length);
        int i = 0;
        while (i < imported.length) {
            this.assertEquals("Wrong imported package from bundle: " + String.valueOf(importer), expectedPackages[i], imported[i]);
            ++i;
        }
    }

    private void checkUsedRequires(BundleDescription requirer, BundleDescription[] expectedRequired) {
        BundleDescription[] required = requirer.getResolvedRequires();
        this.assertEquals("Wrong number of imports for bundle: " + String.valueOf(requirer), expectedRequired.length, required.length);
        int i = 0;
        while (i < required.length) {
            this.assertEquals("Wrong required bundle from bundle: " + String.valueOf(requirer), expectedRequired[i], required[i]);
            ++i;
        }
    }

    private void checkUsedCapability(BundleDescription requirer, GenericDescription[] expectedCapabilities) {
        GenericDescription[] required = requirer.getResolvedGenericRequires();
        this.assertEquals("Wrong number of capabilities for bundle: " + String.valueOf(requirer), expectedCapabilities.length, required.length);
        ArrayList<GenericDescription> providedCollection = new ArrayList<GenericDescription>(Arrays.asList(expectedCapabilities));
        GenericDescription[] genericDescriptionArray = required;
        int n = required.length;
        int n2 = 0;
        while (n2 < n) {
            GenericDescription requiredDescription = genericDescriptionArray[n2];
            Assert.assertTrue((String)("Wrong provider for requirement: " + String.valueOf(requiredDescription)), (boolean)providedCollection.remove(requiredDescription));
            ++n2;
        }
    }
}

