/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.osgi.framework.BundleException;

public class PlatformAdminTest
extends AbstractStateTest {
    @Rule
    public TestName testName = new TestName();
    private static final String GENERIC_REQUIRE = "Eclipse-GenericRequire";
    private static final String GENERIC_CAPABILITY = "Eclipse-GenericCapability";

    private State storeAndRetrieve(State toStore) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        toStore.getFactory().writeState(toStore, (OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return toStore.getFactory().readState((InputStream)bais);
    }

    @Test
    public void testCache() throws IOException, BundleException {
        State originalState = this.buildSimpleState();
        State retrievedState = this.storeAndRetrieve(originalState);
        this.assertEquals("0.9", 0, retrievedState.getChanges().getChanges().length);
        this.assertIdentical("1.0", originalState, retrievedState);
        originalState.resolve();
        retrievedState = this.storeAndRetrieve(originalState);
        this.assertIdentical("2.0", originalState, retrievedState);
    }

    @Test
    public void testClone() throws BundleException {
        State original = this.buildSimpleState();
        State newState = original.getFactory().createState(original);
        this.assertEquals("1", original, newState);
        original = this.buildComplexState();
        newState = original.getFactory().createState(original);
        this.assertEquals("2", original, newState);
    }

    @Test
    public void testBug205270() throws BundleException {
        State state = this.buildSimpleState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        int id = 0;
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-NativeCode", "libwrapper-linux-x86-32.so; wrapper-linux-x86-32; osname=linux; processor=x86");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), (long)id++);
        BundleDescription aPrime = state.getFactory().createBundleDescription(a);
        this.assertEquals("Copy is not equal", a, aPrime);
    }

    @Test
    public void testBug184127() throws BundleException, IOException {
        File resolverData = OSGiTestsActivator.getContext().getDataFile(this.testName.getMethodName());
        resolverData.mkdirs();
        State systemState = StateObjectFactory.defaultFactory.createState(true);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        int id = 0;
        manifest = new Hashtable();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription a = systemState.getFactory().createBundleDescription(systemState, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), (long)id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b, c");
        manifest.put("Require-Bundle", "a");
        manifest.put("Import-Package", "afrag2");
        BundleDescription b = systemState.getFactory().createBundleDescription(systemState, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), (long)id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "afrag2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "afrag2");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "c");
        BundleDescription afrag2 = systemState.getFactory().createBundleDescription(systemState, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), (long)id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "afrag1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b");
        BundleDescription afrag1 = systemState.getFactory().createBundleDescription(systemState, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), (long)id++);
        systemState.addBundle(afrag1);
        systemState.addBundle(afrag2);
        systemState.addBundle(a);
        systemState.addBundle(b);
        systemState.resolve();
        Assert.assertTrue((String)"aFrag1 is not resolved", (boolean)afrag1.isResolved());
        Assert.assertTrue((String)"aFrag2 is not resolved", (boolean)afrag2.isResolved());
        Assert.assertTrue((String)"a is not resolved", (boolean)a.isResolved());
        Assert.assertTrue((String)"b is not resolved", (boolean)b.isResolved());
        StateObjectFactory.defaultFactory.writeState(systemState, resolverData);
        systemState = StateObjectFactory.defaultFactory.readState(resolverData);
        Assert.assertNotNull((String)"SystemState is null", (Object)systemState);
        b = systemState.getBundle("b", null);
        ExportPackageDescription[] exports = null;
        exports = b.getExportPackages();
        Assert.assertNotNull((String)"exports is null", (Object)exports);
        this.assertEquals("Wrong number of exports", 2, exports.length);
    }

    @Test
    public void testBug241128_01() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        int id = 0;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription a1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), (long)id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "a; bundle-version=\"[1.0.0, 2.0.0)\"");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), (long)id++);
        state.addBundle(a1);
        state.addBundle(b);
        state.resolve(true);
        Assert.assertTrue((String)"Bundle a1 is not resolved", (boolean)a1.isResolved());
        Assert.assertTrue((String)"Bundle b is not resolved", (boolean)b.isResolved());
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "2.0.0");
        BundleDescription a2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), a1.getBundleId());
        state.updateBundle(a2);
        state.resolve(true);
        Assert.assertTrue((String)"Bundle a2 is not resolved", (boolean)a2.isResolved());
        Assert.assertFalse((String)"Bundle b is resolved", (boolean)b.isResolved());
        VersionConstraint[] unsatisified = state.getStateHelper().getUnsatisfiedLeaves(state.getBundles());
        this.assertEquals("Wrong number of unsatisified leaves", 1, unsatisified.length);
        this.assertEquals("Wrong unsatisfied constraint", (Object)b.getRequiredBundles()[0], unsatisified[0]);
    }

    @Test
    public void testBug241128_02() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        int id = 0;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription a1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), (long)id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a; bundle-version=\"[1.0.0, 2.0.0)\"");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), (long)id++);
        state.addBundle(a1);
        state.addBundle(b);
        state.resolve(true);
        Assert.assertTrue((String)"Bundle a1 is not resolved", (boolean)a1.isResolved());
        Assert.assertTrue((String)"Bundle b is not resolved", (boolean)b.isResolved());
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "2.0.0");
        BundleDescription a2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), a1.getBundleId());
        state.updateBundle(a2);
        state.resolve(true);
        Assert.assertTrue((String)"Bundle a2 is not resolved", (boolean)a2.isResolved());
        Assert.assertFalse((String)"Bundle b is resolved", (boolean)b.isResolved());
        VersionConstraint[] unsatisified = state.getStateHelper().getUnsatisfiedLeaves(state.getBundles());
        this.assertEquals("Wrong number of unsatisified leaves", 1, unsatisified.length);
        this.assertEquals("Wrong unsatisfied constraint", (Object)b.getHost(), unsatisified[0]);
    }

    @Test
    public void testBug241128_03() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        int id = 0;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a; version=1.0");
        BundleDescription a1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), (long)id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "a; version=\"[1.0.0, 2.0.0)\"");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), (long)id++);
        state.addBundle(a1);
        state.addBundle(b);
        state.resolve(true);
        Assert.assertTrue((String)"Bundle a1 is not resolved", (boolean)a1.isResolved());
        Assert.assertTrue((String)"Bundle b is not resolved", (boolean)b.isResolved());
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "2.0.0");
        manifest.put("Export-Package", "a; version=2.0");
        BundleDescription a2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), a1.getBundleId());
        state.updateBundle(a2);
        state.resolve(true);
        Assert.assertTrue((String)"Bundle a2 is not resolved", (boolean)a2.isResolved());
        Assert.assertFalse((String)"Bundle b is resolved", (boolean)b.isResolved());
        VersionConstraint[] unsatisified = state.getStateHelper().getUnsatisfiedLeaves(state.getBundles());
        this.assertEquals("Wrong number of unsatisified leaves", 1, unsatisified.length);
        this.assertEquals("Wrong unsatisfied constraint", (Object)b.getImportPackages()[0], unsatisified[0]);
    }

    @Test
    public void testBug241128_04() throws BundleException {
        State state = this.buildEmptyState();
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("osgi.os", "win32");
        props[0].put("osgi.arch", "x86");
        state.setPlatformProperties(props);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        int id = 0;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-NativeCode", "Bundle-NativeCode: nativefile1.txt;processor=x86;osname=win32");
        BundleDescription a1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), (long)id++);
        state.addBundle(a1);
        state.resolve(true);
        Assert.assertTrue((String)"Bundle a1 is not resolved", (boolean)a1.isResolved());
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "2.0.0");
        manifest.put("Bundle-NativeCode", "Bundle-NativeCode: nativefile1.txt;processor=linux;osname=gtk");
        BundleDescription a2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + "_" + String.valueOf(manifest.get("Bundle-Version")), a1.getBundleId());
        state.updateBundle(a2);
        state.resolve(true);
        Assert.assertFalse((String)"Bundle a2 is resolved", (boolean)a2.isResolved());
        VersionConstraint[] unsatisified = state.getStateHelper().getUnsatisfiedConstraints(a2);
        this.assertEquals("Wrong number of unsatisified leaves", 1, unsatisified.length);
        this.assertEquals("Wrong unsatisfied constraint", a2.getNativeCodeSpecification(), unsatisified[0]);
        unsatisified = state.getStateHelper().getUnsatisfiedLeaves(state.getBundles());
        this.assertEquals("Wrong number of unsatisified leaves", 1, unsatisified.length);
        this.assertEquals("Wrong unsatisfied constraint", a2.getNativeCodeSpecification(), unsatisified[0]);
    }

    @Test
    public void testGenericsBasics() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapablity");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put(GENERIC_CAPABILITY, "foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\"");
        BundleDescription genCap1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put(GENERIC_REQUIRE, "foo; selection-filter=\"(version>=1.3.0)\"");
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap1);
        state.addBundle(genReq);
        state.resolve();
        Assert.assertTrue((String)"Bundle genCap1 is not resolved", (boolean)genCap1.isResolved());
        Assert.assertTrue((String)"Bundle genReq is not resolved", (boolean)genReq.isResolved());
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapablity");
        manifest.put("Bundle-Version", "2.0.0");
        manifest.put(GENERIC_CAPABILITY, "foo; version=\"1.0\"; attr1=\"value1\"; attr2=\"value2\"");
        BundleDescription genCap2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), genCap1.getBundleId());
        state.updateBundle(genCap2);
        state.resolve(true);
        Assert.assertTrue((String)"Bundle genCap2 is not resolved", (boolean)genCap2.isResolved());
        Assert.assertFalse((String)"Bundle genReq is resolved", (boolean)genReq.isResolved());
        VersionConstraint[] unsatisified = state.getStateHelper().getUnsatisfiedLeaves(state.getBundles());
        this.assertEquals("Wrong number of unsatisified leaves", 1, unsatisified.length);
        this.assertEquals("Wrong unsatisfied constraint", genReq.getGenericRequires()[0], unsatisified[0]);
    }
}

