/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class StateComparisonTest
extends AbstractStateTest {
    @Test
    public void testAddition() throws BundleException {
        State state1 = this.buildEmptyState();
        State state2 = state1.getFactory().createState(state1);
        StateDelta delta = state1.compare(state2);
        this.assertEquals("1.0", 0, delta.getChanges().length);
        delta = state2.compare(state1);
        this.assertEquals("1.1", 0, delta.getChanges().length);
        String A_MANIFEST = "Bundle-SymbolicName: org.eclipse.a\nBundle-Version: 1.0\n";
        BundleDescription bundleA = state2.getFactory().createBundleDescription(StateComparisonTest.parseManifest(A_MANIFEST), "org.eclipse.a", -1L);
        Assert.assertTrue((String)"2.0", (boolean)state2.addBundle(bundleA));
        delta = state1.compare(state2);
        this.assertEquals("2.1", 1, delta.getChanges().length);
        BundleDelta removal = delta.getChanges()[0];
        this.assertEquals("2.2", bundleA, removal.getBundle());
        this.assertEquals("2.3", 2, removal.getType());
        delta = state2.compare(state1);
        this.assertEquals("3.1", 1, delta.getChanges().length);
        BundleDelta addition = delta.getChanges()[0];
        this.assertEquals("3.2", bundleA, addition.getBundle());
        this.assertEquals("3.3", 1, addition.getType());
    }

    @Test
    public void testRemoval() throws BundleException {
        State state1 = this.buildSimpleState();
        State state2 = state1.getFactory().createState(state1);
        StateDelta delta = state1.compare(state2);
        this.assertEquals("1.0", 0, delta.getChanges().length);
        delta = state2.compare(state1);
        this.assertEquals("1.1", 0, delta.getChanges().length);
        BundleDescription bundle1 = state1.getBundleByLocation("org.eclipse.b1");
        Assert.assertNotNull((String)"1.9", (Object)bundle1);
        Assert.assertTrue((String)"2.0", (boolean)state1.removeBundle(bundle1));
        delta = state1.compare(state2);
        this.assertEquals("2.1", 1, delta.getChanges().length);
        BundleDelta removal = delta.getChanges()[0];
        this.assertEquals("2.2", bundle1, removal.getBundle());
        this.assertEquals("2.3", 2, removal.getType());
        delta = state2.compare(state1);
        this.assertEquals("3.1", 1, delta.getChanges().length);
        BundleDelta addition = delta.getChanges()[0];
        this.assertEquals("3.2", bundle1, addition.getBundle());
        this.assertEquals("3.3", 1, addition.getType());
    }

    @Test
    public void testUpdate() throws BundleException {
        State state1 = this.buildSimpleState();
        State state2 = state1.getFactory().createState(state1);
        StateDelta delta = state1.compare(state2);
        this.assertEquals("1.0", 0, delta.getChanges().length);
        delta = state2.compare(state1);
        this.assertEquals("1.1", 0, delta.getChanges().length);
        Assert.assertNotNull((String)"1.9", (Object)state1.getBundleByLocation("org.eclipse.b1"));
        String A_MANIFEST = "Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 2.0\n";
        BundleDescription bundle1 = state1.getFactory().createBundleDescription(StateComparisonTest.parseManifest(A_MANIFEST), "org.eclipse.b1", 1L);
        Assert.assertTrue((String)"2.0", (boolean)state1.updateBundle(bundle1));
        delta = state1.compare(state2);
        this.assertEquals("2.1", 1, delta.getChanges().length);
        BundleDelta update = delta.getChanges()[0];
        this.assertEquals("2.2", bundle1, update.getBundle());
        this.assertEquals("2.3", 4, update.getType());
        delta = state2.compare(state1);
        this.assertEquals("3.1", 0, delta.getChanges().length);
    }
}

