/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.util.Hashtable;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class StateCycleTest
extends AbstractStateTest {
    @Test
    public void testCycle1() throws BundleException {
        State state1 = this.buildEmptyState();
        String A_MANIFEST = "Bundle-SymbolicName: org.eclipse.a\nBundle-Version: 1.0\n";
        state1.addBundle(state1.getFactory().createBundleDescription(StateCycleTest.parseManifest(A_MANIFEST), "org.eclipse.a", 1L));
        String B_MANIFEST = "Bundle-SymbolicName: org.eclipse.b\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.a,org.eclipse.c\n";
        state1.addBundle(state1.getFactory().createBundleDescription(StateCycleTest.parseManifest(B_MANIFEST), "org.eclipse.b", 2L));
        String C_MANIFEST = "Bundle-SymbolicName: org.eclipse.c\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.a,org.eclipse.b\n";
        state1.addBundle(state1.getFactory().createBundleDescription(StateCycleTest.parseManifest(C_MANIFEST), "org.eclipse.c", 3L));
        String D_MANIFEST = "Bundle-SymbolicName: org.eclipse.d\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.a,org.eclipse.c\n";
        state1.addBundle(state1.getFactory().createBundleDescription(StateCycleTest.parseManifest(D_MANIFEST), "org.eclipse.d", 4L));
        String E_MANIFEST = "Bundle-SymbolicName: org.eclipse.e\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.a,org.eclipse.b; optional=true\n";
        state1.addBundle(state1.getFactory().createBundleDescription(StateCycleTest.parseManifest(E_MANIFEST), "org.eclipse.e", 5L));
        String F_MANIFEST = "Bundle-SymbolicName: org.eclipse.f\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.f\n";
        state1.addBundle(state1.getFactory().createBundleDescription(StateCycleTest.parseManifest(F_MANIFEST), "org.eclipse.f", 6L));
        State state = state1;
        state.resolve();
        BundleDescription bundleA = state.getBundleByLocation("org.eclipse.a");
        BundleDescription bundleB = state.getBundleByLocation("org.eclipse.b");
        BundleDescription bundleC = state.getBundleByLocation("org.eclipse.c");
        BundleDescription bundleD = state.getBundleByLocation("org.eclipse.d");
        BundleDescription bundleE = state.getBundleByLocation("org.eclipse.e");
        BundleDescription bundleF = state.getBundleByLocation("org.eclipse.f");
        Object[] allBundles = state.getBundles();
        this.assertContains("0.5", allBundles, bundleA);
        this.assertContains("0.6", allBundles, bundleB);
        this.assertContains("0.7", allBundles, bundleC);
        this.assertContains("0.8", allBundles, bundleD);
        this.assertContains("0.9", allBundles, bundleE);
        this.assertContains("0.10", allBundles, bundleF);
        Assert.assertTrue((String)"1.0", (boolean)bundleA.isResolved());
        Assert.assertTrue((String)"2.0", (boolean)bundleB.isResolved());
        Assert.assertTrue((String)"3.0", (boolean)bundleC.isResolved());
        Assert.assertTrue((String)"4.0", (boolean)bundleD.isResolved());
        Assert.assertTrue((String)"5.0", (boolean)bundleE.isResolved());
        Assert.assertTrue((String)"6.0", (boolean)bundleF.isResolved());
    }

    @Test
    public void testCycle2() throws BundleException {
        State state1 = this.buildEmptyState();
        String A_MANIFEST = "Bundle-SymbolicName: org.eclipse.a\nBundle-Version: 1.0\n";
        state1.addBundle(state1.getFactory().createBundleDescription(StateCycleTest.parseManifest(A_MANIFEST), "org.eclipse.a", 1L));
        String B_MANIFEST = "Bundle-SymbolicName: org.eclipse.b\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.a,org.eclipse.c\n";
        state1.addBundle(state1.getFactory().createBundleDescription(StateCycleTest.parseManifest(B_MANIFEST), "org.eclipse.b", 2L));
        String C_MANIFEST = "Bundle-SymbolicName: org.eclipse.c\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.a,org.eclipse.d\n";
        state1.addBundle(state1.getFactory().createBundleDescription(StateCycleTest.parseManifest(C_MANIFEST), "org.eclipse.c", 3L));
        String D_MANIFEST = "Bundle-SymbolicName: org.eclipse.d\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.a,org.eclipse.b\n";
        state1.addBundle(state1.getFactory().createBundleDescription(StateCycleTest.parseManifest(D_MANIFEST), "org.eclipse.d", 4L));
        String E_MANIFEST = "Bundle-SymbolicName: org.eclipse.e\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.a,org.eclipse.b; optional=true\n";
        state1.addBundle(state1.getFactory().createBundleDescription(StateCycleTest.parseManifest(E_MANIFEST), "org.eclipse.e", 5L));
        String F_MANIFEST = "Bundle-SymbolicName: org.eclipse.f\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.f\n";
        state1.addBundle(state1.getFactory().createBundleDescription(StateCycleTest.parseManifest(F_MANIFEST), "org.eclipse.f", 6L));
        State state = state1;
        state.resolve();
        BundleDescription bundleA = state.getBundleByLocation("org.eclipse.a");
        BundleDescription bundleB = state.getBundleByLocation("org.eclipse.b");
        BundleDescription bundleC = state.getBundleByLocation("org.eclipse.c");
        BundleDescription bundleD = state.getBundleByLocation("org.eclipse.d");
        BundleDescription bundleE = state.getBundleByLocation("org.eclipse.e");
        BundleDescription bundleF = state.getBundleByLocation("org.eclipse.f");
        Object[] allBundles = state.getBundles();
        this.assertContains("0.5", allBundles, bundleA);
        this.assertContains("0.6", allBundles, bundleB);
        this.assertContains("0.7", allBundles, bundleC);
        this.assertContains("0.8", allBundles, bundleD);
        this.assertContains("0.9", allBundles, bundleE);
        this.assertContains("0.10", allBundles, bundleF);
        Assert.assertTrue((String)"1.0", (boolean)bundleA.isResolved());
        Assert.assertTrue((String)"2.0", (boolean)bundleB.isResolved());
        Assert.assertTrue((String)"3.0", (boolean)bundleC.isResolved());
        Assert.assertTrue((String)"4.0", (boolean)bundleD.isResolved());
        Assert.assertTrue((String)"5.0", (boolean)bundleE.isResolved());
        Assert.assertTrue((String)"6.0", (boolean)bundleF.isResolved());
    }

    @Test
    public void testCycle3() throws BundleException {
        State state = this.buildEmptyState();
        String A_MANIFEST = "Bundle-SymbolicName: org.eclipse.a\nBundle-Version: 1.0\n";
        state.addBundle(state.getFactory().createBundleDescription(StateCycleTest.parseManifest(A_MANIFEST), "org.eclipse.a", 1L));
        String B_MANIFEST = "Bundle-SymbolicName: org.eclipse.b\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.c\n";
        state.addBundle(state.getFactory().createBundleDescription(StateCycleTest.parseManifest(B_MANIFEST), "org.eclipse.b", 2L));
        String C_MANIFEST = "Bundle-SymbolicName: org.eclipse.c\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.d\n";
        state.addBundle(state.getFactory().createBundleDescription(StateCycleTest.parseManifest(C_MANIFEST), "org.eclipse.c", 3L));
        String D_MANIFEST = "Bundle-SymbolicName: org.eclipse.d\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.b\n";
        state.addBundle(state.getFactory().createBundleDescription(StateCycleTest.parseManifest(D_MANIFEST), "org.eclipse.d", 4L));
        state.resolve();
        BundleDescription bundleC = state.getBundleByLocation("org.eclipse.c");
        BundleDescription bundleB = state.getBundleByLocation("org.eclipse.b");
        BundleDescription bundleA = state.getBundleByLocation("org.eclipse.a");
        BundleDescription bundleD = state.getBundleByLocation("org.eclipse.d");
        Object[] allBundles = state.getBundles();
        this.assertContains("0.5", allBundles, bundleC);
        this.assertContains("0.6", allBundles, bundleB);
        this.assertContains("0.7", allBundles, bundleA);
        this.assertContains("0.8", allBundles, bundleD);
        Assert.assertTrue((String)"0.9", (boolean)bundleA.isResolved());
        Assert.assertTrue((String)"1.0", (boolean)bundleC.isResolved());
        Assert.assertTrue((String)"2.0", (boolean)bundleB.isResolved());
        Assert.assertTrue((String)"3.0", (boolean)bundleD.isResolved());
    }

    @Test
    public void testCycle4() throws BundleException {
        State state = this.buildEmptyState();
        String A_MANIFEST = "Bundle-SymbolicName: org.eclipse.a\nBundle-Version: 1.0\n";
        state.addBundle(state.getFactory().createBundleDescription(StateCycleTest.parseManifest(A_MANIFEST), "org.eclipse.a", 1L));
        String B_MANIFEST = "Bundle-SymbolicName: org.eclipse.b\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.c\n";
        state.addBundle(state.getFactory().createBundleDescription(StateCycleTest.parseManifest(B_MANIFEST), "org.eclipse.b", 2L));
        String C_MANIFEST = "Bundle-SymbolicName: org.eclipse.c\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.d\n";
        state.addBundle(state.getFactory().createBundleDescription(StateCycleTest.parseManifest(C_MANIFEST), "org.eclipse.c", 3L));
        String D_MANIFEST = "Bundle-SymbolicName: org.eclipse.d\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.b; optional=true\n";
        state.addBundle(state.getFactory().createBundleDescription(StateCycleTest.parseManifest(D_MANIFEST), "org.eclipse.d", 4L));
        state.resolve();
        BundleDescription bundleC = state.getBundleByLocation("org.eclipse.c");
        BundleDescription bundleB = state.getBundleByLocation("org.eclipse.b");
        BundleDescription bundleA = state.getBundleByLocation("org.eclipse.a");
        BundleDescription bundleD = state.getBundleByLocation("org.eclipse.d");
        Object[] allBundles = state.getBundles();
        this.assertContains("0.5", allBundles, bundleC);
        this.assertContains("0.6", allBundles, bundleB);
        this.assertContains("0.7", allBundles, bundleA);
        this.assertContains("0.8", allBundles, bundleD);
        Assert.assertTrue((String)"0.9", (boolean)bundleA.isResolved());
        Assert.assertTrue((String)"1.0", (boolean)bundleC.isResolved());
        Assert.assertTrue((String)"2.0", (boolean)bundleB.isResolved());
        Assert.assertTrue((String)"3.0", (boolean)bundleD.isResolved());
    }

    @Test
    public void test185285() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "X");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "foo; version=\"1.0.0\", bar; version=\"1.0.0\"");
        manifest.put("Import-Package", "foo, bar");
        BundleDescription a_100 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "X");
        manifest.put("Bundle-Version", "1.0.1");
        manifest.put("Export-Package", "foo; version=\"1.0.0\", bar; version=\"1.0.0\"");
        manifest.put("Import-Package", "foo, bar");
        BundleDescription a_101 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(a_100);
        state.addBundle(a_101);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)a_100.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)a_101.isResolved());
        ExportPackageDescription[] selectedExportsA100 = a_100.getSelectedExports();
        ExportPackageDescription[] selectedExportsA101 = a_101.getSelectedExports();
        Assert.assertTrue((String)"2.0", (selectedExportsA100.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (selectedExportsA101.length == 0 ? 1 : 0) != 0);
        ExportPackageDescription[] resolvedImportsA100 = a_100.getResolvedImports();
        ExportPackageDescription[] resolvedImportsA101 = a_100.getResolvedImports();
        Assert.assertTrue((String)"3.0", (resolvedImportsA100.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.1", (resolvedImportsA101.length == 2 ? 1 : 0) != 0);
        int i = 0;
        while (i < resolvedImportsA100.length) {
            Assert.assertTrue((String)("3.2.1." + i), (selectedExportsA100[i] == resolvedImportsA100[i] ? 1 : 0) != 0);
            Assert.assertTrue((String)("3.2.1." + i), (selectedExportsA100[i] == resolvedImportsA101[i] ? 1 : 0) != 0);
            ++i;
        }
    }
}

