/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.util.Hashtable;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class SubstitutableExportsTest
extends AbstractStateTest {
    private State getSubstituteBasicState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; z; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        return state;
    }

    private State getSubstituteUsesState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; version=0.5; bundle=Z, z; uses:=x; version=1.0");
        BundleDescription z = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Import-Package", "x;  bundle=Z");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(z);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        return state;
    }

    private State getSubstituteUsesCycleState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; z; version=0.5");
        BundleDescription z = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,z\"");
        manifest.put("Import-Package", "x; y; z; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,z\"");
        manifest.put("Import-Package", "x; y; z; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,z\"");
        manifest.put("Import-Package", "x; y; z; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        manifest.put("Import-Package", "z");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        manifest.put("Import-Package", "z");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Import-Package", "z");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Export-Package", "z; version=1.0; uses:=x");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Export-Package", "z; version=1.0; uses:=x");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(z);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        return state;
    }

    private State getSubstituteBasicFragState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "AFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A");
        manifest.put("Export-Package", "z; version=1.0");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription aFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "BFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "B");
        manifest.put("Export-Package", "z; version=1.0");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription bFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "CFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "C");
        manifest.put("Export-Package", "z; version=1.0");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription cFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(aFrag);
        state.addBundle(b);
        state.addBundle(bFrag);
        state.addBundle(c);
        state.addBundle(cFrag);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        return state;
    }

    private State getSubstituteUsesFragState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; version=0.5; bundle=Z");
        BundleDescription z = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "AFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A");
        manifest.put("Export-Package", "z; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription aFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "BFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "B");
        manifest.put("Export-Package", "z; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription bFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "CFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "C");
        manifest.put("Export-Package", "z; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription cFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Import-Package", "x;  bundle=Z");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(z);
        state.addBundle(a);
        state.addBundle(aFrag);
        state.addBundle(b);
        state.addBundle(bFrag);
        state.addBundle(c);
        state.addBundle(cFrag);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        return state;
    }

    private State getSubstituteUsesFragCycleState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; z; version=2.0");
        BundleDescription z = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,q\"");
        manifest.put("Import-Package", "x; y; version=\"[1.0,2.0)\", q");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "AFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A");
        manifest.put("Export-Package", "z; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "z; version=\"[1.0,2.0)\"");
        BundleDescription aFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,q\"");
        manifest.put("Import-Package", "x; y; version=\"[1.0,2.0)\", q");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "BFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "B");
        manifest.put("Export-Package", "z; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "z; version=\"[1.0,2.0)\"");
        BundleDescription bFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,q\"");
        manifest.put("Import-Package", "x; y; version=\"[1.0,2.0)\", q");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "CFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "C");
        manifest.put("Export-Package", "z; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "z; version=\"[1.0,2.0)\"");
        BundleDescription cFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Export-Package", "q; version=1.0; uses:=x");
        manifest.put("Import-Package", "q; version=1.0");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Export-Package", "q; version=1.0; uses:=x");
        manifest.put("Import-Package", "q; version=1.0");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "I");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Import-Package", "q; x; version=1.0");
        BundleDescription i = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(z);
        state.addBundle(a);
        state.addBundle(aFrag);
        state.addBundle(b);
        state.addBundle(bFrag);
        state.addBundle(c);
        state.addBundle(cFrag);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.addBundle(i);
        return state;
    }

    private State getSubstituteBasicReexportState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A; visibility:=reexport");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B; visibility:=reexport");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C; visibility:=reexport");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "D");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "E");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "I");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        BundleDescription i = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.addBundle(i);
        return state;
    }

    private State getSubstituteUsesReexportState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; version=0.5; bundle=Z");
        BundleDescription z = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A; visibility:=reexport");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B; visibility:=reexport");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C; visibility:=reexport");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "D");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "E");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "I");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        BundleDescription i = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "J");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        manifest.put("Import-Package", "x;  bundle=Z");
        BundleDescription j = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(z);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.addBundle(i);
        state.addBundle(j);
        return state;
    }

    private State getSubstituteUsesReexportCycleState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; z; version=2.0");
        BundleDescription z = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,z\"");
        manifest.put("Import-Package", "x; y; z; version=\"[1.0,2.0)\"");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,z\"");
        manifest.put("Import-Package", "x; y; z; version=\"[1.0,2.0)\"");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,z\"");
        manifest.put("Import-Package", "x; y; z; version=\"[1.0,2.0)\"");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A; visibility:=reexport");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B; visibility:=reexport");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C; visibility:=reexport");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "D");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "E");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "I");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        BundleDescription i = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "J");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        manifest.put("Export-Package", "z; version=1.0; uses=\"x,y\"");
        manifest.put("Import-Package", "z; version=\"[1.0,2.0)\"");
        BundleDescription j = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(z);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.addBundle(i);
        state.addBundle(j);
        return state;
    }

    private State getSubstituteUnresolvedFragState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "AFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A");
        manifest.put("Export-Package", "z; version=1.0");
        manifest.put("Import-Package", "z; q; version=1.0");
        BundleDescription aFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "BFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "B");
        manifest.put("Export-Package", "z; version=1.0");
        manifest.put("Import-Package", "z; q; version=1.0");
        BundleDescription bFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "CFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "C");
        manifest.put("Export-Package", "z; version=1.0");
        manifest.put("Import-Package", "z, q; version=1.0");
        BundleDescription cFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(aFrag);
        state.addBundle(b);
        state.addBundle(bFrag);
        state.addBundle(c);
        state.addBundle(cFrag);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        return state;
    }

    private State getSubstituteSplitState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; split=split; mandatory:=split");
        manifest.put("Import-Package", "x; y; version=1.0; split=split");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; split=split; mandatory:=split");
        manifest.put("Import-Package", "x; y; version=1.0; split=split");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; split=split; mandatory:=split");
        manifest.put("Import-Package", "x; y; version=1.0; split=split");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "D");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "I");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "E");
        BundleDescription i = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "J");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        BundleDescription j = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.addBundle(i);
        state.addBundle(j);
        return state;
    }

    private State getSubstituteSplitUsesState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; split=split; mandatory:=split; uses:=\"x,y,q\"");
        manifest.put("Import-Package", "x; y; version=1.0; split=split, q; version=\"[1.0,2.0)\"");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; split=split; mandatory:=split; uses:=\"x,y,q\"");
        manifest.put("Import-Package", "x; y; version=1.0; split=split, q; version=\"[1.0,2.0)\"");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; split=split; mandatory:=split; uses:=\"x,y,q\"");
        manifest.put("Import-Package", "x; y; version=1.0; split=split, q; version=\"[1.0,2.0)\"");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,r\"");
        manifest.put("Import-Package", "x; y; version=1.0, r; version=\"[1.0,2.0)\"");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,r\"");
        manifest.put("Import-Package", "x; y; version=1.0, r; version=\"[1.0,2.0)\"");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,r\"");
        manifest.put("Import-Package", "x; y; version=1.0, r; version=\"[1.0,2.0)\"");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "D");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "I");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "E");
        BundleDescription i = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "J");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        BundleDescription j = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "K");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "q; r; version=2.0");
        BundleDescription k = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "L");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "q; r; version=1.0");
        BundleDescription l = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "M");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "x, y, q, r");
        BundleDescription m = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "N");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "q, r");
        manifest.put("Require-Bundle", "F");
        BundleDescription n = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.addBundle(i);
        state.addBundle(j);
        state.addBundle(k);
        state.addBundle(l);
        state.addBundle(m);
        state.addBundle(n);
        return state;
    }

    private State getNonOverlapingSubstituteBasicState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0; nomatch=nomatch");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        return state;
    }

    @Test
    public void testSubstitutableExports001() throws BundleException {
        State state = this.getSubstituteBasicState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        this.assertEquals("aVisible wrong number", 0, aVisible.length);
        this.assertEquals("bVisible wrong number", 2, bVisible.length);
        this.assertEquals("cVisible wrong number", 2, cVisible.length);
        this.assertEquals("dVisible wrong number", 3, dVisible.length);
        this.assertEquals("eVisible wrong number", 2, eVisible.length);
        this.assertEquals("fVisible wrong number", 2, fVisible.length);
        Object[] aExports = a.getSelectedExports();
        Object[] aSubtitutes = new ExportPackageDescription[]{aExports[0], aExports[1]};
        Assert.assertArrayEquals((String)"aVisible not correct", (Object[])aExports, (Object[])a.getExportPackages());
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])aSubtitutes, (Object[])bVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])aSubtitutes, (Object[])cVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])aSubtitutes, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])aSubtitutes, (Object[])fVisible);
    }

    @Test
    public void testSubstitutableExports002() throws BundleException {
        State state = this.getSubstituteUsesState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        Assert.assertFalse((String)"1.6", (boolean)g.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        ExportPackageDescription[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        Assert.assertNotNull((String)"gVisible is null", (Object)gVisible);
        this.assertEquals("aVisible wrong number", 0, aVisible.length);
        this.assertEquals("bVisible wrong number", 2, bVisible.length);
        this.assertEquals("cVisible wrong number", 2, cVisible.length);
        this.assertEquals("dVisible wrong number", 2, dVisible.length);
        this.assertEquals("eVisible wrong number", 2, eVisible.length);
        this.assertEquals("fVisible wrong number", 2, fVisible.length);
        this.assertEquals("gVisible wrong number", 0, gVisible.length);
        Object[] aExports = a.getSelectedExports();
        Assert.assertArrayEquals((String)"aVisible not correct", (Object[])aExports, (Object[])a.getExportPackages());
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])aExports, (Object[])bVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])aExports, (Object[])cVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])aExports, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])aExports, (Object[])fVisible);
    }

    @Test
    public void testSubstitutableExports003() throws BundleException {
        State state = this.getSubstituteUsesCycleState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        BundleDescription h = state.getBundle(8L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        Assert.assertTrue((String)"1.6", (boolean)g.isResolved());
        Assert.assertTrue((String)"1.7", (boolean)h.isResolved());
        Object[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        Assert.assertNotNull((String)"gVisible is null", (Object)gVisible);
        this.assertEquals("aVisible wrong number", 1, aVisible.length);
        this.assertEquals("bVisible wrong number", 3, bVisible.length);
        this.assertEquals("cVisible wrong number", 3, cVisible.length);
        this.assertEquals("dVisible wrong number", 3, dVisible.length);
        this.assertEquals("eVisible wrong number", 3, eVisible.length);
        this.assertEquals("fVisible wrong number", 3, fVisible.length);
        this.assertEquals("gVisible wrong number", 2, gVisible.length);
        this.assertEquals("hVisible wrong number", 3, hVisible.length);
        ExportPackageDescription[] aExported = a.getSelectedExports();
        ExportPackageDescription[] gExported = g.getSelectedExports();
        ExportPackageDescription[] expected = new ExportPackageDescription[aExported.length + gExported.length];
        System.arraycopy(aExported, 0, expected, 0, aExported.length);
        System.arraycopy(gExported, 0, expected, aExported.length, gExported.length);
        int i = 0;
        while (i < expected.length) {
            if (i == 2) {
                this.assertContains("aVisible not correct", aVisible, expected[i]);
            }
            this.assertContains("bVisible not correct", bVisible, expected[i]);
            this.assertContains("cVisible not correct", cVisible, expected[i]);
            this.assertContains("dVisible not correct", dVisible, expected[i]);
            this.assertContains("eVisible not correct", eVisible, expected[i]);
            this.assertContains("fVisible not correct", fVisible, expected[i]);
            if (i == 0 || i == 1) {
                this.assertContains("gVisible not correct", gVisible, expected[i]);
            }
            this.assertContains("hVisible not correct", hVisible, expected[i]);
            ++i;
        }
    }

    @Test
    public void testSubstitutableExports004() throws BundleException {
        State state = this.getSubstituteBasicFragState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription aFrag = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription bFrag = state.getBundle(3L);
        BundleDescription c = state.getBundle(4L);
        BundleDescription cFrag = state.getBundle(5L);
        BundleDescription d = state.getBundle(6L);
        BundleDescription e = state.getBundle(7L);
        BundleDescription f = state.getBundle(8L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.0.1", (boolean)aFrag.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.1.1", (boolean)bFrag.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.2.1", (boolean)cFrag.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        ExportPackageDescription[] aFragVisible = state.getStateHelper().getVisiblePackages(aFrag);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] bFragVisible = state.getStateHelper().getVisiblePackages(bFrag);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] cFragVisible = state.getStateHelper().getVisiblePackages(cFrag);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"aFragVisible is null", (Object)aFragVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"bFragVisible is null", (Object)bFragVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"cFragVisible is null", (Object)cFragVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        this.assertEquals("aVisible wrong number", 0, aVisible.length);
        this.assertEquals("aFragVisible wrong number", 0, aFragVisible.length);
        this.assertEquals("bVisible wrong number", 2, bVisible.length);
        this.assertEquals("bFragVisible wrong number", 1, bFragVisible.length);
        this.assertEquals("cVisible wrong number", 2, cVisible.length);
        this.assertEquals("cFragVisible wrong number", 1, cFragVisible.length);
        this.assertEquals("dVisible wrong number", 3, dVisible.length);
        this.assertEquals("eVisible wrong number", 3, eVisible.length);
        this.assertEquals("fVisible wrong number", 3, fVisible.length);
        Object[] aExports = a.getSelectedExports();
        this.assertEquals("a has wrong number of exports", 3, aExports.length);
        Object[] aDeclaredExports = a.getExportPackages();
        Object[] aFragExports = new ExportPackageDescription[]{aExports[2]};
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])aDeclaredExports, (Object[])bVisible);
        Assert.assertArrayEquals((String)"bFragVisible not correct", (Object[])aFragExports, (Object[])bFragVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])aDeclaredExports, (Object[])cVisible);
        Assert.assertArrayEquals((String)"cFragVisible not correct", (Object[])aFragExports, (Object[])cFragVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])aExports, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])aExports, (Object[])fVisible);
    }

    @Test
    public void testSubstitutableExports005() throws BundleException {
        State state = this.getSubstituteUsesFragState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription aFrag = state.getBundle(2L);
        BundleDescription b = state.getBundle(3L);
        BundleDescription bFrag = state.getBundle(4L);
        BundleDescription c = state.getBundle(5L);
        BundleDescription cFrag = state.getBundle(6L);
        BundleDescription d = state.getBundle(7L);
        BundleDescription e = state.getBundle(8L);
        BundleDescription f = state.getBundle(9L);
        BundleDescription g = state.getBundle(10L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.0.1", (boolean)aFrag.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.1.1", (boolean)bFrag.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.2.1", (boolean)cFrag.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        Assert.assertFalse((String)"1.6", (boolean)g.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        ExportPackageDescription[] aFragVisible = state.getStateHelper().getVisiblePackages(aFrag);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] bFragVisible = state.getStateHelper().getVisiblePackages(bFrag);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] cFragVisible = state.getStateHelper().getVisiblePackages(cFrag);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        ExportPackageDescription[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"aFragVisible is null", (Object)aFragVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"bFragVisible is null", (Object)bFragVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"cFragVisible is null", (Object)cFragVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        Assert.assertNotNull((String)"gVisible is null", (Object)gVisible);
        this.assertEquals("aVisible wrong number", 0, aVisible.length);
        this.assertEquals("aFragVisible wrong number", 0, aFragVisible.length);
        this.assertEquals("bVisible wrong number", 2, bVisible.length);
        this.assertEquals("bFragVisible wrong number", 1, bFragVisible.length);
        this.assertEquals("cVisible wrong number", 2, cVisible.length);
        this.assertEquals("cFragVisible wrong number", 1, cFragVisible.length);
        this.assertEquals("dVisible wrong number", 3, dVisible.length);
        this.assertEquals("eVisible wrong number", 3, eVisible.length);
        this.assertEquals("fVisible wrong number", 3, fVisible.length);
        this.assertEquals("gVisible wrong number", 0, gVisible.length);
        Object[] aExports = a.getSelectedExports();
        this.assertEquals("a has wrong number of exports", 3, aExports.length);
        Object[] aDeclaredExports = a.getExportPackages();
        Object[] aFragExports = new ExportPackageDescription[]{aExports[2]};
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])aDeclaredExports, (Object[])bVisible);
        Assert.assertArrayEquals((String)"bFragVisible not correct", (Object[])aFragExports, (Object[])bFragVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])aDeclaredExports, (Object[])cVisible);
        Assert.assertArrayEquals((String)"cFragVisible not correct", (Object[])aFragExports, (Object[])cFragVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])aExports, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])aExports, (Object[])fVisible);
    }

    @Test
    public void testSubstitutableExports006() throws BundleException {
        State state = this.getSubstituteUsesFragCycleState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription aFrag = state.getBundle(2L);
        BundleDescription b = state.getBundle(3L);
        BundleDescription bFrag = state.getBundle(4L);
        BundleDescription c = state.getBundle(5L);
        BundleDescription cFrag = state.getBundle(6L);
        BundleDescription d = state.getBundle(7L);
        BundleDescription e = state.getBundle(8L);
        BundleDescription f = state.getBundle(9L);
        BundleDescription g = state.getBundle(10L);
        BundleDescription h = state.getBundle(11L);
        BundleDescription i = state.getBundle(12L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.0.1", (boolean)aFrag.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.1.1", (boolean)bFrag.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.2.1", (boolean)cFrag.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        Assert.assertTrue((String)"1.6", (boolean)g.isResolved());
        Assert.assertTrue((String)"1.7", (boolean)h.isResolved());
        Assert.assertTrue((String)"1.7", (boolean)i.isResolved());
        Object[] aVisible = state.getStateHelper().getVisiblePackages(a);
        ExportPackageDescription[] aFragVisible = state.getStateHelper().getVisiblePackages(aFrag);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] bFragVisible = state.getStateHelper().getVisiblePackages(bFrag);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] cFragVisible = state.getStateHelper().getVisiblePackages(cFrag);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Object[] iVisible = state.getStateHelper().getVisiblePackages(i);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"aFragVisible is null", (Object)aFragVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"bFragVisible is null", (Object)bFragVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"cFragVisible is null", (Object)cFragVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        Assert.assertNotNull((String)"gVisible is null", (Object)gVisible);
        Assert.assertNotNull((String)"gVisible is null", (Object)hVisible);
        Assert.assertNotNull((String)"iVisible is null", (Object)iVisible);
        this.assertEquals("aVisible wrong number", 1, aVisible.length);
        this.assertEquals("aFragVisible wrong number", 0, aFragVisible.length);
        this.assertEquals("bVisible wrong number", 3, bVisible.length);
        this.assertEquals("bFragVisible wrong number", 1, bFragVisible.length);
        this.assertEquals("cVisible wrong number", 3, cVisible.length);
        this.assertEquals("cFragVisible wrong number", 1, cFragVisible.length);
        this.assertEquals("dVisible wrong number", 3, dVisible.length);
        this.assertEquals("eVisible wrong number", 3, eVisible.length);
        this.assertEquals("fVisible wrong number", 3, fVisible.length);
        this.assertEquals("gVisible wrong number", 3, gVisible.length);
        this.assertEquals("hVisible wrong number", 4, hVisible.length);
        this.assertEquals("iVisible wrong number", 4, iVisible.length);
        Object[] aExports = a.getSelectedExports();
        this.assertEquals("a has wrong number of exports", 3, aExports.length);
        ExportPackageDescription[] aDeclaredExports = a.getExportPackages();
        Object[] bcExpectedVisible = new ExportPackageDescription[aDeclaredExports.length + 1];
        System.arraycopy(aDeclaredExports, 0, bcExpectedVisible, 0, aDeclaredExports.length);
        bcExpectedVisible[2] = g.getSelectedExports()[0];
        Object[] aFragExports = new ExportPackageDescription[]{aExports[2]};
        Assert.assertArrayEquals((String)"aVisible not correct", (Object[])g.getSelectedExports(), (Object[])aVisible);
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])bcExpectedVisible, (Object[])bVisible);
        Assert.assertArrayEquals((String)"bFragVisible not correct", (Object[])aFragExports, (Object[])bFragVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])bcExpectedVisible, (Object[])cVisible);
        Assert.assertArrayEquals((String)"cFragVisible not correct", (Object[])aFragExports, (Object[])cFragVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])aExports, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])aExports, (Object[])fVisible);
        ExportPackageDescription[] gExports = g.getSelectedExports();
        this.assertEquals("g has wrong number of exports", 1, gExports.length);
        Object[] expectedHIVisible = new ExportPackageDescription[]{gExports[0], aExports[0], aExports[1], aExports[2]};
        Assert.assertArrayEquals((String)"gVisible not correct", (Object[])aExports, (Object[])gVisible);
        Assert.assertArrayEquals((String)"hVisible not correct", (Object[])expectedHIVisible, (Object[])hVisible);
        Assert.assertArrayEquals((String)"iVisible not correct", (Object[])expectedHIVisible, (Object[])iVisible);
    }

    @Test
    public void testSubstitutableExports007() throws BundleException {
        State state = this.getSubstituteBasicReexportState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        BundleDescription g = state.getBundle(5L);
        BundleDescription h = state.getBundle(5L);
        BundleDescription i = state.getBundle(5L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)g.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)h.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)i.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Object[] iVisible = state.getStateHelper().getVisiblePackages(i);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        Assert.assertNotNull((String)"gVisible is null", (Object)gVisible);
        Assert.assertNotNull((String)"hVisible is null", (Object)hVisible);
        Assert.assertNotNull((String)"iVisible is null", (Object)iVisible);
        this.assertEquals("aVisible wrong number", 0, aVisible.length);
        this.assertEquals("bVisible wrong number", 2, bVisible.length);
        this.assertEquals("cVisible wrong number", 2, cVisible.length);
        this.assertEquals("dVisible wrong number", 2, dVisible.length);
        this.assertEquals("eVisible wrong number", 2, eVisible.length);
        this.assertEquals("fVisible wrong number", 2, fVisible.length);
        this.assertEquals("gVisible wrong number", 2, gVisible.length);
        this.assertEquals("hVisible wrong number", 2, hVisible.length);
        this.assertEquals("iVisible wrong number", 2, iVisible.length);
        Object[] aExports = a.getSelectedExports();
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])aExports, (Object[])bVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])aExports, (Object[])cVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])aExports, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])aExports, (Object[])fVisible);
        Assert.assertArrayEquals((String)"gVisible not correct", (Object[])aExports, (Object[])gVisible);
        Assert.assertArrayEquals((String)"hVisible not correct", (Object[])aExports, (Object[])hVisible);
        Assert.assertArrayEquals((String)"iVisible not correct", (Object[])aExports, (Object[])iVisible);
    }

    @Test
    public void testSubstitutableExports008() throws BundleException {
        State state = this.getSubstituteUsesReexportState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        BundleDescription h = state.getBundle(8L);
        BundleDescription i = state.getBundle(9L);
        BundleDescription j = state.getBundle(10L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        Assert.assertTrue((String)"1.6", (boolean)g.isResolved());
        Assert.assertTrue((String)"1.7", (boolean)h.isResolved());
        Assert.assertTrue((String)"1.8", (boolean)i.isResolved());
        Assert.assertFalse((String)"1.9", (boolean)j.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Object[] iVisible = state.getStateHelper().getVisiblePackages(i);
        ExportPackageDescription[] jVisible = state.getStateHelper().getVisiblePackages(j);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        Assert.assertNotNull((String)"gVisible is null", (Object)gVisible);
        Assert.assertNotNull((String)"hVisible is null", (Object)hVisible);
        Assert.assertNotNull((String)"iVisible is null", (Object)iVisible);
        Assert.assertNotNull((String)"jVisible is null", (Object)jVisible);
        this.assertEquals("aVisible wrong number", 0, aVisible.length);
        this.assertEquals("bVisible wrong number", 2, bVisible.length);
        this.assertEquals("cVisible wrong number", 2, cVisible.length);
        this.assertEquals("dVisible wrong number", 2, dVisible.length);
        this.assertEquals("eVisible wrong number", 2, eVisible.length);
        this.assertEquals("fVisible wrong number", 2, fVisible.length);
        this.assertEquals("gVisible wrong number", 2, gVisible.length);
        this.assertEquals("hVisible wrong number", 2, hVisible.length);
        this.assertEquals("iVisible wrong number", 2, iVisible.length);
        this.assertEquals("jVisible wrong number", 0, jVisible.length);
        Object[] aExports = a.getSelectedExports();
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])aExports, (Object[])bVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])aExports, (Object[])cVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])aExports, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])aExports, (Object[])fVisible);
        Assert.assertArrayEquals((String)"gVisible not correct", (Object[])aExports, (Object[])gVisible);
        Assert.assertArrayEquals((String)"hVisible not correct", (Object[])aExports, (Object[])hVisible);
        Assert.assertArrayEquals((String)"iVisible not correct", (Object[])aExports, (Object[])iVisible);
    }

    @Test
    public void testSubstitutableExports009() throws BundleException {
        State state = this.getSubstituteUsesReexportCycleState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        BundleDescription h = state.getBundle(8L);
        BundleDescription i = state.getBundle(9L);
        BundleDescription j = state.getBundle(10L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        Assert.assertTrue((String)"1.6", (boolean)g.isResolved());
        Assert.assertTrue((String)"1.7", (boolean)h.isResolved());
        Assert.assertTrue((String)"1.8", (boolean)i.isResolved());
        Assert.assertTrue((String)"1.9", (boolean)j.isResolved());
        Object[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Object[] iVisible = state.getStateHelper().getVisiblePackages(i);
        Object[] jVisible = state.getStateHelper().getVisiblePackages(j);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        Assert.assertNotNull((String)"gVisible is null", (Object)gVisible);
        Assert.assertNotNull((String)"hVisible is null", (Object)hVisible);
        Assert.assertNotNull((String)"iVisible is null", (Object)iVisible);
        Assert.assertNotNull((String)"jVisible is null", (Object)jVisible);
        this.assertEquals("aVisible wrong number", 1, aVisible.length);
        this.assertEquals("bVisible wrong number", 3, bVisible.length);
        this.assertEquals("cVisible wrong number", 3, cVisible.length);
        this.assertEquals("dVisible wrong number", 2, dVisible.length);
        this.assertEquals("eVisible wrong number", 2, eVisible.length);
        this.assertEquals("fVisible wrong number", 2, fVisible.length);
        this.assertEquals("gVisible wrong number", 2, gVisible.length);
        this.assertEquals("hVisible wrong number", 2, hVisible.length);
        this.assertEquals("iVisible wrong number", 2, iVisible.length);
        this.assertEquals("jVisible wrong number", 2, jVisible.length);
        Object[] aExports = a.getSelectedExports();
        this.assertEquals("aExports count wrong", 2, aExports.length);
        Object[] jExports = j.getSelectedExports();
        this.assertEquals("aExports count wrong", 1, jExports.length);
        Object[] bcExpected = new ExportPackageDescription[]{aExports[0], aExports[1], jExports[0]};
        Assert.assertArrayEquals((String)"aVisible not correct", (Object[])jExports, (Object[])aVisible);
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])bcExpected, (Object[])bVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])bcExpected, (Object[])cVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])aExports, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])aExports, (Object[])fVisible);
        Assert.assertArrayEquals((String)"gVisible not correct", (Object[])aExports, (Object[])gVisible);
        Assert.assertArrayEquals((String)"hVisible not correct", (Object[])aExports, (Object[])hVisible);
        Assert.assertArrayEquals((String)"iVisible not correct", (Object[])aExports, (Object[])iVisible);
        Assert.assertArrayEquals((String)"jVisible not correct", (Object[])aExports, (Object[])jVisible);
    }

    @Test
    public void testSubstitutableExports010() throws BundleException {
        State state = this.getSubstituteBasicState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        BundleDescription[] allBundles = new BundleDescription[]{a, b, c, d, e, f};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 6, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription description = bundleDescriptionArray[n2];
            boolean found = false;
            int j = 0;
            while (j < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[j]), 8, bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == description;
                ++j;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n2;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 1, bundleDeltas.length);
    }

    @Test
    public void testSubstitutableExports011() throws BundleException {
        State state = this.getSubstituteUsesState();
        state.resolve();
        BundleDescription z = state.getBundle(0L);
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription[] allRefreshBundles = new BundleDescription[]{a, b, c, d, e, f};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 6, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray = allRefreshBundles;
        int n = allRefreshBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription description = bundleDescriptionArray[n2];
            boolean found = false;
            int j = 0;
            while (j < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[j]), 8, bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == description;
                ++j;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n2;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 1, bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{z});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 1, bundleDeltas.length);
    }

    @Test
    public void testSubstitutableExports012() throws BundleException {
        int j;
        boolean found;
        BundleDescription description;
        State state = this.getSubstituteUsesCycleState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        BundleDescription h = state.getBundle(8L);
        BundleDescription[] allRefreshBundles = new BundleDescription[]{a, b, c, d, e, f, g, h};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 8, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray = allRefreshBundles;
        int n = allRefreshBundles.length;
        int n2 = 0;
        while (n2 < n) {
            description = bundleDescriptionArray[n2];
            found = false;
            j = 0;
            while (j < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[j]), 8, bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == description;
                ++j;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n2;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 1, bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{c});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 8, bundleDeltas.length);
        bundleDescriptionArray = allRefreshBundles;
        n = allRefreshBundles.length;
        n2 = 0;
        while (n2 < n) {
            description = bundleDescriptionArray[n2];
            found = false;
            j = 0;
            while (j < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[j]), 8, bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == description;
                ++j;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n2;
        }
    }

    @Test
    public void testSubstitutableExports013() throws BundleException {
        State state = this.getSubstituteBasicFragState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription aFrag = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription bFrag = state.getBundle(3L);
        BundleDescription c = state.getBundle(4L);
        BundleDescription cFrag = state.getBundle(5L);
        BundleDescription d = state.getBundle(6L);
        BundleDescription e = state.getBundle(7L);
        BundleDescription f = state.getBundle(8L);
        BundleDescription[] allBundles = new BundleDescription[]{a, aFrag, b, bFrag, c, cFrag, d, e, f};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 9, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription description = bundleDescriptionArray[n2];
            boolean found = false;
            int j = 0;
            while (j < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[j]), 8, bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == description;
                ++j;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n2;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 1, bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{c});
        bundleDeltas = stateDelta.getChanges();
        BundleDescription[] expectedRefresh = new BundleDescription[]{c, cFrag, f};
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 3, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray2 = expectedRefresh;
        int n3 = expectedRefresh.length;
        n = 0;
        while (n < n3) {
            BundleDescription description = bundleDescriptionArray2[n];
            boolean found = false;
            int j = 0;
            while (j < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[j]), 8, bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == description;
                ++j;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n;
        }
    }

    @Test
    public void testSubstitutableExports014() throws BundleException {
        State state = this.getSubstituteUsesFragState();
        state.resolve();
        BundleDescription z = state.getBundle(0L);
        BundleDescription a = state.getBundle(1L);
        BundleDescription aFrag = state.getBundle(2L);
        BundleDescription b = state.getBundle(3L);
        BundleDescription bFrag = state.getBundle(4L);
        BundleDescription c = state.getBundle(5L);
        BundleDescription cFrag = state.getBundle(6L);
        BundleDescription d = state.getBundle(7L);
        BundleDescription e = state.getBundle(8L);
        BundleDescription f = state.getBundle(9L);
        BundleDescription[] allRefreshBundles = new BundleDescription[]{a, aFrag, b, bFrag, c, cFrag, d, e, f};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", allRefreshBundles.length, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray = allRefreshBundles;
        int n = allRefreshBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription description = bundleDescriptionArray[n2];
            boolean found = false;
            int j = 0;
            while (j < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[j]), 8, bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == description;
                ++j;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n2;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 1, bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{z});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 1, bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{c});
        bundleDeltas = stateDelta.getChanges();
        BundleDescription[] expectedRefresh = new BundleDescription[]{c, cFrag, f};
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 3, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray2 = expectedRefresh;
        int n3 = expectedRefresh.length;
        n = 0;
        while (n < n3) {
            BundleDescription description = bundleDescriptionArray2[n];
            boolean found = false;
            int j = 0;
            while (j < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[j]), 8, bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == description;
                ++j;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n;
        }
    }

    @Test
    public void testSubstitutableExports015() throws BundleException {
        int k;
        boolean found;
        BundleDescription description;
        State state = this.getSubstituteUsesFragCycleState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription aFrag = state.getBundle(2L);
        BundleDescription b = state.getBundle(3L);
        BundleDescription bFrag = state.getBundle(4L);
        BundleDescription c = state.getBundle(5L);
        BundleDescription cFrag = state.getBundle(6L);
        BundleDescription d = state.getBundle(7L);
        BundleDescription e = state.getBundle(8L);
        BundleDescription f = state.getBundle(9L);
        BundleDescription g = state.getBundle(10L);
        BundleDescription h = state.getBundle(11L);
        BundleDescription i = state.getBundle(12L);
        BundleDescription[] allRefreshBundles = new BundleDescription[]{a, aFrag, b, bFrag, c, cFrag, d, e, f, g, h, i};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", allRefreshBundles.length, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray = allRefreshBundles;
        int n = allRefreshBundles.length;
        int n2 = 0;
        while (n2 < n) {
            description = bundleDescriptionArray[n2];
            found = false;
            k = 0;
            while (k < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[k]), 8, bundleDeltas[k].getType());
                found = bundleDeltas[k].getBundle() == description;
                ++k;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n2;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 1, bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{c});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", allRefreshBundles.length, bundleDeltas.length);
        bundleDescriptionArray = allRefreshBundles;
        n = allRefreshBundles.length;
        n2 = 0;
        while (n2 < n) {
            description = bundleDescriptionArray[n2];
            found = false;
            k = 0;
            while (k < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[k]), 8, bundleDeltas[k].getType());
                found = bundleDeltas[k].getBundle() == description;
                ++k;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n2;
        }
    }

    @Test
    public void testSubstitutableExports016() throws BundleException {
        State state = this.getSubstituteBasicReexportState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        BundleDescription g = state.getBundle(6L);
        BundleDescription h = state.getBundle(7L);
        BundleDescription i = state.getBundle(8L);
        BundleDescription[] allBundles = new BundleDescription[]{a, b, c, d, e, f, g, h, i};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", allBundles.length, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription description = bundleDescriptionArray[n2];
            boolean found = false;
            int k = 0;
            while (k < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[k]), 8, bundleDeltas[k].getType());
                found = bundleDeltas[k].getBundle() == description;
                ++k;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n2;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        BundleDescription[] expectedRefresh = new BundleDescription[]{f, i};
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", expectedRefresh.length, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray2 = expectedRefresh;
        int n3 = expectedRefresh.length;
        n = 0;
        while (n < n3) {
            BundleDescription description = bundleDescriptionArray2[n];
            boolean found = false;
            int k = 0;
            while (k < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[k]), 8, bundleDeltas[k].getType());
                found = bundleDeltas[k].getBundle() == description;
                ++k;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n;
        }
        stateDelta = state.resolve(new BundleDescription[]{i});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 1, bundleDeltas.length);
    }

    @Test
    public void testSubstitutableExports017() throws BundleException {
        State state = this.getSubstituteUsesReexportState();
        state.resolve();
        BundleDescription z = state.getBundle(0L);
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        BundleDescription h = state.getBundle(8L);
        BundleDescription i = state.getBundle(9L);
        BundleDescription[] allRefreshBundles = new BundleDescription[]{a, b, c, d, e, f, g, h, i};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", allRefreshBundles.length, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray = allRefreshBundles;
        int n = allRefreshBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription description = bundleDescriptionArray[n2];
            boolean found = false;
            int m = 0;
            while (m < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[m]), 8, bundleDeltas[m].getType());
                found = bundleDeltas[m].getBundle() == description;
                ++m;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n2;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        BundleDescription[] expectedRefresh = new BundleDescription[]{f, i};
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", expectedRefresh.length, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray2 = expectedRefresh;
        int n3 = expectedRefresh.length;
        n = 0;
        while (n < n3) {
            BundleDescription description = bundleDescriptionArray2[n];
            boolean found = false;
            int m = 0;
            while (m < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[m]), 8, bundleDeltas[m].getType());
                found = bundleDeltas[m].getBundle() == description;
                ++m;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n;
        }
        stateDelta = state.resolve(new BundleDescription[]{i});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 1, bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{z});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 1, bundleDeltas.length);
    }

    @Test
    public void testSubstitutableExports018() throws BundleException {
        int l;
        boolean found;
        BundleDescription description;
        State state = this.getSubstituteUsesReexportCycleState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        BundleDescription h = state.getBundle(8L);
        BundleDescription i = state.getBundle(9L);
        BundleDescription j = state.getBundle(10L);
        BundleDescription[] allRefreshBundles = new BundleDescription[]{a, b, c, d, e, f, g, h, i, j};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", allRefreshBundles.length, bundleDeltas.length);
        BundleDescription[] bundleDescriptionArray = allRefreshBundles;
        int n = allRefreshBundles.length;
        int n2 = 0;
        while (n2 < n) {
            description = bundleDescriptionArray[n2];
            found = false;
            l = 0;
            while (l < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[l]), 8, bundleDeltas[l].getType());
                found = bundleDeltas[l].getBundle() == description;
                ++l;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n2;
        }
        stateDelta = state.resolve(new BundleDescription[]{i});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", 1, bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{c});
        bundleDeltas = stateDelta.getChanges();
        Assert.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        this.assertEquals("bunldeDeltas wrong number", allRefreshBundles.length, bundleDeltas.length);
        bundleDescriptionArray = allRefreshBundles;
        n = allRefreshBundles.length;
        n2 = 0;
        while (n2 < n) {
            description = bundleDescriptionArray[n2];
            found = false;
            l = 0;
            while (l < bundleDeltas.length && !found) {
                this.assertEquals("unexpected delta type " + String.valueOf(bundleDeltas[l]), 8, bundleDeltas[l].getType());
                found = bundleDeltas[l].getBundle() == description;
                ++l;
            }
            if (!found) {
                Assert.fail((String)("Did not find RESOLVED BundleDelta for " + String.valueOf(description)));
            }
            ++n2;
        }
    }

    @Test
    public void testSubstitutableExports019() throws BundleException {
        State state = this.getSubstituteUnresolvedFragState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription aFrag = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription bFrag = state.getBundle(3L);
        BundleDescription c = state.getBundle(4L);
        BundleDescription cFrag = state.getBundle(5L);
        BundleDescription d = state.getBundle(6L);
        BundleDescription e = state.getBundle(7L);
        BundleDescription f = state.getBundle(8L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertFalse((String)"1.0.1", (boolean)aFrag.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertFalse((String)"1.1.1", (boolean)bFrag.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertFalse((String)"1.2.1", (boolean)cFrag.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        ExportPackageDescription[] aFragVisible = state.getStateHelper().getVisiblePackages(aFrag);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        ExportPackageDescription[] bFragVisible = state.getStateHelper().getVisiblePackages(bFrag);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        ExportPackageDescription[] cFragVisible = state.getStateHelper().getVisiblePackages(cFrag);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"aFragVisible is null", (Object)aFragVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"bFragVisible is null", (Object)bFragVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"cFragVisible is null", (Object)cFragVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        this.assertEquals("aVisible wrong number", 0, aVisible.length);
        this.assertEquals("aFragVisible wrong number", 0, aFragVisible.length);
        this.assertEquals("bVisible wrong number", 2, bVisible.length);
        this.assertEquals("bFragVisible wrong number", 0, bFragVisible.length);
        this.assertEquals("cVisible wrong number", 2, cVisible.length);
        this.assertEquals("cFragVisible wrong number", 0, cFragVisible.length);
        this.assertEquals("dVisible wrong number", 2, dVisible.length);
        this.assertEquals("eVisible wrong number", 2, eVisible.length);
        this.assertEquals("fVisible wrong number", 2, fVisible.length);
        Object[] aExports = a.getSelectedExports();
        this.assertEquals("a has wrong number of exports", 2, aExports.length);
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])aExports, (Object[])bVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])aExports, (Object[])cVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])aExports, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])aExports, (Object[])fVisible);
    }

    @Test
    public void testSubstitutableExports020() throws BundleException {
        State state = this.getSubstituteUnresolvedFragState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription aFrag = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription bFrag = state.getBundle(3L);
        BundleDescription c = state.getBundle(4L);
        BundleDescription cFrag = state.getBundle(5L);
        BundleDescription d = state.getBundle(6L);
        BundleDescription e = state.getBundle(7L);
        BundleDescription f = state.getBundle(8L);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Q");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "q; version=1.0");
        BundleDescription q = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), f.getBundleId() + 1L);
        state.addBundle(q);
        state.resolve(new BundleDescription[]{a});
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.0.1", (boolean)aFrag.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.1.1", (boolean)bFrag.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.2.1", (boolean)cFrag.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] aFragVisible = state.getStateHelper().getVisiblePackages(aFrag);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] bFragVisible = state.getStateHelper().getVisiblePackages(bFrag);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] cFragVisible = state.getStateHelper().getVisiblePackages(cFrag);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"aFragVisible is null", (Object)aFragVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"bFragVisible is null", (Object)bFragVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"cFragVisible is null", (Object)cFragVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        this.assertEquals("aVisible wrong number", 0, aVisible.length);
        this.assertEquals("aFragVisible wrong number", 1, aFragVisible.length);
        this.assertEquals("bVisible wrong number", 2, bVisible.length);
        this.assertEquals("bFragVisible wrong number", 2, bFragVisible.length);
        this.assertEquals("cVisible wrong number", 2, cVisible.length);
        this.assertEquals("cFragVisible wrong number", 2, cFragVisible.length);
        this.assertEquals("dVisible wrong number", 3, dVisible.length);
        this.assertEquals("eVisible wrong number", 3, eVisible.length);
        this.assertEquals("fVisible wrong number", 3, fVisible.length);
        Object[] aExports = a.getSelectedExports();
        this.assertEquals("a has wrong number of exports", 3, aExports.length);
        Object[] aDeclaredExports = a.getExportPackages();
        Object[] aFragExpected = new ExportPackageDescription[]{aExports[2], q.getExportPackages()[0]};
        Assert.assertArrayEquals((String)"aFragVisible not correct", (Object[])q.getSelectedExports(), (Object[])aFragVisible);
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])aDeclaredExports, (Object[])bVisible);
        Assert.assertArrayEquals((String)"bFragVisible not correct", (Object[])aFragExpected, (Object[])bFragVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])aDeclaredExports, (Object[])cVisible);
        Assert.assertArrayEquals((String)"cFragVisible not correct", (Object[])aFragExpected, (Object[])cFragVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])aExports, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])aExports, (Object[])fVisible);
    }

    @Test
    public void testSubstitutableExports021() throws BundleException {
        State state = this.getSubstituteBasicState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        state.removeBundle(a);
        state.resolve(new BundleDescription[]{a});
        Assert.assertFalse((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertFalse((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        ExportPackageDescription[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        ExportPackageDescription[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        this.assertEquals("bVisible wrong number", 0, bVisible.length);
        this.assertEquals("cVisible wrong number", 2, cVisible.length);
        this.assertEquals("dVisible wrong number", 0, dVisible.length);
        this.assertEquals("eVisible wrong number", 2, eVisible.length);
        this.assertEquals("fVisible wrong number", 2, fVisible.length);
        Object[] bExports = b.getSelectedExports();
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])bExports, (Object[])cVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])bExports, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])bExports, (Object[])fVisible);
    }

    @Test
    public void testSubstitutableExports022() throws BundleException {
        State state = this.getSubstituteSplitState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        BundleDescription g = state.getBundle(6L);
        BundleDescription h = state.getBundle(7L);
        BundleDescription i = state.getBundle(8L);
        BundleDescription j = state.getBundle(9L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        Assert.assertTrue((String)"1.6", (boolean)g.isResolved());
        Assert.assertTrue((String)"1.7", (boolean)h.isResolved());
        Assert.assertTrue((String)"1.8", (boolean)i.isResolved());
        Assert.assertTrue((String)"1.9", (boolean)j.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Object[] iVisible = state.getStateHelper().getVisiblePackages(i);
        Object[] jVisible = state.getStateHelper().getVisiblePackages(j);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        Assert.assertNotNull((String)"gVisible is null", (Object)gVisible);
        Assert.assertNotNull((String)"hVisible is null", (Object)hVisible);
        Assert.assertNotNull((String)"iVisible is null", (Object)iVisible);
        Assert.assertNotNull((String)"jVisible is null", (Object)jVisible);
        this.assertEquals("aVisible wrong number", 0, aVisible.length);
        this.assertEquals("bVisible wrong number", 2, bVisible.length);
        this.assertEquals("cVisible wrong number", 2, cVisible.length);
        this.assertEquals("dVisible wrong number", 2, dVisible.length);
        this.assertEquals("eVisible wrong number", 4, eVisible.length);
        this.assertEquals("fVisible wrong number", 4, fVisible.length);
        this.assertEquals("gVisible wrong number", 4, gVisible.length);
        this.assertEquals("hVisible wrong number", 4, hVisible.length);
        this.assertEquals("iVisible wrong number", 4, iVisible.length);
        this.assertEquals("jVisible wrong number", 4, jVisible.length);
        Object[] aExports = a.getSelectedExports();
        Assert.assertArrayEquals((String)"aVisible not correct", (Object[])aExports, (Object[])a.getExportPackages());
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])aExports, (Object[])bVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])aExports, (Object[])cVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        ExportPackageDescription[] aExported = a.getSelectedExports();
        ExportPackageDescription[] dExported = d.getSelectedExports();
        ExportPackageDescription[] expected = new ExportPackageDescription[aExported.length + dExported.length];
        System.arraycopy(aExported, 0, expected, 0, aExported.length);
        System.arraycopy(dExported, 0, expected, aExported.length, dExported.length);
        ExportPackageDescription[] exportPackageDescriptionArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription exportDescription = exportPackageDescriptionArray[n2];
            this.assertContains("eVisible not correct", eVisible, exportDescription);
            this.assertContains("fVisible not correct", fVisible, exportDescription);
            this.assertContains("gVisible not correct", gVisible, exportDescription);
            this.assertContains("hVisible not correct", hVisible, exportDescription);
            this.assertContains("iVisible not correct", iVisible, exportDescription);
            this.assertContains("jVisible not correct", jVisible, exportDescription);
            ++n2;
        }
    }

    @Test
    public void testSubstitutableExports023() throws BundleException {
        State state = this.getSubstituteSplitUsesState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        BundleDescription g = state.getBundle(6L);
        BundleDescription h = state.getBundle(7L);
        BundleDescription i = state.getBundle(8L);
        BundleDescription j = state.getBundle(9L);
        BundleDescription k = state.getBundle(10L);
        BundleDescription l = state.getBundle(11L);
        BundleDescription m = state.getBundle(12L);
        BundleDescription n = state.getBundle(13L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        Assert.assertTrue((String)"1.6", (boolean)g.isResolved());
        Assert.assertTrue((String)"1.7", (boolean)h.isResolved());
        Assert.assertTrue((String)"1.8", (boolean)i.isResolved());
        Assert.assertTrue((String)"1.9", (boolean)j.isResolved());
        Assert.assertTrue((String)"1.9", (boolean)k.isResolved());
        Assert.assertTrue((String)"1.9", (boolean)l.isResolved());
        Assert.assertTrue((String)"1.9", (boolean)j.isResolved());
        Assert.assertTrue((String)"1.9", (boolean)n.isResolved());
        Object[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Object[] iVisible = state.getStateHelper().getVisiblePackages(i);
        Object[] jVisible = state.getStateHelper().getVisiblePackages(j);
        ExportPackageDescription[] kVisible = state.getStateHelper().getVisiblePackages(k);
        ExportPackageDescription[] lVisible = state.getStateHelper().getVisiblePackages(l);
        Object[] mVisible = state.getStateHelper().getVisiblePackages(m);
        Object[] nVisible = state.getStateHelper().getVisiblePackages(n);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        Assert.assertNotNull((String)"gVisible is null", (Object)gVisible);
        Assert.assertNotNull((String)"hVisible is null", (Object)hVisible);
        Assert.assertNotNull((String)"iVisible is null", (Object)iVisible);
        Assert.assertNotNull((String)"jVisible is null", (Object)jVisible);
        Assert.assertNotNull((String)"kVisible is null", (Object)kVisible);
        Assert.assertNotNull((String)"lVisible is null", (Object)lVisible);
        Assert.assertNotNull((String)"mVisible is null", (Object)mVisible);
        Assert.assertNotNull((String)"nVisible is null", (Object)nVisible);
        this.assertEquals("aVisible wrong number", 1, aVisible.length);
        this.assertEquals("bVisible wrong number", 3, bVisible.length);
        this.assertEquals("cVisible wrong number", 3, cVisible.length);
        this.assertEquals("dVisible wrong number", 3, dVisible.length);
        this.assertEquals("eVisible wrong number", 5, eVisible.length);
        this.assertEquals("fVisible wrong number", 5, fVisible.length);
        this.assertEquals("gVisible wrong number", 4, gVisible.length);
        this.assertEquals("hVisible wrong number", 4, hVisible.length);
        this.assertEquals("iVisible wrong number", 4, iVisible.length);
        this.assertEquals("jVisible wrong number", 4, jVisible.length);
        this.assertEquals("kVisible wrong number", 0, kVisible.length);
        this.assertEquals("lVisible wrong number", 0, lVisible.length);
        this.assertEquals("mVisible wrong number", 6, mVisible.length);
        this.assertEquals("nVisible wrong number", 6, nVisible.length);
        ExportPackageDescription[] aExports = a.getSelectedExports();
        this.assertEquals("aExports wrong number", 2, aExports.length);
        Object[] bcExpected = new ExportPackageDescription[]{aExports[0], aExports[1], l.getSelectedExports()[0]};
        Object[] aExpected = new ExportPackageDescription[]{l.getSelectedExports()[0]};
        Assert.assertArrayEquals((String)"aVisible not correct", (Object[])aExpected, (Object[])aVisible);
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])bcExpected, (Object[])bVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])bcExpected, (Object[])cVisible);
        Object[] dExpected = new ExportPackageDescription[]{l.getSelectedExports()[1], aExports[0], aExports[1]};
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])dExpected, (Object[])dVisible);
        ExportPackageDescription[] aExported = a.getSelectedExports();
        ExportPackageDescription[] dExported = d.getSelectedExports();
        ExportPackageDescription[] efExpected = new ExportPackageDescription[aExported.length + dExported.length + 1];
        System.arraycopy(aExported, 0, efExpected, 0, aExported.length);
        System.arraycopy(dExported, 0, efExpected, aExported.length, dExported.length);
        efExpected[aExported.length + dExported.length] = l.getSelectedExports()[1];
        ExportPackageDescription[] exportPackageDescriptionArray = efExpected;
        int n2 = efExpected.length;
        int n3 = 0;
        while (n3 < n2) {
            ExportPackageDescription efExport = exportPackageDescriptionArray[n3];
            this.assertContains("eVisible not correct", eVisible, efExport);
            this.assertContains("fVisible not correct", fVisible, efExport);
            ++n3;
        }
        ExportPackageDescription[] ghijExpected = new ExportPackageDescription[aExported.length + dExported.length];
        System.arraycopy(aExported, 0, ghijExpected, 0, aExported.length);
        System.arraycopy(dExported, 0, ghijExpected, aExported.length, dExported.length);
        ExportPackageDescription[] exportPackageDescriptionArray2 = ghijExpected;
        int n4 = ghijExpected.length;
        n2 = 0;
        while (n2 < n4) {
            ExportPackageDescription ghijExport = exportPackageDescriptionArray2[n2];
            this.assertContains("gVisible not correct", gVisible, ghijExport);
            this.assertContains("hVisible not correct", hVisible, ghijExport);
            this.assertContains("iVisible not correct", iVisible, ghijExport);
            this.assertContains("jVisible not correct", jVisible, ghijExport);
            ++n2;
        }
        ExportPackageDescription[] lExported = l.getSelectedExports();
        ExportPackageDescription[] mnExpected = new ExportPackageDescription[aExported.length + dExported.length + lExported.length];
        System.arraycopy(aExported, 0, mnExpected, 0, aExported.length);
        System.arraycopy(dExported, 0, mnExpected, aExported.length, dExported.length);
        System.arraycopy(lExported, 0, mnExpected, aExported.length + dExported.length, lExported.length);
        ExportPackageDescription[] exportPackageDescriptionArray3 = mnExpected;
        int n5 = mnExpected.length;
        int n6 = 0;
        while (n6 < n5) {
            ExportPackageDescription mnExport = exportPackageDescriptionArray3[n6];
            this.assertContains("mVisible not correct", mVisible, mnExport);
            this.assertContains("nVisible not correct", nVisible, mnExport);
            ++n6;
        }
    }

    @Test
    public void testSubstitutableExports024() throws BundleException {
        State state = this.getNonOverlapingSubstituteBasicState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        this.assertEquals("aVisible wrong number", 0, aVisible.length);
        this.assertEquals("bVisible wrong number", 2, bVisible.length);
        this.assertEquals("cVisible wrong number", 2, cVisible.length);
        this.assertEquals("dVisible wrong number", 2, dVisible.length);
        this.assertEquals("eVisible wrong number", 2, eVisible.length);
        this.assertEquals("fVisible wrong number", 2, fVisible.length);
        Object[] aExports = a.getSelectedExports();
        Assert.assertArrayEquals((String)"aVisible not correct", (Object[])aExports, (Object[])a.getExportPackages());
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])aExports, (Object[])bVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])aExports, (Object[])cVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])aExports, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])aExports, (Object[])fVisible);
        VersionConstraint[] unsatisfied = state.getStateHelper().getUnsatisfiedConstraints(a);
        this.assertEquals("Should not have any unresolvable constraints", 0, unsatisfied.length);
    }

    @Test
    public void testSubstitutableExports025() throws BundleException {
        State state = this.getSubstituteUsesState();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Export-Package", "z; version=0.5");
        manifest.put("Import-Package", "z");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName") + (String)manifest.get("Bundle-Version"), g.getBundleId() + 1L);
        state.addBundle(h);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        Assert.assertFalse((String)"1.6", (boolean)g.isResolved());
        Assert.assertTrue((String)"1.7", (boolean)h.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        ExportPackageDescription[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Assert.assertNotNull((String)"aVisible is null", (Object)aVisible);
        Assert.assertNotNull((String)"bVisible is null", (Object)bVisible);
        Assert.assertNotNull((String)"cVisible is null", (Object)cVisible);
        Assert.assertNotNull((String)"dVisible is null", (Object)dVisible);
        Assert.assertNotNull((String)"eVisible is null", (Object)eVisible);
        Assert.assertNotNull((String)"fVisible is null", (Object)fVisible);
        Assert.assertNotNull((String)"gVisible is null", (Object)gVisible);
        Assert.assertNotNull((String)"hVisible is null", (Object)hVisible);
        this.assertEquals("aVisible wrong number", 0, aVisible.length);
        this.assertEquals("bVisible wrong number", 2, bVisible.length);
        this.assertEquals("cVisible wrong number", 2, cVisible.length);
        this.assertEquals("dVisible wrong number", 2, dVisible.length);
        this.assertEquals("eVisible wrong number", 2, eVisible.length);
        this.assertEquals("fVisible wrong number", 2, fVisible.length);
        this.assertEquals("gVisible wrong number", 0, gVisible.length);
        this.assertEquals("hVisible wrong number", 2, hVisible.length);
        Object[] aExports = a.getSelectedExports();
        Assert.assertArrayEquals((String)"aVisible not correct", (Object[])aExports, (Object[])a.getExportPackages());
        Assert.assertArrayEquals((String)"bVisible not correct", (Object[])aExports, (Object[])bVisible);
        Assert.assertArrayEquals((String)"cVisible not correct", (Object[])aExports, (Object[])cVisible);
        Assert.assertArrayEquals((String)"dVisible not correct", (Object[])aExports, (Object[])dVisible);
        Assert.assertArrayEquals((String)"eVisible not correct", (Object[])aExports, (Object[])eVisible);
        Assert.assertArrayEquals((String)"fVisible not correct", (Object[])aExports, (Object[])fVisible);
        Assert.assertArrayEquals((String)"hVisible not correct", (Object[])aExports, (Object[])hVisible);
        ExportPackageDescription[] hExported = h.getSelectedExports();
        this.assertEquals("Expected one export", 1, hExported.length);
        ExportPackageDescription[] hSubstituted = h.getSubstitutedExports();
        this.assertEquals("Expected no substitutions", 0, hSubstituted.length);
        ImportPackageSpecification[] hImports = h.getImportPackages();
        this.assertEquals("Expected one import", 1, hImports.length);
        this.assertEquals("Wrong supplier", (Object)hExported[0], hImports[0].getSupplier());
    }
}

