/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import org.eclipse.osgi.service.resolver.VersionRange;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Version;

public class VersionRangeTests {
    @Test
    public void testSingleVersionRange() {
        VersionRange range = new VersionRange("[1.0.0, 1.0.0.-)");
        Assert.assertEquals((String)"0.1", (Object)Version.parseVersion((String)"1.0"), (Object)range.getMinimum());
        Assert.assertTrue((String)"0.9", (!range.isIncluded(Version.parseVersion((String)"0.9")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.0", (boolean)range.isIncluded(Version.parseVersion((String)"1")));
        Assert.assertTrue((String)"1.1", (boolean)range.isIncluded(Version.parseVersion((String)"1.0")));
        Assert.assertTrue((String)"1.2", (boolean)range.isIncluded(Version.parseVersion((String)"1.0.0")));
        Assert.assertTrue((String)"2.1", (!range.isIncluded(Version.parseVersion((String)"1.0.0.0")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (!range.isIncluded(Version.parseVersion((String)"1.0.1")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.3", (!range.isIncluded(Version.parseVersion((String)"1.1")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.4", (!range.isIncluded(Version.parseVersion((String)"2")) ? 1 : 0) != 0);
    }

    @Test
    public void testInvertedRange() {
        VersionRange range = new VersionRange("[2.0.0, 1.0.0]");
        Assert.assertTrue((String)"1.0", (!range.isIncluded(Version.parseVersion((String)"1")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.1", (!range.isIncluded(Version.parseVersion((String)"1.5")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.2", (!range.isIncluded(Version.parseVersion((String)"2.0")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.3", (!range.isIncluded(Version.parseVersion((String)"2.5")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.4", (!range.isIncluded(Version.parseVersion((String)"0.5")) ? 1 : 0) != 0);
    }

    @Test
    public void testGreaterThan() {
        VersionRange lowerBound = new VersionRange("1.0.0");
        Assert.assertTrue((String)"1.0", (!lowerBound.isIncluded(Version.parseVersion((String)"0.9")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.1", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"1.0")));
        Assert.assertTrue((String)"1.2", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"1.9.9.x")));
        Assert.assertTrue((String)"1.3", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"999.999.999.foo")));
    }

    @Test
    public void testLowerThan() {
        VersionRange upperBound = new VersionRange("[0,2.0)");
        Assert.assertTrue((String)"1.0", (boolean)upperBound.isIncluded(Version.parseVersion((String)"0.0")));
        Assert.assertTrue((String)"1.1", (boolean)upperBound.isIncluded(Version.parseVersion((String)"0.9")));
        Assert.assertTrue((String)"1.2", (boolean)upperBound.isIncluded(Version.parseVersion((String)"1.0")));
        Assert.assertTrue((String)"1.3", (boolean)upperBound.isIncluded(Version.parseVersion((String)"1.9.9.x")));
        Assert.assertTrue((String)"1.4", (!upperBound.isIncluded(Version.parseVersion((String)"2.0")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.5", (!upperBound.isIncluded(Version.parseVersion((String)"2.1")) ? 1 : 0) != 0);
    }

    @Test
    public void testNullMin() {
        VersionRange nullMin = new VersionRange(null, true, new Version("1.0"), false);
        Assert.assertNotNull((String)"0.1", (Object)nullMin.getMinimum());
        Assert.assertEquals((String)"0.2", (Object)Version.emptyVersion, (Object)nullMin.getMinimum());
        Assert.assertTrue((String)"1.0", (boolean)nullMin.isIncluded(null));
        Assert.assertTrue((String)"1.1", (boolean)nullMin.isIncluded(new Version("0.0")));
        Assert.assertTrue((String)"1.2", (boolean)nullMin.isIncluded(new Version("0.9.9")));
        Assert.assertTrue((String)"1.3", (boolean)nullMin.isIncluded(Version.parseVersion((String)"0.9.9.x")));
        Assert.assertFalse((String)"1.4", (boolean)nullMin.isIncluded(Version.parseVersion((String)"2.0")));
        Assert.assertFalse((String)"1.5", (boolean)nullMin.isIncluded(Version.parseVersion((String)"2.1")));
    }

    @Test
    public void testNullMax() {
        VersionRange nullMaxAny = new VersionRange(new Version("0"), true, null, true);
        Assert.assertTrue((String)"1.0", (boolean)nullMaxAny.isIncluded(Version.parseVersion((String)"0.0")));
        Assert.assertTrue((String)"1.1", (boolean)nullMaxAny.isIncluded(Version.parseVersion((String)"0.9")));
        Assert.assertTrue((String)"1.2", (boolean)nullMaxAny.isIncluded(Version.parseVersion((String)"1.0")));
        Assert.assertTrue((String)"1.3", (boolean)nullMaxAny.isIncluded(Version.parseVersion((String)"1.9.9.x")));
        Assert.assertTrue((String)"1.4", (boolean)nullMaxAny.isIncluded(Version.parseVersion((String)"999.999.999.foo")));
        Assert.assertTrue((String)"1.5", (boolean)nullMaxAny.isIncluded(new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)));
    }
}

