/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class XFriendsInternalResolverTest
extends AbstractStateTest {
    @Test
    public void testXFriends() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.exporter");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "test.exporter.foo1; x-friends:=\"test.importer1, test.requirer1\",test.exporter.foo2; x-friends:=\"test.importer2, test.requirer2\",test.exporter.bar1; x-friends:=\"test.importer1, test.requirer1\",test.exporter.bar2; x-friends:=\"test.importer2, test.requirer2\"");
        BundleDescription testExporter = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.importer1");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "test.exporter.foo1,test.exporter.bar1,test.exporter.foo2; resolution:=optional,test.exporter.bar2; resolution:=optional");
        BundleDescription testImporter1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.importer2");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "test.exporter.foo1; resolution:=optional,test.exporter.bar1; resolution:=optional,test.exporter.foo2,test.exporter.bar2");
        BundleDescription testImporter2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.importer3");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "test.exporter.foo1,test.exporter.bar1,test.exporter.foo2; resolution:=optional,test.exporter.bar2; resolution:=optional");
        BundleDescription testImporter3 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.requirer1");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "test.exporter");
        BundleDescription testRequirer1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.requirer2");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "test.exporter");
        BundleDescription testRequirer2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("osgi.resolverMode", "strict");
        state.setPlatformProperties(props);
        state.addBundle(testExporter);
        state.addBundle(testImporter1);
        state.addBundle(testImporter2);
        state.addBundle(testImporter3);
        state.addBundle(testRequirer1);
        state.addBundle(testRequirer2);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)testExporter.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)testImporter1.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)testImporter2.isResolved());
        Assert.assertFalse((String)"1.3", (boolean)testImporter3.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)testRequirer1.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)testRequirer2.isResolved());
        Object[] validPackages1 = new String[]{"test.exporter.foo1", "test.exporter.bar1"};
        Object[] validPackages2 = new String[]{"test.exporter.foo2", "test.exporter.bar2"};
        ExportPackageDescription[] imported1 = testImporter1.getResolvedImports();
        Assert.assertTrue((String)"2.0", (imported1 != null && imported1.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (boolean)this.contains(validPackages1, imported1[0].getName()));
        Assert.assertTrue((String)"2.2", (boolean)this.contains(validPackages1, imported1[1].getName()));
        ExportPackageDescription[] imported2 = testImporter2.getResolvedImports();
        Assert.assertTrue((String)"3.0", (imported2 != null && imported2.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.1", (boolean)this.contains(validPackages2, imported2[0].getName()));
        Assert.assertTrue((String)"3.2", (boolean)this.contains(validPackages2, imported2[1].getName()));
        StateHelper helper = state.getStateHelper();
        ExportPackageDescription[] required1 = helper.getVisiblePackages(testRequirer1);
        Assert.assertTrue((String)"4.0", (required1 != null && required1.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"4.1", (boolean)this.contains(validPackages1, required1[0].getName()));
        Assert.assertTrue((String)"4.2", (boolean)this.contains(validPackages1, required1[1].getName()));
        ExportPackageDescription[] required2 = helper.getVisiblePackages(testRequirer2);
        Assert.assertTrue((String)"5.0", (required2 != null && required2.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"5.1", (boolean)this.contains(validPackages2, required2[0].getName()));
        Assert.assertTrue((String)"5.2", (boolean)this.contains(validPackages2, required2[1].getName()));
    }

    @Test
    public void testVisiblePackages001() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a.base");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "a.split.pkg; a.base=split; mandatory:=a.base");
        BundleDescription aBase = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a.extra");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "a.base");
        manifest.put("Export-Package", "a.split.pkg");
        BundleDescription aExtra = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "a.extra");
        manifest.put("Export-Package", "test.base.exporter.require");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        state.addBundle(aBase);
        state.addBundle(aExtra);
        state.addBundle(b);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)aBase.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)aExtra.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)b.isResolved());
        StateHelper helper = state.getStateHelper();
        ExportPackageDescription[] visImporter = helper.getVisiblePackages(b);
        Assert.assertTrue((String)"2.0", (visImporter != null && visImporter.length == 2 ? 1 : 0) != 0);
        this.assertEquals("2.1", visImporter[0].getName(), "a.split.pkg");
        this.assertEquals("2.2", visImporter[1].getName(), "a.split.pkg");
        BundleDescription exporter1 = visImporter[0].getExporter();
        BundleDescription exporter2 = visImporter[1].getExporter();
        Assert.assertTrue((String)"2.3", (exporter1 != exporter2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.4", (exporter1 == aBase || exporter1 == aExtra ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.4", (exporter2 == aBase || exporter2 == aExtra ? 1 : 0) != 0);
    }

    @Test
    public void testVisiblePackages002() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.base.exporter");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "test.base; base.exporter=split; mandatory:=base.exporter");
        BundleDescription baseExporter = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.base.exporter.require");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "test.base.exporter");
        manifest.put("Export-Package", "test.base; base.exporter.require=split; mandatory:=base.exporter.require");
        BundleDescription baseExporterRequire = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.base.exporter.require2");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "test.base.exporter.require");
        manifest.put("Export-Package", "test.base.exporter.require");
        BundleDescription baseExporterRequire2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.base.importer");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "test.base.exporter.require");
        BundleDescription baseImporter = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.base.importer2");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "test.base.exporter.require2");
        manifest.put("Export-Package", "test.base");
        BundleDescription baseImporter2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.base.importer3");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "test.base; bundle-symbolic-name=test.base.importer2");
        BundleDescription baseImporter3 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("osgi.resolverMode", "strict");
        state.setPlatformProperties(props);
        state.addBundle(baseExporter);
        state.addBundle(baseExporterRequire);
        state.addBundle(baseExporterRequire2);
        state.addBundle(baseImporter);
        state.addBundle(baseImporter2);
        state.addBundle(baseImporter3);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)baseExporter.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)baseExporterRequire.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)baseExporterRequire2.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)baseImporter.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)baseImporter2.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)baseImporter3.isResolved());
        StateHelper helper = state.getStateHelper();
        ExportPackageDescription[] visImporter = helper.getVisiblePackages(baseImporter);
        Assert.assertTrue((String)"2.0", (visImporter != null && visImporter.length == 2 ? 1 : 0) != 0);
        this.assertEquals("2.1", visImporter[0].getName(), "test.base");
        this.assertEquals("2.2", visImporter[1].getName(), "test.base");
        BundleDescription exporter1 = visImporter[0].getExporter();
        BundleDescription exporter2 = visImporter[1].getExporter();
        Assert.assertTrue((String)"2.3", (exporter1 != exporter2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.4", (exporter1 == baseExporter || exporter1 == baseExporterRequire ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.5", (exporter2 == baseExporter || exporter2 == baseExporterRequire ? 1 : 0) != 0);
        ExportPackageDescription[] visImporter2 = helper.getVisiblePackages(baseImporter2);
        Assert.assertTrue((String)"3.0", (visImporter2 != null && visImporter2.length == 1 ? 1 : 0) != 0);
        this.assertEquals("3.1", visImporter2[0].getName(), "test.base.exporter.require");
        Assert.assertTrue((String)"3.2", (visImporter2[0].getExporter() == baseExporterRequire2 ? 1 : 0) != 0);
        ExportPackageDescription[] visImporter3 = helper.getVisiblePackages(baseImporter3);
        Assert.assertTrue((String)"4.0", (visImporter3 != null && visImporter3.length == 1 ? 1 : 0) != 0);
        this.assertEquals("4.1", visImporter3[0].getName(), "test.base");
        Assert.assertTrue((String)"4.2", (visImporter3[0].getExporter() == baseImporter2 ? 1 : 0) != 0);
    }

    @Test
    public void testVisiblePackages003() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "test.base; E=split; mandatory:=E");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "E");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "D");
        manifest.put("Export-Package", "test.base; D=split; mandatory:=D");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "F; visibility:=reexport");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "test.base; F=split; mandatory:=F");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "B; visibility:=reexport,C");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("osgi.resolverMode", "strict");
        state.setPlatformProperties(props);
        state.addBundle(f);
        state.addBundle(e);
        state.addBundle(d);
        state.addBundle(c);
        state.addBundle(b);
        state.addBundle(a);
        state.resolve();
        Assert.assertTrue((String)"1.0", (boolean)a.isResolved());
        Assert.assertTrue((String)"1.1", (boolean)b.isResolved());
        Assert.assertTrue((String)"1.2", (boolean)c.isResolved());
        Assert.assertTrue((String)"1.3", (boolean)d.isResolved());
        Assert.assertTrue((String)"1.4", (boolean)e.isResolved());
        Assert.assertTrue((String)"1.5", (boolean)f.isResolved());
        StateHelper helper = state.getStateHelper();
        ExportPackageDescription[] visImporter = helper.getVisiblePackages(a);
        Assert.assertTrue((String)"2.0", (visImporter != null && visImporter.length == 2 ? 1 : 0) != 0);
        this.assertEquals("2.1", visImporter[0].getName(), "test.base");
        this.assertEquals("2.2", visImporter[1].getName(), "test.base");
        BundleDescription exporter1 = visImporter[0].getExporter();
        BundleDescription exporter2 = visImporter[1].getExporter();
        Assert.assertTrue((String)"2.3", (exporter1 != exporter2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.4", (exporter1 == c || exporter1 == f ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.5", (exporter2 == c || exporter2 == f ? 1 : 0) != 0);
    }

    private boolean contains(Object[] array, Object element) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

