/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.url;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import org.eclipse.core.runtime.Platform;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;

public class BundleURLConnectionTest {
    private static Class<?> testClass;
    private static Bundle classBundle;

    @BeforeClass
    public static void setUpBeforeClass() {
        testClass = BundleURLConnectionTest.class;
        classBundle = FrameworkUtil.getBundle(testClass);
        Assert.assertNotNull((String)"Class is not from a OSGi-bundle", (Object)classBundle);
    }

    @AfterClass
    public static void tearDownAfterClass() {
        testClass = null;
        classBundle = null;
    }

    @Test
    public void testBundleReference_classLoaderURLConnection() throws IOException {
        URL resource = testClass.getClassLoader().getResource("META-INF/MANIFEST.MF");
        BundleURLConnectionTest.assertBundleReferenceURLConnection(resource, classBundle);
    }

    @Test
    public void testBundleReference_otherClassLoaderURLConnection() throws IOException {
        String resourceName = Platform.class.getName().replace(".", "/") + ".class";
        URL resource = testClass.getClassLoader().getResource(resourceName);
        BundleURLConnectionTest.assertBundleReferenceURLConnection(resource, FrameworkUtil.getBundle(Platform.class));
    }

    @Test
    public void testBundleReference_bundleEntryURLConnection() throws IOException {
        URL entry = classBundle.getEntry("META-INF/MANIFEST.MF");
        BundleURLConnectionTest.assertBundleReferenceURLConnection(entry, classBundle);
    }

    @Test
    public void testBundleReference_bundleEntriesURLConnection() throws IOException {
        Enumeration entries = classBundle.findEntries("META-INF", null, true);
        while (entries.hasMoreElements()) {
            BundleURLConnectionTest.assertBundleReferenceURLConnection((URL)entries.nextElement(), classBundle);
        }
    }

    @Test
    public void testBundleReference_bundleResourceURLConnection() throws IOException {
        URL entry = classBundle.getResource("META-INF/MANIFEST.MF");
        BundleURLConnectionTest.assertBundleReferenceURLConnection(entry, classBundle);
    }

    @Test
    public void testBundleReference_bundleResourcesURLConnection() throws IOException {
        Enumeration entries = classBundle.getResources("META-INF/MANIFEST.MF");
        while (entries.hasMoreElements()) {
            BundleURLConnectionTest.assertBundleReferenceURLConnection((URL)entries.nextElement(), classBundle);
        }
    }

    private static void assertBundleReferenceURLConnection(URL resource, Bundle expectedBundle) throws IOException {
        URLConnection connection = resource.openConnection();
        MatcherAssert.assertThat((Object)connection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(BundleReference.class)));
        Bundle bundle = ((BundleReference)connection).getBundle();
        Assert.assertSame((Object)expectedBundle, (Object)bundle);
    }
}

