/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.util;

import junit.framework.Test;
import org.eclipse.osgi.tests.util.TextProcessorSessionTest;
import org.eclipse.osgi.tests.util.TextProcessorTestCase;
import org.eclipse.osgi.util.TextProcessor;

public class BidiTextProcessorTestCase
extends TextProcessorTestCase {
    protected static final char LRM = '\u200e';
    protected static final char LRE = '\u202a';
    protected static final char PDF = '\u202c';
    private static String PATH_1_RESULT = "\u202a" + PATH_1 + "\u202c";
    private static String PATH_2_RESULT = "\u202a" + PATH_2 + "\u202c";
    private static String PATH_3_RESULT = "\u202a" + PATH_3 + "\u202c";
    private static String PATH_4_RESULT = "\u202a" + PATH_4 + "\u202c";
    private static String PATH_5_RESULT = "\u202ad:\\" + HEBREW_STRING_2 + " abcdef-" + HEBREW_STRING_3 + "\\xyz\\abcdef\\" + HEBREW_STRING_4 + "\u200e\\" + HEBREW_STRING_5 + ".java\u202c";
    private static String PATH_6_RESULT = "\u202ad:\\" + HEBREW_STRING_2 + " abcdef-" + HEBREW_STRING_3 + "\\xyz\\abcdef\\" + HEBREW_STRING_4 + "\u200e\\" + HEBREW_STRING_5 + "\u200e." + HEBREW_STRING_6 + "\u202c";
    private static String PATH_7_RESULT = "\u202ad:\\" + HEBREW_STRING_2 + " abcdef-" + HEBREW_STRING_3 + "\\xyz\\abcdef\\" + HEBREW_STRING_4 + "\\Test.java\u202c";
    private static String PATH_8_RESULT = "\u202a" + PATH_8 + "\u202c";
    private static String PATH_9_RESULT = "\u202a" + PATH_9 + "\u202c";
    private static String PATH_10_RESULT = "\u202a" + PATH_10 + "\u202c";
    private static String PATH_11_RESULT = "\u202a" + PATH_11 + "\u202c";
    private static String PATH_12_RESULT = PATH_12;
    private static String PATH_13_RESULT = "\u202a" + PATH_13 + "\u202c";
    private static String STRING_1_RESULT = STRING_1;
    private static String STRING_2_RESULT = STRING_2;
    private static String STRING_3_RESULT = "\u202a" + STRING_3 + "\u202c";
    private static String STRING_4_RESULT = "\u202a" + STRING_4 + "\u202c";
    private static String STRING_5_RESULT = "\u202a" + STRING_5 + "\u202c";
    private static String STRING_6_RESULT = "\u202a" + STRING_6 + "\u202c";
    private static String STRING_7_RESULT = STRING_7;
    private static String STRING_8_RESULT = "\u202a" + STRING_8 + "\u202c";
    private static String STRING_9_RESULT = "\u202ad:\\myFolder\\" + HEBREW_STRING_5 + "\u200e\\" + HEBREW_STRING_6 + ".java\u202c";
    private static String STRING_10_RESULT = "\u202ad:\\myFolder\\" + HEBREW_STRING_2 + "\u200e\\123/" + HEBREW_STRING_3 + ".java\u202c";
    private static String STRING_11_RESULT = "\u202ad:\\myFolder\\" + HEBREW_STRING_2 + "\u200e\\123/" + HEBREW_STRING_3 + "\u200e." + HEBREW_STRING_5 + "\u202c";
    private static String STRING_12_RESULT = "\u202ad:\\myFolder\\" + HEBREW_STRING_2 + "\u200e\\123" + HEBREW_STRING_3 + "\u200e." + HEBREW_STRING_6 + "\u202c";
    private static String STRING_13_RESULT = "\u202ad:\\myFolder\\" + HEBREW_STRING_2 + "\u200e\\123/myfile." + HEBREW_STRING_6 + "\u202c";
    private static String STRING_14_RESULT = "\u202ad:\\myFolder\\" + HEBREW_STRING_2 + "\u200e\\123myfile." + HEBREW_STRING_6 + "\u202c";
    private static String STRING_15_RESULT = "\u202ad:\\myFolder\\" + HEBREW_STRING_2 + "12-=\u200e\\<>?34" + HEBREW_STRING_6 + ".java\u202c";
    private static String STRING_16_RESULT = "\u202a" + HEBREW_STRING_2 + "\u200e/" + HEBREW_STRING_6 + "\u200e/" + HEBREW_STRING_4 + "\u200e." + HEBREW_STRING_5 + "\u202c";
    private static String STRING_17_RESULT = "\u202a" + HEBREW_STRING_7 + "\u200e/" + HEBREW_STRING_8 + "\u200e/" + HEBREW_STRING_9 + "\u200e/" + HEBREW_STRING_10 + "\u200e/" + HEBREW_STRING_11 + "\u200e/" + HEBREW_STRING_12 + "\u200e/" + HEBREW_STRING_13 + "\u202c";
    private static String STRING_18_RESULT = "\u202a_" + HEBREW_STRING_2 + " mixed text starts and ends with neutral.\u202c";
    private static String STRING_19_RESULT = "\u202aenglish and " + HEBREW_STRING_2 + " text starts with LTR ends with neutral _\u202c";
    private static String OTHER_STRING_NO_DELIM = "\u202a\u05ea\u05e9\u05e8\u05e7\u05e6 abcdef-\u05e5\u05e4\u05e3\u202c";
    private static String OTHER_STRING_1_RESULT = "\u202a*.java\u202c";
    private static String OTHER_STRING_2_RESULT = "\u202a*.\u05d0\u05d1\u05d2\u202c";
    private static String OTHER_STRING_3_RESULT = "\u202a\u05d0\u05d1\u05d2 \u200e= \u05ea\u05e9\u05e8\u05e7\u05e6\u202c";
    private static String OTHER_STRING_1_ND_RESULT = "\u202a*.java\u202c";
    private static String OTHER_STRING_2_ND_RESULT = "\u202a*.\u05d0\u05d1\u05d2\u202c";
    private static String OTHER_STRING_3_ND_RESULT = "\u202a\u05d0\u05d1\u05d2 = \u05ea\u05e9\u05e8\u05e7\u05e6\u202c";
    private static String[] RESULT_DEFAULT_PATHS = new String[]{PATH_1_RESULT, PATH_2_RESULT, PATH_3_RESULT, PATH_4_RESULT, PATH_5_RESULT, PATH_6_RESULT, PATH_7_RESULT, PATH_8_RESULT, PATH_9_RESULT, PATH_10_RESULT, PATH_11_RESULT, PATH_12_RESULT, PATH_13_RESULT};
    private static String[] RESULT_ADDITIONAL_STRINGS = new String[]{STRING_1_RESULT, STRING_2_RESULT, STRING_3_RESULT, STRING_4_RESULT, STRING_5_RESULT, STRING_6_RESULT, STRING_7_RESULT, STRING_8_RESULT, STRING_9_RESULT, STRING_10_RESULT, STRING_11_RESULT, STRING_12_RESULT, STRING_13_RESULT, STRING_14_RESULT, STRING_15_RESULT, STRING_16_RESULT, STRING_17_RESULT, STRING_18_RESULT, STRING_19_RESULT};
    private static String[] RESULT_STAR_PATHS = new String[]{OTHER_STRING_1_RESULT, OTHER_STRING_2_RESULT};
    private static String[] RESULT_EQUALS_PATHS = new String[]{OTHER_STRING_3_RESULT};
    private static String[] RESULT_STAR_PATHS_ND = new String[]{OTHER_STRING_1_ND_RESULT, OTHER_STRING_2_ND_RESULT};
    private static String[] RESULT_EQUALS_PATHS_ND = new String[]{OTHER_STRING_3_ND_RESULT};
    private static boolean isSupportedPlatform = false;
    protected static String defaultDelimiters;

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows") || osName.startsWith("linux") || osName.startsWith("mac")) {
            isSupportedPlatform = true;
        }
        defaultDelimiters = TextProcessor.getDefaultDelimiters();
    }

    public static Test suite() {
        return new TextProcessorSessionTest("org.eclipse.osgi.tests", BidiTextProcessorTestCase.class, "iw");
    }

    public BidiTextProcessorTestCase(String name) {
        super(name);
    }

    public void testBidiPaths() {
        int i = 0;
        while (i < TEST_DEFAULT_PATHS.length) {
            String result = TextProcessor.process((String)TEST_DEFAULT_PATHS[i]);
            if (isSupportedPlatform) {
                this.verifyBidiResult("Process path " + (i + 1), result, RESULT_DEFAULT_PATHS[i]);
            } else {
                this.verifyResult("Process path " + (i + 1), result, TEST_DEFAULT_PATHS[i]);
            }
            ++i;
        }
    }

    public void testBidiPathsDeprocess() {
        int i = 0;
        while (i < TEST_DEFAULT_PATHS.length) {
            String result = TextProcessor.process((String)TEST_DEFAULT_PATHS[i]);
            String resultDP = TextProcessor.deprocess((String)result);
            this.verifyBidiResult("Deprocess path " + (i + 1), resultDP, TEST_DEFAULT_PATHS[i]);
            ++i;
        }
    }

    public void testBidiPathsWithNullDelimiter() {
        int i = 0;
        while (i < TEST_DEFAULT_PATHS.length) {
            String result = TextProcessor.process((String)TEST_DEFAULT_PATHS[i], null);
            if (isSupportedPlatform) {
                this.verifyBidiResult("Process path " + (i + 1), result, RESULT_DEFAULT_PATHS[i]);
            } else {
                this.verifyResult("Process path " + (i + 1), result, TEST_DEFAULT_PATHS[i]);
            }
            ++i;
        }
    }

    public void testBidiStringWithNoDelimiters() {
        String result = TextProcessor.process((String)OTHER_STRING_NO_DELIM);
        BidiTextProcessorTestCase.assertEquals((String)"Other string containing no delimiters not equivalent.", (String)OTHER_STRING_NO_DELIM, (String)result);
    }

    public void testOtherStrings() {
        String result;
        int testNum = 1;
        int i = 0;
        while (i < TEST_STAR_PATHS.length) {
            result = TextProcessor.process((String)TEST_STAR_PATHS[i], (String)"*.");
            if (isSupportedPlatform) {
                this.verifyBidiResult("Other (star) string" + testNum, result, RESULT_STAR_PATHS[i]);
            } else {
                this.verifyResult("Other (star) string" + testNum, result, TEST_STAR_PATHS[i]);
            }
            ++testNum;
            ++i;
        }
        i = 0;
        while (i < TEST_EQUALS_PATHS.length) {
            result = TextProcessor.process((String)TEST_EQUALS_PATHS[i], (String)"=");
            if (isSupportedPlatform) {
                this.verifyBidiResult("Other (equals) string" + testNum, result, RESULT_EQUALS_PATHS[i]);
            } else {
                this.verifyResult("Other (equals) string" + testNum, result, TEST_EQUALS_PATHS[i]);
            }
            ++testNum;
            ++i;
        }
    }

    public void testOtherStringsDeprocess() {
        String resultDP;
        String result;
        int testNum = 1;
        String[] stringArray = TEST_STAR_PATHS;
        int n = TEST_STAR_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String testStarPath = stringArray[n2];
            result = TextProcessor.process((String)testStarPath, (String)"*.");
            resultDP = TextProcessor.deprocess((String)result);
            this.verifyBidiResult("Deprocess other (star) string" + testNum, resultDP, testStarPath);
            ++testNum;
            ++n2;
        }
        stringArray = TEST_EQUALS_PATHS;
        n = TEST_EQUALS_PATHS.length;
        n2 = 0;
        while (n2 < n) {
            String testEqualsPath = stringArray[n2];
            result = TextProcessor.process((String)testEqualsPath, (String)"=");
            resultDP = TextProcessor.deprocess((String)result);
            this.verifyBidiResult("Deprocess other (equals) string" + testNum, resultDP, testEqualsPath);
            ++testNum;
            ++n2;
        }
    }

    public void testOtherStringsWithNullDelimiter() {
        String result;
        int testNum = 1;
        int i = 0;
        while (i < TEST_STAR_PATHS.length) {
            result = TextProcessor.process((String)TEST_STAR_PATHS[i], null);
            if (isSupportedPlatform) {
                this.verifyBidiResult("Other (star) string" + testNum, result, RESULT_STAR_PATHS_ND[i]);
            } else {
                this.verifyResult("Other (star) string" + testNum, result, TEST_STAR_PATHS[i]);
            }
            ++testNum;
            ++i;
        }
        i = 0;
        while (i < TEST_EQUALS_PATHS.length) {
            result = TextProcessor.process((String)TEST_EQUALS_PATHS[i], null);
            if (isSupportedPlatform) {
                this.verifyBidiResult("Other (equals) string" + testNum, result, RESULT_EQUALS_PATHS_ND[i]);
            } else {
                this.verifyResult("Other (equals) string" + testNum, result, TEST_EQUALS_PATHS[i]);
            }
            ++testNum;
            ++i;
        }
    }

    public void testDoubleProcessPaths() {
        int i = 0;
        while (i < TEST_DEFAULT_PATHS.length) {
            String result = TextProcessor.process((String)TEST_DEFAULT_PATHS[i]);
            result = TextProcessor.process((String)result);
            if (isSupportedPlatform) {
                this.verifyBidiResult("Path " + (i + 1), result, RESULT_DEFAULT_PATHS[i]);
            } else {
                this.verifyResult("Path " + (i + 1), result, TEST_DEFAULT_PATHS[i]);
            }
            ++i;
        }
    }

    public void testDoubleProcessOtherStrings() {
        String result;
        int testNum = 1;
        int i = 0;
        while (i < TEST_STAR_PATHS.length) {
            result = TextProcessor.process((String)TEST_STAR_PATHS[i], (String)"*.");
            result = TextProcessor.process((String)result, (String)"*.");
            if (isSupportedPlatform) {
                this.verifyBidiResult("Other (star) string " + testNum, result, RESULT_STAR_PATHS[i]);
            } else {
                this.verifyResult("Other (star) string " + testNum, result, TEST_STAR_PATHS[i]);
            }
            ++testNum;
            ++i;
        }
        i = 0;
        while (i < TEST_EQUALS_PATHS.length) {
            result = TextProcessor.process((String)TEST_EQUALS_PATHS[i], (String)"=");
            result = TextProcessor.process((String)result, (String)"=");
            if (isSupportedPlatform) {
                this.verifyBidiResult("Other (equals) string" + testNum, result, RESULT_EQUALS_PATHS[i]);
            } else {
                this.verifyResult("Other (equals) string" + testNum, result, TEST_EQUALS_PATHS[i]);
            }
            ++testNum;
            ++i;
        }
    }

    public void testAdditionalStrings() {
        int i = 0;
        while (i < TEST_ADDITIONAL_STRINGS.length) {
            String result = TextProcessor.process((String)TEST_ADDITIONAL_STRINGS[i]);
            if (isSupportedPlatform) {
                this.verifyBidiResult("Additional string " + (i + 1), result, RESULT_ADDITIONAL_STRINGS[i]);
            } else {
                this.verifyResult("Additional string " + (i + 1), result, TEST_ADDITIONAL_STRINGS[i]);
            }
            ++i;
        }
    }

    public void testAdditionalStringsDeprocess() {
        int i = 0;
        while (i < TEST_ADDITIONAL_STRINGS.length) {
            String result = TextProcessor.process((String)TEST_ADDITIONAL_STRINGS[i]);
            String resultDP = TextProcessor.deprocess((String)result);
            this.verifyBidiResult("Additional string " + (i + 1), resultDP, TEST_ADDITIONAL_STRINGS[i]);
            ++i;
        }
    }

    public void testEmptyStringParams() {
        this.verifyBidiResult("TextProcessor.process(String) for empty string ", TextProcessor.process((String)""), EMPTY_STRING);
        this.verifyBidiResult("TextProcessor.process(String, String) for empty strings ", TextProcessor.process((String)"", (String)""), EMPTY_STRING);
    }

    public void testEmptyStringParamsDeprocess() {
        this.verifyBidiResult("TextProcessor.deprocess(String) for empty string ", TextProcessor.deprocess((String)""), EMPTY_STRING);
    }

    public void testNullParams() {
        BidiTextProcessorTestCase.assertNull((String)"TextProcessor.process(String) for null param ", (Object)TextProcessor.process(null));
        BidiTextProcessorTestCase.assertNull((String)"TextProcessor.process(String, String) for params ", (Object)TextProcessor.process(null, null));
    }

    public void testNullParamsDeprocess() {
        BidiTextProcessorTestCase.assertNull((String)"TextProcessor.deprocess(String) for null param ", (Object)TextProcessor.deprocess(null));
    }

    private void verifyBidiResult(String testName, String result, String expected) {
        boolean testResult = result.equals(expected);
        BidiTextProcessorTestCase.assertTrue((String)(testName + " result string is not the same as expected string."), (boolean)testResult);
    }
}

