/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.util;

import junit.framework.Test;
import org.eclipse.osgi.tests.util.TextProcessorSessionTest;
import org.eclipse.osgi.tests.util.TextProcessorTestCase;
import org.eclipse.osgi.util.TextProcessor;

public class LatinTextProcessorTestCase
extends TextProcessorTestCase {
    protected static String[] ALL_PATHS;

    static {
        int size = TEST_DEFAULT_PATHS.length + TEST_STAR_PATHS.length + TEST_EQUALS_PATHS.length + TEST_ADDITIONAL_STRINGS.length;
        ALL_PATHS = new String[size];
        int idx = 0;
        String[] stringArray = TEST_DEFAULT_PATHS;
        int n = TEST_DEFAULT_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String testDefaultPath;
            LatinTextProcessorTestCase.ALL_PATHS[idx] = testDefaultPath = stringArray[n2];
            ++idx;
            ++n2;
        }
        stringArray = TEST_STAR_PATHS;
        n = TEST_STAR_PATHS.length;
        n2 = 0;
        while (n2 < n) {
            String testStartPath;
            LatinTextProcessorTestCase.ALL_PATHS[idx] = testStartPath = stringArray[n2];
            ++idx;
            ++n2;
        }
        stringArray = TEST_EQUALS_PATHS;
        n = TEST_EQUALS_PATHS.length;
        n2 = 0;
        while (n2 < n) {
            String testEqualsPath;
            LatinTextProcessorTestCase.ALL_PATHS[idx] = testEqualsPath = stringArray[n2];
            ++idx;
            ++n2;
        }
        stringArray = TEST_ADDITIONAL_STRINGS;
        n = TEST_ADDITIONAL_STRINGS.length;
        n2 = 0;
        while (n2 < n) {
            String testAdditionalString;
            LatinTextProcessorTestCase.ALL_PATHS[idx] = testAdditionalString = stringArray[n2];
            ++idx;
            ++n2;
        }
    }

    public static Test suite() {
        return new TextProcessorSessionTest("org.eclipse.osgi.tests", LatinTextProcessorTestCase.class, "en");
    }

    public LatinTextProcessorTestCase(String name) {
        super(name);
    }

    public void testLatinPaths() {
        int i = 0;
        while (i < ALL_PATHS.length) {
            String result = TextProcessor.process((String)ALL_PATHS[i]);
            this.verifyResult("Process string " + (i + 1), result, ALL_PATHS[i]);
            ++i;
        }
    }

    public void testLatinPathsDeprocess() {
        int i = 0;
        while (i < ALL_PATHS.length) {
            String result = TextProcessor.process((String)ALL_PATHS[i]);
            String resultDP = TextProcessor.deprocess((String)result);
            this.verifyResult("Deprocess string " + (i + 1), resultDP, ALL_PATHS[i]);
            ++i;
        }
    }

    public void testLatinPathsWithNullDelimiter() {
        int i = 0;
        while (i < ALL_PATHS.length) {
            String result = TextProcessor.process((String)ALL_PATHS[i], null);
            this.verifyResult("Process string " + (i + 1), result, ALL_PATHS[i]);
            ++i;
        }
    }

    public void testLatinOtherStrings() {
        String result;
        int i = 0;
        while (i < TEST_STAR_PATHS.length) {
            result = TextProcessor.process((String)TEST_STAR_PATHS[i], (String)"*.");
            this.verifyResult("File association " + (i + 1), result, TEST_STAR_PATHS[i]);
            ++i;
        }
        i = 0;
        while (i < TEST_EQUALS_PATHS.length) {
            result = TextProcessor.process((String)TEST_EQUALS_PATHS[i], (String)"=");
            this.verifyResult("Equals expression " + (i + 1), result, TEST_EQUALS_PATHS[i]);
            ++i;
        }
    }

    public void testLatinOtherStringsDeprocess() {
        String resultDP;
        String result;
        int i = 0;
        while (i < TEST_STAR_PATHS.length) {
            result = TextProcessor.process((String)TEST_STAR_PATHS[i], (String)"*.");
            resultDP = TextProcessor.deprocess((String)result);
            this.verifyResult("File association " + (i + 1), resultDP, TEST_STAR_PATHS[i]);
            ++i;
        }
        i = 0;
        while (i < TEST_EQUALS_PATHS.length) {
            result = TextProcessor.process((String)TEST_EQUALS_PATHS[i], (String)"=");
            resultDP = TextProcessor.deprocess((String)result);
            this.verifyResult("Equals expression " + (i + 1), resultDP, TEST_EQUALS_PATHS[i]);
            ++i;
        }
    }

    public void testLatinOtherStringsWithNoDelimiter() {
        String result;
        int i = 0;
        while (i < TEST_STAR_PATHS.length) {
            result = TextProcessor.process((String)TEST_STAR_PATHS[i], null);
            this.verifyResult("File association " + (i + 1), result, TEST_STAR_PATHS[i]);
            ++i;
        }
        i = 0;
        while (i < TEST_EQUALS_PATHS.length) {
            result = TextProcessor.process((String)TEST_EQUALS_PATHS[i], null);
            this.verifyResult("Equals expression " + (i + 1), result, TEST_EQUALS_PATHS[i]);
            ++i;
        }
    }

    public void testEmptyStringParams() {
        this.verifyResult("TextProcessor.process(String) for empty string ", TextProcessor.process((String)""), EMPTY_STRING);
        this.verifyResult("TextProcessor.process(String, String) for empty strings ", TextProcessor.process((String)"", (String)""), EMPTY_STRING);
    }

    public void testEmptyStringParamsDeprocess() {
        this.verifyResult("TextProcessor.deprocess(String) for empty string ", TextProcessor.deprocess((String)""), EMPTY_STRING);
    }

    public void testNullParams() {
        LatinTextProcessorTestCase.assertNull((String)"TextProcessor.process(String) for null param ", (Object)TextProcessor.process(null));
        LatinTextProcessorTestCase.assertNull((String)"TextProcessor.process(String, String) for params ", (Object)TextProcessor.process(null, null));
    }

    public void testNullParamsDeprocess() {
        LatinTextProcessorTestCase.assertNull((String)"TextProcessor.deprocess(String) for null param ", (Object)TextProcessor.deprocess(null));
    }
}

