/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.ManifestElement;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class ManifestElementTestCase {
    private static final List<String> TEST_MANIFEST = Arrays.asList("Bundle-ManifestVersion: 2", "Bundle-SymbolicName: test.", " bsn", "Import-Package: test1,", " test2,", " test3", "");

    @Test
    public void testSpacesInValues() throws BundleException {
        ManifestElement[] elements = ManifestElement.parseHeader((String)"test-spaces", (String)"\"comp 1\";\"comp 2\";\"comp 3\";attr=\"val 1\";dir:=\"val 2\"");
        Assert.assertNotNull((String)"1.0", (Object)elements);
        Assert.assertEquals((String)"1.1", (long)elements.length, (long)1L);
        String[] components = elements[0].getValueComponents();
        Assert.assertEquals((String)"1.2", (long)components.length, (long)3L);
        Assert.assertEquals((String)"2.0", (Object)components[0], (Object)"comp 1");
        Assert.assertEquals((String)"2.1", (Object)components[1], (Object)"comp 2");
        Assert.assertEquals((String)"2.2", (Object)components[2], (Object)"comp 3");
        Assert.assertEquals((String)"3.0", (Object)elements[0].getAttribute("attr"), (Object)"val 1");
        Assert.assertEquals((String)"3.1", (Object)elements[0].getDirective("dir"), (Object)"val 2");
    }

    @Test
    public void testBug238675_01() throws BundleException {
        ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-NativeCode", (String)"\"external:C:/tmp/x.dll\";\"external:C:/tmp/y.dll\"; osname =WindowsXP; osverison = 2.0; processor = x86");
        Assert.assertNotNull((String)"1.0", (Object)elements);
        Assert.assertEquals((String)"1.1", (long)1L, (long)elements.length);
        String[] components = elements[0].getValueComponents();
        Assert.assertEquals((String)"1.2", (long)2L, (long)components.length);
        Assert.assertEquals((String)"2.0", (Object)"external:C:/tmp/x.dll", (Object)components[0]);
        Assert.assertEquals((String)"2.1", (Object)"external:C:/tmp/y.dll", (Object)components[1]);
    }

    @Test
    public void testBug238675_02() throws BundleException {
        ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-NativeCode", (String)"\"external:test1:test2\";\"test3:test4:\"; osname =WindowsXP; osverison = 2.0; processor = x86");
        Assert.assertNotNull((String)"1.0", (Object)elements);
        Assert.assertEquals((String)"1.1", (long)1L, (long)elements.length);
        String[] components = elements[0].getValueComponents();
        Assert.assertEquals((String)"1.2", (long)2L, (long)components.length);
        Assert.assertEquals((String)"2.0", (Object)components[0], (Object)"external:test1:test2");
        Assert.assertEquals((String)"2.1", (Object)components[1], (Object)"test3:test4:");
    }

    @Test
    public void testManifestWithCR() throws IOException, BundleException {
        this.doManifestTest("\r");
    }

    @Test
    public void testManifestWithLF() throws IOException, BundleException {
        this.doManifestTest("\n");
    }

    @Test
    public void testManifestWithCRLF() throws IOException, BundleException {
        this.doManifestTest("\r\n");
    }

    private void doManifestTest(String newLine) throws IOException, BundleException {
        Map<String, String> manifest = this.getManifest(TEST_MANIFEST, newLine);
        Assert.assertEquals((String)"Wrong Bundle-SymbolicName.", (Object)"test.bsn", (Object)manifest.get("Bundle-SymbolicName"));
        Assert.assertEquals((String)"Wrong Import-Package.", (Object)"test1,test2,test3", (Object)manifest.get("Import-Package"));
    }

    private Map<String, String> getManifest(List<String> manifestLines, String newLine) throws IOException, BundleException {
        StringBuilder manifestText = new StringBuilder();
        for (String line : manifestLines) {
            manifestText.append(line).append(newLine);
        }
        return ManifestElement.parseBundleManifest((InputStream)new ByteArrayInputStream(manifestText.toString().getBytes(StandardCharsets.UTF_8)), null);
    }
}

