/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.util;

import java.util.ArrayList;
import org.eclipse.osgi.framework.util.ObjectPool;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.osgi.framework.Version;

public class ObjectPoolTestCase {
    @Rule
    public TestName testName = new TestName();

    private String getName() {
        return this.testName.getMethodName();
    }

    @Test
    public void testObjectPool01() {
        String test2;
        String test1;
        ArrayList<String> objects = new ArrayList<String>();
        int num = 2000;
        int i = 0;
        while (i < num) {
            test1 = this.getName() + "_" + i;
            test2 = (String)ObjectPool.intern((Object)test1);
            Assert.assertTrue((String)("Strings are not the same: " + test1), (test1 == test2 ? 1 : 0) != 0);
            objects.add(test2);
            ++i;
        }
        ObjectPoolTestCase.doGC();
        i = 0;
        while (i < num) {
            test1 = this.getName() + "_" + i;
            test2 = (String)ObjectPool.intern((Object)test1);
            Assert.assertFalse((String)("Strings are the same: " + test1), (test1 == test2 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Strings are not the same: " + test1), (test2 == objects.get(i) ? 1 : 0) != 0);
            ++i;
        }
        objects.clear();
        ObjectPoolTestCase.doGC();
        i = 0;
        while (i < num) {
            test1 = this.getName() + "_" + i;
            test2 = (String)ObjectPool.intern((Object)test1);
            Assert.assertTrue((String)("Strings are not the same: " + test1), (test1 == test2 ? 1 : 0) != 0);
            objects.add(test2);
            ++i;
        }
        objects.clear();
        ObjectPoolTestCase.doGC();
    }

    @Test
    public void testObjectPool02() {
        Version testVersion2;
        Version testVersion1;
        String testString2;
        String testString1;
        ArrayList<String> strings = new ArrayList<String>();
        ArrayList<Version> versions = new ArrayList<Version>();
        int num = 2000;
        int i = 0;
        while (i < num) {
            testString1 = this.getName() + "_" + i;
            testString2 = (String)ObjectPool.intern((Object)testString1);
            Assert.assertTrue((String)("Strings are not the same: " + testString1), (testString1 == testString2 ? 1 : 0) != 0);
            strings.add(testString2);
            testVersion1 = new Version(i, i, i, this.getName() + "_" + i);
            testVersion2 = (Version)ObjectPool.intern((Object)testVersion1);
            Assert.assertTrue((String)("Versions are not the same: " + String.valueOf(testVersion1)), (testVersion1 == testVersion2 ? 1 : 0) != 0);
            versions.add(testVersion2);
            ++i;
        }
        ObjectPoolTestCase.doGC();
        i = 0;
        while (i < num) {
            testString1 = this.getName() + "_" + i;
            testString2 = (String)ObjectPool.intern((Object)testString1);
            Assert.assertFalse((String)("Strings are the same: " + testString1), (testString1 == testString2 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Strings are not the same: " + testString1), (testString2 == strings.get(i) ? 1 : 0) != 0);
            testVersion1 = new Version(i, i, i, this.getName() + "_" + i);
            testVersion2 = (Version)ObjectPool.intern((Object)testVersion1);
            Assert.assertFalse((String)("Versions are the same: " + String.valueOf(testVersion1)), (testVersion1 == testVersion2 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Versions are not the same: " + String.valueOf(testVersion1)), (testVersion2 == versions.get(i) ? 1 : 0) != 0);
            ++i;
        }
        strings.clear();
        versions.clear();
        ObjectPoolTestCase.doGC();
        i = 0;
        while (i < num) {
            testString1 = this.getName() + "_" + i;
            testString2 = (String)ObjectPool.intern((Object)testString1);
            Assert.assertTrue((String)("Strings are not the same: " + testString1), (testString1 == testString2 ? 1 : 0) != 0);
            strings.add(testString2);
            testVersion1 = new Version(i, i, i, this.getName() + "_" + i);
            testVersion2 = (Version)ObjectPool.intern((Object)testVersion1);
            Assert.assertTrue((String)("Versions are not the same: " + String.valueOf(testVersion1)), (testVersion1 == testVersion2 ? 1 : 0) != 0);
            versions.add(testVersion2);
            ++i;
        }
        strings.clear();
        versions.clear();
        ObjectPoolTestCase.doGC();
    }

    private static void doGC() {
        System.gc();
        System.runFinalization();
        System.gc();
        System.runFinalization();
    }
}

