/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.junit.Assert;
import org.junit.Test;

public class TestCaseinsensitiveMap {
    static String[] COMMON_KEY_NAMES = new String[]{"objectClass", "service.bundleid", "service.changecount", "service.description", "service.id", "service.pid", "service.ranking", "service.scope", "service.vendor", "component.name", "component.id", "metatype.pid", "metatype.factory.pid", "event.topics", "event.filter", "jmx.objectname", "Manifest-Version", "Bundle-ActivationPolicy", "Bundle-Activator", "Bundle-ClassPath", "Bundle-Description", "Bundle-License", "Bundle-Localization", "Bundle-ManifestVersion", "Bundle-Name", "Bundle-NativeCode", "Bundle-RequiredExecutionEnvironment", "Bundle-SCM", "Bundle-SymbolicName", "Bundle-Vendor", "Bundle-Version", "DynamicImport-Package", "Export-Package", "Fragment-Host", "Import-Package", "Require-Bundle", "Require-Capability", "Provide-Capability"};
    String[] OTHER_KEY_NAMES = new String[]{"test.key0", "test.key1", "test.key2", "test.key3", "test.key4", "test.key5", "test.key6", "test.key7", "test.key8", "test.key9"};
    private static final String VALUE1 = "-VALUE1";
    private static final String VALUE2 = "-VALUE2";

    @Test
    public void testCommonKeys() {
        this.testKeys(COMMON_KEY_NAMES);
    }

    @Test
    public void testOtherKeys() {
        this.testKeys(this.OTHER_KEY_NAMES);
    }

    private void testKeys(String[] keys) {
        CaseInsensitiveDictionaryMap testMap = new CaseInsensitiveDictionaryMap();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            testMap.put(key, key + VALUE1);
            Assert.assertEquals((String)"Wrong value found.", (Object)(key + VALUE1), testMap.get(key));
            ++n2;
        }
        HashSet<String> upperKeys = new HashSet<String>();
        String[] stringArray2 = keys;
        int n3 = keys.length;
        n = 0;
        while (n < n3) {
            String key = stringArray2[n];
            String upperKey = key.toUpperCase();
            upperKeys.add(upperKey);
            Assert.assertEquals((String)"Wrong value found.", (Object)(key + VALUE1), testMap.get(upperKey));
            Assert.assertEquals((String)"Wrong value found.", (Object)(key + VALUE1), (Object)testMap.put(upperKey, key + VALUE2));
            Assert.assertEquals((String)"Wrong value found.", (Object)(key + VALUE2), testMap.get(key));
            Assert.assertEquals((String)"Wrong value found.", (Object)(key + VALUE2), testMap.get(upperKey));
            ++n;
        }
        Set currentKeys = testMap.keySet();
        Assert.assertEquals((String)"Wrong number of keys.", (long)upperKeys.size(), (long)currentKeys.size());
        Assert.assertTrue((String)("Wrong keys found: " + String.valueOf(currentKeys)), (boolean)upperKeys.containsAll(currentKeys));
    }
}

