/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Platform;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.osgi.framework.Version;

public class BuildTests {
    private static final String PLATFORM_FEATURE = "org.eclipse.platform_";
    public static final List<String> REQUIRED_FEATURE_FILES_EPL2 = List.of("epl-2.0.html", "feature.properties", "feature.xml", "license.html");
    public static final String REQUIRED_FEATURE_SUFFIX = "";
    public static final List<String> REQUIRED_PLUGIN_FILES = List.of("about.html", "plugin.properties", "plugin.xml");
    public static final String REQUIRED_PLUGIN_SUFFIX = ".jar";
    public static final List<String> REQUIRED_FEATURE_PLUGIN_FILES = List.of("about.html", "about.ini", "about.mappings", "about.properties", "plugin.properties", "plugin.xml");
    public static final String REQUIRED_FEATURE_PLUGIN_SUFFIX = ".gif";
    public static final List<String> REQUIRED_FRAGMENT_FILES = List.of("fragment.xml");
    public static final String REQUIRED_FRAGMENT_SUFFIX = "";
    public static final List<String> REQUIRED_SWT_FRAGMENT_FILES = List.of("fragment.properties");
    public static final String REQUIRED_SWT_FRAGMENT_SUFFIX = "";
    public static final List<String> REQUIRED_SOURCE_FILES = List.of("about.html");
    public static final String REQUIRED_SOURCE_SUFFIX = ".zip";
    public static final List<String> REQUIRED_BUNDLE_FILES = List.of("about.html");
    public static final String REQUIRED_BUNDLE_MANIFEST = "MANIFEST.MF";
    public static final String REQUIRED_BUNDLE_SUFFIX = ".jar";
    public static final List<String> SUFFIX_EXEMPT_LIST = List.of("org.eclipse.swt", "org.apache.ant");
    public static final int PLUGIN_COUNT = 84;
    public static final int FEATURE_COUNT = 9;

    @Test
    public void testFeatureFiles() {
        Assume.assumeFalse((boolean)this.isMavenRun());
        ArrayList<String> result = new ArrayList<String>();
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] fileArray = featureDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File aFeature = fileArray[n2];
            List<String> testFiles = REQUIRED_FEATURE_FILES_EPL2;
            if (!this.testDirectory(aFeature, testFiles, "")) {
                result.add(aFeature.getPath());
            }
            ++n2;
        }
        Object aString = "";
        if (!result.isEmpty()) {
            for (String element : result) {
                aString = (String)aString + element + "; ";
            }
        }
        Assert.assertTrue((String)("Feature directory missing required files: " + (String)aString), (boolean)result.isEmpty());
    }

    @Test
    public void testProductFileVersion() throws Exception {
        Assume.assumeFalse((boolean)this.isMavenRun());
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File productFile = new File(installDir, ".eclipseproduct");
        Properties props = new Properties();
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream stream = Files.newInputStream(productFile.toPath(), new OpenOption[0]);){
            props.load(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String versionProp = props.getProperty("version");
        Assert.assertNotNull((String)("'version' property not found in " + String.valueOf(productFile)), (Object)versionProp);
        File featureDir = new File(installDir, "features");
        String versionStr = null;
        File[] fileArray = featureDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File feature = fileArray[n2];
            String featureName = feature.getName();
            if (featureName.startsWith(PLATFORM_FEATURE)) {
                versionStr = featureName.substring(PLATFORM_FEATURE.length(), featureName.length());
                break;
            }
            ++n2;
        }
        Assert.assertNotNull((String)("Failed to find platform feature at " + String.valueOf(featureDir)), versionStr);
        Assert.assertTrue((String)("Failed to find product file at " + String.valueOf(productFile)), (boolean)productFile.isFile());
        Version featureVersion = new Version(versionStr);
        featureVersion = new Version(featureVersion.getMajor(), featureVersion.getMinor(), featureVersion.getMicro());
        Version productVersion = new Version(versionProp);
        Assert.assertEquals((String)"Product version doesn't match version of the platform", (Object)featureVersion, (Object)productVersion);
    }

    @Test
    public void testPluginFiles() {
        Assume.assumeFalse((boolean)this.isMavenRun());
        ArrayList<String> result = new ArrayList<String>();
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] fileArray = pluginDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File aPlugin = fileArray[n2];
            String name = aPlugin.getName();
            if (!(name.contains("test") || !name.startsWith("org.eclipse") || name.contains("org.eclipse.jetty") || name.contains("org.eclipse.ecf") || name.startsWith("org.eclipse.orbit") || this.testPluginFile(aPlugin))) {
                result.add(aPlugin.getPath());
            }
            ++n2;
        }
        Object aString = "";
        if (!result.isEmpty()) {
            for (String element : result) {
                aString = (String)aString + element + "; ";
            }
        }
        Assert.assertTrue((String)("Plugin directory missing required files: " + (String)aString), (boolean)result.isEmpty());
    }

    private boolean isMavenRun() {
        return System.getenv("MAVEN_CMD_LINE_ARGS") != null;
    }

    private boolean testPluginFile(File aPlugin) {
        if (this.testDirectory(aPlugin, REQUIRED_PLUGIN_FILES, REQUIRED_SOURCE_SUFFIX)) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_FEATURE_PLUGIN_FILES, REQUIRED_FEATURE_PLUGIN_SUFFIX)) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_PLUGIN_FILES, ".jar")) {
            return true;
        }
        if (this.testSourcePlugin(aPlugin)) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_FRAGMENT_FILES, "") || this.testBundleDirectory(aPlugin, REQUIRED_BUNDLE_FILES, REQUIRED_BUNDLE_MANIFEST, "")) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_SWT_FRAGMENT_FILES, "")) {
            return true;
        }
        return this.testBundleDirectory(aPlugin, REQUIRED_BUNDLE_FILES, REQUIRED_BUNDLE_MANIFEST, ".jar");
    }

    private boolean testPluginJar(File aDirectory, List<String> requiredFiles) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipFile jarredPlugin = new ZipFile(aDirectory);){
                Enumeration<? extends ZipEntry> _enum = jarredPlugin.entries();
                while (_enum.hasMoreElements()) {
                    list.add(_enum.nextElement().toString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list.containsAll(requiredFiles);
    }

    private boolean testDirectory(File aDirectory, List<String> requiredFiles, String requiredSuffix) {
        if (aDirectory.getName().endsWith(".jar")) {
            return this.testPluginJar(aDirectory, requiredFiles);
        }
        if (!Arrays.asList(aDirectory.list()).containsAll(requiredFiles)) {
            return false;
        }
        int index = aDirectory.getName().indexOf(95);
        if (index == -1) {
            index = aDirectory.getName().length();
        }
        String plainName = aDirectory.getName().substring(0, index);
        if (requiredSuffix.isEmpty() || SUFFIX_EXEMPT_LIST.contains(plainName)) {
            return true;
        }
        return aDirectory.listFiles(new FileSuffixFilter(requiredSuffix)).length != 0;
    }

    private boolean testBundleDirectory(File aDirectory, List<String> requiredFiles, String manifestFile, String requiredSuffix) {
        if (aDirectory.getName().endsWith(".jar")) {
            return this.testPluginJar(aDirectory, requiredFiles);
        }
        if (!Arrays.asList(aDirectory.list()).containsAll(requiredFiles)) {
            return false;
        }
        int index = aDirectory.getName().indexOf(95);
        if (index == -1) {
            index = aDirectory.getName().length();
        }
        String plainName = aDirectory.getName().substring(0, index);
        File metaDir = new File(aDirectory, "META-INF");
        String[] metaFiles = metaDir.list();
        if (metaFiles == null) {
            return false;
        }
        String[] stringArray = metaFiles;
        int n = metaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (filename == manifestFile) {
                return true;
            }
            ++n2;
        }
        if (!metaDir.exists()) {
            return false;
        }
        if (requiredSuffix.isEmpty() || SUFFIX_EXEMPT_LIST.contains(plainName)) {
            return true;
        }
        return aDirectory.listFiles(new FileSuffixFilter(requiredSuffix)).length != 0;
    }

    private boolean testSourcePlugin(File aPlugin) {
        if (!this.testDirectory(aPlugin, REQUIRED_PLUGIN_FILES, "")) {
            return false;
        }
        File sourceDir = new File(aPlugin, "src");
        File[] sourceDirs = sourceDir.listFiles();
        if (sourceDirs == null) {
            return false;
        }
        File[] fileArray = sourceDirs;
        int n = sourceDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File aSourceDir = fileArray[n2];
            if (!this.testDirectory(aSourceDir, REQUIRED_SOURCE_FILES, REQUIRED_SOURCE_SUFFIX)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Test
    public void testJavadocLogs() throws Exception {
        boolean problemLogsExist;
        Assume.assumeFalse((boolean)this.isMavenRun());
        String javadocUrls = System.getProperty("RELENGTEST.JAVADOC.URLS");
        if (javadocUrls == null) {
            System.err.println("WARNING: no javadoc logs to test, since RELENGTEST.JAVADOC.URLS property was not set");
            return;
        }
        System.err.println("RELENGTEST.JAVADOC.URLS: " + javadocUrls);
        String[] urls = javadocUrls.split(",");
        URL[] javadocLogs = new URL[urls.length];
        int i = 0;
        while (i < urls.length) {
            javadocLogs[i] = new URL(urls[i]);
            System.err.println("javadocLogs[" + i + "]: " + String.valueOf(javadocLogs[i]));
            ++i;
        }
        JavadocLog javadocLog = new JavadocLog(javadocLogs);
        String message = "javadoc errors and/or warnings in: \n";
        boolean bl = problemLogsExist = !javadocLog.logs.isEmpty();
        if (problemLogsExist) {
            int i2 = 0;
            while (i2 < javadocLog.logs.size()) {
                message = message.concat(javadocLog.logs.get(i2) + "\n");
                ++i2;
            }
        }
        message = message.concat("See the javadoc logs linked from the test results page for details");
        Assert.assertTrue((String)message, (!problemLogsExist ? 1 : 0) != 0);
    }

    @Test
    public void testJarSign() throws Exception {
        Assume.assumeFalse((boolean)this.isMavenRun());
        String buildId = System.getProperty("buildId");
        Assert.assertNotNull((String)"buildId property must be specified for testJarSign test", (Object)buildId);
        String downloadHost = "download.eclipse.org";
        String urlOfFile = "https://" + downloadHost + "/eclipse/downloads/drops4/" + buildId + "/buildlogs/reporeports/reports/unsigned8.txt";
        URL logURL = new URL(urlOfFile);
        URLConnection urlConnection = logURL.openConnection();
        long nBytes = urlConnection.getContentLength();
        Assert.assertTrue((String)("Some bundles are unsigned please refer  " + urlOfFile), (2L > nBytes ? 1 : 0) != 0);
    }

    private String getDownloadHost() {
        String downloadHost = System.getProperty("downloadHost");
        if (downloadHost == null) {
            downloadHost = "download.eclipse.org";
        }
        return downloadHost;
    }

    private void printHeaders(URLConnection urlConnection) {
        System.out.println("Debug: Headers for urlConnection to " + String.valueOf(urlConnection.getURL()));
        Map<String, List<String>> allFields = urlConnection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : allFields.entrySet()) {
            for (String value : entry.getValue()) {
                System.out.printf("Debug: %-20s %-30s %n", "key: " + entry.getKey(), "value: " + value);
            }
        }
    }

    @Test
    public void testComparatorLogSize() throws Exception {
        Assume.assumeFalse((boolean)this.isMavenRun());
        boolean DEBUG_TEST = true;
        long MAX_ALLOWED_BYTES = 319L;
        String buildId = System.getProperty("buildId");
        Assert.assertNotNull((String)"buildId property must be specified for testComparatorLogSize test", (Object)buildId);
        String downloadHost = this.getDownloadHost();
        String urlOfFile = "https://" + downloadHost + "/eclipse/downloads/drops4/" + buildId + "/buildlogs/comparatorlogs/buildtimeComparatorUnanticipated.log.txt";
        URL logURL = new URL(urlOfFile);
        URLConnection urlConnection = logURL.openConnection();
        long nBytes = urlConnection.getContentLength();
        System.out.println("Debug info for testComparatorLogSize");
        System.out.println("Debug: nBytes: " + nBytes);
        this.printHeaders(urlConnection);
        Assert.assertTrue((String)("Either file (url) does not exist, or HTTP response does not contain content length. urlOfFile: " + urlOfFile), (-1L != nBytes ? 1 : 0) != 0);
        Assert.assertTrue((String)("Unanticipated comparator log file has increased in size, indicating a regression. See " + urlOfFile), (nBytes <= MAX_ALLOWED_BYTES ? 1 : 0) != 0);
        if (MAX_ALLOWED_BYTES > nBytes + 20L) {
            System.out.println("WARNING: MAX_ALLOWED_BYTES was larger than bytes found, by " + (MAX_ALLOWED_BYTES - nBytes) + ", which may indicate MAX_ALLOWED_BYTES needs to be lowered, to catch regressions.");
        }
    }

    public class FileSuffixFilter
    implements FilenameFilter {
        private String suffix;

        public FileSuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File dir, String name) {
            int lastDot = name.lastIndexOf(46);
            if (lastDot == -1) {
                return false;
            }
            return name.substring(lastDot).equals(this.suffix);
        }
    }

    private class JavadocLog {
        private ArrayList<String> logs = new ArrayList();

        private JavadocLog(URL[] logs) {
            this.findProblems(logs);
        }

        private void findProblems(URL[] javadocLogs) {
            String JAVADOC_WARNING = ": warning";
            String JAVADOC_ERROR = ": error";
            String JAVADOC_JAVA = ".java:";
            URL[] uRLArray = javadocLogs;
            int n = javadocLogs.length;
            int n2 = 0;
            while (n2 < n) {
                URL javadocLog = uRLArray[n2];
                try {
                    Throwable throwable = null;
                    Object var10_13 = null;
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(javadocLog.openStream()));){
                        String tmp;
                        while ((tmp = in.readLine()) != null) {
                            String fileName;
                            if (!(tmp = tmp.toLowerCase()).contains(JAVADOC_ERROR) && !tmp.contains(JAVADOC_WARNING) && !tmp.contains(JAVADOC_JAVA) || this.logs.contains(fileName = new File(javadocLog.getFile()).getName())) continue;
                            this.logs.add(fileName);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (FileNotFoundException e) {
                    this.logs.add("Unable to find " + new File(javadocLog.getFile()).getName() + " to read.");
                    e.printStackTrace();
                }
                catch (IOException e) {
                    this.logs.add("Unable to read " + new File(javadocLog.getFile()).getName());
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }
}

