/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundleShapeAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactDescriptorQuery;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public abstract class AbstractProvisioningTest
extends TestCase {
    protected static final VersionRange ANY_VERSION = VersionRange.emptyRange;
    protected static final IProvidedCapability[] BUNDLE_CAPABILITY = new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"eclipse.touchpoint", (String)"bundle", (Version)Version.createOSGi((int)1, (int)0, (int)0))};
    private static final IRequirement[] BUNDLE_REQUIREMENT = new IRequirement[]{MetadataFactory.createRequirement((String)"eclipse.touchpoint", (String)"bundle", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)true)};
    protected static final Version DEFAULT_VERSION = Version.createOSGi((int)1, (int)0, (int)0);
    public static final ITouchpointType TOUCHPOINT_OSGI = MetadataFactory.createTouchpointType((String)"org.eclipse.equinox.p2.osgi", (Version)Version.createOSGi((int)1, (int)0, (int)0));
    protected static final Map<String, String> NO_PROPERTIES = Collections.emptyMap();
    protected static final IProvidedCapability[] NO_PROVIDES = new IProvidedCapability[0];
    protected static final IRequiredCapability[] NO_REQUIRES = new IRequiredCapability[0];
    protected static final ITouchpointData NO_TP_DATA = MetadataFactory.createTouchpointData(new HashMap());
    protected boolean DISABLED = true;
    private final List<IMetadataRepository> metadataRepos = new ArrayList<IMetadataRepository>();
    protected List<String> profilesToRemove = new ArrayList<String>();
    private File testFolder = null;
    protected Object previousSelfValue = null;

    public static void assertEmptyProfile(IProfile profile) {
        AbstractProvisioningTest.assertNotNull((String)"The profile should not be null", (Object)profile);
        if (AbstractProvisioningTest.getInstallableUnits(profile).hasNext()) {
            AbstractProvisioningTest.fail((String)("The profile should be empty,profileId=" + String.valueOf(profile)));
        }
    }

    protected static void assertNotIUs(IInstallableUnit[] ius, Iterator<IInstallableUnit> installableUnits) {
        HashSet<IInstallableUnit> notexpected = new HashSet<IInstallableUnit>();
        notexpected.addAll(Arrays.asList(ius));
        while (installableUnits.hasNext()) {
            IInstallableUnit next = installableUnits.next();
            if (!notexpected.contains(next)) continue;
            AbstractProvisioningTest.fail((String)("not expected [" + String.valueOf(next) + "]"));
        }
    }

    protected static void assertNotOK(IStatus result) {
        AbstractProvisioningTest.assertNotOK("The status should not have been OK", result);
    }

    protected static void assertNotOK(String message, IStatus result) {
        AbstractProvisioningTest.assertTrue((String)message, (!result.isOK() ? 1 : 0) != 0);
    }

    public static void assertOK(IStatus status) {
        AbstractProvisioningTest.assertOK("The status should have been OK.", status);
    }

    protected static void assertOK(String message, IStatus status) {
        IStatus[] children;
        if (status.isOK()) {
            return;
        }
        IStatus[] iStatusArray = children = status.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            if (!child.isOK()) {
                new CoreException(child).printStackTrace();
            }
            ++n2;
        }
        AbstractProvisioningTest.fail(message + " " + status.getMessage(), status.getException());
    }

    protected static void assertProfileContains(String message, IProfile profile, IInstallableUnit[] expectedUnits) {
        HashSet<IInstallableUnit> expected = new HashSet<IInstallableUnit>(Arrays.asList(expectedUnits));
        Iterator<IInstallableUnit> it = AbstractProvisioningTest.getInstallableUnits(profile);
        while (it.hasNext()) {
            IInstallableUnit actual = it.next();
            if (expected.remove(actual)) continue;
            AbstractProvisioningTest.fail((String)(message + " profile " + profile.getProfileId() + " contained an unexpected unit: " + String.valueOf(actual)));
        }
        if (!expected.isEmpty()) {
            AbstractProvisioningTest.fail((String)(message + " profile " + profile.getProfileId() + " did not contain expected units: " + String.valueOf(expected)));
        }
    }

    protected static void assertProfileContainsAll(String message, IProfile profile2, IInstallableUnit[] expectedUnits) {
        HashSet<IInstallableUnit> expected = new HashSet<IInstallableUnit>(Arrays.asList(expectedUnits));
        Iterator<IInstallableUnit> it = AbstractProvisioningTest.getInstallableUnits(profile2);
        while (it.hasNext()) {
            IInstallableUnit actual = it.next();
            expected.remove(actual);
        }
        if (!expected.isEmpty()) {
            AbstractProvisioningTest.fail((String)(message + " profile " + profile2.getProfileId() + " did not contain expected units: " + String.valueOf(expected)));
        }
    }

    public static void copy(String message, File source, File target) {
        AbstractProvisioningTest.copy(message, source, target, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(String message, File source, File target, FileFilter filter) {
        if (!source.exists()) {
            return;
        }
        if (source.isDirectory()) {
            File[] children;
            if (target.exists() && target.isFile()) {
                target.delete();
            }
            if (!target.exists()) {
                target.mkdirs();
            }
            File[] fileArray = children = source.listFiles(filter);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                AbstractProvisioningTest.copy(message, child, new File(target, child.getName()));
                ++n2;
            }
            return;
        }
        try {
            Throwable children = null;
            Object var5_14 = null;
            try {
                InputStream input = Files.newInputStream(source.toPath(), new OpenOption[0]);
                try {
                    try (OutputStream output = Files.newOutputStream(target.toPath(), new OpenOption[0]);){
                        input.transferTo(output);
                    }
                    if (input == null) return;
                }
                catch (Throwable throwable) {
                    if (children == null) {
                        children = throwable;
                    } else if (children != throwable) {
                        children.addSuppressed(throwable);
                    }
                    if (input == null) throw children;
                    input.close();
                    throw children;
                }
                input.close();
                return;
            }
            catch (Throwable throwable) {
                if (children == null) {
                    children = throwable;
                    throw children;
                } else {
                    if (children == throwable) throw children;
                    children.addSuppressed(throwable);
                }
                throw children;
            }
        }
        catch (IOException e) {
            AbstractProvisioningTest.fail(message, e);
        }
    }

    public static void move(String message, File source, File target) {
        AbstractProvisioningTest.move(message, source, target, null);
    }

    public static void move(String message, File source, File target, FileFilter filter) {
        if (!source.exists()) {
            return;
        }
        if (filter == null && source.renameTo(target)) {
            return;
        }
        if (source.isDirectory()) {
            File[] children;
            if (target.exists() && target.isFile()) {
                target.delete();
            }
            if (!target.exists()) {
                target.mkdirs();
            }
            File[] fileArray = children = source.listFiles(filter);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                AbstractProvisioningTest.move(message, child, new File(target, child.getName()), filter);
                ++n2;
            }
            return;
        }
        if (target.isDirectory()) {
            AbstractProvisioningTest.delete(target);
        }
        if (source.renameTo(target)) {
            return;
        }
        AbstractProvisioningTest.copy(message, source, target);
        if (target.exists()) {
            AbstractProvisioningTest.delete(source);
        }
    }

    public static IInstallableUnitFragment createBundleFragment(String name) {
        MetadataFactory.InstallableUnitFragmentDescription fragment = new MetadataFactory.InstallableUnitFragmentDescription();
        fragment.setId(name);
        fragment.setVersion(DEFAULT_VERSION);
        fragment.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        fragment.setTouchpointType(TOUCHPOINT_OSGI);
        fragment.addTouchpointData(NO_TP_DATA);
        fragment.setHost(BUNDLE_REQUIREMENT);
        fragment.setCapabilities(new IProvidedCapability[]{AbstractProvisioningTest.getSelfCapability(name, fragment.getVersion())});
        return MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)fragment);
    }

    public static IInstallableUnitFragment createBundleFragment(String name, Version version, ITouchpointData tpData) {
        return AbstractProvisioningTest.createIUFragment(null, name, version, BUNDLE_REQUIREMENT, TOUCHPOINT_OSGI, tpData);
    }

    public IInstallableUnit createBundleIU(BundleDescription bd, boolean isFolder, IArtifactKey key) {
        PublisherInfo info = new PublisherInfo();
        String shape = isFolder ? "dir" : "jar";
        info.addAdvice((IPublisherAdvice)new BundleShapeAdvice(bd.getSymbolicName(), PublisherHelper.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion()), shape));
        return BundlesAction.createBundleIU((BundleDescription)bd, (IArtifactKey)key, (IPublisherInfo)info);
    }

    public static IDirector createDirector() {
        return (IDirector)AbstractProvisioningTest.getAgent().getService(IDirector.class);
    }

    public static IInstallableUnit createEclipseIU(String name) {
        return AbstractProvisioningTest.createEclipseIU(name, DEFAULT_VERSION);
    }

    public static IInstallableUnit createEclipseIU(String name, Version version) {
        return AbstractProvisioningTest.createIU(name, version, null, (IRequirement[])NO_REQUIRES, BUNDLE_CAPABILITY, NO_PROPERTIES, TOUCHPOINT_OSGI, NO_TP_DATA, false);
    }

    public static IInstallableUnit createEclipseIUSingleton(String name, Version version) {
        return AbstractProvisioningTest.createIU(name, version, null, (IRequirement[])NO_REQUIRES, BUNDLE_CAPABILITY, NO_PROPERTIES, TOUCHPOINT_OSGI, NO_TP_DATA, true);
    }

    public static IInstallableUnit createEclipseIU(String name, Version version, IRequirement[] requires, ITouchpointData touchpointData) {
        return AbstractProvisioningTest.createIU(name, version, null, requires, BUNDLE_CAPABILITY, NO_PROPERTIES, TOUCHPOINT_OSGI, touchpointData, false);
    }

    public static IEngine createEngine() {
        return (IEngine)AbstractProvisioningTest.getAgent().getService(IEngine.class);
    }

    protected static IMatchExpression<IInstallableUnit> createFilter(String filterKey, String filterValue) {
        return InstallableUnit.parseFilter((String)("(" + filterKey + "=" + filterValue + ")"));
    }

    public static IInstallableUnit createIU(String name) {
        return AbstractProvisioningTest.createIU(name, DEFAULT_VERSION);
    }

    public static IInstallableUnit createIU(String name, IProvidedCapability[] additionalProvides) {
        return AbstractProvisioningTest.createIU(name, DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, additionalProvides, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false);
    }

    public static IInstallableUnit createIU(String name, IRequirement[] requires) {
        return AbstractProvisioningTest.createIU(name, DEFAULT_VERSION, null, requires, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false);
    }

    public static IInstallableUnit createIU(String name, IRequirement[] requires, boolean singleton) {
        return AbstractProvisioningTest.createIU(name, DEFAULT_VERSION, null, requires, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, singleton);
    }

    public static IInstallableUnit createIU(String name, String filter, IProvidedCapability[] additionalProvides) {
        return AbstractProvisioningTest.createIU(name, (IMatchExpression<IInstallableUnit>)InstallableUnit.parseFilter((String)filter), additionalProvides);
    }

    public static IInstallableUnit createIU(String name, IMatchExpression<IInstallableUnit> filter, IProvidedCapability[] additionalProvides) {
        return AbstractProvisioningTest.createIU(name, DEFAULT_VERSION, filter, (IRequirement[])NO_REQUIRES, additionalProvides, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false);
    }

    public static IInstallableUnit createIU(String name, Version version) {
        return AbstractProvisioningTest.createIU(name, version, null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false);
    }

    public static IInstallableUnit createIU(String name, Version version, boolean singleton) {
        return AbstractProvisioningTest.createIU(name, version, null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, singleton);
    }

    public static IInstallableUnit createIU(String name, Version version, IProvidedCapability[] additionalProvides) {
        return AbstractProvisioningTest.createIU(name, version, null, (IRequirement[])NO_REQUIRES, additionalProvides, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false);
    }

    public static IInstallableUnit createIU(String name, Version version, IRequirement[] required) {
        return AbstractProvisioningTest.createIU(name, version, null, required, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false);
    }

    public static IInstallableUnit createIUWithMetaRequirement(String name, Version version, boolean singleton, IRequirement[] requirements, IRequirement[] metaRequirements) {
        return AbstractProvisioningTest.createIU(name, version, null, requirements, NO_PROVIDES, NO_PROPERTIES, null, NO_TP_DATA, singleton, null, metaRequirements);
    }

    public static IInstallableUnit createIU(String name, Version version, IRequirement[] required, Map<String, String> properties, boolean singleton) {
        return AbstractProvisioningTest.createIU(name, version, null, required, NO_PROVIDES, properties, ITouchpointType.NONE, NO_TP_DATA, singleton);
    }

    public static IInstallableUnit createIU(String name, Version version, String filter, IProvidedCapability[] additionalProvides) {
        return AbstractProvisioningTest.createIU(name, version, (IMatchExpression<IInstallableUnit>)InstallableUnit.parseFilter((String)filter), additionalProvides);
    }

    public static IInstallableUnit createIU(String name, Version version, IMatchExpression<IInstallableUnit> filter, IProvidedCapability[] additionalProvides) {
        return AbstractProvisioningTest.createIU(name, version, filter, (IRequirement[])NO_REQUIRES, additionalProvides, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false);
    }

    public static IInstallableUnit createIU(String name, Version version, IMatchExpression<IInstallableUnit> filter, IRequirement[] required, IProvidedCapability[] additionalProvides, Map<String, String> properties, ITouchpointType tpType, ITouchpointData tpData, boolean singleton) {
        return AbstractProvisioningTest.createIU(name, version, filter, required, additionalProvides, properties, tpType, tpData, singleton, null, null);
    }

    public static IInstallableUnitPatch createIUPatch(String name, Version version, boolean singleton, IRequirementChange[] changes, IRequirement[][] scope, IRequirement lifeCycle) {
        return AbstractProvisioningTest.createIUPatch(name, version, null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, singleton, null, changes, scope, lifeCycle, (IRequirement[])NO_REQUIRES);
    }

    public static IInstallableUnitPatch createIUPatch(String name, Version version, IMatchExpression<IInstallableUnit> filter, IRequirement[] required, IProvidedCapability[] additionalProvides, Map<String, String> properties, ITouchpointType tpType, ITouchpointData tpData, boolean singleton, IUpdateDescriptor update, IRequirementChange[] reqChanges, IRequirement[][] scope, IRequirement lifeCycle, IRequirement[] metaRequirements) {
        MetadataFactory.InstallableUnitPatchDescription iu = new MetadataFactory.InstallableUnitPatchDescription();
        iu.setId(name);
        iu.setVersion(version);
        iu.setFilter(filter);
        IProvidedCapability[] provides = new IProvidedCapability[additionalProvides.length + 1];
        provides[0] = AbstractProvisioningTest.getSelfCapability(name, version);
        int i = 0;
        while (i < additionalProvides.length) {
            provides[i + 1] = additionalProvides[i];
            ++i;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            iu.setProperty(entry.getKey(), entry.getValue());
        }
        iu.setCapabilities(provides);
        iu.setRequirements(required);
        iu.setTouchpointType(tpType);
        if (tpData != null) {
            iu.addTouchpointData(tpData);
        }
        iu.setSingleton(singleton);
        iu.setUpdateDescriptor(update);
        iu.setRequirementChanges(reqChanges);
        iu.setApplicabilityScope(scope);
        iu.setLifeCycle(lifeCycle);
        iu.setMetaRequirements(metaRequirements);
        return MetadataFactory.createInstallableUnitPatch((MetadataFactory.InstallableUnitPatchDescription)iu);
    }

    public static IInstallableUnit createIU(String name, Version version, IMatchExpression<IInstallableUnit> filter, IRequirement[] required, IProvidedCapability[] additionalProvides, Map<String, String> properties, ITouchpointType tpType, ITouchpointData tpData, boolean singleton, IUpdateDescriptor update, IRequirement[] metaRequirements) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId(name);
        iu.setVersion(version);
        iu.setFilter(filter);
        IProvidedCapability[] provides = new IProvidedCapability[additionalProvides.length + 1];
        provides[0] = AbstractProvisioningTest.getSelfCapability(name, version);
        int i = 0;
        while (i < additionalProvides.length) {
            provides[i + 1] = additionalProvides[i];
            ++i;
        }
        for (String nextKey : properties.keySet()) {
            String nextValue = properties.get(nextKey);
            iu.setProperty(nextKey, nextValue);
        }
        iu.setCapabilities(provides);
        iu.setRequirements(required);
        iu.setTouchpointType(tpType);
        if (tpData != null) {
            iu.addTouchpointData(tpData);
        }
        iu.setSingleton(singleton);
        iu.setUpdateDescriptor(update);
        if (metaRequirements == null) {
            metaRequirements = NO_REQUIRES;
        }
        iu.setMetaRequirements(metaRequirements);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    public static IInstallableUnitFragment createIUFragment(IInstallableUnit host, String name, Version version) {
        return AbstractProvisioningTest.createIUFragment(host, name, version, (IRequirement[])NO_REQUIRES, ITouchpointType.NONE, NO_TP_DATA);
    }

    public static IInstallableUnitFragment createIUFragment(IInstallableUnit host, String name, Version version, IRequirement[] required, ITouchpointType tpType, ITouchpointData tpData) {
        MetadataFactory.InstallableUnitFragmentDescription fragment = new MetadataFactory.InstallableUnitFragmentDescription();
        fragment.setId(name);
        fragment.setVersion(version);
        fragment.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        fragment.setRequirements(required);
        fragment.setTouchpointType(tpType);
        if (tpData != null) {
            fragment.addTouchpointData(tpData);
        }
        if (host != null) {
            VersionRange hostRange = new VersionRange(host.getVersion(), true, host.getVersion(), true);
            fragment.setHost(new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)host.getId(), (VersionRange)hostRange, null, (boolean)false, (boolean)false)});
        }
        fragment.setCapabilities(new IProvidedCapability[]{AbstractProvisioningTest.getSelfCapability(name, version)});
        return MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)fragment);
    }

    public static void changeVersion(MetadataFactory.InstallableUnitDescription desc, Version newVersion) {
        ArrayList<IProvidedCapability> capabilities = new ArrayList<IProvidedCapability>(desc.getProvidedCapabilities());
        int i = 0;
        while (i < capabilities.size()) {
            IProvidedCapability pc = (IProvidedCapability)capabilities.get(i);
            if (desc.getVersion().equals(pc.getVersion())) {
                capabilities.set(i, MetadataFactory.createProvidedCapability((String)pc.getNamespace(), (String)pc.getName(), (Version)newVersion));
            }
            ++i;
        }
        desc.setVersion(newVersion);
        desc.setCapabilities(capabilities.toArray(new IProvidedCapability[capabilities.size()]));
    }

    public static MetadataFactory.InstallableUnitDescription createIUDescriptor(IInstallableUnit prototype) {
        MetadataFactory.InstallableUnitDescription desc = new MetadataFactory.InstallableUnitDescription();
        Collection originalArtifacts = prototype.getArtifacts();
        desc.setArtifacts(originalArtifacts.toArray(new IArtifactKey[originalArtifacts.size()]));
        Collection originalCapabilities = prototype.getProvidedCapabilities();
        desc.setCapabilities(originalCapabilities.toArray(new IProvidedCapability[originalCapabilities.size()]));
        desc.setCopyright(prototype.getCopyright());
        desc.setFilter(prototype.getFilter());
        desc.setId(prototype.getId());
        Collection originalLicenses = prototype.getLicenses();
        desc.setLicenses(originalLicenses.toArray(new ILicense[originalLicenses.size()]));
        Collection originalRequirements = prototype.getRequirements();
        desc.setRequirements(originalRequirements.toArray(new IRequirement[originalRequirements.size()]));
        originalRequirements = prototype.getMetaRequirements();
        desc.setMetaRequirements(originalRequirements.toArray(new IRequirement[originalRequirements.size()]));
        desc.setSingleton(prototype.isSingleton());
        desc.setTouchpointType(MetadataFactory.createTouchpointType((String)prototype.getTouchpointType().getId(), (Version)prototype.getTouchpointType().getVersion()));
        desc.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((Collection)prototype.getUpdateDescriptor().getIUsBeingUpdated(), (int)prototype.getUpdateDescriptor().getSeverity(), (String)prototype.getUpdateDescriptor().getDescription(), null));
        desc.setVersion(prototype.getVersion());
        Map prototypeProperties = prototype.getProperties();
        Set entries = prototypeProperties.entrySet();
        for (Map.Entry entry : entries) {
            desc.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return desc;
    }

    public static IPlanner createPlanner() {
        return (IPlanner)AbstractProvisioningTest.getAgent().getService(IPlanner.class);
    }

    protected static IRequirement[] createRequiredCapabilities(String namespace, String name) {
        return AbstractProvisioningTest.createRequiredCapabilities(namespace, name, ANY_VERSION, null);
    }

    protected static IRequirement[] createRequiredCapabilities(String namespace, String name, String filter) {
        return AbstractProvisioningTest.createRequiredCapabilities(namespace, name, ANY_VERSION, filter);
    }

    protected static IRequirement[] createRequiredCapabilities(String namespace, String name, VersionRange range) {
        return AbstractProvisioningTest.createRequiredCapabilities(namespace, name, range, null);
    }

    protected static IRequirement[] createRequiredCapabilities(String namespace, String name, VersionRange range, String filter) {
        return AbstractProvisioningTest.createRequiredCapabilities(namespace, name, range, (IMatchExpression<IInstallableUnit>)InstallableUnit.parseFilter((String)filter));
    }

    protected static IRequirement[] createRequiredCapabilities(String namespace, String name, VersionRange range, IMatchExpression<IInstallableUnit> filter) {
        return new IRequirement[]{MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)range, filter, (boolean)false, (boolean)false)};
    }

    public static IRequirement createIURequirement(String name, VersionRange range) {
        return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)name, (VersionRange)range, null, (boolean)false, (boolean)false);
    }

    public static IRequirement createIURequirement(String name, VersionRange range, String filter) {
        return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)name, (VersionRange)range, (IMatchExpression)InstallableUnit.parseFilter((String)filter), (boolean)false, (boolean)false);
    }

    public static VersionRange createStrictVersionRange(String version) {
        Version parsedVersion = Version.create((String)version);
        return new VersionRange(parsedVersion, true, parsedVersion, true);
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] children;
            file.setWritable(true);
            file.setReadable(true);
            file.setExecutable(true);
            File[] fileArray = children = file.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                AbstractProvisioningTest.delete(child);
                ++n2;
            }
        }
        if (!file.delete()) {
            file.setWritable(true);
            file.setReadable(true);
            file.delete();
        }
        return !file.exists();
    }

    protected static boolean equal(String[][] tuples0, String[][] tuples1) {
        if (tuples0.length != tuples1.length) {
            return false;
        }
        int i = 0;
        while (i < tuples0.length) {
            String[] tuple0 = tuples0[i];
            String[] tuple1 = tuples1[i];
            if (tuple0.length != tuple1.length) {
                return false;
            }
            int j = 0;
            while (j < tuple0.length) {
                if (!tuple0[j].equals(tuple1[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static void fail(String message, Throwable e) {
        if (e instanceof CoreException) {
            IStatus status = ((CoreException)e).getStatus();
            if (status.getException() == null) {
                e.printStackTrace();
            }
            AbstractProvisioningTest.write(status, 0, System.err);
        } else if (e != null) {
            e.printStackTrace();
        }
        if (e != null) {
            message = (String)message + ": " + String.valueOf(e);
        }
        AbstractProvisioningTest.fail((String)message);
    }

    public static Iterator<IInstallableUnit> getInstallableUnits(IProfile profile2) {
        return profile2.query(QueryUtil.createIUAnyQuery(), null).iterator();
    }

    protected static IProvidedCapability getSelfCapability(IInstallableUnit iu) {
        return AbstractProvisioningTest.getSelfCapability(iu.getId(), iu.getVersion());
    }

    protected static IProvidedCapability getSelfCapability(String installableUnitId, Version installableUnitVersion) {
        return MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)installableUnitId, (Version)installableUnitVersion);
    }

    private static void indent(OutputStream output, int indent) {
        int i = 0;
        while (i < indent) {
            try {
                output.write("\t".getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void writeBuffer(File outputFile, CharSequence buffer) throws IOException {
        outputFile.getParentFile().mkdirs();
        Files.write(outputFile.toPath(), buffer.toString().getBytes(), new OpenOption[0]);
    }

    public static void writeProperties(File outputFile, Properties properties) throws IOException {
        outputFile.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream stream = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
            properties.store(stream, "");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static int queryResultSize(IQueryResult queryResult) {
        return queryResult.toUnmodifiableSet().size();
    }

    public static int queryResultUniqueSize(IQueryResult queryResult) {
        int cnt = 0;
        Iterator itor = queryResult.iterator();
        HashSet uniqueTracker = new HashSet();
        while (itor.hasNext()) {
            if (!uniqueTracker.add(itor.next())) continue;
            ++cnt;
        }
        return cnt;
    }

    public static void restartBundle(Bundle bundle) throws BundleException {
        bundle.stop(1);
        AbstractProvisioningTest.startBundle(bundle);
    }

    public static void startBundle(Bundle bundle) throws BundleException {
        bundle.start(2);
        bundle.start(1);
    }

    private static void write(IStatus status, int indent, PrintStream output) {
        AbstractProvisioningTest.indent(output, indent);
        output.println("Severity: " + status.getSeverity());
        AbstractProvisioningTest.indent(output, indent);
        output.println("Plugin ID: " + status.getPlugin());
        AbstractProvisioningTest.indent(output, indent);
        output.println("Code: " + status.getCode());
        AbstractProvisioningTest.indent(output, indent);
        output.println("Message: " + status.getMessage());
        if (status.getException() != null) {
            AbstractProvisioningTest.indent(output, indent);
            output.print("Exception: ");
            status.getException().printStackTrace(output);
        }
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                AbstractProvisioningTest.write(child, indent + 1, output);
                ++n2;
            }
        }
    }

    public AbstractProvisioningTest() {
        super("");
    }

    public AbstractProvisioningTest(String name) {
        super(name);
    }

    protected IProfile createProfile(String name) {
        return this.createProfile(name, null);
    }

    public IProfile createProfile(String name, Map<String, String> properties) {
        IProfileRegistry profileRegistry = this.getProfileRegistry();
        profileRegistry.removeProfile(name);
        this.profilesToRemove.add(name);
        try {
            return profileRegistry.addProfile(name, properties);
        }
        catch (ProvisionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected IProgressMonitor getMonitor() {
        return new FussyProgressMonitor();
    }

    protected IProfile getProfile(String profileId) {
        return this.getProfileRegistry().getProfile(profileId);
    }

    protected IInstallableUnit createResolvedIU(IInstallableUnit unit) {
        return MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)unit, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]);
    }

    protected IMetadataRepository createTestMetdataRepository(IInstallableUnit[] units) {
        TestMetadataRepository repo = new TestMetadataRepository(AbstractProvisioningTest.getAgent(), units);
        MetadataRepositoryManager repoMan = (MetadataRepositoryManager)AbstractProvisioningTest.getMetadataRepositoryManager();
        AbstractProvisioningTest.assertNotNull((Object)repoMan);
        repoMan.addRepository((IMetadataRepository)repo);
        this.metadataRepos.add((IMetadataRepository)repo);
        return repo;
    }

    protected IArtifactRepository createArtifactRepository(URI location, Map<String, String> properties) throws ProvisionException {
        IArtifactRepositoryManager artifactRepositoryManager = AbstractProvisioningTest.getArtifactRepositoryManager();
        IArtifactRepository repo = artifactRepositoryManager.createRepository(location, "artifact", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
        artifactRepositoryManager.removeRepository(repo.getLocation());
        return repo;
    }

    public static IProvisioningAgent getAgent() {
        return (IProvisioningAgent)ServiceHelper.getService((BundleContext)TestActivator.getContext(), IProvisioningAgent.class);
    }

    protected static IProvisioningAgentProvider getAgentProvider() {
        return (IProvisioningAgentProvider)ServiceHelper.getService((BundleContext)TestActivator.getContext(), IProvisioningAgentProvider.class);
    }

    protected static IAgentLocation getAgentLocation() {
        return (IAgentLocation)AbstractProvisioningTest.getAgent().getService(IAgentLocation.class);
    }

    protected static IArtifactRepositoryManager getArtifactRepositoryManager() {
        return (IArtifactRepositoryManager)AbstractProvisioningTest.getAgent().getService(IArtifactRepositoryManager.class);
    }

    protected IProfileRegistry getProfileRegistry() {
        return (IProfileRegistry)AbstractProvisioningTest.getAgent().getService(IProfileRegistry.class);
    }

    public Transport getTransport() {
        return (Transport)AbstractProvisioningTest.getAgent().getService(Transport.class);
    }

    protected IMetadataRepository createMetadataRepository(URI location, Map<String, String> properties) throws ProvisionException {
        IMetadataRepositoryManager metadataRepositoryManager = AbstractProvisioningTest.getMetadataRepositoryManager();
        IMetadataRepository repo = metadataRepositoryManager.createRepository(location, "metadata", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
        this.metadataRepos.add(repo);
        return repo;
    }

    protected IMetadataRepository loadMetadataRepository(URI location) throws ProvisionException {
        IMetadataRepositoryManager metadataRepositoryManager = AbstractProvisioningTest.getMetadataRepositoryManager();
        IMetadataRepository repo = metadataRepositoryManager.loadRepository(location, null);
        this.metadataRepos.add(repo);
        return repo;
    }

    protected IArtifactRepository loadArtifactRepository(URI location) throws ProvisionException {
        IArtifactRepositoryManager manager = AbstractProvisioningTest.getArtifactRepositoryManager();
        IArtifactRepository repo = manager.loadRepository(location, null);
        manager.removeRepository(location);
        return repo;
    }

    protected IInstallableUnit getIU(IMetadataRepository repository, String name) {
        IQueryResult queryResult = repository.query(QueryUtil.createIUQuery((String)name), null);
        IInstallableUnit unit = null;
        if (!queryResult.isEmpty()) {
            unit = (IInstallableUnit)queryResult.iterator().next();
        }
        return unit;
    }

    protected static IMetadataRepositoryManager getMetadataRepositoryManager() {
        return (IMetadataRepositoryManager)AbstractProvisioningTest.getAgent().getService(IMetadataRepositoryManager.class);
    }

    public static String getUniqueString() {
        return System.currentTimeMillis() + "-" + Math.random();
    }

    public File getTempFolder() {
        return this.getTestFolder(AbstractProvisioningTest.getUniqueString());
    }

    protected File getTestFolder(String name) {
        URL url;
        Location instanceLocation = (Location)ServiceHelper.getService((BundleContext)TestActivator.getContext(), Location.class, (String)Location.INSTANCE_FILTER);
        URL uRL = url = instanceLocation != null ? instanceLocation.getURL() : null;
        if (instanceLocation == null || !instanceLocation.isSet() || url == null) {
            String tempDir = System.getProperty("java.io.tmpdir");
            this.testFolder = new File(tempDir, name);
        } else {
            File instance = URLUtil.toFile((URL)url);
            this.testFolder = new File(instance, name);
        }
        if (this.testFolder.exists()) {
            AbstractProvisioningTest.delete(this.testFolder);
        }
        this.testFolder.mkdirs();
        return this.testFolder;
    }

    protected void runTest() throws Throwable {
        super.runTest();
        if (this.testFolder != null && this.testFolder.exists()) {
            AbstractProvisioningTest.delete(this.testFolder);
            this.testFolder = null;
        }
    }

    protected void tearDown() throws Exception {
        URI[] urls;
        super.tearDown();
        IMetadataRepositoryManager repoMan = AbstractProvisioningTest.getMetadataRepositoryManager();
        if (!this.metadataRepos.isEmpty()) {
            for (IMetadataRepository repo : this.metadataRepos) {
                repoMan.removeRepository(repo.getLocation());
            }
            this.metadataRepos.clear();
        }
        URI[] uRIArray = urls = repoMan.getKnownRepositories(0);
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URI url = uRIArray[n2];
            try {
                if (url.toString().contains("cache") || url.toString().contains("rollback")) {
                    repoMan.loadRepository(url, null).removeAll();
                }
            }
            catch (ProvisionException provisionException) {
                // empty catch block
            }
            ++n2;
        }
        IProfileRegistry profileRegistry = this.getProfileRegistry();
        for (String toRemove : this.profilesToRemove) {
            profileRegistry.removeProfile(toRemove);
        }
        this.profilesToRemove.clear();
    }

    public static File getTestData(String message, String entry) {
        URL base;
        if (entry == null) {
            AbstractProvisioningTest.fail((String)(message + " entry is null."));
        }
        if ((base = TestActivator.getContext().getBundle().getEntry(entry)) == null) {
            AbstractProvisioningTest.fail((String)(message + " entry not found in bundle: " + entry));
        }
        try {
            String osPath = IPath.fromOSString((String)FileLocator.toFileURL((URL)base).getPath()).toOSString();
            File result = new File(osPath);
            if (!result.getCanonicalPath().equals(result.getPath())) {
                AbstractProvisioningTest.fail((String)(message + " result path: " + result.getPath() + " does not match canonical path: " + result.getCanonicalFile().getPath()));
            }
            return result;
        }
        catch (IOException e) {
            AbstractProvisioningTest.fail(message, e);
            return null;
        }
    }

    protected static void assertInstallOperand(IProvisioningPlan plan, IInstallableUnit iu) {
        if (plan.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)iu), null).isEmpty()) {
            AbstractProvisioningTest.fail((String)("Can't find " + String.valueOf(iu) + " in the plan"));
        }
    }

    protected static void assertUninstallOperand(IProvisioningPlan plan, IInstallableUnit iu) {
        if (plan.getRemovals().query(QueryUtil.createIUQuery((IVersionedId)iu), null).isEmpty()) {
            AbstractProvisioningTest.fail((String)("Can't find " + String.valueOf(iu) + " in the plan"));
        }
    }

    protected static void assertNoOperand(IProvisioningPlan plan, IInstallableUnit iu) {
        if (!plan.getRemovals().query(QueryUtil.createIUQuery((IVersionedId)iu), null).isEmpty() || !plan.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)iu), null).isEmpty()) {
            AbstractProvisioningTest.fail((String)(String.valueOf(iu) + " should not be present in this plan."));
        }
    }

    protected void setUp() throws Exception {
        URI[] repos;
        super.setUp();
        IMetadataRepositoryManager repoMan = AbstractProvisioningTest.getMetadataRepositoryManager();
        URI[] uRIArray = repos = repoMan.getKnownRepositories(0);
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            URI repo = uRIArray[n2];
            repoMan.removeRepository(repo);
            ++n2;
        }
    }

    protected IStatus installAsRoots(IProfile profile, IInstallableUnit[] ius, boolean strict, IPlanner planner, IEngine engine) {
        ProfileChangeRequest req = new ProfileChangeRequest(profile);
        IInstallableUnit[] iInstallableUnitArray = ius;
        int n = ius.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            req.add(iu);
            req.setInstallableUnitInclusionRules(iu, strict ? ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)iu) : ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
            req.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
            ++n2;
        }
        return this.install((IProfileChangeRequest)req, planner, engine);
    }

    protected IStatus installAsRootsAndFlaggedAsBase(IProfile profile, IInstallableUnit[] ius, boolean strict, IPlanner planner, IEngine engine) {
        ProfileChangeRequest req = new ProfileChangeRequest(profile);
        IInstallableUnit[] iInstallableUnitArray = ius;
        int n = ius.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            req.add(iu);
            req.setInstallableUnitInclusionRules(iu, strict ? ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)iu) : ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
            req.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
            req.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.base", Boolean.TRUE.toString());
            ++n2;
        }
        return this.install((IProfileChangeRequest)req, planner, engine);
    }

    protected IStatus install(IProfile profile, IInstallableUnit[] ius, boolean strict, IPlanner planner, IEngine engine) {
        ProfileChangeRequest req = new ProfileChangeRequest(profile);
        IInstallableUnit[] iInstallableUnitArray = ius;
        int n = ius.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            req.add(iu);
            req.setInstallableUnitInclusionRules(iu, strict ? ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)iu) : ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
            ++n2;
        }
        return this.install((IProfileChangeRequest)req, planner, engine);
    }

    protected IStatus install(IProfileChangeRequest req, IPlanner planner, IEngine engine) {
        IProvisioningPlan plan = planner.getProvisioningPlan(req, null, null);
        if (plan.getStatus().getSeverity() == 4 || plan.getStatus().getSeverity() == 8) {
            return plan.getStatus();
        }
        return engine.perform(plan, null);
    }

    protected IStatus uninstall(IProfile profile, IInstallableUnit[] ius, IPlanner planner, IEngine engine) {
        ProfileChangeRequest req = new ProfileChangeRequest(profile);
        req.removeInstallableUnits(ius);
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        return engine.perform(plan, null);
    }

    protected static void assertEquals(String message, Object[] expected, Object[] actual, boolean orderImportant) {
        if (orderImportant) {
            AbstractProvisioningTest.assertEquals((String)message, (Object)expected, (Object)actual);
            return;
        }
        if (expected == null && actual == null) {
            return;
        }
        if (expected == actual) {
            return;
        }
        if (expected == null || actual == null) {
            AbstractProvisioningTest.assertTrue((String)(message + ".1"), (boolean)false);
        }
        if (expected.length != actual.length) {
            AbstractProvisioningTest.assertTrue((String)(message + ".2"), (boolean)false);
        }
        boolean[] found = new boolean[expected.length];
        Object[] objectArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            Object expectedelement = objectArray[n2];
            int j = 0;
            while (j < expected.length) {
                if (!found[j] && expectedelement.equals(actual[j])) {
                    found[j] = true;
                }
                ++j;
            }
            ++n2;
        }
        int i = 0;
        while (i < found.length) {
            if (!found[i]) {
                AbstractProvisioningTest.assertTrue((String)(message + ".3." + i), (boolean)false);
            }
            ++i;
        }
    }

    public static void assertFileContent(String message, File f, String content) {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader reader = Files.newBufferedReader(f.toPath());){
                String line = reader.readLine();
                AbstractProvisioningTest.assertEquals((String)message, (String)content, (String)line);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            AbstractProvisioningTest.fail("Getting copy target", e);
        }
        catch (IOException e) {
            AbstractProvisioningTest.fail("reading copy target", e);
        }
    }

    protected IProvisioningEventBus getEventBus() {
        IProvisioningEventBus bus = (IProvisioningEventBus)AbstractProvisioningTest.getAgent().getService(IProvisioningEventBus.class);
        AbstractProvisioningTest.assertNotNull((Object)bus);
        return bus;
    }

    protected static void assertEquals(String message, IInstallableUnit iu1, IInstallableUnit iu2) throws AssertionFailedError {
        if (iu1 == iu2) {
            return;
        }
        if (iu1 == null || iu2 == null) {
            AbstractProvisioningTest.fail((String)message);
        }
        if (!iu1.equals((Object)iu2)) {
            AbstractProvisioningTest.fail((String)(message + " " + String.valueOf(iu1) + " is not equal to " + String.valueOf(iu2)));
        }
        if (QueryUtil.isFragment((IInstallableUnit)iu1)) {
            if (!QueryUtil.isFragment((IInstallableUnit)iu2)) {
                AbstractProvisioningTest.fail((String)(message + " " + String.valueOf(iu1) + " is not a fragment."));
            }
            try {
                AbstractProvisioningTest.assertEquals((String)message, (Object)((IInstallableUnitFragment)iu1).getHost(), (Object)((IInstallableUnitFragment)iu2).getHost());
            }
            catch (AssertionFailedError failure) {
                AbstractProvisioningTest.fail((String)(message + " Unequal hosts: " + failure.getMessage()));
            }
        } else if (QueryUtil.isFragment((IInstallableUnit)iu2)) {
            AbstractProvisioningTest.fail((String)(message + " " + String.valueOf(iu2) + " is a fragment."));
        }
        if (iu1.isSingleton()) {
            if (!iu2.isSingleton()) {
                AbstractProvisioningTest.fail((String)(message + " " + String.valueOf(iu2) + " is not a singleton."));
            }
        } else if (iu2.isSingleton()) {
            AbstractProvisioningTest.fail((String)(message + " " + String.valueOf(iu2) + " is a singleton."));
        }
        AbstractProvisioningTest.assertEquals((String)message, (Object)iu1.getProvidedCapabilities(), (Object)iu2.getProvidedCapabilities());
        AbstractProvisioningTest.assertEquals((String)message, (Object)iu1.getRequirements(), (Object)iu2.getRequirements());
        AbstractProvisioningTest.assertEquals((String)message, (Object)iu1.getArtifacts(), (Object)iu2.getArtifacts());
        AbstractProvisioningTest.assertEquals((String)message, (Object)iu1.getTouchpointType(), (Object)iu2.getTouchpointType());
        AbstractProvisioningTest.assertEquals((String)message, (Object)iu1.getTouchpointData(), (Object)iu2.getTouchpointData());
        AbstractProvisioningTest.assertEquals((String)message, (Object)iu1.getProperties(), (Object)iu2.getProperties());
        AbstractProvisioningTest.assertEquals((String)message, (Object)iu1.getLicenses(), (Object)iu2.getLicenses());
        AbstractProvisioningTest.assertEquals(message, iu1.getCopyright(), iu2.getCopyright());
        AbstractProvisioningTest.assertEquals(message, iu1.getUpdateDescriptor(), iu2.getUpdateDescriptor());
        AbstractProvisioningTest.assertEquals((String)message, (Object)iu1.getFilter(), (Object)iu2.getFilter());
        if (iu1.isResolved() && iu2.isResolved()) {
            AbstractProvisioningTest.assertEquals((String)message, (Object)iu1.getFragments(), (Object)iu2.getFragments());
        }
    }

    protected static void assertEquals(String message, IInstallableUnitFragment[] fragments1, IInstallableUnitFragment[] fragments2) throws AssertionFailedError {
        HashMap<IInstallableUnitFragment, IInstallableUnitFragment> map = new HashMap<IInstallableUnitFragment, IInstallableUnitFragment>(fragments2.length);
        IInstallableUnitFragment[] iInstallableUnitFragmentArray = fragments2;
        int n = fragments2.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnitFragment fragments2element = iInstallableUnitFragmentArray[n2];
            map.put(fragments2element, fragments2element);
            ++n2;
        }
        iInstallableUnitFragmentArray = fragments1;
        n = fragments1.length;
        n2 = 0;
        while (n2 < n) {
            IInstallableUnitFragment fragments1element = iInstallableUnitFragmentArray[n2];
            if (!map.containsKey(fragments1)) {
                AbstractProvisioningTest.fail((String)(message + " Expected fragment '" + String.valueOf(fragments1element) + "' not present."));
            } else {
                AbstractProvisioningTest.assertEquals((String)message, (Object)fragments1element, map.remove(fragments1element));
            }
            ++n2;
        }
        if (map.size() > 0) {
            AbstractProvisioningTest.fail((String)(message + " Unexpected fragment '" + String.valueOf(map.entrySet().iterator().next()) + "'"));
        }
    }

    protected static void assertEquals(String message, IUpdateDescriptor desc1, IUpdateDescriptor desc2) throws AssertionFailedError {
        if (desc1 == desc2) {
            return;
        }
        if (desc1 == null || desc2 == null) {
            AbstractProvisioningTest.fail();
        }
        try {
            AbstractProvisioningTest.assertEquals((String)message, (Object)desc1.getIUsBeingUpdated(), (Object)desc2.getIUsBeingUpdated());
            AbstractProvisioningTest.assertEquals((String)message, (int)desc1.getSeverity(), (int)desc2.getSeverity());
            AbstractProvisioningTest.assertEquals((String)message, (String)desc1.getDescription(), (String)desc2.getDescription());
            String d1 = desc1.getDescription();
            String d2 = desc2.getDescription();
            if (d1 == null) {
                d1 = "";
            }
            if (d2 == null) {
                d2 = "";
            }
            AbstractProvisioningTest.assertEquals((String)message, (String)d1, (String)d2);
        }
        catch (AssertionFailedError e) {
            AbstractProvisioningTest.fail((String)(message + " Unequal Update Descriptors: " + e.getMessage()));
        }
    }

    public static void assertEquals(String message, IInstallableUnit[] ius1, IInstallableUnit[] ius2) {
        TreeSet<Object> set = new TreeSet<Object>((o1, o2) -> o1.toString().compareTo(o2.toString()));
        set.addAll(Arrays.asList(ius2));
        IInstallableUnit[] iInstallableUnitArray = ius1;
        int n = ius1.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit ius1unit = iInstallableUnitArray[n2];
            SortedSet<CallSite> subset = set.subSet(ius1unit, ius1unit.toString() + "\u0000");
            if (subset.size() == 1) {
                IInstallableUnit candidate = (IInstallableUnit)subset.first();
                try {
                    AbstractProvisioningTest.assertEquals(message, ius1unit, candidate);
                }
                catch (AssertionFailedError e) {
                    AbstractProvisioningTest.fail((String)(message + " IUs '" + String.valueOf(ius1unit) + "' are unequal : " + e.getMessage()));
                }
                subset.remove(candidate);
            } else if (subset.size() > 1) {
                AbstractProvisioningTest.fail((String)(message + " ERROR: Unexpected failure."));
            } else {
                AbstractProvisioningTest.fail((String)(message + " Expected IU " + String.valueOf(ius1unit) + " not found."));
            }
            ++n2;
        }
        if (set.size() > 0) {
            AbstractProvisioningTest.fail((String)(message + " Unexpected IU " + String.valueOf(set.first()) + "."));
        }
    }

    protected static void assertEquals(String message, ICopyright cpyrt1, ICopyright cpyrt2) {
        if (cpyrt1 == cpyrt2) {
            return;
        }
        if (cpyrt1 == null || cpyrt2 == null) {
            AbstractProvisioningTest.fail((String)message);
        }
        AbstractProvisioningTest.assertEquals((String)message, (String)cpyrt1.getBody(), (String)cpyrt2.getBody());
        AbstractProvisioningTest.assertEquals((String)message, (String)cpyrt1.getLocation().toString(), (String)cpyrt2.getLocation().toString());
    }

    protected static void assertContains(String message, IArtifactRepository sourceRepo, IArtifactRepository destinationRepo) {
        for (IArtifactKey key : sourceRepo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null)) {
            Object[] destinationDescriptors = destinationRepo.getArtifactDescriptors(key);
            if (destinationDescriptors == null || destinationDescriptors.length == 0) {
                AbstractProvisioningTest.fail((String)(message + ": unmatched key: " + key.toString()));
            }
            Object[] sourceDescriptors = sourceRepo.getArtifactDescriptors(key);
            AbstractProvisioningTest.assertEquals(message, sourceDescriptors, destinationDescriptors, false);
        }
    }

    protected static void assertContentEquals(String message, IArtifactRepository repo1, IArtifactRepository repo2) {
        AbstractProvisioningTest.assertContains(message, repo1, repo2);
        AbstractProvisioningTest.assertContains(message, repo2, repo1);
    }

    protected static void assertContains(String message, IMetadataRepository sourceRepo, IMetadataRepository destinationRepo) {
        IQueryResult sourceCollector = sourceRepo.query(QueryUtil.createIUAnyQuery(), null);
        for (IInstallableUnit sourceIU : sourceCollector) {
            IQueryResult destinationCollector = destinationRepo.query(QueryUtil.createIUQuery((IVersionedId)sourceIU), null);
            AbstractProvisioningTest.assertEquals((String)message, (int)1, (int)AbstractProvisioningTest.queryResultSize(destinationCollector));
            AbstractProvisioningTest.assertEquals(message, sourceIU, (IInstallableUnit)destinationCollector.iterator().next());
        }
    }

    protected static void assertContentEquals(String message, IMetadataRepository repo1, IMetadataRepository repo2) {
        AbstractProvisioningTest.assertContains(message, repo1, repo2);
        AbstractProvisioningTest.assertContains(message, repo2, repo1);
    }

    public static void assertContains(String message, IQueryable source, IQueryable destination) {
        IQueryResult sourceCollector = source.query(QueryUtil.createIUAnyQuery(), null);
        for (IInstallableUnit sourceIU : sourceCollector) {
            IQueryResult destinationCollector = destination.query(QueryUtil.createIUQuery((IVersionedId)sourceIU), null);
            AbstractProvisioningTest.assertEquals((String)message, (int)1, (int)AbstractProvisioningTest.queryResultSize(destinationCollector));
            AbstractProvisioningTest.assertEquals((String)message, (Object)sourceIU, destinationCollector.iterator().next());
        }
    }

    public static void assertContains(String message, IQueryResult result, IQueryResult mustHave) {
        AbstractProvisioningTest.assertContains(message, result.iterator(), mustHave.iterator());
    }

    public static void assertContains(String message, Iterator result, Iterator mustHave) {
        HashSet repoSet = new HashSet();
        while (mustHave.hasNext()) {
            repoSet.add(mustHave.next());
        }
        AbstractProvisioningTest.assertContains(message, result, repoSet);
    }

    public static void assertContains(String message, Iterator result, Collection mustHave) {
        while (result.hasNext()) {
            AbstractProvisioningTest.assertTrue((String)message, (boolean)mustHave.contains(result.next()));
        }
    }

    public static void assertContains(IQueryResult result, Object value) {
        AbstractProvisioningTest.assertContains(null, result, value);
    }

    public static void assertNotContains(IQueryResult result, Object value) {
        AbstractProvisioningTest.assertNotContains(null, result, value);
    }

    public static void assertContains(String message, IQueryResult result, Object value) {
        Iterator itor = result.iterator();
        while (itor.hasNext()) {
            if (!itor.next().equals(value)) continue;
            return;
        }
        AbstractProvisioningTest.fail((String)message);
    }

    public static void assertNotContains(String message, IQueryResult result, Object value) {
        Iterator itor = result.iterator();
        while (itor.hasNext()) {
            if (!itor.next().equals(value)) continue;
            AbstractProvisioningTest.fail((String)message);
        }
    }

    public static void assertContains(String message, Collection fromIUs, Iterator fromRepo) {
        AbstractProvisioningTest.assertContains(message, fromIUs.iterator(), fromRepo);
    }

    protected static boolean isEqual(IInstallableUnit iu1, IInstallableUnit iu2) {
        try {
            AbstractProvisioningTest.assertEquals("IUs not equal", iu1, iu2);
        }
        catch (AssertionFailedError e) {
            return false;
        }
        return true;
    }

    protected boolean isWindows() {
        return Platform.getOS().equals("win32");
    }

    protected IUpdateDescriptor createUpdateDescriptor(String id, Version version) {
        return MetadataFactory.createUpdateDescriptor((String)id, (VersionRange)new VersionRange(Version.emptyVersion, true, version, false), (int)1, (String)"desc");
    }

    protected static void assertRepositoryProperties(String message, Map expected, Map actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            AbstractProvisioningTest.fail((String)message);
        }
        for (Object expectedelement : expected.keySet()) {
            AbstractProvisioningTest.assertTrue((String)message, (boolean)actual.containsKey(expectedelement));
            if (expectedelement.equals("p2.timestamp")) continue;
            AbstractProvisioningTest.assertEquals((String)message, expected.get(expectedelement), actual.get(expectedelement));
        }
    }

    public static void assertLogContainsLine(File log, String[] parts) throws IOException {
        AbstractProvisioningTest.assertNotNull((Object)log);
        AbstractProvisioningTest.assertTrue((boolean)log.exists());
        AbstractProvisioningTest.assertTrue((log.length() > 0L ? 1 : 0) != 0);
        AbstractProvisioningTest.assertNotNull((Object)parts);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(log));){
            while (reader.ready()) {
                String line = reader.readLine();
                boolean found = true;
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    found = found && line.contains(part);
                    ++n2;
                }
                if (!found) continue;
                return;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        AbstractProvisioningTest.assertTrue((boolean)false);
    }

    public static void assertLogContainsLines(File log, String ... lines) throws Exception {
        AbstractProvisioningTest.assertNotNull((Object)log);
        AbstractProvisioningTest.assertTrue((boolean)log.exists());
        AbstractProvisioningTest.assertTrue((log.length() > 0L ? 1 : 0) != 0);
        int idx = 0;
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(log));){
            while (reader.ready()) {
                String line = reader.readLine();
                if (!line.contains(lines[idx]) || ++idx < lines.length) continue;
                return;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        AbstractProvisioningTest.fail((String)String.format("Log file %s doesn't contain lines %s", log.getCanonicalPath(), Arrays.toString(lines)));
    }

    public static void assertLogDoesNotContainLine(File log, String msg) throws Exception {
        AbstractProvisioningTest.assertLogDoesNotContainLines(log, new String[]{msg});
    }

    public static void assertLogDoesNotContainLines(File log, String[] lines) throws Exception {
        AbstractProvisioningTest.assertNotNull((Object)log);
        AbstractProvisioningTest.assertTrue((boolean)log.exists());
        AbstractProvisioningTest.assertTrue((log.length() > 0L ? 1 : 0) != 0);
        int idx = 0;
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(log));){
            while (reader.ready()) {
                String line = reader.readLine();
                if (!line.contains(lines[idx]) || ++idx < lines.length) continue;
                AbstractProvisioningTest.fail((String)String.format("Log file %s contains lines %s", log.getCanonicalPath(), Arrays.toString(lines)));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void clearProfileMap(SimpleProfileRegistry profileRegistry) {
        try {
            Field profilesMap = SimpleProfileRegistry.class.getDeclaredField("profiles");
            profilesMap.setAccessible(true);
            profilesMap.set(profileRegistry, null);
        }
        catch (Throwable t) {
            AbstractProvisioningTest.fail();
        }
    }

    protected int getArtifactKeyCount(URI location) {
        try {
            return this.getArtifactKeyCount(AbstractProvisioningTest.getArtifactRepositoryManager().loadRepository(location, null));
        }
        catch (ProvisionException e) {
            AbstractProvisioningTest.fail((String)("Failed to load repository " + URIUtil.toUnencodedString((URI)location) + " for ArtifactDescriptor count"));
            return -1;
        }
    }

    protected int getArtifactKeyCount(IArtifactRepository repo) {
        return AbstractProvisioningTest.queryResultSize(repo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null));
    }

    protected int getArtifactDescriptorCount(URI location) {
        int count = 0;
        try {
            IArtifactRepository repo = AbstractProvisioningTest.getArtifactRepositoryManager().loadRepository(location, null);
            IQueryResult descriptors = repo.descriptorQueryable().query((IQuery)ArtifactDescriptorQuery.ALL_DESCRIPTORS, null);
            return AbstractProvisioningTest.queryResultSize(descriptors);
        }
        catch (ProvisionException e) {
            AbstractProvisioningTest.fail((String)("Failed to load repository " + URIUtil.toUnencodedString((URI)location) + " for ArtifactDescriptor count"));
            return count;
        }
    }

    public int countPlanElements(IProvisioningPlan plan) {
        return AbstractProvisioningTest.queryResultSize(QueryUtil.compoundQueryable((IQueryable)plan.getAdditions(), (IQueryable)plan.getRemovals()).query(QueryUtil.createIUAnyQuery(), null));
    }

    protected void setUpSelfProfile() {
        if (System.getProperty("eclipse.p2.profile") == null) {
            SimpleProfileRegistry profileRegistry = (SimpleProfileRegistry)this.getProfileRegistry();
            try {
                Field selfField = SimpleProfileRegistry.class.getDeclaredField("self");
                selfField.setAccessible(true);
                this.previousSelfValue = selfField.get(profileRegistry);
                if (this.previousSelfValue == null) {
                    selfField.set(profileRegistry, "agent");
                }
            }
            catch (Throwable t) {
                AbstractProvisioningTest.fail();
            }
        }
        this.createProfile("agent");
    }

    protected void tearDownSelfProfile() {
        if (System.getProperty("eclipse.p2.profile") == null) {
            SimpleProfileRegistry profileRegistry = (SimpleProfileRegistry)this.getProfileRegistry();
            try {
                Field selfField = SimpleProfileRegistry.class.getDeclaredField("self");
                selfField.setAccessible(true);
                Object self = selfField.get(profileRegistry);
                if (self.equals("agent")) {
                    selfField.set(profileRegistry, this.previousSelfValue);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public IEngine getEngine() {
        return (IEngine)AbstractProvisioningTest.getAgent().getService(IEngine.class);
    }

    public IPlanner getPlanner(IProvisioningAgent agent) {
        return (IPlanner)agent.getService(IPlanner.class);
    }

    public void assertNoContents(File file, String[] lines) {
        if (!file.exists()) {
            AbstractProvisioningTest.fail((String)("File: " + file.toString() + " can't be found."));
        }
        int idx = 0;
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (line.indexOf(lines[idx]) <= 0) continue;
                    AbstractProvisioningTest.fail((String)("String: " + lines[idx] + " should not be in " + file.getAbsolutePath()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            AbstractProvisioningTest.fail((String)("Exception while reading: " + file.getAbsolutePath()));
        }
    }

    public void assertContents(File file, String[] lines) {
        if (!file.exists()) {
            AbstractProvisioningTest.fail((String)("File: " + file.toString() + " can't be found."));
        }
        int idx = 0;
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (!line.contains(lines[idx]) || ++idx < lines.length) continue;
                    return;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            AbstractProvisioningTest.fail((String)("String: " + lines[idx] + " not found in " + file.getAbsolutePath()));
        }
        AbstractProvisioningTest.fail((String)("String:" + lines[idx] + " not found"));
    }

    protected void assertEqualArtifacts(String message, SimpleArtifactRepository expected, SimpleArtifactRepository actual) {
        for (IArtifactKey key : expected.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null)) {
            IArtifactDescriptor[] expectedDescriptors = expected.getArtifactDescriptors(key);
            IArtifactDescriptor[] actualDescriptors = actual.getArtifactDescriptors(key);
            if (!(expectedDescriptors != null && actualDescriptors != null || expectedDescriptors == null && actualDescriptors == null)) {
                AbstractProvisioningTest.fail((String)(message + " missing key " + String.valueOf(key)));
            }
            IArtifactDescriptor[] iArtifactDescriptorArray = expectedDescriptors;
            int n = expectedDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    IArtifactDescriptor expectedDescriptor = iArtifactDescriptorArray[n2];
                    IArtifactDescriptor[] iArtifactDescriptorArray2 = actualDescriptors;
                    int n3 = actualDescriptors.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IArtifactDescriptor actualDescriptor = iArtifactDescriptorArray2[n4];
                        if (Arrays.equals(expectedDescriptor.getProcessingSteps(), actualDescriptor.getProcessingSteps())) {
                            File expectedFile = expected.getArtifactFile(expectedDescriptor);
                            File actualFile = actual.getArtifactFile(actualDescriptor);
                            if (expectedFile == null || actualFile == null) {
                                AbstractProvisioningTest.fail((String)(message + " descriptor mismatch"));
                            }
                            if (!expectedFile.exists() || !actualFile.exists()) {
                                AbstractProvisioningTest.fail((String)(message + " file does not exist"));
                            }
                            if ("jar".equals(IPath.fromOSString((String)expectedFile.getName()).getFileExtension())) {
                                this.assertEqualJars(expectedFile, actualFile);
                            } else {
                                AbstractProvisioningTest.assertEquals((String)("Different file: " + expectedFile.getName()), (long)expectedFile.length(), (long)actualFile.length());
                            }
                            break block9;
                        }
                        ++n4;
                    }
                    AbstractProvisioningTest.fail((String)(message + "Missing expected descriptor" + String.valueOf(expectedDescriptor)));
                }
                ++n2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void assertEqualJars(File expectedFile, File actualFile) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                JarFile expectedJar = new JarFile(expectedFile);
                try {
                    try (JarFile actualJar = new JarFile(actualFile);){
                        int expectedEntryCount = 0;
                        int actualEntryCount = 0;
                        Enumeration<JarEntry> en = expectedJar.entries();
                        while (en.hasMoreElements()) {
                            ++expectedEntryCount;
                            JarEntry expectedEntry = en.nextElement();
                            JarEntry actualEntry = actualJar.getJarEntry(expectedEntry.getName());
                            AbstractProvisioningTest.assertNotNull((Object)actualEntry);
                            AbstractProvisioningTest.assertEquals((String)("Unmatched entry size: " + expectedEntry.getName()), (long)expectedEntry.getSize(), (long)actualEntry.getSize());
                        }
                        en = expectedJar.entries();
                        while (en.hasMoreElements()) {
                            ++actualEntryCount;
                            en.nextElement();
                        }
                        AbstractProvisioningTest.assertEquals((String)("Unexpected difference in entries for " + expectedFile.getName()), (int)expectedEntryCount, (int)actualEntryCount);
                    }
                    if (expectedJar == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (expectedJar == null) throw throwable;
                    expectedJar.close();
                    throw throwable;
                }
                expectedJar.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            AbstractProvisioningTest.fail("Unexpected error comparing jars", e);
        }
    }

    public void assertResolve(IProfileChangeRequest request, IPlanner planner) {
        IProvisioningPlan plan = planner.getProvisioningPlan(request, null, null);
        AbstractProvisioningTest.assertOK(plan.getStatus());
    }

    public static final class ProvisioningTestRuleAdapter
    extends AbstractProvisioningTest
    implements TestRule {
        public Statement apply(final Statement base, Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    this.setUp();
                    try {
                        base.evaluate();
                    }
                    finally {
                        this.tearDown();
                    }
                }
            };
        }
    }
}

