/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class ReducedCUDFParser {
    private static final boolean DEBUG = false;
    private static final boolean TIMING = true;
    private MetadataFactory.InstallableUnitDescription currentIU = null;
    private final List<IInstallableUnit> allIUs = new ArrayList<IInstallableUnit>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(InputStream stream, boolean includeRecommends, String sumProperty) {
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                String next = reader.readLine();
                while (true) {
                    Object line = next;
                    next = reader.readLine();
                    while (next != null && next.length() > 1 && next.charAt(0) == ' ') {
                        line = (String)line + next.substring(1);
                        next = reader.readLine();
                    }
                    if (line == null) {
                        this.validateAndAddIU();
                        return;
                    }
                    if (((String)line).trim().length() == 0) {
                        this.validateAndAddIU();
                        continue;
                    }
                    if (((String)line).startsWith("#") || ((String)line).startsWith("preamble: ") || ((String)line).startsWith("property: ") || ((String)line).startsWith("univ-checksum: ")) continue;
                    if (((String)line).startsWith("package: ")) {
                        this.handlePackage((String)line);
                        continue;
                    }
                    if (((String)line).startsWith("version: ")) {
                        this.handleVersion((String)line);
                        continue;
                    }
                    if (((String)line).startsWith("depends: ")) {
                        this.handleDepends((String)line);
                        continue;
                    }
                    if (((String)line).startsWith("provides: ")) {
                        this.handleProvides((String)line);
                        continue;
                    }
                    if (!((String)line).startsWith("singleton:")) continue;
                    this.handleSingleton((String)line);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void handleSingleton(String line) {
        this.currentIU.setSingleton(line.contains("true"));
    }

    private void validateAndAddIU() {
        if (this.currentIU == null) {
            return;
        }
        if (this.currentIU.getId() == null) {
            throw new IllegalStateException("Malformed 'package' stanza. No package element found.");
        }
        if (this.currentIU.getVersion() == null) {
            throw new IllegalStateException("Malformed 'package' stanza. Package " + this.currentIU.getId() + " does not have a version.");
        }
        if (this.currentIU.getProvidedCapabilities().size() == 0) {
            this.currentIU.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)this.currentIU.getId(), (Version)this.currentIU.getVersion()), MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)this.currentIU.getId(), (Version)this.currentIU.getVersion())});
        }
        this.currentIU.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)this.currentIU.getId(), (VersionRange)new VersionRange(Version.emptyVersion, true, this.currentIU.getVersion(), false), (int)0, null));
        this.currentIU.setProperty("org.eclipse.equinox.p2.type.group", "true");
        this.allIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)this.currentIU));
        this.currentIU = null;
    }

    private void handleVersion(String line) {
        this.currentIU.setVersion(Version.create((String)this.cudfPosintToInt(line.substring("version: ".length()))));
    }

    private String cudfPosintToInt(String posint) {
        if (posint.startsWith("+")) {
            return posint.substring(1).trim();
        }
        return posint.trim();
    }

    private void handleDepends(String line) {
        this.mergeRequirements(this.createRequires(line.substring("depends: ".length()), true, false, true));
    }

    private void mergeRequirements(List requirements) {
        if (this.currentIU.getRequirements() != null) {
            List current = this.currentIU.getRequirements();
            for (IRequirement iRequirement : current) {
                requirements.add(iRequirement);
            }
        }
        this.currentIU.setRequirements((IRequirement[])requirements.toArray(new IRequiredCapability[requirements.size()]));
    }

    private List<Tuple> createPackageList(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, ",");
        ArrayList<Tuple> result = new ArrayList<Tuple>(tokenizer.countTokens());
        while (tokenizer.hasMoreElements()) {
            result.add(new Tuple(tokenizer.nextToken()));
        }
        return result;
    }

    private List createRequires(String line, boolean expandNotEquals, boolean optional, boolean dependency) {
        ArrayList<Object> ands = new ArrayList<Object>();
        StringTokenizer s = new StringTokenizer(line, ",");
        while (s.hasMoreElements()) {
            StringTokenizer subTokenizer = new StringTokenizer(s.nextToken(), "|");
            if (subTokenizer.countTokens() == 1) {
                String subtoken = subTokenizer.nextToken().trim();
                if ("true!".equals(subtoken)) {
                    if (dependency) continue;
                    throw new RuntimeException("Cannot have true! in a conflict!!!!!");
                }
                if ("false!".equals(subtoken)) {
                    if (!dependency) continue;
                    throw new RuntimeException("Cannot have false! in a dependency!!!!!");
                }
                Object o = this.createRequire(subtoken, expandNotEquals, optional);
                if (o instanceof IRequiredCapability) {
                    ands.add(o);
                    continue;
                }
                ands.addAll((Collection)o);
                continue;
            }
            RequiredCapability[] ors = new RequiredCapability[subTokenizer.countTokens()];
            int i = 0;
            while (subTokenizer.hasMoreElements()) {
                ors[i++] = (IRequiredCapability)this.createRequire(subTokenizer.nextToken().trim(), expandNotEquals, optional);
            }
        }
        return ands;
    }

    private Object createRequire(String nextToken, boolean expandNotEquals, boolean optional) {
        StringTokenizer expressionTokens = new StringTokenizer(nextToken.trim(), ">=!<", true);
        int tokenCount = expressionTokens.countTokens();
        if (tokenCount == 1) {
            return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)expressionTokens.nextToken().trim(), (VersionRange)VersionRange.emptyRange, null, (boolean)optional, (boolean)false, (boolean)true);
        }
        if (tokenCount == 3) {
            return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)expressionTokens.nextToken().trim(), (VersionRange)this.createRange3(expressionTokens.nextToken(), expressionTokens.nextToken()), null, (boolean)optional, (boolean)false, (boolean)true);
        }
        if (tokenCount == 4) {
            String id = expressionTokens.nextToken().trim();
            String signFirstChar = expressionTokens.nextToken();
            expressionTokens.nextToken();
            String version = expressionTokens.nextToken().trim();
            if (!"!".equals(signFirstChar)) {
                return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)this.createRange4(signFirstChar, version), null, (boolean)optional, (boolean)false, (boolean)true);
            }
            ArrayList<IRequirement> res = new ArrayList<IRequirement>(2);
            res.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)this.createRange3("<", version), null, (boolean)optional, (boolean)false, (boolean)true));
            res.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)this.createRange3(">", version), null, (boolean)optional, (boolean)false, (boolean)true));
            return res;
        }
        return null;
    }

    private VersionRange createRange3(String sign, String versionAsString) {
        int version = Integer.decode(this.cudfPosintToInt(versionAsString));
        if (">".equals(sign = sign.trim())) {
            return new VersionRange(Version.createOSGi((int)version, (int)0, (int)0), false, Version.MAX_VERSION, false);
        }
        if ("<".equals(sign)) {
            return new VersionRange(Version.emptyVersion, false, Version.createOSGi((int)version, (int)0, (int)0), false);
        }
        if ("=".equals(sign)) {
            return new VersionRange(Version.createOSGi((int)version, (int)0, (int)0), true, Version.createOSGi((int)version, (int)0, (int)0), true);
        }
        throw new IllegalArgumentException(sign);
    }

    private VersionRange createRange4(String sign, String versionAsString) {
        int version = Integer.decode(this.cudfPosintToInt(versionAsString));
        if (">".equals(sign)) {
            return new VersionRange(Version.createOSGi((int)version, (int)0, (int)0), true, Version.MAX_VERSION, false);
        }
        if ("<".equals(sign)) {
            return new VersionRange(Version.emptyVersion, false, Version.createOSGi((int)version, (int)0, (int)0), true);
        }
        return null;
    }

    private IProvidedCapability createProvidedCapability(Tuple tuple) {
        assert (tuple.operator == null);
        return MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)tuple.name, (Version)Version.create((String)tuple.version));
    }

    private void handlePackage(String readLine) {
        this.currentIU = new MetadataFactory.InstallableUnitDescription();
        this.currentIU.setId(readLine.substring("package: ".length()).trim());
    }

    private void handleProvides(String line) {
        line = line.substring("provides: ".length());
        List<Tuple> pkgs = this.createPackageList(line);
        ProvidedCapability[] providedCapabilities = new ProvidedCapability[pkgs.size() + 2];
        int i = 0;
        for (Tuple tuple : pkgs) {
            providedCapabilities[i++] = this.createProvidedCapability(tuple);
        }
        providedCapabilities[i++] = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)this.currentIU.getId(), (Version)this.currentIU.getVersion());
        providedCapabilities[i++] = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)this.currentIU.getId(), (Version)this.currentIU.getVersion());
        this.currentIU.setCapabilities((IProvidedCapability[])providedCapabilities);
    }

    private void debug(InstallableUnit unit) {
    }

    public IInstallableUnit getIU() {
        assert (this.allIUs.size() == 1);
        return this.allIUs.get(0);
    }

    class Tuple {
        String name;
        String version;
        String operator;

        Tuple(String line) {
            String[] tuple = new String[3];
            int i = 0;
            StringTokenizer iter = new StringTokenizer(line, " \t");
            while (iter.hasMoreTokens()) {
                tuple[i] = iter.nextToken().trim();
                ++i;
            }
            this.name = tuple[0];
            this.operator = tuple[1];
            this.version = tuple[2];
        }
    }
}

