/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests;

import java.io.File;
import java.io.IOException;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class TestAgentProvider
extends ExternalResource {
    private final TemporaryFolder tempManager = new TemporaryFolder();
    private IProvisioningAgent agent;

    protected void before() throws Throwable {
        this.tempManager.create();
    }

    protected void after() {
        if (this.agent != null) {
            this.agent.stop();
        }
        this.tempManager.delete();
    }

    public IProvisioningAgent getAgent() throws ProvisionException {
        if (this.agent == null) {
            try {
                this.agent = this.createProvisioningAgent(this.tempManager.newFolder("p2agent"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.agent;
    }

    private IProvisioningAgent createProvisioningAgent(File location) throws ProvisionException {
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IProvisioningAgentProvider.class);
        IProvisioningAgentProvider agentFactory = (IProvisioningAgentProvider)bundleContext.getService(serviceReference);
        try {
            IProvisioningAgent iProvisioningAgent = agentFactory.createAgent(location.toURI());
            return iProvisioningAgent;
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }

    public <T> T getService(Class<T> type) throws ProvisionException {
        return (T)this.getAgent().getService(type);
    }
}

