/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRequest;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.repository.helpers.AbstractRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.spi.AbstractArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.junit.Assert;

public class TestArtifactRepository
extends AbstractArtifactRepository {
    private static final String SCHEME = "testartifactrepo";
    private static final String NAME = "ATestArtifactRepository";
    private static final String TYPE = "testartifactrepo";
    private static final String VERSION = "1";
    private static final String PROVIDER = "org.eclipse";
    private static final String DESCRIPTION = "A Test Artifact Repository";
    Map<IArtifactKey, URI> keysToLocations = new HashMap<IArtifactKey, URI>();
    Map<URI, byte[]> locationsToContents = new HashMap<URI, byte[]>();
    Set<IArtifactDescriptor> artifactDescriptors = new HashSet<IArtifactDescriptor>();
    Transport testhandler = new Transport(){

        public IStatus download(URI toDownload, OutputStream target, IProgressMonitor pm) {
            byte[] contents = TestArtifactRepository.this.locationsToContents.get(toDownload);
            if (contents == null) {
                Assert.fail((String)("Attempt to download missing artifact in TestArtifactRepository: " + String.valueOf(toDownload)));
            }
            try {
                target.write(contents);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)("Unexpected exception in TestArtifactRepository" + e.getMessage()));
            }
            return Status.OK_STATUS;
        }

        public InputStream stream(URI toDownload, IProgressMonitor monitor) {
            throw new IllegalStateException("Method should not be called");
        }

        public long getLastModified(URI toDownload, IProgressMonitor monitor) {
            throw new IllegalStateException("Method should not be called");
        }
    };

    public TestArtifactRepository(IProvisioningAgent agent, URI location) {
        super(agent, NAME, "testartifactrepo", VERSION, location, DESCRIPTION, PROVIDER, null);
    }

    public TestArtifactRepository(IProvisioningAgent agent) {
        super(agent, NAME, "testartifactrepo", VERSION, null, DESCRIPTION, PROVIDER, null);
    }

    public boolean addToRepositoryManager() {
        try {
            Method method = AbstractRepositoryManager.class.getDeclaredMethod("addRepository", IRepository.class, Boolean.TYPE, String.class);
            method.setAccessible(true);
            method.invoke((Object)AbstractProvisioningTest.getArtifactRepositoryManager(), new Object[]{this, false, ""});
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void addArtifact(IArtifactKey key, byte[] contents) {
        URI keyLocation = this.locationFor(key);
        this.keysToLocations.put(key, keyLocation);
        this.locationsToContents.put(keyLocation, contents);
    }

    private URI locationFor(IArtifactKey key) {
        try {
            return new URI("testartifactrepo", key.toString(), null);
        }
        catch (URISyntaxException e) {
            Assert.fail((String)("Invalid URI in TestArtifactRepository: " + e.getMessage()));
            return null;
        }
    }

    public URI getArtifact(IArtifactKey key) {
        return this.keysToLocations.get(key);
    }

    private IStatus getArtifact(ArtifactRequest request, IProgressMonitor monitor) {
        request.perform((IArtifactRepository)this, monitor);
        return request.getResult();
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)requests.length);
        try {
            MultiStatus overallStatus = new MultiStatus("org.eclipse.equinox.p2.test", 0, null, null);
            IArtifactRequest[] iArtifactRequestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactRequest request = iArtifactRequestArray[n2];
                overallStatus.add(this.getArtifact((ArtifactRequest)request, (IProgressMonitor)subMonitor.newChild(1)));
                ++n2;
            }
            IStatus iStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : overallStatus;
            return iStatus;
        }
        finally {
            subMonitor.done();
        }
    }

    public void initialize(URI repoURL, InputStream descriptorFile) {
        this.setLocation(repoURL);
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        return this.keysToLocations.get(descriptor.getArtifactKey()) != null;
    }

    public boolean contains(IArtifactKey key) {
        return this.keysToLocations.get(key) != null;
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        ProcessingStepHandler handler = new ProcessingStepHandler();
        destination = handler.createAndLink(this.getProvisioningAgent(), descriptor.getProcessingSteps(), null, destination, monitor);
        this.testhandler.download(this.keysToLocations.get(descriptor.getArtifactKey()), destination, monitor);
        return Status.OK_STATUS;
    }

    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.testhandler.download(this.keysToLocations.get(descriptor.getArtifactKey()), destination, monitor);
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        if (!this.contains(key)) {
            return null;
        }
        return new IArtifactDescriptor[]{new ArtifactDescriptor(key)};
    }

    public void addDescriptor(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        ((ArtifactDescriptor)descriptor).setRepository((IArtifactRepository)this);
        this.artifactDescriptors.add(descriptor);
        this.keysToLocations.put(descriptor.getArtifactKey(), null);
    }

    public void removeDescriptor(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        this.removeDescriptor(descriptor.getArtifactKey(), monitor);
    }

    public void removeDescriptors(IArtifactDescriptor[] descriptors, IProgressMonitor monitor) {
        IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
            this.removeDescriptor(descriptor, monitor);
            ++n2;
        }
    }

    public void removeDescriptors(IArtifactKey[] keys, IProgressMonitor monitor) {
        IArtifactKey[] iArtifactKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactKey key = iArtifactKeyArray[n2];
            this.removeDescriptor(key, monitor);
            ++n2;
        }
    }

    public void removeDescriptor(IArtifactKey key, IProgressMonitor monitor) {
        for (IArtifactDescriptor nextDescriptor : this.artifactDescriptors) {
            if (!key.equals(nextDescriptor.getArtifactKey())) continue;
            this.artifactDescriptors.remove(nextDescriptor);
        }
        if (this.keysToLocations.containsKey(key)) {
            URI theLocation = this.keysToLocations.get(key);
            this.locationsToContents.remove(theLocation);
            this.keysToLocations.remove(key);
        }
    }

    public void removeAll(IProgressMonitor monitor) {
        this.artifactDescriptors.clear();
        this.keysToLocations.clear();
        this.locationsToContents.clear();
    }

    public boolean isModifiable() {
        return true;
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException("Method is not implemented by this repository");
    }

    public IQueryable<IArtifactDescriptor> descriptorQueryable() {
        return null;
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        return null;
    }
}

