/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.junit.Assert;

public class TestData {
    private static final String TEST_DATA_ROOT_FOLDER = "testData";
    private static final String PREFIX_SEPERATOR = "~";

    public static InputStream get(String testDataFolder, String testDataName) throws IOException {
        return new BufferedInputStream(TestActivator.getContext().getBundle().getEntry("testData/" + testDataFolder + "/" + testDataName).openStream());
    }

    public static File getFile(String testDataFolder, String testDataName) throws IOException {
        return new File(FileLocator.toFileURL((URL)TestActivator.getContext().getBundle().getEntry("testData/" + testDataFolder + "/" + testDataName)).getPath());
    }

    public static File getTempFile(String testDataFolder, String testDataName) throws IOException {
        File temp = TestData.createTempFile(testDataName);
        FileOutputStream out = new FileOutputStream(temp);
        FileUtils.copyStream((InputStream)TestData.get(testDataFolder, testDataName), (boolean)true, (OutputStream)out, (boolean)true);
        return temp;
    }

    public static File createTempFile(String testDataName) throws IOException {
        int i = testDataName.lastIndexOf(46);
        File temp = i == -1 ? File.createTempFile(testDataName + PREFIX_SEPERATOR, ".tmp") : File.createTempFile(testDataName.substring(0, i) + PREFIX_SEPERATOR, testDataName.substring(i));
        temp.deleteOnExit();
        return temp;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void assertEquals(InputStream expected, InputStream actual) throws IOException {
        try {
            block8: {
                int count;
                int readActual;
                int readExpected;
                block7: {
                    readExpected = 0;
                    readActual = 0;
                    count = 0;
                    if (!true) break block7;
                    if (readActual == -1) return;
                    if (readExpected == -1) break block8;
                }
                do {
                    readActual = actual.read();
                    readExpected = expected.read();
                    Assert.assertEquals((String)("Different bytes at " + count), (long)readExpected, (long)readActual);
                    ++count;
                    if (readActual == -1) return;
                } while (readExpected != -1);
            }
            return;
        }
        finally {
            if (expected != null) {
                expected.close();
            }
            if (actual != null) {
                actual.close();
            }
        }
    }

    public static void assertEquals(ZipInputStream expected, ZipInputStream actual) throws IOException {
        Map<String, Object[]> expectedEntries = TestData.getEntries(expected);
        Map<String, Object[]> actualEntries = TestData.getEntries(actual);
        for (String name : expectedEntries.keySet()) {
            Object[] expectedFiles = expectedEntries.get(name);
            Object[] actualFiles = actualEntries.remove(name);
            Assert.assertNotNull((String)(name + " entry is missing in actual zip stream (actual=" + String.valueOf(actualEntries.keySet()) + ", expected=" + String.valueOf(expectedEntries.keySet()) + ")"), (Object)actualFiles);
            ZipEntry entry1 = (ZipEntry)expectedFiles[0];
            ZipEntry entry2 = (ZipEntry)actualFiles[0];
            Assert.assertEquals((Object)entry1.getName(), (Object)entry2.getName());
            Assert.assertEquals((long)entry1.getSize(), (long)entry2.getSize());
            Assert.assertEquals((Object)entry1.isDirectory(), (Object)entry2.isDirectory());
            Assert.assertEquals((long)entry1.getCrc(), (long)entry2.getCrc());
            Assert.assertEquals((long)entry1.getMethod(), (long)entry2.getMethod());
            Assert.assertArrayEquals((byte[])((byte[])expectedFiles[1]), (byte[])((byte[])actualFiles[1]));
        }
        Assert.assertEquals((long)0L, (long)actualEntries.size());
    }

    public static void assertContains(Map<String, Object[]> fileMap, ZipInputStream input2, boolean compareContent) throws IOException {
        Map<String, Object[]> jar2 = TestData.getEntries(input2);
        for (String name : fileMap.keySet()) {
            Object[] file1 = fileMap.get(name);
            Object[] file2 = jar2.remove(name);
            Assert.assertNotNull((Object)file2);
            File entry1 = (File)file1[0];
            ZipEntry entry2 = (ZipEntry)file2[0];
            Assert.assertEquals((Object)entry1.isDirectory(), (Object)entry2.isDirectory());
            if (!compareContent) continue;
            Assert.assertArrayEquals((byte[])((byte[])file1[1]), (byte[])((byte[])file2[1]));
        }
    }

    private static Map<String, Object[]> getEntries(ZipInputStream input) throws IOException {
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        ZipEntry entry;
        while ((entry = input.getNextEntry()) != null) {
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            FileUtils.copyStream((InputStream)input, (boolean)false, (OutputStream)content, (boolean)true);
            input.closeEntry();
            result.put(entry.getName(), new Object[]{entry, content.toByteArray()});
        }
        return result;
    }
}

