/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests;

import java.net.URI;
import java.util.EventObject;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.junit.Assert;

public class TestRepositoryListener
implements SynchronousProvisioningListener {
    private static final long MAX_WAIT = 10000L;
    public boolean lastEnablement;
    public int lastKind;
    public int lastRepoType;
    private final URI repoLocation;
    private boolean wasCalled;

    public TestRepositoryListener(URI location) {
        this.repoLocation = location;
    }

    /*
     * WARNING - void declaration
     */
    public void notify(EventObject o) {
        void event;
        if (!(o instanceof RepositoryEvent)) {
            return;
        }
        RepositoryEvent repositoryEvent = (RepositoryEvent)o;
        if (this.repoLocation != null && !event.getRepositoryLocation().equals(this.repoLocation)) {
            return;
        }
        this.setCalled(true);
        this.lastKind = event.getKind();
        this.lastRepoType = event.getRepositoryType();
        this.lastEnablement = event.isRepositoryEnabled();
    }

    public void reset() {
        this.lastRepoType = 0;
        this.lastKind = 0;
        this.lastEnablement = false;
        this.setCalled(false);
    }

    public synchronized void setCalled(boolean wasCalled) {
        this.wasCalled = wasCalled;
        this.notifyAll();
    }

    public synchronized void waitForEvent() {
        long waitStart = System.currentTimeMillis();
        while (!this.wasCalled()) {
            Assert.assertTrue((String)"Timeout waiting for repository event", (System.currentTimeMillis() - waitStart < 10000L ? 1 : 0) != 0);
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean wasCalled() {
        return this.wasCalled;
    }
}

