/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractAntProvisioningTest;

public class Repo2RunnableTaskTests
extends AbstractAntProvisioningTest {
    private URI destination;
    private URI source;

    @Override
    public void setUp() throws Exception {
        this.source = Repo2RunnableTaskTests.getTestData("Error loading data", "testData/mirror/mirrorSourceRepo1 with space").toURI();
        this.destination = this.getTestFolder(this.getName()).toURI();
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        Repo2RunnableTaskTests.getArtifactRepositoryManager().removeRepository(this.source);
        Repo2RunnableTaskTests.getMetadataRepositoryManager().removeRepository(this.source);
        Repo2RunnableTaskTests.getArtifactRepositoryManager().removeRepository(this.destination);
        Repo2RunnableTaskTests.getMetadataRepositoryManager().removeRepository(this.destination);
        Repo2RunnableTaskTests.delete(new File(this.destination));
        super.tearDown();
    }

    public void testRepo2Runnable() {
        this.createRepo2RunnableTaskElement(TYPE_BOTH);
        this.runAntTask();
        Repo2RunnableTaskTests.assertEquals((String)"Number of artifact keys differs", (int)this.getArtifactKeyCount(this.source), (int)this.getArtifactKeyCount(this.destination));
        Repo2RunnableTaskTests.assertTrue((String)"Unexpected format", (boolean)this.expectedFormat(this.destination));
    }

    public void testRepo2RunnableFragments() throws IOException {
        this.createRepo2RunnableTaskElementFragments(TYPE_BOTH);
        this.runAntTask();
        Repo2RunnableTaskTests.assertEquals((String)"Number of artifact keys differs", (int)this.getArtifactKeyCount(this.source), (int)this.getArtifactKeyCount(this.destination));
        Repo2RunnableTaskTests.assertTrue((String)"Unexpected format", (boolean)this.expectedFormat(this.destination));
        File f = new File(this.destination);
        Repo2RunnableTaskTests.assertTrue((String)"Missing content.jar", (boolean)new File(f, "content.jar").exists());
        Repo2RunnableTaskTests.assertTrue((String)"Missing artifacts.jar", (boolean)new File(f, "artifacts.jar").exists());
        Repo2RunnableTaskTests.assertTrue((String)"Missing fragment.info", (boolean)new File(f, "fragment.info").exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(new File(f, "fragment.info")));){
            while (br.ready()) {
                System.out.println(br.readLine());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void testRepo2RunnableSpecifiedIU() {
        IInstallableUnit iu = null;
        try {
            IMetadataRepository repo = Repo2RunnableTaskTests.getMetadataRepositoryManager().loadRepository(this.source, (IProgressMonitor)new NullProgressMonitor());
            IQueryResult ius = repo.query(QueryUtil.createIUQuery((String)"helloworldfeature.feature.jar"), (IProgressMonitor)new NullProgressMonitor());
            Repo2RunnableTaskTests.assertEquals((String)"Expected number of IUs", (int)1, (int)Repo2RunnableTaskTests.queryResultSize(ius));
            iu = (IInstallableUnit)ius.iterator().next();
        }
        catch (ProvisionException e) {
            Repo2RunnableTaskTests.fail("Failed to obtain iu", e);
        }
        AbstractAntProvisioningTest.AntTaskElement task = this.createRepo2RunnableTaskElement(TYPE_BOTH);
        task.addElement(this.createIUElement(iu));
        this.runAntTask();
        Repo2RunnableTaskTests.assertEquals((String)"Number of artifact keys differs", (int)iu.getArtifacts().size(), (int)this.getArtifactKeyCount(this.destination));
        Repo2RunnableTaskTests.assertTrue((String)"Unexpected format", (boolean)this.expectedFormat(this.destination));
    }

    public void testRepo2RunnableFailOnError() {
        this.source = Repo2RunnableTaskTests.getTestData("Error loading data", "testData/mirror/mirrorSourceRepo3").toURI();
        URI binary = Repo2RunnableTaskTests.getTestData("Error loading binary data", "testData/testRepos/binary.repo").toURI();
        AbstractAntProvisioningTest.AntTaskElement mirror = new AbstractAntProvisioningTest.AntTaskElement("p2.mirror");
        AbstractAntProvisioningTest.AntTaskElement sourceRepo = new AbstractAntProvisioningTest.AntTaskElement("source");
        sourceRepo.addElement(this.getRepositoryElement(this.source, TYPE_BOTH));
        sourceRepo.addElement(this.getRepositoryElement(binary, TYPE_BOTH));
        mirror.addElement(sourceRepo);
        mirror.addElement(this.getRepositoryElement(this.destination, TYPE_BOTH));
        this.addTask(mirror);
        AbstractAntProvisioningTest.AntTaskElement delete = new AbstractAntProvisioningTest.AntTaskElement("delete");
        delete.addAttribute("file", String.valueOf(this.getTestFolder(this.getName())) + "/plugins/helloworld_1.0.0.jar");
        this.addTask(delete);
        Repo2RunnableTaskTests.getArtifactRepositoryManager().removeRepository(binary);
        Repo2RunnableTaskTests.getMetadataRepositoryManager().removeRepository(binary);
        Repo2RunnableTaskTests.getArtifactRepositoryManager().removeRepository(this.source);
        Repo2RunnableTaskTests.getMetadataRepositoryManager().removeRepository(this.source);
        this.source = this.destination;
        File destinationFile = new File(this.getTestFolder(this.getName()), "repo2");
        this.destination = destinationFile.toURI();
        AbstractAntProvisioningTest.AntTaskElement task = this.createRepo2RunnableTaskElement(TYPE_BOTH);
        task.addAttribute("failOnError", "false");
        this.runAntTask();
        Repo2RunnableTaskTests.assertTrue((boolean)new File(destinationFile, "binary/f_root_1.0.0").exists());
    }

    protected boolean expectedFormat(URI location) {
        IArtifactRepository repo = null;
        try {
            repo = Repo2RunnableTaskTests.getArtifactRepositoryManager().loadRepository(location, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            Repo2RunnableTaskTests.fail("Failed to load repository", e);
        }
        IQueryResult keys = repo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        for (IArtifactKey key : keys) {
            IArtifactDescriptor[] descriptors;
            IArtifactDescriptor[] iArtifactDescriptorArray = descriptors = repo.getArtifactDescriptors(key);
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isFolder;
                IArtifactDescriptor desc = iArtifactDescriptorArray[n2];
                boolean bl = isFolder = desc.getProperty("artifact.folder") != null ? Boolean.valueOf(desc.getProperty("artifact.folder")) : false;
                if (key.getClassifier().equals("")) {
                    Repo2RunnableTaskTests.assertTrue((String)(String.valueOf(desc) + " is not a folder"), (boolean)isFolder);
                } else {
                    Repo2RunnableTaskTests.assertFalse((String)(String.valueOf(desc) + " is a folder"), (boolean)isFolder);
                }
                Repo2RunnableTaskTests.assertTrue((String)"Artifact is still packed", (!"packed".equals(desc.getProperty("format")) ? 1 : 0) != 0);
                ++n2;
            }
        }
        return true;
    }

    protected AbstractAntProvisioningTest.AntTaskElement createRepo2RunnableTaskElement() {
        AbstractAntProvisioningTest.AntTaskElement task = new AbstractAntProvisioningTest.AntTaskElement("p2.repo2runnable");
        this.addTask(task);
        return task;
    }

    protected AbstractAntProvisioningTest.AntTaskElement createRepo2RunnableTaskElement(String type) {
        AbstractAntProvisioningTest.AntTaskElement task = this.createRepo2RunnableTaskElement();
        task.addElement(this.getRepositoryElement(this.destination, type));
        AbstractAntProvisioningTest.AntTaskElement sourceElement = new AbstractAntProvisioningTest.AntTaskElement("source");
        sourceElement.addElement(this.getRepositoryElement(this.source, type));
        task.addElement(sourceElement);
        return task;
    }

    protected AbstractAntProvisioningTest.AntTaskElement createRepo2RunnableTaskElementFragments(String type) {
        AbstractAntProvisioningTest.AntTaskElement task = this.createRepo2RunnableTaskElement();
        task.addElement(this.getRepositoryElement(this.destination, type));
        AbstractAntProvisioningTest.AntTaskElement sourceElement = new AbstractAntProvisioningTest.AntTaskElement("source");
        sourceElement.addElement(this.getRepositoryElement(this.source, type));
        task.addElement(sourceElement);
        task.addAttribute("createFragments", "true");
        return task;
    }
}

