/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ant;

import java.io.File;
import java.net.URI;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractAntProvisioningTest;

public class RepoTasksTests
extends AbstractAntProvisioningTest {
    private static final String MIRROR_TASK = "p2.mirror";
    private static final String REMOVE_IU_TASK = "p2.remove.iu";
    private URI destinationRepo;
    private URI sourceRepo;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.destinationRepo = this.getTestFolder(this.getName()).toURI();
        this.sourceRepo = RepoTasksTests.getTestData("error loading data", "testData/mirror/mirrorSourceRepo2").toURI();
    }

    @Override
    public void tearDown() throws Exception {
        RepoTasksTests.getArtifactRepositoryManager().removeRepository(this.destinationRepo);
        RepoTasksTests.getMetadataRepositoryManager().removeRepository(this.destinationRepo);
        RepoTasksTests.getArtifactRepositoryManager().removeRepository(this.sourceRepo);
        RepoTasksTests.getMetadataRepositoryManager().removeRepository(this.sourceRepo);
        RepoTasksTests.delete(new File(this.destinationRepo).getParentFile());
        super.tearDown();
    }

    public void testRemoveIU() throws Exception {
        AbstractAntProvisioningTest.AntTaskElement mirror = new AbstractAntProvisioningTest.AntTaskElement(MIRROR_TASK);
        AbstractAntProvisioningTest.AntTaskElement source = new AbstractAntProvisioningTest.AntTaskElement("source");
        source.addElement(this.getRepositoryElement(this.sourceRepo, TYPE_BOTH));
        mirror.addElement(source);
        mirror.addElement(this.getRepositoryElement(this.destinationRepo, TYPE_BOTH));
        this.addTask(mirror);
        AbstractAntProvisioningTest.AntTaskElement removeIU = new AbstractAntProvisioningTest.AntTaskElement(REMOVE_IU_TASK);
        removeIU.addElement(this.getRepositoryElement(this.destinationRepo, TYPE_BOTH));
        removeIU.addElement(this.getIUElement("anotherplugin", null));
        AbstractAntProvisioningTest.AntTaskElement iuElement = new AbstractAntProvisioningTest.AntTaskElement("iu");
        iuElement.addAttribute("query", "");
        iuElement.addAttribute("artifacts", "(format=packed)");
        removeIU.addElement(iuElement);
        this.addTask(removeIU);
        this.runAntTask();
        IMetadataRepository metadata = this.loadMetadataRepository(this.destinationRepo);
        IInstallableUnit iu = this.getIU(metadata, "anotherplugin");
        RepoTasksTests.assertNull((Object)iu);
        RepoTasksTests.assertNotNull((Object)this.getIU(metadata, "anotherfeature.feature.group"));
        IArtifactRepository artifacts = RepoTasksTests.getArtifactRepositoryManager().loadRepository(this.destinationRepo, null);
        IQueryResult keys = artifacts.query((IQuery)new ArtifactKeyQuery(null, "anotherplugin", null), null);
        RepoTasksTests.assertTrue((boolean)keys.isEmpty());
        RepoTasksTests.assertFalse((boolean)new File(this.getTestFolder(this.getName()), "plugins/anotherplugin_1.0.0.jar").exists());
    }
}

