/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.processors;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.ChecksumUtilities;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.ChecksumVerifier;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.OSGiVersion;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class ChecksumPriorityTest {
    @Test
    public void testChecksumPriorityWithFullSet() {
        ArtifactDescriptor artifactDescriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("", "", (Version)new OSGiVersion(1, 1, 1, (Comparable)((Object)""))));
        artifactDescriptor.setProperty("artifact.checksum.md5", "abc");
        artifactDescriptor.setProperty("artifact.checksum.sha-1", "abc");
        artifactDescriptor.setProperty("artifact.checksum.sha-256", "abc");
        artifactDescriptor.setProperty("artifact.checksum.sha-512", "abc");
        ChecksumPriorityTest.assertBestChoice(artifactDescriptor, "sha-512");
    }

    @Test
    public void testChecksumPriorityWithStandardSet() {
        ArtifactDescriptor artifactDescriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("", "", (Version)new OSGiVersion(1, 1, 1, (Comparable)((Object)""))));
        artifactDescriptor.setProperty("artifact.checksum.md5", "abc");
        artifactDescriptor.setProperty("artifact.checksum.sha-256", "abc");
        ChecksumPriorityTest.assertBestChoice(artifactDescriptor, "sha-256");
    }

    @Test
    public void testChecksumPriorityWithDeprecatedSet() {
        ArtifactDescriptor artifactDescriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("", "", (Version)new OSGiVersion(1, 1, 1, (Comparable)((Object)""))));
        artifactDescriptor.setProperty("artifact.checksum.md5", "abc");
        artifactDescriptor.setProperty("artifact.checksum.sha-1", "abc");
        ChecksumPriorityTest.assertBestChoice(artifactDescriptor, "sha-1");
    }

    private static void assertBestChoice(ArtifactDescriptor artifactDescriptor, String bestAlgorithm) {
        Collection checksumVerifiers = ChecksumUtilities.getChecksumVerifiers((IArtifactDescriptor)artifactDescriptor, (String)"artifact.checksum", Collections.emptySet());
        Assert.assertEquals((String)("more than one algorithm was choosen: " + checksumVerifiers.stream().map(ChecksumVerifier::getAlgorithmId).collect(Collectors.joining(", "))), (long)1L, (long)checksumVerifiers.size());
        ChecksumVerifier verifier = (ChecksumVerifier)checksumVerifiers.iterator().next();
        Assert.assertEquals((Object)bestAlgorithm, (Object)verifier.getAlgorithmId());
    }
}

