/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.processors;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.ChecksumUtilities;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.ChecksumVerifier;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.OSGiVersion;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ChecksumUtilitiesTest {
    @Parameterized.Parameter(value=0)
    public String propertyType;
    @Parameterized.Parameter(value=1)
    public String property;
    @Parameterized.Parameter(value=2)
    public String value;
    @Parameterized.Parameter(value=3)
    public String digestAlgorithm;
    @Parameterized.Parameter(value=4)
    public String algorithmId;
    private ArtifactDescriptor artifactDescriptor;

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        return Arrays.asList({"artifact.checksum", "artifact.checksum".concat(".md5"), "123456789_123456789_123456789_12", "MD5", "md5"}, {"artifact.checksum", "artifact.checksum".concat(".sha-256"), "123456789_123456789_123456789_123456789_123456789_123456789_1234", "SHA-256", "sha-256"}, {"download.checksum", "download.checksum".concat(".md5"), "123456789_123456789_123456789_12", "MD5", "md5"}, {"download.checksum", "download.checksum".concat(".sha-256"), "123456789_123456789_123456789_123456789_123456789_123456789_1234", "SHA-256", "sha-256"});
    }

    @Before
    public void buildArtifactDescriptor() {
        this.artifactDescriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("", "", (Version)new OSGiVersion(1, 1, 1, (Comparable)((Object)""))));
        this.artifactDescriptor.setProperty(this.property, this.value);
    }

    @Test
    public void testChecksumProperty() {
        Collection checksumVerifiers = ChecksumUtilities.getChecksumVerifiers((IArtifactDescriptor)this.artifactDescriptor, (String)this.propertyType, Collections.emptySet());
        Assert.assertEquals((String)String.format("Verifier for property=%s", this.property), (long)1L, (long)checksumVerifiers.size());
        ChecksumVerifier verifier = (ChecksumVerifier)checksumVerifiers.iterator().next();
        Assert.assertEquals((Object)this.digestAlgorithm, (Object)verifier.getAlgorithmName());
        Assert.assertEquals((Object)this.algorithmId, (Object)verifier.getAlgorithmId());
        Assert.assertEquals((Object)this.value, (Object)verifier.getExpectedChecksum());
        Assert.assertEquals((Object)Status.OK_STATUS, (Object)verifier.getStatus());
    }

    @Test
    public void testChecksumsToSkip() {
        Collection checksumVerifiers = ChecksumUtilities.getChecksumVerifiers((IArtifactDescriptor)this.artifactDescriptor, (String)this.propertyType, Collections.singleton(this.algorithmId));
        Assert.assertEquals(Collections.emptyList(), (Object)checksumVerifiers);
    }
}

