/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.processors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.ChecksumVerifier;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class ChecksumVerifierTest {
    @Parameterized.Parameter(value=0)
    public String digestAlgorithm;
    @Parameterized.Parameter(value=1)
    public String providerName;
    @Parameterized.Parameter(value=2)
    public String algorithmId;
    @Parameterized.Parameter(value=3)
    public String downloadProperty;
    @Parameterized.Parameter(value=4)
    public String artifactProperty;
    @Parameterized.Parameter(value=5)
    public String checksum;

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        Object[][] objectArrayArray = new Object[2][];
        Object[] objectArray = new Object[6];
        objectArray[0] = "MD5";
        objectArray[2] = "md5";
        objectArray[3] = "download.checksum".concat(".md5");
        objectArray[4] = "artifact.checksum".concat(".md5");
        objectArray[5] = "123456789_123456789_123456789_12";
        objectArrayArray[0] = objectArray;
        Object[] objectArray2 = new Object[6];
        objectArray2[0] = "SHA-256";
        objectArray2[2] = "sha-256";
        objectArray2[3] = "download.checksum".concat(".sha-256");
        objectArray2[4] = "artifact.checksum".concat(".sha-256");
        objectArray2[5] = "123456789_123456789_123456789_123456789_123456789_123456789_1234";
        objectArrayArray[1] = objectArray2;
        return Arrays.asList(objectArrayArray);
    }

    @Test
    public void testInitialize() throws IOException, IllegalArgumentException, SecurityException {
        IProcessingStepDescriptor processingStepDescriptor = (IProcessingStepDescriptor)Mockito.mock(IProcessingStepDescriptor.class);
        Mockito.when((Object)processingStepDescriptor.getData()).thenReturn((Object)this.checksum);
        Throwable throwable = null;
        Object var3_4 = null;
        try (ChecksumVerifier verifier = new ChecksumVerifier(this.digestAlgorithm, this.providerName, this.algorithmId, false, 0);){
            verifier.initialize(null, processingStepDescriptor, null);
            Assert.assertEquals((Object)Status.OK_STATUS, (Object)verifier.getStatus());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testInitialize_DownloadChecksum() throws IOException, IllegalArgumentException, SecurityException {
        IProcessingStepDescriptor processingStepDescriptor = (IProcessingStepDescriptor)Mockito.mock(IProcessingStepDescriptor.class);
        Mockito.when((Object)processingStepDescriptor.getData()).thenReturn((Object)this.downloadProperty);
        IArtifactDescriptor artifactDescriptor = (IArtifactDescriptor)Mockito.mock(IArtifactDescriptor.class);
        Mockito.when((Object)artifactDescriptor.getProperty(this.downloadProperty)).thenReturn((Object)this.checksum);
        Mockito.when((Object)artifactDescriptor.getProperty((String)AdditionalMatchers.not((Object)((String)ArgumentMatchers.eq((Object)this.downloadProperty))))).thenReturn(null);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(this.downloadProperty, this.checksum);
        Mockito.when((Object)artifactDescriptor.getProperties()).thenReturn(properties);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ChecksumVerifier verifier = new ChecksumVerifier(this.digestAlgorithm, this.providerName, this.algorithmId, false, 0);){
            verifier.initialize(null, processingStepDescriptor, artifactDescriptor);
            Assert.assertEquals((Object)Status.OK_STATUS, (Object)verifier.getStatus());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testInitialize_ArtifactChecksum() throws IOException, IllegalArgumentException, SecurityException {
        IProcessingStepDescriptor processingStepDescriptor = (IProcessingStepDescriptor)Mockito.mock(IProcessingStepDescriptor.class);
        Mockito.when((Object)processingStepDescriptor.getData()).thenReturn((Object)this.artifactProperty);
        IArtifactDescriptor artifactDescriptor = (IArtifactDescriptor)Mockito.mock(IArtifactDescriptor.class);
        Mockito.when((Object)artifactDescriptor.getProperty(this.artifactProperty)).thenReturn((Object)this.checksum);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(this.artifactProperty, this.checksum);
        Mockito.when((Object)artifactDescriptor.getProperties()).thenReturn(properties);
        Mockito.when((Object)artifactDescriptor.getProperty((String)AdditionalMatchers.not((Object)((String)ArgumentMatchers.eq((Object)this.artifactProperty))))).thenReturn(null);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ChecksumVerifier verifier = new ChecksumVerifier(this.digestAlgorithm, this.providerName, this.algorithmId, false, 0);){
            verifier.initialize(null, processingStepDescriptor, artifactDescriptor);
            Assert.assertEquals((Object)Status.OK_STATUS, (Object)verifier.getStatus());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

