/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.processors;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPSignatureVerifier;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.repository.DefaultPGPPublicKeyService;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.equinox.p2.tests.TestAgentProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class PGPSignatureVerifierTest {
    @Rule
    public TestAgentProvider agentProvider = new TestAgentProvider();

    @Before
    public void initialize() {
        try {
            PGPPublicKeyService keyService = this.agentProvider.getService(PGPPublicKeyService.class);
            if (keyService instanceof DefaultPGPPublicKeyService) {
                DefaultPGPPublicKeyService defaultPGPPublicKeyService = (DefaultPGPPublicKeyService)keyService;
                defaultPGPPublicKeyService.setKeyServers(Set.of());
                defaultPGPPublicKeyService.setGPG(false);
            }
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
    }

    private IArtifactDescriptor createArtifact(String signaturesResourcePath, String publicKeyResourcePath) throws IOException, URISyntaxException {
        ArtifactDescriptor res = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("whatever", "whatever", Version.parseVersion((String)"1.0.0")));
        res.setProperty("pgp.signatures", this.read(signaturesResourcePath));
        res.setProperty("pgp.publicKeys", this.read(publicKeyResourcePath));
        return res;
    }

    private String read(String resource) throws IOException, URISyntaxException {
        return Files.readString(new File(FileLocator.toFileURL((URL)this.getClass().getResource(resource)).toURI()).toPath());
    }

    @Test
    public void testOK() throws Exception {
        ProcessingStepDescriptor processingStepDescriptor = new ProcessingStepDescriptor(null, null, false);
        IArtifactDescriptor artifact = this.createArtifact("signed_by_signer_1", "public_signer1.pgp");
        PGPSignatureVerifier verifier = new PGPSignatureVerifier();
        verifier.initialize(this.agentProvider.getAgent(), (IProcessingStepDescriptor)processingStepDescriptor, artifact);
        ArtifactOutputStream artifactOutputStream = new ArtifactOutputStream();
        verifier.link((OutputStream)artifactOutputStream, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)verifier.getStatus().toString(), (boolean)verifier.getStatus().isOK());
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream bytes = this.getClass().getResourceAsStream("testArtifact");){
            bytes.transferTo((OutputStream)verifier);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)verifier.getStatus().isOK());
        verifier.close();
        Assert.assertTrue((boolean)verifier.getStatus().isOK());
        IArtifactDescriptor descriptor = artifactOutputStream.getDescriptor();
        Assert.assertNotNull((String)"Signatures should be present", (Object)descriptor.getProperty("pgp.signatures"));
        Assert.assertNotNull((String)"Keys should be present", (Object)descriptor.getProperty("pgp.publicKeys"));
    }

    @Test
    public void testNoPublicKeyFound() throws Exception {
        ProcessingStepDescriptor processingStepDescriptor = new ProcessingStepDescriptor(null, null, false);
        IArtifactDescriptor artifact = this.createArtifact("signed_by_signer_1", "public_signer2.pgp");
        Throwable throwable = null;
        Object var4_5 = null;
        try (PGPSignatureVerifier verifier = new PGPSignatureVerifier();){
            verifier.initialize(this.agentProvider.getAgent(), (IProcessingStepDescriptor)processingStepDescriptor, artifact);
            ArtifactOutputStream artifactOutputStream = new ArtifactOutputStream();
            verifier.link((OutputStream)artifactOutputStream, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertTrue((String)verifier.getStatus().toString(), (boolean)verifier.getStatus().isOK());
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (InputStream bytes = this.getClass().getResourceAsStream("testArtifact");){
                bytes.transferTo((OutputStream)verifier);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            Assert.assertTrue((boolean)verifier.getStatus().isOK());
            verifier.close();
            Assert.assertTrue((boolean)verifier.getStatus().isOK());
            IArtifactDescriptor descriptor = artifactOutputStream.getDescriptor();
            Assert.assertNull((String)"No signatures should be present", (Object)descriptor.getProperty("pgp.signatures"));
            Assert.assertNull((String)"No keys should be present", (Object)descriptor.getProperty("pgp.publicKeys"));
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testTamperedSignature() throws Exception {
        ProcessingStepDescriptor processingStepDescriptor = new ProcessingStepDescriptor(null, null, false);
        IArtifactDescriptor artifact = this.createArtifact("signed_by_signer_1_tampered", "public_signer1.pgp");
        Throwable throwable = null;
        Object var4_5 = null;
        try (PGPSignatureVerifier verifier = new PGPSignatureVerifier();){
            verifier.initialize(this.agentProvider.getAgent(), (IProcessingStepDescriptor)processingStepDescriptor, artifact);
            Assert.assertFalse((boolean)verifier.getStatus().isOK());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSignatureForAnotherArtifact() throws Exception {
        ProcessingStepDescriptor processingStepDescriptor = new ProcessingStepDescriptor(null, null, false);
        IArtifactDescriptor artifact = this.createArtifact("signed_by_signer_1_otherArtifact", "public_signer1.pgp");
        PGPSignatureVerifier verifier = new PGPSignatureVerifier();
        verifier.initialize(this.agentProvider.getAgent(), (IProcessingStepDescriptor)processingStepDescriptor, artifact);
        Assert.assertTrue((boolean)verifier.getStatus().isOK());
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream bytes = this.getClass().getResourceAsStream("testArtifact");){
            bytes.transferTo((OutputStream)verifier);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)verifier.getStatus().isOK());
        verifier.close();
        IStatus status = verifier.getStatus();
        Assert.assertEquals((long)4L, (long)status.getSeverity());
        Assert.assertTrue((boolean)status.getMessage().matches(".*signature.*invalid.*"));
    }

    private static class ArtifactOutputStream
    extends ByteArrayOutputStream
    implements IAdaptable {
        IArtifactDescriptor descriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("whatever", "whatever", Version.parseVersion((String)"1.0.0")));

        private ArtifactOutputStream() {
        }

        public IArtifactDescriptor getDescriptor() {
            return this.descriptor;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.isInstance(this.descriptor)) {
                return adapter.cast(this.descriptor);
            }
            return null;
        }
    }
}

