/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.processors;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.ChecksumUtilities;
import org.junit.Assert;
import org.junit.Test;

public class ProduceChecksumTest {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testChecksums() throws IOException {
        File tempFile;
        block13: {
            tempFile = File.createTempFile("testArtifact", ".tmp");
            tempFile.deleteOnExit();
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                OutputStream fout = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);
                try {
                    try (InputStream resource = this.getClass().getResourceAsStream("testArtifact");){
                        resource.transferTo(fout);
                    }
                    if (fout == null) break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fout == null) throw throwable;
                    fout.close();
                    throw throwable;
                }
                fout.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        HashMap hashMap = new HashMap();
        IStatus status = ChecksumUtilities.calculateChecksums((File)new File(tempFile.toURI()), hashMap, Collections.emptyList());
        Assert.assertTrue((String)status.toString(), (boolean)status.isOK());
        String md5sum = (String)hashMap.get("md5");
        Assert.assertNull((String)"MD5 was computed but should be disabled!", (Object)md5sum);
        String sha256sum = (String)hashMap.get("sha-256");
        Assert.assertNotNull((String)"SHA256 was not computed!", (Object)sha256sum);
        Assert.assertEquals((String)"SHA256 mismatch", (Object)"39d083c8c75eac51b2c4566cca299b41cc93d5b0313906f5979fbebf1104ff49", (Object)sha256sum);
    }
}

