/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class BatchExecuteArtifactRepositoryTest
extends AbstractProvisioningTest {
    private File repositoryFile = null;
    private URI repositoryURI = null;

    private IArtifactDescriptor createDescriptor(String classifier, String id, Version version) {
        return new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey(classifier, id, version));
    }

    public void testAdd() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            SimpleArtifactRepository repo = (SimpleArtifactRepository)BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            URI artifactXML = new URI(this.repositoryFile.toURI().toString() + "/artifacts.xml");
            IStatus status = repo.executeBatch(monitor -> {
                repo.addDescriptor(this.createDescriptor("foo", "foo", Version.emptyVersion), monitor);
                try {
                    BatchExecuteArtifactRepositoryTest.assertFalse((String)"1.0", (boolean)this.fileContainsString(artifactXML, "foo"));
                }
                catch (IOException e) {
                    BatchExecuteArtifactRepositoryTest.fail((String)"0.99");
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteArtifactRepositoryTest.assertTrue((boolean)status.isOK());
            BatchExecuteArtifactRepositoryTest.assertTrue((String)"1.0", (boolean)this.fileContainsString(artifactXML, "foo"));
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"2.0", (int)1, (int)repo.query((IQuery)new ArtifactKeyQuery("foo", "foo", null), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testMultiAdd() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            SimpleArtifactRepository repo = (SimpleArtifactRepository)BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            URI artifactXML = new URI(this.repositoryFile.toURI().toString() + "/artifacts.xml");
            IStatus status = repo.executeBatch(monitor -> {
                repo.addDescriptor(this.createDescriptor("foo", "foo", Version.emptyVersion), monitor);
                repo.addDescriptor(this.createDescriptor("bar", "bar", Version.emptyVersion), monitor);
                repo.addDescriptor(this.createDescriptor("baz", "baz", Version.emptyVersion), monitor);
                try {
                    BatchExecuteArtifactRepositoryTest.assertFalse((String)"1.0", (boolean)this.fileContainsString(artifactXML, "foo"));
                    BatchExecuteArtifactRepositoryTest.assertFalse((String)"1.0", (boolean)this.fileContainsString(artifactXML, "bar"));
                    BatchExecuteArtifactRepositoryTest.assertFalse((String)"1.0", (boolean)this.fileContainsString(artifactXML, "baz"));
                }
                catch (IOException e) {
                    BatchExecuteArtifactRepositoryTest.fail((String)"0.99");
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteArtifactRepositoryTest.assertTrue((boolean)status.isOK());
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"1.0", (int)1, (int)repo.query((IQuery)new ArtifactKeyQuery("foo", "foo", null), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"1.1", (int)1, (int)repo.query((IQuery)new ArtifactKeyQuery("bar", "bar", null), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"1.2", (int)1, (int)repo.query((IQuery)new ArtifactKeyQuery("baz", "baz", null), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteArtifactRepositoryTest.assertTrue((String)"2.0", (boolean)this.fileContainsString(artifactXML, "foo"));
            BatchExecuteArtifactRepositoryTest.assertTrue((String)"2.1", (boolean)this.fileContainsString(artifactXML, "bar"));
            BatchExecuteArtifactRepositoryTest.assertTrue((String)"2.2", (boolean)this.fileContainsString(artifactXML, "baz"));
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testMultiAddWithException() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            SimpleArtifactRepository repo = (SimpleArtifactRepository)BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            URI artifactXML = new URI(this.repositoryFile.toURI().toString() + "/artifacts.xml");
            IStatus status = repo.executeBatch(monitor -> {
                repo.addDescriptor(this.createDescriptor("foo", "foo", Version.emptyVersion), monitor);
                repo.addDescriptor(this.createDescriptor("bar", "bar", Version.emptyVersion), monitor);
                throw new RuntimeException();
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteArtifactRepositoryTest.assertFalse((boolean)status.isOK());
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"1.0", (int)1, (int)repo.query((IQuery)new ArtifactKeyQuery("foo", "foo", null), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"1.1", (int)1, (int)repo.query((IQuery)new ArtifactKeyQuery("bar", "bar", null), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteArtifactRepositoryTest.assertTrue((String)"2.0", (boolean)this.fileContainsString(artifactXML, "foo"));
            BatchExecuteArtifactRepositoryTest.assertTrue((String)"2.1", (boolean)this.fileContainsString(artifactXML, "bar"));
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testAddAndRemove() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            SimpleArtifactRepository repo = (SimpleArtifactRepository)BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            URI artifactXML = new URI(this.repositoryFile.toURI().toString() + "/artifacts.xml");
            IStatus status = repo.executeBatch(monitor -> {
                IArtifactDescriptor foo = this.createDescriptor("foo", "foo", Version.emptyVersion);
                repo.addDescriptor(foo, monitor);
                repo.addDescriptor(this.createDescriptor("bar", "bar", Version.emptyVersion), monitor);
                repo.removeDescriptor(foo, monitor);
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteArtifactRepositoryTest.assertTrue((boolean)status.isOK());
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"1.0", (int)1, (int)repo.query((IQuery)new ArtifactKeyQuery("bar", "bar", null), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"1.1", (int)0, (int)repo.query((IQuery)new ArtifactKeyQuery("foo", "foo", null), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteArtifactRepositoryTest.assertFalse((String)"2.0", (boolean)this.fileContainsString(artifactXML, "foo"));
            BatchExecuteArtifactRepositoryTest.assertTrue((String)"2.1", (boolean)this.fileContainsString(artifactXML, "bar"));
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testMultiAddAndRemove() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            SimpleArtifactRepository repo = (SimpleArtifactRepository)BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            URI artifactXML = new URI(this.repositoryFile.toURI().toString() + "/artifacts.xml");
            IStatus status = repo.executeBatch(monitor -> {
                repo.addDescriptor(this.createDescriptor("1", "1", Version.emptyVersion), monitor);
                repo.addDescriptor(this.createDescriptor("2", "2", Version.emptyVersion), monitor);
                repo.addDescriptor(this.createDescriptor("3", "3", Version.emptyVersion), monitor);
                IArtifactDescriptor foo = this.createDescriptor("foo", "foo", Version.emptyVersion);
                repo.addDescriptor(foo, monitor);
                repo.addDescriptor(this.createDescriptor("bar", "bar", Version.emptyVersion), monitor);
                repo.removeDescriptor(foo, monitor);
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteArtifactRepositoryTest.assertTrue((boolean)status.isOK());
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"1.0", (int)4, (int)repo.query((IQuery)new ArtifactKeyQuery(null, null, null), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteArtifactRepositoryTest.assertFalse((String)"2.0", (boolean)this.fileContainsString(artifactXML, "foo"));
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    boolean fileContainsString(URI location, String string) throws IOException {
        StringBuilder buffer = new StringBuilder();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(location)));){
            while (reader.ready()) {
                buffer.append(reader.readLine());
            }
            return buffer.toString().contains(string);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void testBatchProcessingOK() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            SimpleArtifactRepository repo = (SimpleArtifactRepository)BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            IStatus status = repo.executeBatch(monitor -> {}, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteArtifactRepositoryTest.assertTrue((boolean)status.isOK());
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testBatchProcessingExceptionsSimple() {
        try {
            FailingSimpleArtifactRepository simpleArtifactRepository = new FailingSimpleArtifactRepository("foo", new URI("http://foo.bar"), null);
            IStatus status = simpleArtifactRepository.executeBatch(monitor -> {
                throw new RuntimeException("bar");
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteArtifactRepositoryTest.assertFalse((boolean)status.isOK());
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"foo", (String)status.getException().getMessage());
            BatchExecuteArtifactRepositoryTest.assertEquals((int)1, (int)status.getChildren().length);
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"bar", (String)status.getChildren()[0].getMessage());
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testBatchProcessingSaveExceptionSimple() {
        try {
            FailingSimpleArtifactRepository simpleArtifactRepository = new FailingSimpleArtifactRepository("foo", new URI("http://foo.bar"), null);
            IStatus status = simpleArtifactRepository.executeBatch(monitor -> {}, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteArtifactRepositoryTest.assertFalse((boolean)status.isOK());
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"foo", (String)status.getException().getMessage());
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testBatchProcessingCancelled() {
        try {
            HashMap properties = new HashMap();
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            SimpleArtifactRepository repo = (SimpleArtifactRepository)BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            NullProgressMonitor monitor = new NullProgressMonitor();
            monitor.setCanceled(true);
            IStatus status = repo.executeBatch(monitor1 -> {
                if (monitor1.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }, (IProgressMonitor)monitor);
            BatchExecuteArtifactRepositoryTest.assertTrue((status.getSeverity() == 8 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testBatchProcessingExceptionsComposite() {
        try {
            FailingCompositeArtifactRepository compositeArtifactRepository = new FailingCompositeArtifactRepository(BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager(), "foo", new URI("http://foo.bar"), null);
            IStatus status = compositeArtifactRepository.executeBatch(monitor -> {
                throw new RuntimeException("bar");
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteArtifactRepositoryTest.assertFalse((boolean)status.isOK());
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"foo", (String)status.getException().getMessage());
            BatchExecuteArtifactRepositoryTest.assertEquals((int)1, (int)status.getChildren().length);
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"bar", (String)status.getChildren()[0].getMessage());
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testBatchProcessingSaveExceptionComposite() {
        try {
            FailingCompositeArtifactRepository compositeArtifactRepository = new FailingCompositeArtifactRepository(BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager(), "foo", new URI("http://foo.bar"), null);
            IStatus status = compositeArtifactRepository.executeBatch(monitor -> {}, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteArtifactRepositoryTest.assertFalse((boolean)status.isOK());
            BatchExecuteArtifactRepositoryTest.assertEquals((String)"foo", (String)status.getException().getMessage());
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testBatchProcessingTrackSaving() {
        try {
            TrackSavignSimpleArtifactRepository simpleArtifactRepository = new TrackSavignSimpleArtifactRepository("foo", new URI("http://foo.bar"), null);
            simpleArtifactRepository.executeBatch(monitor -> {}, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteArtifactRepositoryTest.assertTrue((boolean)simpleArtifactRepository.didSave);
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testBatchProcessingTrackSavingException() {
        try {
            TrackSavignSimpleArtifactRepository simpleArtifactRepository = new TrackSavignSimpleArtifactRepository("foo", new URI("http://foo.bar"), null);
            simpleArtifactRepository.executeBatch(monitor -> {
                throw new RuntimeException();
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteArtifactRepositoryTest.assertTrue((boolean)simpleArtifactRepository.didSave);
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testDisableSaveFlagResetSimple() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            SimpleArtifactRepository repo = (SimpleArtifactRepository)BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            repo.executeBatch(monitor -> {
                throw new RuntimeException();
            }, (IProgressMonitor)new NullProgressMonitor());
            Field field = SimpleArtifactRepository.class.getDeclaredField("disableSave");
            field.setAccessible(true);
            boolean disableSave = field.getBoolean(repo);
            BatchExecuteArtifactRepositoryTest.assertFalse((String)"1.0", (boolean)disableSave);
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testDisableSaveFlagDuringExecutionSimple() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            SimpleArtifactRepository repo = (SimpleArtifactRepository)BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            repo.executeBatch(monitor -> {
                try {
                    Field field = SimpleArtifactRepository.class.getDeclaredField("disableSave");
                    field.setAccessible(true);
                    boolean disableSave = field.getBoolean(repo);
                    BatchExecuteArtifactRepositoryTest.assertTrue((String)"1.0", (boolean)disableSave);
                }
                catch (SecurityException e1) {
                    BatchExecuteArtifactRepositoryTest.fail((String)("1.1" + e1.getMessage()));
                }
                catch (NoSuchFieldException e2) {
                    BatchExecuteArtifactRepositoryTest.fail((String)("1.2" + e2.getMessage()));
                }
                catch (IllegalArgumentException e3) {
                    BatchExecuteArtifactRepositoryTest.fail((String)("1.2" + e3.getMessage()));
                }
                catch (IllegalAccessException e4) {
                    BatchExecuteArtifactRepositoryTest.fail((String)("1.2" + e4.getMessage()));
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testDisableSaveFlagResetComposite() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            CompositeArtifactRepository repo = (CompositeArtifactRepository)BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", properties);
            repo.executeBatch(monitor -> {
                throw new RuntimeException();
            }, (IProgressMonitor)new NullProgressMonitor());
            Field field = CompositeArtifactRepository.class.getDeclaredField("disableSave");
            field.setAccessible(true);
            boolean disableSave = field.getBoolean(repo);
            BatchExecuteArtifactRepositoryTest.assertFalse((String)"1.0", (boolean)disableSave);
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testDisableSaveFlagDuringExecutionComposite() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            CompositeArtifactRepository repo = (CompositeArtifactRepository)BatchExecuteArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", properties);
            repo.executeBatch(monitor -> {
                try {
                    Field field = CompositeArtifactRepository.class.getDeclaredField("disableSave");
                    field.setAccessible(true);
                    boolean disableSave = field.getBoolean(repo);
                    BatchExecuteArtifactRepositoryTest.assertTrue((String)"1.0", (boolean)disableSave);
                }
                catch (SecurityException e1) {
                    BatchExecuteArtifactRepositoryTest.fail((String)("1.1" + e1.getMessage()));
                }
                catch (NoSuchFieldException e2) {
                    BatchExecuteArtifactRepositoryTest.fail((String)("1.2" + e2.getMessage()));
                }
                catch (IllegalArgumentException e3) {
                    BatchExecuteArtifactRepositoryTest.fail((String)("1.2" + e3.getMessage()));
                }
                catch (IllegalAccessException e4) {
                    BatchExecuteArtifactRepositoryTest.fail((String)("1.2" + e4.getMessage()));
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            BatchExecuteArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    class FailingCompositeArtifactRepository
    extends CompositeArtifactRepository {
        boolean executeBatch;

        public FailingCompositeArtifactRepository(IArtifactRepositoryManager manager, String repositoryName, URI location, Map<String, String> properties) {
            super(manager, location, repositoryName, properties);
            this.executeBatch = false;
        }

        public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
            this.executeBatch = true;
            return super.executeBatch(runnable, monitor);
        }

        public void save() {
            if (this.executeBatch) {
                throw new RuntimeException("foo");
            }
        }
    }

    class FailingSimpleArtifactRepository
    extends SimpleArtifactRepository {
        boolean executeBatch;

        public FailingSimpleArtifactRepository(String repositoryName, URI location, Map<String, String> properties) {
            super(BatchExecuteArtifactRepositoryTest.getAgent(), repositoryName, location, properties);
            this.executeBatch = false;
        }

        public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
            this.executeBatch = true;
            return super.executeBatch(runnable, monitor);
        }

        public void save() {
            if (this.executeBatch) {
                throw new RuntimeException("foo");
            }
        }
    }

    class TrackSavignSimpleArtifactRepository
    extends SimpleArtifactRepository {
        boolean executeBatch;
        public boolean didSave;

        public TrackSavignSimpleArtifactRepository(String repositoryName, URI location, Map<String, String> properties) {
            super(BatchExecuteArtifactRepositoryTest.getAgent(), repositoryName, location, properties);
            this.executeBatch = false;
            this.didSave = false;
        }

        public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
            this.executeBatch = true;
            return super.executeBatch(runnable, monitor);
        }

        public void save() {
            if (this.executeBatch) {
                this.didSave = true;
            }
        }
    }
}

