/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public class JarURLArtifactRepositoryTest {
    private IArtifactRepositoryManager manager;

    @Before
    public void setUp() throws Exception {
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)TestActivator.getContext(), IProvisioningAgent.class);
        this.manager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.class);
    }

    @After
    public void tearDown() throws Exception {
        this.manager = null;
    }

    @Test
    public void testJarURLRepository() throws ProvisionException, MalformedURLException, URISyntaxException {
        URL engineJar = TestActivator.getContext().getBundle().getEntry("/testData/enginerepo.jar");
        URI jarRepoLocation = URIUtil.toURI((URL)new URL("jar:" + engineJar.toString() + "!/testData/enginerepo/"));
        IArtifactRepository repo = this.manager.loadRepository(jarRepoLocation, null);
        Assert.assertTrue((boolean)repo.contains((IArtifactKey)new ArtifactKey("osgi.bundle", "testdata", Version.create((String)"1.0.0.1"))));
    }
}

