/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorSelector;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.spi.AbstractArtifactRepository;
import org.eclipse.equinox.p2.repository.spi.AbstractRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.AbstractWrappedArtifactRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MirrorRequestTest
extends AbstractProvisioningTest {
    private static final String testDataLocation = "testData/artifactRepo/emptyJarRepo";
    File targetLocation;
    IArtifactRepository targetRepository;
    IArtifactRepository sourceRepository;
    URI destination;
    URI failedOptimized;
    URI pakedRepositoryLocation;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.targetLocation = File.createTempFile("target", ".repo");
        this.targetLocation.delete();
        this.targetLocation.mkdirs();
        this.targetRepository = new SimpleArtifactRepository(MirrorRequestTest.getAgent(), "TargetRepo", this.targetLocation.toURI(), null);
        IArtifactRepositoryManager mgr = MirrorRequestTest.getArtifactRepositoryManager();
        this.sourceRepository = mgr.loadRepository(MirrorRequestTest.getTestData("EmptyJar repo", testDataLocation).toURI(), null);
        this.failedOptimized = URIUtil.toJarURI((URI)MirrorRequestTest.getTestData("Error loading test data", "testData/mirror/invalidPackedMissingCanonical.zip").toURI(), null);
        this.pakedRepositoryLocation = MirrorRequestTest.getTestData("Error loading packed repository", "testData/mirror/mirrorPackedRepo").toURI();
        this.destination = this.getTempFolder().toURI();
    }

    @Override
    protected void tearDown() throws Exception {
        MirrorRequestTest.getArtifactRepositoryManager().removeRepository(this.destination);
        MirrorRequestTest.getArtifactRepositoryManager().removeRepository(this.failedOptimized);
        MirrorRequestTest.getArtifactRepositoryManager().removeRepository(this.targetLocation.toURI());
        MirrorRequestTest.getArtifactRepositoryManager().removeRepository(this.pakedRepositoryLocation);
        AbstractProvisioningTest.delete(this.targetLocation);
        MirrorRequestTest.delete(new File(this.destination));
        super.tearDown();
    }

    public void testInvalidZipFileInTheSource() {
        ArtifactKey key = new ArtifactKey("org.eclipse.update.feature", "HelloWorldFeature", Version.createOSGi((int)1, (int)0, (int)0));
        HashMap<String, String> targetProperties = new HashMap<String, String>();
        targetProperties.put("artifact.folder", "true");
        MirrorRequest request = new MirrorRequest((IArtifactKey)key, this.targetRepository, null, targetProperties, (Transport)MirrorRequestTest.getAgent().getService(Transport.class));
        request.perform(this.sourceRepository, (IProgressMonitor)new NullProgressMonitor());
        MirrorRequestTest.assertTrue((boolean)request.getResult().matches(4));
        MirrorRequestTest.assertTrue((boolean)(request.getResult().getException() instanceof IOException));
    }

    public void testMissingArtifact() {
        ArtifactKey key = new ArtifactKey("org.eclipse.update.feature", "Missing", Version.createOSGi((int)1, (int)0, (int)0));
        HashMap<String, String> targetProperties = new HashMap<String, String>();
        targetProperties.put("artifact.folder", "true");
        MirrorRequest request = new MirrorRequest((IArtifactKey)key, this.targetRepository, null, targetProperties, this.getTransport());
        request.perform(this.sourceRepository, (IProgressMonitor)new NullProgressMonitor());
        MirrorRequestTest.assertTrue((boolean)request.getResult().matches(4));
    }

    public void testFailToCanonical() {
        RemoteRepo src = new RemoteRepo((SimpleArtifactRepository)this.sourceRepository);
        ArtifactKey key = new ArtifactKey("test.txt", "fail_to_canonical", Version.parseVersion((String)"1.0.0"));
        MirrorRequest request = new MirrorRequest((IArtifactKey)key, this.targetRepository, null, null, this.getTransport());
        request.perform((IArtifactRepository)src, (IProgressMonitor)new NullProgressMonitor());
        MirrorRequestTest.assertTrue((String)request.getResult().toString(), (boolean)request.getResult().isOK());
        MirrorRequestTest.assertTrue((String)String.format("Target does not contain artifact %s", key), (boolean)this.targetRepository.contains((IArtifactKey)key));
        MirrorRequestTest.assertEquals((String)"Exact number of downloads", (int)1, (int)src.downloadCount);
    }

    public void testFailToCanonicalWithMirrors() {
        OrderedMirrorSelector selector = new OrderedMirrorSelector(this.sourceRepository);
        try {
            RemoteRepo src = new RemoteRepo((SimpleArtifactRepository)this.sourceRepository);
            ArtifactKey key = new ArtifactKey("test.txt", "fail_to_canonical", Version.parseVersion((String)"1.0.0"));
            MirrorRequest request = new MirrorRequest((IArtifactKey)key, this.targetRepository, null, null, this.getTransport());
            request.perform((IArtifactRepository)src, (IProgressMonitor)new NullProgressMonitor());
            MirrorRequestTest.assertTrue((String)request.getResult().toString(), (boolean)request.getResult().isOK());
            MirrorRequestTest.assertTrue((String)String.format("Target does not contain artifact %s", key), (boolean)this.targetRepository.contains((IArtifactKey)key));
            MirrorRequestTest.assertEquals((String)"Exact number of downloads", (int)3, (int)src.downloadCount);
            MirrorRequestTest.assertEquals((String)"All mirrors utilized", (int)selector.mirrors.length, (int)selector.index);
        }
        finally {
            selector.clearSelector();
        }
    }

    public void testMirrorFailOver() {
        OrderedMirrorSelector selector = new OrderedMirrorSelector(this.sourceRepository);
        try {
            ArtifactKey key = new ArtifactKey("test.txt", "HelloWorldText", Version.parseVersion((String)"1.0.0"));
            MirrorRequest request = new MirrorRequest((IArtifactKey)key, this.targetRepository, null, null, this.getTransport());
            request.perform(this.sourceRepository, (IProgressMonitor)new NullProgressMonitor());
            MirrorRequestTest.assertTrue((String)request.getResult().toString(), (boolean)request.getResult().isOK());
            MirrorRequestTest.assertEquals((String)"All mirrors utilized", (int)selector.mirrors.length, (int)selector.index);
        }
        finally {
            selector.clearSelector();
        }
    }

    public void testStatusFromFailover() {
        StatusSequenceRepository source = null;
        LinkedList<IStatus> seq = new LinkedList<IStatus>();
        try {
            source = new StatusSequenceRepository(MirrorRequestTest.getArtifactRepositoryManager().loadRepository(this.pakedRepositoryLocation, (IProgressMonitor)new NullProgressMonitor()));
        }
        catch (ProvisionException e) {
            MirrorRequestTest.fail((String)"Failed to load source repository");
        }
        source.setSequence(seq);
        IQueryResult<IArtifactKey> keys = source.query((IQuery<IArtifactKey>)ArtifactKeyQuery.ALL_KEYS, null);
        MirrorRequestTest.assertTrue((String)"Unable to obtain artifact keys", (keys != null && !keys.isEmpty() ? 1 : 0) != 0);
        IArtifactKey key = (IArtifactKey)keys.iterator().next();
        MirrorRequest req = new MirrorRequest(key, this.targetRepository, null, null, this.getTransport());
        req.perform((IArtifactRepository)source, (IProgressMonitor)new NullProgressMonitor());
        MirrorRequestTest.assertEquals((String)"Expected OK status", (int)0, (int)req.getResult().getSeverity());
        this.targetRepository.removeDescriptor(key, (IProgressMonitor)new NullProgressMonitor());
        req = new MirrorRequest(key, this.targetRepository, null, null, this.getTransport());
        req.perform((IArtifactRepository)source, (IProgressMonitor)new NullProgressMonitor());
        MirrorRequestTest.assertEquals((String)"Expected OK status", (int)0, (int)req.getResult().getSeverity());
        this.targetRepository.removeDescriptor(key, (IProgressMonitor)new NullProgressMonitor());
        req = new MirrorRequest(key, this.targetRepository, null, null, this.getTransport());
        req.perform((IArtifactRepository)source, (IProgressMonitor)new NullProgressMonitor());
        MirrorRequestTest.assertEquals((String)"Expected OK status", (int)0, (int)req.getResult().getSeverity());
    }

    protected static void assertStatusContains(String message, IStatus status, String statusString) {
        if (!MirrorRequestTest.statusContains(status, statusString)) {
            MirrorRequestTest.fail((String)message);
        }
    }

    private static boolean statusContains(IStatus status, String statusString) {
        IStatus[] children;
        if (status.getMessage().indexOf(statusString) != -1) {
            return true;
        }
        if (!status.isMultiStatus()) {
            return false;
        }
        IStatus[] iStatusArray = children = status.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            if (MirrorRequestTest.statusContains(child, statusString)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected class OrderedMirrorSelector
    extends MirrorSelector {
        private URI repoLocation;
        int index;
        MirrorSelector.MirrorInfo[] mirrors;
        IArtifactRepository repo;
        MirrorSelector oldSelector;

        OrderedMirrorSelector(IArtifactRepository repo) {
            super((IRepository)repo, MirrorRequestTest.this.getTransport());
            this.index = 0;
            this.oldSelector = null;
            this.repo = repo;
            repo.setProperty("eclipse.p2.force.threading", String.valueOf(true));
            this.setSelector();
            this.getRepoLocation();
            this.mirrors = this.computeMirrors("file:///" + MirrorRequestTest.getTestData("Mirror Location", "testData/artifactRepo/emptyJarRepo/" + (String)repo.getProperties().get("p2.mirrorsURL")).toString().replace('\\', '/'));
        }

        private void setSelector() {
            Field mirrorField = null;
            try {
                mirrorField = SimpleArtifactRepository.class.getDeclaredField("mirrors");
                mirrorField.setAccessible(true);
                this.oldSelector = (MirrorSelector)mirrorField.get(this.repo);
                mirrorField.set(this.repo, (Object)this);
            }
            catch (Exception e) {
                MirrorRequestTest.fail("0.2", e);
            }
        }

        public void clearSelector() {
            if (this.repo == null) {
                return;
            }
            this.repo.setProperty("eclipse.p2.force.threading", String.valueOf(false));
            Field mirrorField = null;
            try {
                mirrorField = SimpleArtifactRepository.class.getDeclaredField("mirrors");
                mirrorField.setAccessible(true);
                mirrorField.set(this.repo, this.oldSelector);
            }
            catch (Exception e) {
                MirrorRequestTest.fail("0.2", e);
            }
        }

        public synchronized void reportResult(String toDownload, IStatus result) {
        }

        public synchronized boolean hasValidMirror() {
            return this.mirrors != null && this.index < this.mirrors.length;
        }

        public synchronized URI getMirrorLocation(URI inputLocation, IProgressMonitor monitor) {
            return URIUtil.append((URI)this.nextMirror(), (String)this.repoLocation.relativize(inputLocation).getPath());
        }

        private URI nextMirror() {
            Field mirrorLocation = null;
            try {
                mirrorLocation = MirrorSelector.MirrorInfo.class.getDeclaredField("locationString");
                mirrorLocation.setAccessible(true);
                return URIUtil.makeAbsolute((URI)new URI((String)mirrorLocation.get(this.mirrors[this.index++])), (URI)this.repoLocation);
            }
            catch (Exception e) {
                MirrorRequestTest.fail(Double.toString(0.4 + (double)this.index), e);
                return null;
            }
        }

        private synchronized void getRepoLocation() {
            Field locationField = null;
            try {
                locationField = AbstractRepository.class.getDeclaredField("location");
                locationField.setAccessible(true);
                this.repoLocation = (URI)locationField.get(this.repo);
            }
            catch (Exception e) {
                MirrorRequestTest.fail("0.3", e);
            }
        }

        private MirrorSelector.MirrorInfo[] computeMirrors(String mirrorsURL) {
            Document document;
            block5: {
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                document = builder.parse(mirrorsURL);
                if (document != null) break block5;
                return null;
            }
            try {
                NodeList mirrorNodes = document.getElementsByTagName("mirror");
                int mirrorCount = mirrorNodes.getLength();
                MirrorSelector.MirrorInfo[] infos = new MirrorSelector.MirrorInfo[mirrorCount + 1];
                int i = 0;
                while (i < mirrorCount) {
                    Element mirrorNode = (Element)mirrorNodes.item(i);
                    String infoURL = mirrorNode.getAttribute("url");
                    infos[i] = new MirrorSelector.MirrorInfo(infoURL, i);
                    ++i;
                }
                infos[mirrorCount] = new MirrorSelector.MirrorInfo(this.repoLocation.toString(), mirrorCount);
                return infos;
            }
            catch (Exception e) {
                if (mirrorsURL != null && (mirrorsURL.startsWith("http://") || mirrorsURL.startsWith("https://") || mirrorsURL.startsWith("file://") || mirrorsURL.startsWith("ftp://") || mirrorsURL.startsWith("jar://"))) {
                    MirrorRequestTest.fail("Error processing mirrors URL: " + mirrorsURL, e);
                }
                return null;
            }
        }
    }

    protected class RemoteRepo
    extends AbstractArtifactRepository {
        SimpleArtifactRepository delegate;
        int downloadCount;

        RemoteRepo(SimpleArtifactRepository repo) {
            super(MirrorRequestTest.getAgent(), repo.getName(), repo.getType(), repo.getVersion(), repo.getLocation(), repo.getDescription(), repo.getProvider(), repo.getProperties());
            this.downloadCount = 0;
            this.delegate = repo;
        }

        public synchronized URI getLocation() {
            try {
                return new URI("http://test/");
            }
            catch (URISyntaxException e) {
                MirrorRequestTest.fail("URI creation failed", e);
                return null;
            }
        }

        public boolean contains(IArtifactDescriptor descriptor) {
            return this.delegate.contains(descriptor);
        }

        public boolean contains(IArtifactKey key) {
            return this.delegate.contains(key);
        }

        public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream dest, IProgressMonitor monitor) {
            ++this.downloadCount;
            return this.delegate.getArtifact(descriptor, dest, monitor);
        }

        public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
            return this.delegate.getArtifactDescriptors(key);
        }

        public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
            return this.delegate.getArtifacts(requests, monitor);
        }

        public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
            return this.delegate.getOutputStream(descriptor);
        }

        public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream dest, IProgressMonitor monitor) {
            return this.delegate.getRawArtifact(descriptor, dest, monitor);
        }

        public IQueryable<IArtifactDescriptor> descriptorQueryable() {
            return this.delegate.descriptorQueryable();
        }

        public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
            return this.delegate.query(query, monitor);
        }
    }

    class StatusSequenceRepository
    extends AbstractWrappedArtifactRepository {
        Queue<IStatus> sequence;

        public StatusSequenceRepository(IArtifactRepository repo) {
            super(repo);
        }

        @Override
        public URI getLocation() {
            try {
                return new URI("http://somewhere");
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        @Override
        public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream dest, IProgressMonitor monitor) {
            try {
                dest.write(new byte[]{1, 1, 2});
            }
            catch (Exception e) {
                MirrorRequestTest.fail("Failed to write to stream", e);
            }
            if (this.sequence.isEmpty()) {
                return Status.OK_STATUS;
            }
            return this.sequence.remove();
        }

        public void setSequence(Queue<IStatus> queue) {
            this.sequence = queue;
        }
    }
}

